/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.ScaledDimension;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileRenderer;
import org.pepsoft.worldpainter.TileSelector;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainterModalFrame;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.NotPresent;
import org.pepsoft.worldpainter.layers.NotPresentBlock;

public class TileEditor
extends WorldPainterModalFrame
implements TileSelector.Listener {
    private JButton buttonAddTiles;
    private JButton buttonClose;
    private JButton buttonRemoveTiles;
    private JTextPane jTextPane1;
    private TileSelector tileSelector1;
    private final Dimension dimension;
    private final Dimension backgroundDimension;
    private boolean tilesChanged = false;
    private static final long serialVersionUID = 1L;

    public TileEditor(Frame parent, Dimension dimension, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, Set<Layer> hiddenLayers, boolean contourLines, int contourSeparation, TileRenderer.LightOrigin lightOrigin) {
        super((Window)parent);
        this.dimension = dimension;
        Dimension.Anchor anchor = dimension.getAnchor();
        this.backgroundDimension = anchor.role == Dimension.Role.DETAIL ? dimension.getWorld().getDimension(new Dimension.Anchor(anchor.dim, Dimension.Role.MASTER, anchor.invert, 0)) : null;
        this.initComponents();
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this.jTextPane1.getDocument()).getStyleSheet().addRule(bodyRule);
        this.tileSelector1.setColourScheme(colourScheme);
        this.tileSelector1.setHiddenLayers(hiddenLayers);
        this.tileSelector1.setContourLines(contourLines);
        this.tileSelector1.setContourSeparation(contourSeparation);
        this.tileSelector1.setLightOrigin(lightOrigin);
        this.tileSelector1.setCustomBiomeManager(customBiomeManager);
        this.tileSelector1.setDimension(dimension);
        this.tileSelector1.addListener(this);
        this.getRootPane().setDefaultButton(this.buttonClose);
        this.scaleToUI();
        this.pack();
        this.scaleWindowToUI();
        this.setLocationRelativeTo(parent);
    }

    public boolean isTilesChanged() {
        return this.tilesChanged;
    }

    public void moveTo(Point coords) {
        this.tileSelector1.moveTo(coords);
    }

    @Override
    public void selectionChanged(TileSelector tileSelector, Set<Point> newSelection) {
        this.setControlStates();
    }

    private void setControlStates() {
        boolean allowAddTiles;
        boolean allowRemoveTiles;
        Set<Point> selectedTiles = this.tileSelector1.getSelectedTiles();
        if (selectedTiles.isEmpty()) {
            allowRemoveTiles = false;
            allowAddTiles = false;
        } else {
            allowAddTiles = false;
            allowRemoveTiles = false;
            for (Point selectedTile : selectedTiles) {
                Tile existingTile = this.dimension.getTile(selectedTile);
                if (existingTile != null) {
                    allowRemoveTiles = true;
                    if (!existingTile.hasLayer((Layer)NotPresent.INSTANCE) && !existingTile.hasLayer((Layer)NotPresentBlock.INSTANCE)) continue;
                    allowAddTiles = true;
                    continue;
                }
                allowAddTiles = true;
            }
        }
        this.buttonAddTiles.setEnabled(allowAddTiles);
        this.buttonRemoveTiles.setEnabled(allowRemoveTiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTiles() {
        Set<Point> selectedTiles = this.tileSelector1.getSelectedTiles();
        HashSet<Point> tilesToAdd = new HashSet<Point>();
        HashSet<Point> tilesToExpand = new HashSet<Point>();
        int newLowestTileX = this.dimension.getLowestX();
        int newHighestTileX = this.dimension.getHighestX();
        int newLowestTileY = this.dimension.getLowestY();
        int newHighestTileY = this.dimension.getHighestY();
        for (Point selectedTile : selectedTiles) {
            Tile existingTile = this.dimension.getTile(selectedTile);
            if (existingTile == null) {
                tilesToAdd.add(selectedTile);
                if (selectedTile.x < newLowestTileX) {
                    newLowestTileX = selectedTile.x;
                }
                if (selectedTile.x > newHighestTileX) {
                    newHighestTileX = selectedTile.x;
                }
                if (selectedTile.y < newLowestTileY) {
                    newLowestTileY = selectedTile.y;
                }
                if (selectedTile.y <= newHighestTileY) continue;
                newHighestTileY = selectedTile.y;
                continue;
            }
            if (!existingTile.hasLayer((Layer)NotPresent.INSTANCE) && !existingTile.hasLayer((Layer)NotPresentBlock.INSTANCE)) continue;
            tilesToExpand.add(selectedTile);
        }
        if (tilesToAdd.isEmpty() && tilesToExpand.isEmpty()) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long maxMemory = runtime.maxMemory();
        long freeMemory = runtime.freeMemory();
        long totalMemory = runtime.totalMemory();
        long memoryInUse = totalMemory - freeMemory;
        long availableMemory = maxMemory - memoryInUse;
        availableMemory -= 250000000L;
        long totalEstimatedDataSize = tilesToAdd.size() * 81;
        long totalEstimatedImageSize = ((long)(newHighestTileX - newLowestTileX) + 1L) * 128L * (long)(newHighestTileY - newLowestTileY + 1) * 128L * 4L / 1024L;
        long currentImageSize = ((long)(this.dimension.getHighestX() - this.dimension.getLowestX()) + 1L) * 128L * (long)(this.dimension.getHighestY() - this.dimension.getLowestY() + 1) * 128L * 4L / 1024L;
        long totalEstimatedSize = totalEstimatedDataSize + totalEstimatedImageSize - currentImageSize;
        if (totalEstimatedSize > (availableMemory /= 1024L)) {
            if (JOptionPane.showConfirmDialog(this, "There may not be enough memory to add " + tilesToAdd.size() + " tiles!\nIt may fail, or cause errors later on.\nPlease consider adding fewer tiles, or installing more memory.\nDo you want to continue?", "Too Many Tiles", 0, 2) != 0) {
                return;
            }
        } else {
            String action;
            String string = tilesToAdd.isEmpty() ? "expand " + tilesToExpand.size() + " tile(s)" : (action = tilesToExpand.isEmpty() ? "add " + tilesToAdd.size() + " new tile(s)" : "add " + tilesToAdd.size() + " new tile(s) and expand " + tilesToExpand.size() + " tile(s)");
            if (JOptionPane.showConfirmDialog(this, "Do you want to " + action + "?\nNote that this cannot be undone!", "Confirm Adding/Expanding Tiles", 0) != 0) {
                return;
            }
        }
        this.dimension.setEventsInhibited(true);
        this.dimension.clearUndo();
        try {
            ScaledDimension scaledBackground = !tilesToAdd.isEmpty() && this.backgroundDimension != null ? new ScaledDimension(this.backgroundDimension, this.backgroundDimension.getScale()) : null;
            for (Point newTileCoords : tilesToAdd) {
                Tile newTile = null;
                if (this.backgroundDimension != null) {
                    newTile = scaledBackground.getTile(newTileCoords);
                }
                if (newTile == null) {
                    newTile = this.dimension.getTileFactory().createTile(newTileCoords.x, newTileCoords.y);
                }
                this.dimension.addTile(newTile);
            }
            for (Point expandTileCoords : tilesToExpand) {
                Tile tile = this.dimension.getTileForEditing(expandTileCoords);
                tile.clearLayerData((Layer)NotPresent.INSTANCE);
                tile.clearLayerData((Layer)NotPresentBlock.INSTANCE);
            }
        }
        finally {
            this.dimension.setEventsInhibited(false);
        }
        this.dimension.armSavePoint();
        this.tilesChanged = true;
        World2 world = this.dimension.getWorld();
        if (world != null) {
            world.addHistoryEntry(15, new Serializable[]{this.dimension.getName(), Integer.valueOf(tilesToAdd.size())});
        }
        this.tileSelector1.clearSelection();
        this.tileSelector1.refresh();
        this.setControlStates();
    }

    private void removeTiles() {
        Set<Point> selectedTiles = this.tileSelector1.getSelectedTiles();
        Set<Point> tilesToRemove = selectedTiles.stream().filter(selectedTile -> this.dimension.getTile(selectedTile) != null).collect(Collectors.toSet());
        if (tilesToRemove.isEmpty()) {
            return;
        }
        if (tilesToRemove.size() == this.dimension.getTileCount()) {
            JOptionPane.showMessageDialog(this, "<html>You cannot remove <em>all</em> tiles from the dimension!</html>", "All Tiles Selected", 0);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Do you want to remove " + tilesToRemove.size() + " tiles?\nNote that this cannot be undone!", "Confirm Removing Tiles", 0) == 0) {
            this.dimension.setEventsInhibited(true);
            this.dimension.clearUndo();
            try {
                tilesToRemove.forEach(arg_0 -> ((Dimension)this.dimension).removeTile(arg_0));
            }
            finally {
                this.dimension.setEventsInhibited(false);
            }
            this.dimension.armSavePoint();
            this.tilesChanged = true;
            World2 world = this.dimension.getWorld();
            if (world != null) {
                world.addHistoryEntry(16, new Serializable[]{this.dimension.getName(), Integer.valueOf(tilesToRemove.size())});
            }
            this.tileSelector1.clearSelection();
            this.tileSelector1.refresh();
            this.setControlStates();
        }
    }

    private void initComponents() {
        this.buttonClose = new JButton();
        this.buttonAddTiles = new JButton();
        this.buttonRemoveTiles = new JButton();
        this.tileSelector1 = new TileSelector();
        this.jTextPane1 = new JTextPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("WorldPainter - Add, Expand or Remove Tiles");
        this.buttonClose.setText("Close");
        this.buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileEditor.this.buttonCloseActionPerformed(evt);
            }
        });
        this.buttonAddTiles.setText("Add or expand tiles");
        this.buttonAddTiles.setEnabled(false);
        this.buttonAddTiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileEditor.this.buttonAddTilesActionPerformed(evt);
            }
        });
        this.buttonRemoveTiles.setText("Remove tiles");
        this.buttonRemoveTiles.setEnabled(false);
        this.buttonRemoveTiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileEditor.this.buttonRemoveTilesActionPerformed(evt);
            }
        });
        this.tileSelector1.setAllowNonExistentTileSelection(true);
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setContentType("text/html");
        this.jTextPane1.setText("WorldPainter works in tiles of 128 by 128 blocks.\nOn this screen you can add, expand or remove tiles.<br>\n<br>\nSelect tiles to the right using the left mouse button,\nmove the map with the middle or right buttons,\nthen select an action below:<br>\n<br>\nDrag to select tiles; hold Ctrl and drag to deselect tiles.<br>\n<br>\n<b>Note:</b> this will remove all undo information!");
        this.jTextPane1.setOpaque(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.buttonClose).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextPane1, -2, 146, -2).addComponent(this.buttonAddTiles).addComponent(this.buttonRemoveTiles)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tileSelector1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tileSelector1, -1, 451, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonClose)).addGroup(layout.createSequentialGroup().addComponent(this.jTextPane1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.buttonAddTiles).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveTiles))).addContainerGap()));
        this.pack();
    }

    private void buttonCloseActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonAddTilesActionPerformed(ActionEvent evt) {
        this.addTiles();
    }

    private void buttonRemoveTilesActionPerformed(ActionEvent evt) {
        this.removeTiles();
    }
}

