/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.SubProgressReceiver;
import org.pepsoft.util.mdc.MDCUtils;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.CoordinateTransform;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.ExceptionHandler;
import org.pepsoft.worldpainter.Translation;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainterDialog;

public class ShiftWorldDialog
extends WorldPainterDialog
implements ProgressReceiver {
    private JButton buttonCancel;
    private ButtonGroup buttonGroup1;
    private JButton buttonShift;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JProgressBar jProgressBar1;
    private JSpinner jSpinner1;
    private JSpinner jSpinner2;
    private JLabel labelProgressMessage;
    private final World2 world;
    private final Dimension.Anchor anchor;
    private final List<Dimension> affectedDimensions;
    private static final long serialVersionUID = 1L;

    public ShiftWorldDialog(Window parent, World2 world, Dimension.Anchor anchor) {
        super(parent);
        this.world = world;
        this.anchor = anchor;
        this.affectedDimensions = world.getDimensions().stream().filter(dimension -> dimension.getAnchor().dim == anchor.dim).collect(Collectors.toList());
        this.initComponents();
        this.setTitle("Shift " + new Dimension.Anchor(anchor.dim, Dimension.Role.DETAIL, false, 0).getDefaultName() + " Dimension");
        this.getRootPane().setDefaultButton(this.buttonShift);
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public synchronized void setProgress(float progress) {
        AwtUtils.doOnEventThread(() -> this.jProgressBar1.setValue((int)(progress * 100.0f)));
    }

    public synchronized void exceptionThrown(Throwable exception) {
        Throwable exceptionWithContext = MDCUtils.decorateWithMdcContext((Throwable)exception);
        AwtUtils.doOnEventThread(() -> {
            ExceptionHandler.handleException(exceptionWithContext, this);
            this.cancel();
        });
    }

    public synchronized void done() {
        AwtUtils.doOnEventThread(() -> {
            if (this.affectedDimensions.stream().flatMap(dimension -> dimension.getOverlays().stream()).anyMatch(overlay -> !overlay.getFile().canRead())) {
                MessageUtils.beepAndShowWarning((Component)this, (String)"One or more overlay image files could not be read,\nand have therefore not been shifted.\nYou will need to shift these manually.", (String)"Not All Overlays Shifted");
            }
            this.ok();
        });
    }

    public synchronized void setMessage(String message) {
        AwtUtils.doOnEventThread(() -> this.labelProgressMessage.setText(message));
    }

    public synchronized void checkForCancellation() {
    }

    public void reset() {
        AwtUtils.doOnEventThread(() -> this.jProgressBar1.setValue(0));
    }

    public void subProgressStarted(SubProgressReceiver subProgressReceiver) {
    }

    private void shift() {
        this.buttonShift.setEnabled(false);
        this.buttonCancel.setEnabled(false);
        int east = (Integer)this.jSpinner1.getValue();
        int south = (Integer)this.jSpinner2.getValue();
        Translation transform = new Translation(east, south);
        new Thread("World Shifter", (CoordinateTransform)transform, east, south){
            final /* synthetic */ CoordinateTransform val$transform;
            final /* synthetic */ int val$east;
            final /* synthetic */ int val$south;
            {
                this.val$transform = coordinateTransform;
                this.val$east = n;
                this.val$south = n2;
                super(arg0);
            }

            @Override
            public void run() {
                try {
                    for (int i = 0; i < ShiftWorldDialog.this.affectedDimensions.size(); ++i) {
                        Dimension dimension = ShiftWorldDialog.this.affectedDimensions.get(i);
                        ShiftWorldDialog.this.world.transform(dimension.getAnchor(), this.val$transform, (ProgressReceiver)new SubProgressReceiver((ProgressReceiver)ShiftWorldDialog.this, (float)i / (float)ShiftWorldDialog.this.affectedDimensions.size(), 1.0f / (float)ShiftWorldDialog.this.affectedDimensions.size()));
                        ShiftWorldDialog.this.world.addHistoryEntry(17, new Serializable[]{dimension.getName(), Integer.valueOf(this.val$east), Integer.valueOf(this.val$south)});
                    }
                    ShiftWorldDialog.this.done();
                }
                catch (Throwable t) {
                    ShiftWorldDialog.this.exceptionThrown(t);
                }
            }
        }.start();
    }

    private void setControlStates() {
        this.buttonShift.setEnabled((Integer)this.jSpinner1.getValue() != 0 || (Integer)this.jSpinner2.getValue() != 0);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.buttonCancel = new JButton();
        this.buttonShift = new JButton();
        this.labelProgressMessage = new JLabel();
        this.jLabel2 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jSpinner2 = new JSpinner();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("Shift World");
        this.setResizable(false);
        this.jLabel1.setText("Choose a shift amount and press the Shift button to shift the dimension horizontally (by whole tiles):");
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShiftWorldDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonShift.setText("Shift");
        this.buttonShift.setEnabled(false);
        this.buttonShift.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShiftWorldDialog.this.buttonShiftActionPerformed(evt);
            }
        });
        this.labelProgressMessage.setText(" ");
        this.jLabel2.setText("X axis:");
        this.jSpinner1.setModel(new SpinnerNumberModel(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 128));
        this.jSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ShiftWorldDialog.this.jSpinner1StateChanged(evt);
            }
        });
        this.jLabel3.setText("Z axis:");
        this.jSpinner2.setModel(new SpinnerNumberModel(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 128));
        this.jSpinner2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ShiftWorldDialog.this.jSpinner2StateChanged(evt);
            }
        });
        this.jLabel4.setText("(negative values shift west; positive values shift east)");
        this.jLabel5.setText("(negative values shift north; positive values shift south)");
        this.jLabel6.setText("<html><em>This operation cannot be undone!</em>   </html>");
        this.jLabel7.setText("<html><i>All associated dimension such as Ceiling Dimensions and<br>\nCustom Cave/Tunnel Floor Dimensions will be shifted together.</i></html>");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBar1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonShift).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.labelProgressMessage).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSpinner2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5)).addGroup(layout.createSequentialGroup().addComponent(this.jSpinner1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4)))).addComponent(this.jLabel6, -2, -1, -2).addComponent(this.jLabel7, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jSpinner1, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jSpinner2, -2, -1, -2).addComponent(this.jLabel5)).addGap(18, 18, 18).addComponent(this.labelProgressMessage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonShift)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonShiftActionPerformed(ActionEvent evt) {
        this.shift();
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        int value = (Integer)this.jSpinner1.getValue();
        if (value % 128 != 0) {
            this.jSpinner1.setValue(Math.round((float)value / 128.0f) * 128);
        }
        this.setControlStates();
    }

    private void jSpinner2StateChanged(ChangeEvent evt) {
        int value = (Integer)this.jSpinner2.getValue();
        if (value % 128 != 0) {
            this.jSpinner2.setValue(Math.round((float)value / 128.0f) * 128);
        }
        this.setControlStates();
    }
}

