/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollBar;
import javax.swing.Timer;

public class Scroller
implements ActionListener {
    private JScrollBar scrollBar;
    private Timer timer;
    private long pauseStart;
    private long pauseAtStart = 5000L;
    private long pauseAtEnd = 3000L;
    private State state;
    public static final int DEFAULT_PAUSE_AT_START = 5000;
    public static final int DEFAULT_PAUSE_AT_END = 3000;

    public void attach(JScrollBar scrollBar) {
        this.scrollBar = scrollBar;
        this.state = State.PAUSING_AT_START;
        this.pauseStart = System.currentTimeMillis();
        this.timer = new Timer(100, this);
        this.timer.start();
    }

    public void detach() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.scrollBar = null;
    }

    public long getPauseAtEnd() {
        return this.pauseAtEnd;
    }

    public void setPauseAtEnd(long pauseAtEnd) {
        this.pauseAtEnd = pauseAtEnd;
    }

    public long getPauseAtStart() {
        return this.pauseAtStart;
    }

    public void setPauseAtStart(long pauseAtStart) {
        this.pauseAtStart = pauseAtStart;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean valueIsAdjusting = this.scrollBar.getValueIsAdjusting();
        int current = this.scrollBar.getValue();
        int max = this.scrollBar.getMaximum() - this.scrollBar.getVisibleAmount();
        long now = System.currentTimeMillis();
        switch (this.state) {
            case PAUSING_AT_START: {
                if (valueIsAdjusting) {
                    this.state = State.VALUE_IS_ADJUSTING;
                    break;
                }
                if (now - this.pauseStart <= this.pauseAtStart) break;
                this.state = State.SCROLLING;
                break;
            }
            case SCROLLING: {
                if (valueIsAdjusting) {
                    this.state = State.VALUE_IS_ADJUSTING;
                    break;
                }
                if (current < max) {
                    this.scrollBar.setValue(current + 1);
                    break;
                }
                this.state = State.PAUSING_AT_END;
                this.pauseStart = now;
                break;
            }
            case VALUE_IS_ADJUSTING: {
                if (valueIsAdjusting) break;
                this.state = State.PAUSING_AT_START;
                this.pauseStart = now;
                break;
            }
            case PAUSING_AT_END: {
                if (valueIsAdjusting) {
                    this.state = State.VALUE_IS_ADJUSTING;
                    break;
                }
                if (now - this.pauseStart <= this.pauseAtEnd) break;
                this.scrollBar.setValue(0);
                this.state = State.PAUSING_AT_START;
                this.pauseStart = now;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    private static enum State {
        PAUSING_AT_START,
        SCROLLING,
        VALUE_IS_ADJUSTING,
        PAUSING_AT_END;

    }
}

