/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Cursor;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Timer;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.MouseAdapter;

class ScrollController
extends MouseAdapter
implements KeyEventDispatcher {
    private final App app;
    private final Timer timer = new Timer(10, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ScrollController.this.keyDragging = false;
            if (!ScrollController.this.mouseDragging) {
                ScrollController.this.app.glassPane.setCursor(ScrollController.this.previousCursor);
            }
        }
    });
    private Point previousLocation;
    private boolean mouseDragging;
    private boolean keyDragging;
    private Cursor previousCursor;
    private long lastReleased;
    private static final int KEY_REPEAT_GUARD_TIME = 10;

    ScrollController(App app) {
        this.app = app;
        this.timer.setRepeats(false);
    }

    void install() {
        this.app.view.addMouseListener(this);
        this.app.view.addMouseMotionListener(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
    }

    void uninstall() {
        if (this.keyDragging || this.mouseDragging) {
            this.app.glassPane.setCursor(this.previousCursor);
        }
        this.mouseDragging = false;
        this.keyDragging = false;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.app.view.removeMouseMotionListener(this);
        this.app.view.removeMouseListener(this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 2 && !this.mouseDragging) {
            if (!this.keyDragging) {
                Point viewLocOnScreen = this.app.view.getLocationOnScreen();
                e.translatePoint(viewLocOnScreen.x, viewLocOnScreen.y);
                this.previousLocation = e.getPoint();
                this.previousCursor = this.app.glassPane.getCursor();
                this.app.glassPane.setCursor(Cursor.getPredefinedCursor(13));
            }
            this.mouseDragging = true;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.mouseDragging || this.keyDragging) {
            Point viewLocOnScreen = this.app.view.getLocationOnScreen();
            e.translatePoint(viewLocOnScreen.x, viewLocOnScreen.y);
            Point location = e.getPoint();
            if (this.previousLocation != null) {
                int dx = location.x - this.previousLocation.x;
                int dy = location.y - this.previousLocation.y;
                this.app.view.moveBy(-dx, -dy);
            }
            this.previousLocation = location;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mouseDragging || this.keyDragging) {
            Point viewLocOnScreen = this.app.view.getLocationOnScreen();
            e.translatePoint(viewLocOnScreen.x, viewLocOnScreen.y);
            Point location = e.getPoint();
            if (this.previousLocation != null) {
                int dx = location.x - this.previousLocation.x;
                int dy = location.y - this.previousLocation.y;
                this.app.view.moveBy(-dx, -dy);
            }
            this.previousLocation = location;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 2 && this.mouseDragging) {
            this.mouseDragging = false;
            if (!this.keyDragging) {
                this.app.glassPane.setCursor(this.previousCursor);
            }
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 32 && this.app.isFocused()) {
            if (e.getID() == 401) {
                if (e.getWhen() - this.lastReleased < 10L) {
                    this.timer.stop();
                    return true;
                }
                if (!this.keyDragging) {
                    Point mouseLocOnScreen = MouseInfo.getPointerInfo().getLocation();
                    Point scrollPaneLocOnScreen = this.app.view.getLocationOnScreen();
                    Rectangle viewBoundsOnScreen = this.app.view.getBounds();
                    viewBoundsOnScreen.translate(scrollPaneLocOnScreen.x, scrollPaneLocOnScreen.y);
                    if (!viewBoundsOnScreen.contains(mouseLocOnScreen)) {
                        return false;
                    }
                    if (!this.mouseDragging) {
                        this.previousLocation = mouseLocOnScreen;
                        this.previousCursor = this.app.glassPane.getCursor();
                        this.app.glassPane.setCursor(Cursor.getPredefinedCursor(13));
                    }
                    this.keyDragging = true;
                    return true;
                }
            } else if (e.getID() == 402 && this.keyDragging) {
                this.lastReleased = e.getWhen();
                this.timer.start();
                return true;
            }
        }
        return false;
    }
}

