/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.SubProgressReceiver;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.util.swing.ProgressDialog;
import org.pepsoft.util.swing.ProgressTask;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.CoordinateTransform;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.util.MinecraftUtil;

public class ScaleWorldDialog
extends WorldPainterDialog {
    private JButton buttonCancel;
    private JButton buttonScale;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel labelCurrentSize;
    private JLabel labelCurrentWalkingTime;
    private JLabel labelNewSize;
    private JLabel labelNewWalkingTime;
    private JSpinner spinnerScaleFactor;
    private final World2 world;
    private final Dimension.Anchor anchor;
    private final List<Dimension> affectedDimensions;

    public ScaleWorldDialog(Window parent, World2 world, Dimension.Anchor anchor) {
        super(parent);
        this.world = world;
        this.anchor = anchor;
        this.affectedDimensions = world.getDimensions().stream().filter(dimension -> dimension.getAnchor().dim == anchor.dim).collect(Collectors.toList());
        this.initComponents();
        this.setTitle("Scale " + new Dimension.Anchor(anchor.dim, Dimension.Role.DETAIL, false, 0).getDefaultName() + " Dimension");
        Dimension dimension2 = world.getDimension(anchor);
        int width = dimension2.getWidth() * 128;
        int height = dimension2.getHeight() * 128;
        this.labelCurrentSize.setText(String.format("%s x %s blocks", App.INT_NUMBER_FORMAT.format(width), App.INT_NUMBER_FORMAT.format(height)));
        this.labelCurrentWalkingTime.setText(this.getWalkingTime(width, height));
        this.updateNewSize();
        this.getRootPane().setDefaultButton(this.buttonScale);
        this.setLocationRelativeTo(parent);
    }

    private void scale() {
        final int percentage = (Integer)this.spinnerScaleFactor.getValue();
        if (percentage == 100) {
            MessageUtils.beepAndShowError((Component)this, (String)"Select a scaling factor other than 100%", (String)"Select Scaling Factor");
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to scale this dimension by " + percentage + "%?\nThis cannot be undone!", "Confirm Scaling", 0) != 0) {
            return;
        }
        final CoordinateTransform transform = CoordinateTransform.getScalingInstance((float)((float)percentage / 100.0f));
        ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<Void>(){

            public String getName() {
                return "Scaling dimension(s)";
            }

            public Void execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                for (int i = 0; i < ScaleWorldDialog.this.affectedDimensions.size(); ++i) {
                    Dimension dimension = ScaleWorldDialog.this.affectedDimensions.get(i);
                    ScaleWorldDialog.this.world.transform(dimension.getAnchor(), transform, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, (float)i / (float)ScaleWorldDialog.this.affectedDimensions.size(), 1.0f / (float)ScaleWorldDialog.this.affectedDimensions.size()) : null));
                    ScaleWorldDialog.this.world.addHistoryEntry(26, new Serializable[]{dimension.getName(), Integer.valueOf(percentage)});
                }
                return null;
            }
        }, (ProgressDialog.Option[])new ProgressDialog.Option[]{ProgressDialog.NOT_CANCELABLE});
        if (this.affectedDimensions.stream().flatMap(dimension -> dimension.getOverlays().stream()).anyMatch(overlay -> !overlay.getFile().canRead())) {
            MessageUtils.beepAndShowWarning((Component)this, (String)"One or more overlay image files could not be read,\nand have therefore not been scaled.\nYou will need to scale these manually.", (String)"Not All Overlays Scaled");
        }
        this.ok();
    }

    private void updateNewSize() {
        Dimension dimension = this.world.getDimension(this.anchor);
        float scale = (float)((Integer)this.spinnerScaleFactor.getValue()).intValue() / 100.0f;
        int newWidth = Math.round((float)(dimension.getWidth() * 128) * scale);
        int newHeight = Math.round((float)(dimension.getHeight() * 128) * scale);
        this.labelNewSize.setText(String.format("%s x %s blocks", App.INT_NUMBER_FORMAT.format(newWidth), App.INT_NUMBER_FORMAT.format(newHeight)));
        this.labelNewWalkingTime.setText(this.getWalkingTime(newWidth, newHeight));
    }

    private void setControlStates() {
        this.buttonScale.setEnabled((Integer)this.spinnerScaleFactor.getValue() != 100);
    }

    private String getWalkingTime(int width, int height) {
        String northSouthTime;
        if (width == height) {
            return MinecraftUtil.blocksToWalkingTime((int)width);
        }
        String westEastTime = MinecraftUtil.blocksToWalkingTime((int)width);
        if (westEastTime.equals(northSouthTime = MinecraftUtil.blocksToWalkingTime((int)height))) {
            return westEastTime;
        }
        return "west to east: " + westEastTime + ", north to south: " + northSouthTime;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.labelCurrentSize = new JLabel();
        this.labelCurrentWalkingTime = new JLabel();
        this.jLabel4 = new JLabel();
        this.spinnerScaleFactor = new JSpinner();
        this.jLabel5 = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonScale = new JButton();
        this.jLabel6 = new JLabel();
        this.labelNewSize = new JLabel();
        this.jLabel7 = new JLabel();
        this.labelNewWalkingTime = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Scale World");
        this.jLabel1.setText("Scale the current dimension according to these settings:");
        this.jLabel2.setText("Current size:");
        this.jLabel3.setText("Current edge to edge walking time:");
        this.labelCurrentSize.setText("jLabel4");
        this.labelCurrentWalkingTime.setText("jLabel4");
        this.jLabel4.setLabelFor(this.spinnerScaleFactor);
        this.jLabel4.setText("Scale factor:");
        this.spinnerScaleFactor.setModel(new SpinnerNumberModel(100, 10, 1000, 1));
        this.spinnerScaleFactor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ScaleWorldDialog.this.spinnerScaleFactorStateChanged(evt);
            }
        });
        this.jLabel5.setText("%");
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScaleWorldDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonScale.setText("Scale");
        this.buttonScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScaleWorldDialog.this.buttonScaleActionPerformed(evt);
            }
        });
        this.jLabel6.setText("New size:");
        this.labelNewSize.setText("jLabel7");
        this.jLabel7.setText("New edge to edge walking time:");
        this.labelNewWalkingTime.setText("jLabel8");
        this.jLabel8.setText("<html>\nNotes:\n<ul>\n<li>The terrain height and continuous layers such as trees, Custom Object layers, Frost, etc.<br>\nwill be scaled smoothly using bicubic interpolation. Artefacts are still unavoidable though,<br>\nespecially at larger scales.\n<li>Discrete layers such as Annotations and Biomes, but also the terrain type will be scaled<br>\nusing nearest neighbour interpolation. At larger scales these will become noticeably blocky.\n<li>Scaling low-resolution terrain (Imported from Minecraft, or from a low resolution height<br>\nmap) may result in blocky results.\n<li>Extra land may be added around the edges in order to meet chunk boundaries.\n<li><strong>Caution:</strong> if you are scaling up this may fail if there is not enough memory. Save your work to<br>\ndisk first!\n</ul>\n</html>");
        this.jLabel9.setFont(this.jLabel9.getFont().deriveFont(this.jLabel9.getFont().getStyle() | 2));
        this.jLabel9.setText("This operation cannot be undone!");
        this.jLabel10.setText("<html><i>All associated dimension such as Ceiling Dimensions and<br> Custom Cave/Tunnel Floor Dimensions will be scaled together.</i></html>");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonScale).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelCurrentSize)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelCurrentWalkingTime)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerScaleFactor, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel5)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelNewSize)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelNewWalkingTime)).addComponent(this.jLabel8, -2, -1, -2).addComponent(this.jLabel9)).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel10, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.labelCurrentSize)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.labelCurrentWalkingTime)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.spinnerScaleFactor, -2, -1, -2).addComponent(this.jLabel5)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.labelNewSize)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.labelNewWalkingTime)).addGap(18, 18, 18).addComponent(this.jLabel8, -2, -1, -2).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonScale)).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonScaleActionPerformed(ActionEvent evt) {
        this.scale();
    }

    private void spinnerScaleFactorStateChanged(ChangeEvent evt) {
        this.setControlStates();
        this.updateNewSize();
    }
}

