/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.SubProgressReceiver;
import org.pepsoft.util.mdc.MDCUtils;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.CoordinateTransform;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.ExceptionHandler;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainterDialog;

public class RotateWorldDialog
extends WorldPainterDialog
implements ProgressReceiver {
    private JButton buttonCancel;
    private ButtonGroup buttonGroup1;
    private JButton buttonRotate;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel7;
    private JProgressBar jProgressBar1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JLabel labelProgressMessage;
    private final World2 world;
    private final Dimension.Anchor anchor;
    private final List<Dimension> affectedDimensions;
    private static final long serialVersionUID = 1L;

    public RotateWorldDialog(Window parent, World2 world, Dimension.Anchor anchor) {
        super(parent);
        this.world = world;
        this.anchor = anchor;
        this.affectedDimensions = world.getDimensions().stream().filter(dimension -> dimension.getAnchor().dim == anchor.dim).collect(Collectors.toList());
        this.initComponents();
        this.setTitle("Rotate " + new Dimension.Anchor(anchor.dim, Dimension.Role.DETAIL, false, 0).getDefaultName() + " Dimension");
        this.getRootPane().setDefaultButton(this.buttonRotate);
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public synchronized void setProgress(float progress) {
        AwtUtils.doOnEventThread(() -> this.jProgressBar1.setValue((int)(progress * 100.0f)));
    }

    public synchronized void exceptionThrown(Throwable exception) {
        Throwable exceptionWithContext = MDCUtils.decorateWithMdcContext((Throwable)exception);
        AwtUtils.doOnEventThread(() -> {
            ExceptionHandler.handleException(exceptionWithContext, this);
            this.cancel();
        });
    }

    public synchronized void done() {
        AwtUtils.doOnEventThread(() -> {
            if (this.affectedDimensions.stream().flatMap(dimension -> dimension.getOverlays().stream()).anyMatch(overlay -> !overlay.getFile().canRead())) {
                MessageUtils.beepAndShowWarning((Component)this, (String)"One or more overlay image files could not be read,\nand have therefore not been adjusted.\nYou will need to adjust these manually.", (String)"Not All Overlays Adjusted");
            } else if (this.affectedDimensions.stream().anyMatch(dimension -> !dimension.getOverlays().isEmpty())) {
                MessageUtils.beepAndShowWarning((Component)this, (String)"The overlay(s) have been shifted to the correct location, but not rotated.\nYou must manually rotate the image files outside of WorldPainter.", (String)"Overlays Not Rotated");
            }
            this.ok();
        });
    }

    public synchronized void setMessage(String message) {
        AwtUtils.doOnEventThread(() -> this.labelProgressMessage.setText(message));
    }

    public synchronized void checkForCancellation() {
    }

    public void reset() {
        AwtUtils.doOnEventThread(() -> this.jProgressBar1.setValue(0));
    }

    public void subProgressStarted(SubProgressReceiver subProgressReceiver) {
    }

    private void rotate() {
        int degrees;
        CoordinateTransform transform;
        this.buttonRotate.setEnabled(false);
        this.buttonCancel.setEnabled(false);
        if (this.jRadioButton1.isSelected()) {
            transform = CoordinateTransform.ROTATE_CLOCKWISE_90_DEGREES;
            degrees = 90;
        } else if (this.jRadioButton2.isSelected()) {
            transform = CoordinateTransform.ROTATE_180_DEGREES;
            degrees = 180;
        } else {
            transform = CoordinateTransform.ROTATE_CLOCKWISE_270_DEGREES;
            degrees = 270;
        }
        new Thread("World Rotator"){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < RotateWorldDialog.this.affectedDimensions.size(); ++i) {
                        Dimension dimension = RotateWorldDialog.this.affectedDimensions.get(i);
                        RotateWorldDialog.this.world.transform(dimension.getAnchor(), transform, (ProgressReceiver)new SubProgressReceiver((ProgressReceiver)RotateWorldDialog.this, (float)i / (float)RotateWorldDialog.this.affectedDimensions.size(), 1.0f / (float)RotateWorldDialog.this.affectedDimensions.size()));
                        RotateWorldDialog.this.world.addHistoryEntry(19, new Serializable[]{dimension.getName(), Integer.valueOf(degrees)});
                    }
                    RotateWorldDialog.this.done();
                }
                catch (Throwable t) {
                    RotateWorldDialog.this.exceptionThrown(t);
                }
            }
        }.start();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.buttonCancel = new JButton();
        this.buttonRotate = new JButton();
        this.labelProgressMessage = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jLabel7 = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("Rotate World");
        this.setResizable(false);
        this.jLabel1.setText("Choose a rotation angle and press the Rotate button to rotate the dimension:");
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RotateWorldDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonRotate.setText("Rotate");
        this.buttonRotate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RotateWorldDialog.this.buttonRotateActionPerformed(evt);
            }
        });
        this.labelProgressMessage.setText(" ");
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("90 degrees clockwise");
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("180 degrees");
        this.buttonGroup1.add(this.jRadioButton3);
        this.jRadioButton3.setText("90 degrees anticlockwise");
        this.jLabel2.setText("<html><em>This operation cannot be undone!</em>   </html>");
        this.jLabel7.setText("<html><i>All associated dimension such as Ceiling Dimensions and<br> Custom Cave/Tunnel Floor Dimensions will be rotated together.</i></html>");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBar1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonRotate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.labelProgressMessage).addComponent(this.jRadioButton1).addComponent(this.jRadioButton2).addComponent(this.jRadioButton3).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.jLabel7, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton3).addGap(18, 18, 18).addComponent(this.labelProgressMessage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonRotate)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonRotateActionPerformed(ActionEvent evt) {
        this.rotate();
    }
}

