/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pepsoft.minecraft.CustomGenerator;
import org.pepsoft.minecraft.MapGenerator;
import org.pepsoft.minecraft.SeededGenerator;
import org.pepsoft.minecraft.SuperflatGenerator;
import org.pepsoft.minecraft.SuperflatPreset;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.util.swing.SpinnerUtils;
import org.pepsoft.worldpainter.AccelerationType;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.DimensionPropertiesDialog;
import org.pepsoft.worldpainter.ExceptionHandler;
import org.pepsoft.worldpainter.GameType;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.HeightTransform;
import org.pepsoft.worldpainter.Main;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.PlatformListCellRenderer;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileFactoryFactory;
import org.pepsoft.worldpainter.TileRenderer;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.exporting.ExportSettings;
import org.pepsoft.worldpainter.exporting.ExportSettingsEditor;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.plugins.PlatformProvider;
import org.pepsoft.worldpainter.themes.SimpleTheme;
import org.pepsoft.worldpainter.themes.TerrainListCellRenderer;
import org.pepsoft.worldpainter.util.BackupUtils;
import org.pepsoft.worldpainter.util.EnumListCellRenderer;
import org.pepsoft.worldpainter.util.WorldUtils;

public class PreferencesDialog
extends WorldPainterDialog {
    private JButton buttonCancel;
    private JButton buttonCleanUpBackupsNow;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private ButtonGroup buttonGroup5;
    private JButton buttonModePreset;
    private JButton buttonOK;
    private JButton buttonReset;
    private JCheckBox checkBoxAutoDeleteBackups;
    private JCheckBox checkBoxAutoSave;
    private JCheckBox checkBoxBeaches;
    private JCheckBox checkBoxCheats;
    private JCheckBox checkBoxCheckForUpdates;
    private JCheckBox checkBoxChestOfGoodies;
    private JCheckBox checkBoxCircular;
    private JCheckBox checkBoxContours;
    private JCheckBox checkBoxExtendedBlockIds;
    private JCheckBox checkBoxGrid;
    private JCheckBox checkBoxLava;
    private JCheckBox checkBoxPing;
    private JCheckBox checkBoxResourcesEverywhere;
    private JCheckBox checkBoxStructures;
    private JCheckBox checkBoxUndo;
    private JCheckBox checkBoxViewDistance;
    private JCheckBox checkBoxWalkingDistance;
    private JComboBox<Integer> comboBoxHeight;
    private JComboBox comboBoxLightDirection;
    private JComboBox comboBoxLookAndFeel;
    private JComboBox<GameType> comboBoxMode;
    private JComboBox<Platform> comboBoxPlatform;
    private JComboBox comboBoxSurfaceMaterial;
    private JComboBox<Generator> comboBoxWorldType;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel31;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel34;
    private JLabel jLabel35;
    private JLabel jLabel36;
    private JLabel jLabel37;
    private JLabel jLabel38;
    private JLabel jLabel39;
    private JLabel jLabel4;
    private JLabel jLabel40;
    private JLabel jLabel41;
    private JLabel jLabel42;
    private JLabel jLabel43;
    private JLabel jLabel44;
    private JLabel jLabel45;
    private JLabel jLabel46;
    private JLabel jLabel47;
    private JLabel jLabel48;
    private JLabel jLabel49;
    private JLabel jLabel5;
    private JLabel jLabel50;
    private JLabel jLabel51;
    private JLabel jLabel52;
    private JLabel jLabel53;
    private JLabel jLabel54;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator5;
    private JTabbedPane jTabbedPane1;
    private JLabel labelEditExportSettingsLink;
    private JLabel labelTerrainAndLayerSettings;
    private JLabel labelUIScale;
    private JRadioButton radioButtonAccelDefault;
    private JRadioButton radioButtonAccelDirect3D;
    private JRadioButton radioButtonAccelOpenGL;
    private JRadioButton radioButtonAccelQuartz;
    private JRadioButton radioButtonAccelUnaccelerated;
    private JRadioButton radioButtonAccelXRender;
    private JRadioButton radioButtonFlat;
    private JRadioButton radioButtonHilly;
    private JRadioButton radioButtonOverlayOptimiseOnLoad;
    private JRadioButton radioButtonOverlayScaleOnLoad;
    private JRadioButton radioButtonOverlayScaleOnPaint;
    private JRadioButton radioButtonThreadCountAuto;
    private JRadioButton radioButtonThreadCountManual;
    private JRadioButton radioButtonUIScaleAuto;
    private JRadioButton radioButtonUIScaleManual;
    private JSlider sliderUIScale;
    private JSpinner spinnerAutoSaveGuardTime;
    private JSpinner spinnerAutoSaveInterval;
    private JSpinner spinnerBrushSize;
    private JSpinner spinnerContours;
    private JSpinner spinnerFreeSpaceForMaps;
    private JSpinner spinnerGrid;
    private JSpinner spinnerGroundLevel;
    private JSpinner spinnerHeight;
    private JSpinner spinnerManualThreadCount;
    private JSpinner spinnerRange;
    private JSpinner spinnerScale;
    private JSpinner spinnerUndoLevels;
    private JSpinner spinnerWaterLevel;
    private JSpinner spinnerWidth;
    private JSpinner spinnerWorldBackups;
    private final ColourScheme colourScheme;
    private boolean pingNotSet;
    private boolean programmaticChange;
    private int previousMaxHeight;
    private String generatorOptions;
    private Dimension defaultTerrainAndLayerSettings;
    private ExportSettings defaultExportSettings;
    private Platform previousPlatform;
    private static final long serialVersionUID = 1L;

    public PreferencesDialog(Frame parent, ColourScheme colourScheme) {
        super((Window)parent);
        this.colourScheme = colourScheme;
        this.initComponents();
        this.comboBoxSurfaceMaterial.setModel(new DefaultComboBoxModel<Terrain>(Terrain.PICK_LIST));
        this.comboBoxSurfaceMaterial.setRenderer(new TerrainListCellRenderer(colourScheme));
        this.comboBoxMode.setRenderer(new EnumListCellRenderer());
        this.comboBoxWorldType.setRenderer(new EnumListCellRenderer());
        List accelTypes = AccelerationType.getForThisOS();
        this.radioButtonAccelDefault.setEnabled(accelTypes.contains(AccelerationType.DEFAULT));
        this.radioButtonAccelDirect3D.setEnabled(accelTypes.contains(AccelerationType.DIRECT3D));
        this.radioButtonAccelOpenGL.setEnabled(accelTypes.contains(AccelerationType.OPENGL));
        this.radioButtonAccelQuartz.setEnabled(accelTypes.contains(AccelerationType.QUARTZ));
        this.radioButtonAccelUnaccelerated.setEnabled(accelTypes.contains(AccelerationType.UNACCELERATED));
        this.radioButtonAccelXRender.setEnabled(accelTypes.contains(AccelerationType.XRENDER));
        this.comboBoxPlatform.setModel(new DefaultComboBoxModel<Platform>(PlatformManager.getInstance().getAllPlatforms().toArray(new Platform[0])));
        this.comboBoxPlatform.setRenderer(new PlatformListCellRenderer());
        int logicalProcessorCount = Runtime.getRuntime().availableProcessors();
        ((SpinnerNumberModel)this.spinnerManualThreadCount.getModel()).setMaximum(Integer.valueOf(logicalProcessorCount));
        this.spinnerManualThreadCount.setValue(logicalProcessorCount);
        this.loadSettings();
        this.rootPane.setDefaultButton(this.buttonOK);
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    @Override
    public void ok() {
        this.saveSettings();
        super.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettings() {
        this.programmaticChange = true;
        try {
            boolean maxThreadCountFixed;
            Configuration config = Configuration.getInstance();
            if (Main.privateContext == null) {
                this.checkBoxPing.setSelected(false);
                this.checkBoxPing.setEnabled(false);
                this.pingNotSet = true;
            } else if (config.getPingAllowed() != null) {
                this.checkBoxPing.setSelected(config.getPingAllowed());
            } else {
                this.checkBoxPing.setSelected(false);
                this.pingNotSet = true;
            }
            if (Main.privateContext == null || "true".equals(System.getProperty("org.pepsoft.worldpainter.devMode")) || "true".equals(System.getProperty("org.pepsoft.worldpainter.disableUpdateCheck"))) {
                this.checkBoxCheckForUpdates.setSelected(false);
                this.checkBoxCheckForUpdates.setEnabled(false);
            } else {
                this.checkBoxCheckForUpdates.setSelected(config.isCheckForUpdates());
            }
            if ("true".equals(System.getProperty("org.pepsoft.worldpainter.disableUndo"))) {
                this.checkBoxUndo.setSelected(false);
                this.checkBoxUndo.setEnabled(false);
                this.spinnerUndoLevels.setEnabled(false);
            } else {
                this.checkBoxUndo.setSelected(config.isUndoEnabled());
                this.spinnerUndoLevels.setValue(config.getUndoLevels());
            }
            this.checkBoxGrid.setSelected(config.isDefaultGridEnabled());
            this.spinnerGrid.setValue(config.getDefaultGridSize());
            this.checkBoxContours.setSelected(config.isDefaultContoursEnabled());
            this.spinnerContours.setValue(config.getDefaultContourSeparation());
            this.checkBoxViewDistance.setSelected(config.isDefaultViewDistanceEnabled());
            this.checkBoxWalkingDistance.setSelected(config.isDefaultWalkingDistanceEnabled());
            this.comboBoxLightDirection.setSelectedItem(config.getDefaultLightOrigin());
            this.checkBoxCircular.setSelected(config.isDefaultCircularWorld());
            this.spinnerBrushSize.setValue(config.getMaximumBrushSize());
            this.defaultTerrainAndLayerSettings = config.getDefaultTerrainAndLayerSettings();
            this.defaultExportSettings = config.getDefaultExportSettings() != null ? config.getDefaultExportSettings().clone() : null;
            this.checkBoxResourcesEverywhere.setSelected(config.getDefaultResourcesMinimumLevel() > 0);
            this.spinnerWidth.setValue(config.getDefaultWidth() * 128);
            this.spinnerHeight.setValue(config.getDefaultHeight() * 128);
            this.previousPlatform = config.getDefaultPlatform();
            this.comboBoxPlatform.setSelectedItem(this.previousPlatform);
            this.setControlStatesForPlatform();
            this.comboBoxHeight.setSelectedItem(config.getDefaultMaxHeight());
            if (config.isHilly()) {
                this.radioButtonHilly.setSelected(true);
            } else {
                this.radioButtonFlat.setSelected(true);
                this.spinnerRange.setEnabled(false);
                this.spinnerScale.setEnabled(false);
            }
            this.spinnerRange.setValue(Math.round(config.getDefaultRange()));
            this.spinnerScale.setValue((int)Math.round(config.getDefaultScale() * 100.0));
            this.spinnerGroundLevel.setValue(config.getLevel());
            this.spinnerWaterLevel.setValue(config.getWaterLevel());
            this.checkBoxLava.setSelected(config.isLava());
            this.checkBoxBeaches.setSelected(config.isBeaches());
            this.comboBoxSurfaceMaterial.setSelectedItem(config.getSurface());
            this.spinnerWorldBackups.setValue(config.getWorldFileBackups());
            this.checkBoxExtendedBlockIds.setSelected(config.isDefaultExtendedBlockIds());
            this.checkBoxChestOfGoodies.setSelected(config.isDefaultCreateGoodiesChest());
            this.comboBoxWorldType.setSelectedItem(config.getDefaultGenerator().getType());
            this.generatorOptions = config.getDefaultGenerator() instanceof CustomGenerator ? ((CustomGenerator)config.getDefaultGenerator()).getName() : null;
            this.checkBoxStructures.setSelected(config.isDefaultMapFeatures());
            this.comboBoxMode.setSelectedItem(config.getDefaultGameType());
            this.checkBoxCheats.setSelected(config.isDefaultAllowCheats());
            this.previousMaxHeight = config.getDefaultMaxHeight();
            this.comboBoxLookAndFeel.setSelectedIndex(config.getLookAndFeel() != null ? config.getLookAndFeel().ordinal() : 0);
            if (config.getUiScale() == 0.0f) {
                this.radioButtonUIScaleAuto.setSelected(true);
                this.sliderUIScale.setValue((int)(GUIUtils.SYSTEM_UI_SCALE_FLOAT * 100.0f));
            } else {
                this.radioButtonUIScaleManual.setSelected(true);
                this.sliderUIScale.setValue((int)(config.getUiScale() * 100.0f));
            }
            this.updateLabelUIScale();
            switch (config.getAccelerationType()) {
                case DEFAULT: {
                    this.radioButtonAccelDefault.setSelected(true);
                    break;
                }
                case DIRECT3D: {
                    this.radioButtonAccelDirect3D.setSelected(true);
                    break;
                }
                case OPENGL: {
                    this.radioButtonAccelOpenGL.setSelected(true);
                    break;
                }
                case QUARTZ: {
                    this.radioButtonAccelQuartz.setSelected(true);
                    break;
                }
                case UNACCELERATED: {
                    this.radioButtonAccelUnaccelerated.setSelected(true);
                    break;
                }
                case XRENDER: {
                    this.radioButtonAccelXRender.setSelected(true);
                }
            }
            switch (config.getOverlayType()) {
                case OPTIMISE_ON_LOAD: {
                    this.radioButtonOverlayOptimiseOnLoad.setSelected(true);
                    break;
                }
                case SCALE_ON_LOAD: {
                    this.radioButtonOverlayScaleOnLoad.setSelected(true);
                    break;
                }
                case SCALE_ON_PAINT: {
                    this.radioButtonOverlayScaleOnPaint.setSelected(true);
                }
            }
            this.checkBoxAutoSave.setSelected(config.isAutosaveEnabled());
            this.spinnerAutoSaveGuardTime.setValue(config.getAutosaveDelay() / 1000);
            this.spinnerAutoSaveInterval.setValue(config.getAutosaveInterval() / 1000);
            this.spinnerFreeSpaceForMaps.setValue(config.getMinimumFreeSpaceForMaps());
            this.checkBoxAutoDeleteBackups.setSelected(config.isAutoDeleteBackups());
            String sysProp = System.getProperty("org.pepsoft.worldpainter.threads");
            boolean bl = maxThreadCountFixed = sysProp != null;
            if (maxThreadCountFixed) {
                this.radioButtonThreadCountManual.setSelected(true);
                this.spinnerManualThreadCount.setValue(Integer.parseInt(sysProp));
                this.radioButtonThreadCountAuto.setToolTipText("Overridden by org.pepsoft.worldpainter.threads advanced setting");
                this.radioButtonThreadCountManual.setToolTipText("Overridden by org.pepsoft.worldpainter.threads advanced setting");
                this.spinnerManualThreadCount.setToolTipText("Overridden by org.pepsoft.worldpainter.threads advanced setting");
            } else if (config.getMaxThreadCount() != null) {
                this.radioButtonThreadCountManual.setSelected(true);
                this.spinnerManualThreadCount.setValue(config.getMaxThreadCount());
            } else {
                this.radioButtonThreadCountAuto.setSelected(true);
            }
            this.radioButtonThreadCountAuto.setEnabled(!maxThreadCountFixed);
            this.radioButtonThreadCountManual.setEnabled(!maxThreadCountFixed);
            this.setControlStates();
        }
        finally {
            this.programmaticChange = false;
        }
    }

    private void saveSettings() {
        Configuration config = Configuration.getInstance();
        if (!this.pingNotSet) {
            config.setPingAllowed(Boolean.valueOf(this.checkBoxPing.isSelected()));
        }
        if (!"true".equals(System.getProperty("org.pepsoft.worldpainter.devMode")) && !"true".equals(System.getProperty("org.pepsoft.worldpainter.disableUpdateCheck"))) {
            config.setCheckForUpdates(this.checkBoxCheckForUpdates.isSelected());
        }
        if (!"true".equals(System.getProperty("org.pepsoft.worldpainter.disableUndo"))) {
            config.setUndoEnabled(this.checkBoxUndo.isSelected());
            config.setUndoLevels(((Number)this.spinnerUndoLevels.getValue()).intValue());
        }
        config.setDefaultGridEnabled(this.checkBoxGrid.isSelected());
        config.setDefaultGridSize(((Integer)this.spinnerGrid.getValue()).intValue());
        config.setDefaultContoursEnabled(this.checkBoxContours.isSelected());
        config.setDefaultContourSeparation(((Integer)this.spinnerContours.getValue()).intValue());
        config.setDefaultViewDistanceEnabled(this.checkBoxViewDistance.isSelected());
        config.setDefaultWalkingDistanceEnabled(this.checkBoxWalkingDistance.isSelected());
        config.setDefaultLightOrigin((TileRenderer.LightOrigin)this.comboBoxLightDirection.getSelectedItem());
        config.setDefaultWidth((Integer)this.spinnerWidth.getValue() / 128);
        config.setDefaultCircularWorld(this.checkBoxCircular.isSelected());
        config.setDefaultHeight((Integer)this.spinnerHeight.getValue() / 128);
        Platform platform = (Platform)this.comboBoxPlatform.getSelectedItem();
        config.setDefaultPlatform(platform);
        config.setDefaultMaxHeight(((Integer)this.comboBoxHeight.getSelectedItem()).intValue());
        config.setHilly(this.radioButtonHilly.isSelected());
        config.setDefaultRange(((Number)this.spinnerRange.getValue()).floatValue());
        config.setDefaultScale((double)((Integer)this.spinnerScale.getValue()).intValue() / 100.0);
        config.setLevel(((Integer)this.spinnerGroundLevel.getValue()).intValue());
        config.setWaterLevel(((Integer)this.spinnerWaterLevel.getValue()).intValue());
        config.setLava(this.checkBoxLava.isSelected());
        config.setBeaches(this.checkBoxBeaches.isSelected());
        config.setSurface((Terrain)this.comboBoxSurfaceMaterial.getSelectedItem());
        config.setWorldFileBackups(((Integer)this.spinnerWorldBackups.getValue()).intValue());
        config.setMaximumBrushSize(((Integer)this.spinnerBrushSize.getValue()).intValue());
        config.setDefaultExtendedBlockIds(this.checkBoxExtendedBlockIds.isSelected());
        config.setDefaultCreateGoodiesChest(this.checkBoxChestOfGoodies.isSelected());
        Generator generatorType = (Generator)this.comboBoxWorldType.getSelectedItem();
        config.setDefaultGenerator((MapGenerator)(switch (generatorType) {
            case Generator.DEFAULT, Generator.LARGE_BIOMES, Generator.AMPLIFIED, Generator.NETHER, Generator.END -> new SeededGenerator(generatorType, 27594263L);
            case Generator.FLAT -> new SuperflatGenerator(SuperflatPreset.defaultPreset((Platform)platform));
            default -> throw new InternalError("Generator type " + generatorType + " not supported");
        }));
        config.setDefaultMapFeatures(this.checkBoxStructures.isSelected());
        config.setDefaultGameType((GameType)this.comboBoxMode.getSelectedItem());
        config.setDefaultAllowCheats(this.checkBoxCheats.isSelected());
        config.setLookAndFeel(Configuration.LookAndFeel.values()[this.comboBoxLookAndFeel.getSelectedIndex()]);
        if (this.radioButtonUIScaleAuto.isSelected()) {
            config.setUiScale(0.0f);
        } else {
            config.setUiScale((float)this.sliderUIScale.getValue() / 100.0f);
        }
        if (this.radioButtonAccelDefault.isSelected()) {
            config.setAccelerationType(AccelerationType.DEFAULT);
        } else if (this.radioButtonAccelDirect3D.isSelected()) {
            config.setAccelerationType(AccelerationType.DIRECT3D);
        } else if (this.radioButtonAccelOpenGL.isSelected()) {
            config.setAccelerationType(AccelerationType.OPENGL);
        } else if (this.radioButtonAccelQuartz.isSelected()) {
            config.setAccelerationType(AccelerationType.QUARTZ);
        } else if (this.radioButtonAccelUnaccelerated.isSelected()) {
            config.setAccelerationType(AccelerationType.UNACCELERATED);
        } else if (this.radioButtonAccelXRender.isSelected()) {
            config.setAccelerationType(AccelerationType.XRENDER);
        }
        if (this.radioButtonOverlayOptimiseOnLoad.isSelected()) {
            config.setOverlayType(Configuration.OverlayType.OPTIMISE_ON_LOAD);
        } else if (this.radioButtonOverlayScaleOnLoad.isSelected()) {
            config.setOverlayType(Configuration.OverlayType.SCALE_ON_LOAD);
        } else if (this.radioButtonOverlayScaleOnPaint.isSelected()) {
            config.setOverlayType(Configuration.OverlayType.SCALE_ON_PAINT);
        }
        config.setAutosaveEnabled(this.checkBoxAutoSave.isSelected());
        config.setAutosaveDelay((Integer)this.spinnerAutoSaveGuardTime.getValue() * 1000);
        config.setAutosaveInterval((Integer)this.spinnerAutoSaveInterval.getValue() * 1000);
        config.setMinimumFreeSpaceForMaps(((Integer)this.spinnerFreeSpaceForMaps.getValue()).intValue());
        config.setAutoDeleteBackups(this.checkBoxAutoDeleteBackups.isSelected());
        config.setDefaultExportSettings(this.defaultExportSettings);
        config.setDefaultResourcesMinimumLevel(this.checkBoxResourcesEverywhere.isSelected() ? 8 : 0);
        if (this.radioButtonThreadCountManual.isEnabled()) {
            if (this.radioButtonThreadCountAuto.isSelected()) {
                config.setMaxThreadCount(null);
            } else {
                config.setMaxThreadCount(Integer.valueOf((Integer)this.spinnerManualThreadCount.getValue()));
            }
        }
        try {
            config.save();
            Preferences prefs = Preferences.userNodeForPackage(Main.class);
            prefs.put((Version.isSnapshot() ? "snapshot." : "") + "accelerationType", config.getAccelerationType().name());
            prefs.flush();
            prefs = Preferences.userNodeForPackage(GUIUtils.class);
            prefs.putFloat((Version.isSnapshot() ? "snapshot." : "") + "manualUIScale", config.getUiScale());
            prefs.flush();
        }
        catch (IOException | BackingStoreException e) {
            ExceptionHandler.handleException(e, this);
        }
    }

    private void setControlStates() {
        this.spinnerUndoLevels.setEnabled(this.checkBoxUndo.isSelected());
        boolean hilly = this.radioButtonHilly.isSelected();
        this.spinnerRange.setEnabled(hilly);
        this.spinnerScale.setEnabled(hilly);
        this.spinnerHeight.setEnabled(!this.checkBoxCircular.isSelected());
        this.buttonModePreset.setEnabled(this.comboBoxWorldType.getSelectedItem() == Generator.FLAT);
        boolean autosaveEnabled = this.checkBoxAutoSave.isSelected();
        boolean autosaveInhibited = Configuration.getInstance().isAutosaveInhibited();
        this.checkBoxAutoSave.setEnabled(!autosaveInhibited);
        this.spinnerAutoSaveGuardTime.setEnabled(autosaveEnabled && !autosaveInhibited);
        this.spinnerAutoSaveInterval.setEnabled(autosaveEnabled && !autosaveInhibited);
        this.sliderUIScale.setEnabled(this.radioButtonUIScaleManual.isSelected());
        this.spinnerManualThreadCount.setEnabled(this.radioButtonThreadCountManual.isSelected() && this.radioButtonThreadCountManual.isEnabled());
    }

    private void updateLabelUIScale() {
        if (this.radioButtonUIScaleAuto.isSelected()) {
            this.labelUIScale.setText((int)(GUIUtils.SYSTEM_UI_SCALE_FLOAT * 100.0f) + "%");
        } else {
            this.labelUIScale.setText(this.sliderUIScale.getValue() + "%");
        }
    }

    private void editTerrainAndLayerSettings() {
        Configuration config = Configuration.getInstance();
        this.defaultTerrainAndLayerSettings.getWorld().setPlatform((Platform)this.comboBoxPlatform.getSelectedItem());
        DimensionPropertiesDialog dialog = new DimensionPropertiesDialog(this, this.defaultTerrainAndLayerSettings, this.colourScheme, null, true);
        dialog.setVisible(true);
        TileFactory tileFactory = this.defaultTerrainAndLayerSettings.getTileFactory();
        if (tileFactory instanceof HeightMapTileFactory && ((HeightMapTileFactory)tileFactory).getTheme() instanceof SimpleTheme) {
            HeightMapTileFactory heightMapTileFactory = (HeightMapTileFactory)tileFactory;
            SimpleTheme theme = (SimpleTheme)((HeightMapTileFactory)tileFactory).getTheme();
            this.checkBoxBeaches.setSelected(theme.isBeaches());
            int waterLevel = heightMapTileFactory.getWaterHeight();
            this.spinnerWaterLevel.setValue(waterLevel);
            this.defaultTerrainAndLayerSettings.setBorderLevel(heightMapTileFactory.getWaterHeight());
            SortedMap terrainRanges = theme.getTerrainRanges();
            this.comboBoxSurfaceMaterial.setSelectedItem(terrainRanges.get(terrainRanges.headMap(waterLevel + 3).lastKey()));
        }
    }

    private void cleanUpBackupsNow() {
        Configuration config = Configuration.getInstance();
        int oldMinimumFreeSpaceForMaps = config.getMinimumFreeSpaceForMaps();
        config.setMinimumFreeSpaceForMaps(((Integer)this.spinnerFreeSpaceForMaps.getValue()).intValue());
        try {
            BackupUtils.cleanUpBackups(null, (Window)this);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while cleaning backups", e);
        }
        finally {
            config.setMinimumFreeSpaceForMaps(oldMinimumFreeSpaceForMaps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void platformSelected() {
        if (this.programmaticChange) {
            return;
        }
        this.programmaticChange = true;
        try {
            Integer currentMaxHeight;
            Platform platform = (Platform)this.comboBoxPlatform.getSelectedItem();
            Generator currentGenerator = (Generator)this.comboBoxWorldType.getSelectedItem();
            ArrayList supportedGenerators = new ArrayList(platform.supportedGenerators);
            supportedGenerators.retainAll(Arrays.asList(Generator.DEFAULT, Generator.LARGE_BIOMES, Generator.AMPLIFIED, Generator.NETHER, Generator.END, Generator.FLAT));
            this.comboBoxWorldType.setModel(new DefaultComboBoxModel<Generator>(supportedGenerators.toArray(new Generator[0])));
            if (currentGenerator != null && supportedGenerators.contains(currentGenerator)) {
                this.comboBoxWorldType.setSelectedItem(currentGenerator);
            }
            boolean useStandardMaxHeight = (currentMaxHeight = (Integer)this.comboBoxHeight.getSelectedItem()) == null || currentMaxHeight == this.previousPlatform.standardMaxHeight;
            List<Integer> supportedMaxHeights = Arrays.stream(platform.maxHeights).boxed().collect(Collectors.toList());
            this.comboBoxHeight.setModel(new DefaultComboBoxModel<Integer>(supportedMaxHeights.toArray(new Integer[0])));
            int newMinHeight = platform.minZ;
            int newMaxHeight = !useStandardMaxHeight && supportedMaxHeights.contains(currentMaxHeight) ? currentMaxHeight : platform.standardMaxHeight;
            this.comboBoxHeight.setSelectedItem(newMaxHeight);
            SpinnerUtils.setMinimum((JSpinner)this.spinnerGroundLevel, (Comparable)Integer.valueOf(newMinHeight));
            SpinnerUtils.setMaximum((JSpinner)this.spinnerGroundLevel, (Comparable)Integer.valueOf(newMaxHeight - 1));
            SpinnerUtils.setMinimum((JSpinner)this.spinnerWaterLevel, (Comparable)Integer.valueOf(newMinHeight));
            SpinnerUtils.setMaximum((JSpinner)this.spinnerWaterLevel, (Comparable)Integer.valueOf(newMaxHeight - 1));
            SpinnerUtils.setMinimum((JSpinner)this.spinnerRange, (Comparable)Integer.valueOf(newMinHeight));
            SpinnerUtils.setMaximum((JSpinner)this.spinnerRange, (Comparable)Integer.valueOf(newMaxHeight - 1));
            GameType currentGameType = (GameType)this.comboBoxMode.getSelectedItem();
            List supportedGameTypes = platform.supportedGameTypes;
            this.comboBoxMode.setModel(new DefaultComboBoxModel<GameType>(supportedGameTypes.toArray(new GameType[0])));
            if (currentGameType != null && supportedGameTypes.contains(currentGameType)) {
                this.comboBoxMode.setSelectedItem(currentGameType);
            }
            this.checkBoxChestOfGoodies.setEnabled(platform != DefaultPlugin.JAVA_ANVIL_1_15 && platform != DefaultPlugin.JAVA_ANVIL_1_17);
            this.checkBoxExtendedBlockIds.setEnabled(platform.capabilities.contains(Platform.Capability.BLOCK_BASED) && !platform.capabilities.contains(Platform.Capability.NAME_BASED) && platform != DefaultPlugin.JAVA_MCREGION);
            try {
                WorldUtils.resizeDimension((Dimension)this.defaultTerrainAndLayerSettings, (int)newMinHeight, (int)newMaxHeight, (HeightTransform)HeightTransform.IDENTITY, (boolean)true, null);
            }
            catch (ProgressReceiver.OperationCancelled e) {
                throw new InternalError();
            }
            PlatformProvider platformProvider = PlatformManager.getInstance().getPlatformProvider(platform);
            ExportSettings platformDefaultExportSettings = platformProvider.getDefaultExportSettings(platform);
            if (platformDefaultExportSettings != null) {
                this.labelEditExportSettingsLink.setForeground(Color.BLUE);
                this.labelEditExportSettingsLink.setCursor(new Cursor(12));
                if (this.defaultExportSettings != null && platformDefaultExportSettings.getClass() != this.defaultExportSettings.getClass()) {
                    this.defaultExportSettings = null;
                }
            } else {
                this.defaultExportSettings = null;
                this.labelEditExportSettingsLink.setForeground(Color.GRAY);
                this.labelEditExportSettingsLink.setCursor(null);
            }
            this.previousPlatform = platform;
        }
        finally {
            this.programmaticChange = false;
        }
    }

    private void setControlStatesForPlatform() {
        Configuration config = Configuration.getInstance();
        Platform platform = config.getDefaultPlatform();
        ArrayList supportedGenerators = new ArrayList(platform.supportedGenerators);
        supportedGenerators.retainAll(Arrays.asList(Generator.DEFAULT, Generator.LARGE_BIOMES, Generator.AMPLIFIED, Generator.NETHER, Generator.END, Generator.FLAT));
        this.comboBoxWorldType.setModel(new DefaultComboBoxModel<Generator>(supportedGenerators.toArray(new Generator[0])));
        List<Integer> supportedMaxHeights = Arrays.stream(platform.maxHeights).boxed().collect(Collectors.toList());
        this.comboBoxHeight.setModel(new DefaultComboBoxModel<Integer>(supportedMaxHeights.toArray(new Integer[0])));
        List supportedGameTypes = platform.supportedGameTypes;
        this.comboBoxMode.setModel(new DefaultComboBoxModel<GameType>(supportedGameTypes.toArray(new GameType[0])));
        this.checkBoxChestOfGoodies.setEnabled(platform != DefaultPlugin.JAVA_ANVIL_1_15 && platform != DefaultPlugin.JAVA_ANVIL_1_17);
        this.checkBoxExtendedBlockIds.setEnabled(platform.capabilities.contains(Platform.Capability.BLOCK_BASED) && !platform.capabilities.contains(Platform.Capability.NAME_BASED) && platform != DefaultPlugin.JAVA_MCREGION);
        PlatformProvider platformProvider = PlatformManager.getInstance().getPlatformProvider(platform);
        ExportSettings platformDefaultExportSettings = platformProvider.getDefaultExportSettings(platform);
        if (platformDefaultExportSettings != null) {
            this.labelEditExportSettingsLink.setForeground(Color.BLUE);
            this.labelEditExportSettingsLink.setCursor(new Cursor(12));
        } else {
            this.labelEditExportSettingsLink.setForeground(Color.GRAY);
            this.labelEditExportSettingsLink.setCursor(null);
        }
        int maxHeight = config.getDefaultMaxHeight();
        ((SpinnerNumberModel)this.spinnerGroundLevel.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
        ((SpinnerNumberModel)this.spinnerWaterLevel.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
        ((SpinnerNumberModel)this.spinnerRange.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
    }

    private void editDefaultExportSettings() {
        Platform platform = (Platform)this.comboBoxPlatform.getSelectedItem();
        PlatformProvider platformProvider = PlatformManager.getInstance().getPlatformProvider(platform);
        ExportSettings platformDefaultExportSettings = platformProvider.getDefaultExportSettings(platform);
        if (platformDefaultExportSettings != null) {
            ExportSettingsEditor editor = platformProvider.getExportSettingsEditor(platform);
            if (this.defaultExportSettings != null && this.defaultExportSettings.getClass() == platformDefaultExportSettings.getClass()) {
                editor.setExportSettings(this.defaultExportSettings);
            } else {
                editor.setExportSettings(platformDefaultExportSettings);
            }
            final WorldPainterDialog dialog = new WorldPainterDialog((Window)this);
            dialog.setTitle("Configure Default Post Processing Settings");
            dialog.getContentPane().add((Component)editor, "Center");
            JPanel panel = new JPanel(new FlowLayout(2));
            final boolean[] reset = new boolean[]{false};
            panel.add(new JButton(new AbstractAction("Reset"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    reset[0] = true;
                    dialog.ok();
                }
            }));
            JButton okButton = new JButton(new AbstractAction("OK"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.ok();
                }
            });
            panel.add(okButton);
            panel.add(new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.cancel();
                }
            }));
            dialog.getContentPane().add((Component)panel, "South");
            dialog.getRootPane().setDefaultButton(okButton);
            dialog.pack();
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isCancelled()) {
                if (reset[0]) {
                    this.defaultExportSettings = null;
                    MessageUtils.showInfo((Component)this, (String)"Default post processing settings reset to default values.", (String)"Default Post Processing Settings Reset");
                } else {
                    this.defaultExportSettings = editor.getExportSettings();
                }
            }
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.buttonGroup5 = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.checkBoxPing = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.checkBoxCheckForUpdates = new JCheckBox();
        this.jLabel20 = new JLabel();
        this.spinnerWorldBackups = new JSpinner();
        this.jLabel30 = new JLabel();
        this.comboBoxLookAndFeel = new JComboBox();
        this.jLabel32 = new JLabel();
        this.checkBoxAutoSave = new JCheckBox();
        this.jLabel45 = new JLabel();
        this.spinnerAutoSaveGuardTime = new JSpinner();
        this.jLabel46 = new JLabel();
        this.spinnerAutoSaveInterval = new JSpinner();
        this.jLabel47 = new JLabel();
        this.jLabel48 = new JLabel();
        this.checkBoxUndo = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.spinnerUndoLevels = new JSpinner();
        this.jLabel2 = new JLabel();
        this.sliderUIScale = new JSlider();
        this.labelUIScale = new JLabel();
        this.radioButtonUIScaleAuto = new JRadioButton();
        this.radioButtonUIScaleManual = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.jLabel49 = new JLabel();
        this.jLabel50 = new JLabel();
        this.spinnerFreeSpaceForMaps = new JSpinner();
        this.jLabel51 = new JLabel();
        this.checkBoxAutoDeleteBackups = new JCheckBox();
        this.buttonCleanUpBackupsNow = new JButton();
        this.jPanel5 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.checkBoxGrid = new JCheckBox();
        this.checkBoxContours = new JCheckBox();
        this.checkBoxViewDistance = new JCheckBox();
        this.jLabel22 = new JLabel();
        this.comboBoxLightDirection = new JComboBox();
        this.jLabel7 = new JLabel();
        this.spinnerGrid = new JSpinner();
        this.jLabel8 = new JLabel();
        this.spinnerContours = new JSpinner();
        this.checkBoxWalkingDistance = new JCheckBox();
        this.jLabel26 = new JLabel();
        this.spinnerBrushSize = new JSpinner();
        this.jLabel21 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jLabel10 = new JLabel();
        this.spinnerWidth = new JSpinner();
        this.jLabel11 = new JLabel();
        this.spinnerHeight = new JSpinner();
        this.jLabel19 = new JLabel();
        this.jLabel12 = new JLabel();
        this.comboBoxHeight = new JComboBox();
        this.jLabel13 = new JLabel();
        this.radioButtonHilly = new JRadioButton();
        this.jLabel23 = new JLabel();
        this.spinnerRange = new JSpinner();
        this.jLabel24 = new JLabel();
        this.spinnerScale = new JSpinner();
        this.jLabel25 = new JLabel();
        this.radioButtonFlat = new JRadioButton();
        this.checkBoxCircular = new JCheckBox();
        this.jLabel14 = new JLabel();
        this.spinnerGroundLevel = new JSpinner();
        this.jLabel15 = new JLabel();
        this.spinnerWaterLevel = new JSpinner();
        this.checkBoxLava = new JCheckBox();
        this.checkBoxBeaches = new JCheckBox();
        this.jLabel16 = new JLabel();
        this.comboBoxSurfaceMaterial = new JComboBox();
        this.checkBoxExtendedBlockIds = new JCheckBox();
        this.buttonReset = new JButton();
        this.labelTerrainAndLayerSettings = new JLabel();
        this.jLabel17 = new JLabel();
        this.jSeparator5 = new JSeparator();
        this.checkBoxChestOfGoodies = new JCheckBox();
        this.jLabel28 = new JLabel();
        this.comboBoxWorldType = new JComboBox();
        this.buttonModePreset = new JButton();
        this.checkBoxStructures = new JCheckBox();
        this.jLabel29 = new JLabel();
        this.comboBoxMode = new JComboBox();
        this.checkBoxCheats = new JCheckBox();
        this.jLabel52 = new JLabel();
        this.comboBoxPlatform = new JComboBox();
        this.labelEditExportSettingsLink = new JLabel();
        this.checkBoxResourcesEverywhere = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel31 = new JLabel();
        this.radioButtonAccelDefault = new JRadioButton();
        this.radioButtonAccelDirect3D = new JRadioButton();
        this.radioButtonAccelOpenGL = new JRadioButton();
        this.radioButtonAccelQuartz = new JRadioButton();
        this.radioButtonAccelXRender = new JRadioButton();
        this.radioButtonAccelUnaccelerated = new JRadioButton();
        this.jLabel33 = new JLabel();
        this.jLabel34 = new JLabel();
        this.jLabel36 = new JLabel();
        this.jLabel37 = new JLabel();
        this.jLabel38 = new JLabel();
        this.jLabel39 = new JLabel();
        this.jLabel35 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel40 = new JLabel();
        this.jLabel41 = new JLabel();
        this.radioButtonOverlayScaleOnLoad = new JRadioButton();
        this.radioButtonOverlayOptimiseOnLoad = new JRadioButton();
        this.radioButtonOverlayScaleOnPaint = new JRadioButton();
        this.jLabel42 = new JLabel();
        this.jLabel43 = new JLabel();
        this.jLabel44 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel53 = new JLabel();
        this.radioButtonThreadCountAuto = new JRadioButton();
        this.radioButtonThreadCountManual = new JRadioButton();
        this.spinnerManualThreadCount = new JSpinner();
        this.jLabel54 = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Preferences");
        this.checkBoxPing.setSelected(true);
        this.checkBoxPing.setText("Send usage information to the developer");
        this.checkBoxPing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.checkBoxPingActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont(this.jLabel3.getFont().getStyle() | 2));
        this.jLabel3.setText("Note that the information does not include personally identifiable ");
        this.jLabel4.setFont(this.jLabel4.getFont().deriveFont(this.jLabel4.getFont().getStyle() | 2));
        this.jLabel4.setText("information, and will never be sold or given to third parties. ");
        this.checkBoxCheckForUpdates.setSelected(true);
        this.checkBoxCheckForUpdates.setText("Check for updates on startup");
        this.jLabel20.setText("No. of backups of .world files to keep:");
        this.spinnerWorldBackups.setModel(new SpinnerNumberModel((Number)3, Integer.valueOf(0), null, (Number)1));
        this.jLabel30.setText("Visual theme:");
        this.comboBoxLookAndFeel.setModel(new DefaultComboBoxModel<String>(new String[]{"System", "Metal", "Nimbus", "Dark Metal", "Dark Nimbus"}));
        this.comboBoxLookAndFeel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.comboBoxLookAndFeelActionPerformed(evt);
            }
        });
        this.jLabel32.setText("<html><em>Effective after restart  </em></html>");
        this.checkBoxAutoSave.setSelected(true);
        this.checkBoxAutoSave.setText("Enable autosave");
        this.checkBoxAutoSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.checkBoxAutoSaveActionPerformed(evt);
            }
        });
        this.jLabel45.setText("Guard time:");
        this.spinnerAutoSaveGuardTime.setModel(new SpinnerNumberModel(10, 1, 999, 1));
        this.jLabel46.setText("Autosave interval:");
        this.spinnerAutoSaveInterval.setModel(new SpinnerNumberModel(300, 1, 9999, 1));
        this.jLabel47.setText("seconds");
        this.jLabel48.setText("seconds");
        this.checkBoxUndo.setSelected(true);
        this.checkBoxUndo.setText("Enable undo");
        this.checkBoxUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.checkBoxUndoActionPerformed(evt);
            }
        });
        this.jLabel5.setLabelFor(this.spinnerUndoLevels);
        this.jLabel5.setText("Undo levels:");
        this.spinnerUndoLevels.setModel(new SpinnerNumberModel(25, 1, 999, 1));
        this.jLabel2.setLabelFor(this.sliderUIScale);
        this.jLabel2.setText("UI scale:");
        this.sliderUIScale.setMajorTickSpacing(25);
        this.sliderUIScale.setMaximum(400);
        this.sliderUIScale.setMinimum(25);
        this.sliderUIScale.setSnapToTicks(true);
        this.sliderUIScale.setValue(100);
        this.sliderUIScale.setEnabled(false);
        this.sliderUIScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PreferencesDialog.this.sliderUIScaleStateChanged(evt);
            }
        });
        this.labelUIScale.setText("100 %");
        this.buttonGroup4.add(this.radioButtonUIScaleAuto);
        this.radioButtonUIScaleAuto.setText("auto:");
        this.radioButtonUIScaleAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.radioButtonUIScaleAutoActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.radioButtonUIScaleManual);
        this.radioButtonUIScaleManual.setText("manual:");
        this.radioButtonUIScaleManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.radioButtonUIScaleManualActionPerformed(evt);
            }
        });
        this.jSeparator1.setOrientation(1);
        this.jLabel49.setText("Backup settings");
        this.jLabel50.setText("Minimum free space on drive:");
        this.spinnerFreeSpaceForMaps.setModel(new SpinnerNumberModel(2, 1, 999, 1));
        this.jLabel51.setText("GB");
        this.checkBoxAutoDeleteBackups.setSelected(true);
        this.checkBoxAutoDeleteBackups.setText("Offer to delete old map backups on Export and Merge as necessary");
        this.checkBoxAutoDeleteBackups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.checkBoxAutoDeleteBackupsActionPerformed(evt);
            }
        });
        this.buttonCleanUpBackupsNow.setText("Clean Up Backups Now");
        this.buttonCleanUpBackupsNow.setToolTipText("Delete backups, oldest first, until there is at least the indicated amount of space free");
        this.buttonCleanUpBackupsNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.buttonCleanUpBackupsNowActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxPing).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxCheckForUpdates).addComponent(this.checkBoxUndo).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel30).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboBoxLookAndFeel, -2, -1, -2).addComponent(this.jLabel32, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioButtonUIScaleManual).addComponent(this.radioButtonUIScaleAuto)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelUIScale).addComponent(this.sliderUIScale, -2, -1, -2))))).addGroup(jPanel1Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerUndoLevels, -2, -1, -2))))).addGap(22, 22, 22).addComponent(this.jSeparator1, -2, -1, -2))).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel49).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerWorldBackups, -2, -1, -2)).addComponent(this.checkBoxAutoSave).addGroup(jPanel1Layout.createSequentialGroup().addGap(19, 19, 19).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel45).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerAutoSaveGuardTime, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel47)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel46).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerAutoSaveInterval, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel48)))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel50).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerFreeSpaceForMaps, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel51)).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonCleanUpBackupsNow).addComponent(this.checkBoxAutoDeleteBackups)))).addContainerGap(50, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.checkBoxPing).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.checkBoxCheckForUpdates).addGap(18, 18, 18).addComponent(this.checkBoxUndo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.spinnerUndoLevels, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel30).addComponent(this.comboBoxLookAndFeel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonUIScaleAuto).addComponent(this.jLabel2).addComponent(this.labelUIScale)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.radioButtonUIScaleManual).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel32, -2, -1, -2)).addComponent(this.sliderUIScale, -2, -1, -2))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel49).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel20).addComponent(this.spinnerWorldBackups, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.checkBoxAutoSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel45).addComponent(this.spinnerAutoSaveGuardTime, -2, -1, -2).addComponent(this.jLabel47)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel46).addComponent(this.spinnerAutoSaveInterval, -2, -1, -2).addComponent(this.jLabel48)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel50).addComponent(this.spinnerFreeSpaceForMaps, -2, -1, -2).addComponent(this.jLabel51)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxAutoDeleteBackups).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCleanUpBackupsNow))).addGap(0, 166, Short.MAX_VALUE))).addContainerGap()));
        this.jTabbedPane1.addTab("General", this.jPanel1);
        this.jLabel1.setText("Configure your default settings on this screen:");
        this.jLabel18.setFont(this.jLabel18.getFont().deriveFont(this.jLabel18.getFont().getStyle() | 2));
        this.jLabel18.setText("(Note that changes to these settings will only take effect for the next world you load or create.) ");
        this.jLabel6.setFont(this.jLabel6.getFont().deriveFont(this.jLabel6.getFont().getStyle() | 2));
        this.jLabel6.setText("Default view settings ");
        this.checkBoxGrid.setText("Grid enabled");
        this.checkBoxContours.setSelected(true);
        this.checkBoxContours.setText("Contour lines enabled");
        this.checkBoxViewDistance.setText("View distance enabled");
        this.jLabel22.setText("Light direction:");
        this.comboBoxLightDirection.setModel(new DefaultComboBoxModel<TileRenderer.LightOrigin>(TileRenderer.LightOrigin.values()));
        this.comboBoxLightDirection.setRenderer(new EnumListCellRenderer());
        this.jLabel7.setLabelFor(this.spinnerGrid);
        this.jLabel7.setText("Grid size:");
        this.spinnerGrid.setModel(new SpinnerNumberModel(128, 2, 999, 1));
        this.jLabel8.setText("Separation:");
        this.spinnerContours.setModel(new SpinnerNumberModel(10, 2, 999, 1));
        this.checkBoxWalkingDistance.setText("Walking distance enabled");
        this.jLabel26.setText("Maximum brush size:");
        this.spinnerBrushSize.setModel(new SpinnerNumberModel((Number)300, Integer.valueOf(100), null, (Number)10));
        this.jLabel21.setText(" ");
        this.jLabel27.setFont(this.jLabel27.getFont().deriveFont(this.jLabel27.getFont().getStyle() | 2));
        this.jLabel27.setText("Warning: large brush sizes could slow your computer to a crawl! ");
        this.jLabel9.setFont(this.jLabel9.getFont().deriveFont(this.jLabel9.getFont().getStyle() | 2));
        this.jLabel9.setText("Default world settings ");
        this.jLabel10.setLabelFor(this.spinnerWidth);
        this.jLabel10.setText("Dimensions:");
        this.spinnerWidth.setModel(new SpinnerNumberModel((Number)640, Integer.valueOf(128), null, (Number)128));
        this.spinnerWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PreferencesDialog.this.spinnerWidthStateChanged(evt);
            }
        });
        this.jLabel11.setText("x");
        this.spinnerHeight.setModel(new SpinnerNumberModel((Number)640, Integer.valueOf(128), null, (Number)128));
        this.spinnerHeight.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PreferencesDialog.this.spinnerHeightStateChanged(evt);
            }
        });
        this.jLabel19.setText("blocks");
        this.jLabel12.setLabelFor(this.comboBoxHeight);
        this.jLabel12.setText("Height:");
        this.comboBoxHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.comboBoxHeightActionPerformed(evt);
            }
        });
        this.jLabel13.setText("Topography:");
        this.buttonGroup1.add(this.radioButtonHilly);
        this.radioButtonHilly.setSelected(true);
        this.radioButtonHilly.setText("Hilly");
        this.radioButtonHilly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.radioButtonHillyActionPerformed(evt);
            }
        });
        this.jLabel23.setText("(height:");
        this.spinnerRange.setModel(new SpinnerNumberModel(20, 1, 255, 1));
        this.jLabel24.setText("scale:");
        this.spinnerScale.setModel(new SpinnerNumberModel(100, 1, 999, 1));
        this.jLabel25.setText("%)");
        this.buttonGroup1.add(this.radioButtonFlat);
        this.radioButtonFlat.setText("Flat");
        this.radioButtonFlat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.radioButtonFlatActionPerformed(evt);
            }
        });
        this.checkBoxCircular.setText("Circular world");
        this.checkBoxCircular.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.checkBoxCircularActionPerformed(evt);
            }
        });
        this.jLabel14.setLabelFor(this.spinnerGroundLevel);
        this.jLabel14.setText("Level:");
        this.spinnerGroundLevel.setModel(new SpinnerNumberModel(58, 1, 255, 1));
        this.jLabel15.setText("Water level:");
        this.spinnerWaterLevel.setModel(new SpinnerNumberModel(62, 0, 255, 1));
        this.spinnerWaterLevel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PreferencesDialog.this.spinnerWaterLevelStateChanged(evt);
            }
        });
        this.checkBoxLava.setText("Lava instead of water");
        this.checkBoxBeaches.setSelected(true);
        this.checkBoxBeaches.setText("Beaches");
        this.checkBoxBeaches.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.checkBoxBeachesActionPerformed(evt);
            }
        });
        this.jLabel16.setText("Surface material:");
        this.comboBoxSurfaceMaterial.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboBoxSurfaceMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.comboBoxSurfaceMaterialActionPerformed(evt);
            }
        });
        this.checkBoxExtendedBlockIds.setText("Extended block ID's");
        this.buttonReset.setText("Reset...");
        this.buttonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.buttonResetActionPerformed(evt);
            }
        });
        this.labelTerrainAndLayerSettings.setForeground(Color.blue);
        this.labelTerrainAndLayerSettings.setText("<html><u>Configure default border, terrain and layer settings</u></html>");
        this.labelTerrainAndLayerSettings.setCursor(new Cursor(12));
        this.labelTerrainAndLayerSettings.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PreferencesDialog.this.labelTerrainAndLayerSettingsMouseClicked(evt);
            }
        });
        this.jLabel17.setFont(this.jLabel17.getFont().deriveFont(this.jLabel17.getFont().getStyle() | 2));
        this.jLabel17.setText("Default export settings");
        this.checkBoxChestOfGoodies.setText("Include chest of goodies");
        this.jLabel28.setText("World type:");
        this.comboBoxWorldType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.comboBoxWorldTypeActionPerformed(evt);
            }
        });
        this.buttonModePreset.setText("...");
        this.buttonModePreset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.buttonModePresetActionPerformed(evt);
            }
        });
        this.checkBoxStructures.setText("Structures");
        this.jLabel29.setText("Mode:");
        this.comboBoxMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.comboBoxModeActionPerformed(evt);
            }
        });
        this.checkBoxCheats.setText("Allow Cheats");
        this.jLabel52.setText("Map format:");
        this.comboBoxPlatform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.comboBoxPlatformActionPerformed(evt);
            }
        });
        this.labelEditExportSettingsLink.setForeground(new Color(0, 0, 255));
        this.labelEditExportSettingsLink.setText("<html><u>Configure default post processing settings</u></html>");
        this.labelEditExportSettingsLink.setCursor(new Cursor(12));
        this.labelEditExportSettingsLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PreferencesDialog.this.labelEditExportSettingsLinkMouseClicked(evt);
            }
        });
        this.checkBoxResourcesEverywhere.setSelected(true);
        this.checkBoxResourcesEverywhere.setText("Resources everywhere");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator3).addComponent(this.jSeparator2).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.labelTerrainAndLayerSettings, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonReset)).addComponent(this.jSeparator5).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel18).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.checkBoxChestOfGoodies).addGap(18, 18, 18).addComponent(this.checkBoxStructures).addGap(18, 18, 18).addComponent(this.jLabel29).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxMode, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxCheats).addGap(18, 18, 18).addComponent(this.labelEditExportSettingsLink, -2, -1, -2)).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerWidth, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerHeight, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel19).addGap(18, 18, 18).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxHeight, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonHilly).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel23).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerRange, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel24).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerScale, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel25).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonFlat)).addComponent(this.jLabel6).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerGrid, -2, -1, -2)).addComponent(this.checkBoxGrid)).addGap(18, 18, 18).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxContours).addGroup(jPanel5Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerContours, -2, -1, -2))).addGap(18, 18, 18).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxWalkingDistance).addComponent(this.checkBoxViewDistance)).addGap(18, 18, 18).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel26).addGap(6, 6, 6).addComponent(this.spinnerBrushSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel21)).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel22).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxLightDirection, -2, -1, -2)).addComponent(this.jLabel27))).addComponent(this.jLabel9).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.checkBoxCircular).addGap(18, 18, 18).addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerGroundLevel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerWaterLevel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.checkBoxLava).addGap(18, 18, 18).addComponent(this.checkBoxBeaches).addGap(18, 18, 18).addComponent(this.checkBoxResourcesEverywhere)).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxSurfaceMaterial, -2, -1, -2).addGap(18, 18, 18).addComponent(this.checkBoxExtendedBlockIds)).addComponent(this.jLabel17).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel52).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxPlatform, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel28).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxWorldType, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonModePreset))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel18).addGap(18, 18, 18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxGrid).addComponent(this.checkBoxContours).addComponent(this.checkBoxViewDistance).addComponent(this.jLabel22).addComponent(this.comboBoxLightDirection, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.spinnerGrid, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.spinnerContours, -2, -1, -2).addComponent(this.checkBoxWalkingDistance).addComponent(this.jLabel21).addComponent(this.jLabel26).addComponent(this.spinnerBrushSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel27).addGap(18, 18, 18).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel28).addComponent(this.comboBoxWorldType, -2, -1, -2).addComponent(this.buttonModePreset)).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel52).addComponent(this.comboBoxPlatform, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.spinnerWidth, -2, -1, -2).addComponent(this.jLabel11).addComponent(this.spinnerHeight, -2, -1, -2).addComponent(this.jLabel12).addComponent(this.comboBoxHeight, -2, -1, -2).addComponent(this.jLabel13).addComponent(this.radioButtonHilly).addComponent(this.radioButtonFlat).addComponent(this.jLabel19).addComponent(this.jLabel23).addComponent(this.spinnerRange, -2, -1, -2).addComponent(this.jLabel24).addComponent(this.spinnerScale, -2, -1, -2).addComponent(this.jLabel25)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.spinnerGroundLevel, -2, -1, -2).addComponent(this.jLabel15).addComponent(this.spinnerWaterLevel, -2, -1, -2).addComponent(this.checkBoxLava).addComponent(this.checkBoxBeaches).addComponent(this.checkBoxCircular).addComponent(this.checkBoxResourcesEverywhere)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.comboBoxSurfaceMaterial, -2, -1, -2).addComponent(this.checkBoxExtendedBlockIds)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelTerrainAndLayerSettings, -2, -1, -2).addComponent(this.buttonReset)).addGap(18, 18, 18).addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator5, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxChestOfGoodies).addComponent(this.checkBoxStructures).addComponent(this.jLabel29).addComponent(this.comboBoxMode, -2, -1, -2).addComponent(this.checkBoxCheats).addComponent(this.labelEditExportSettingsLink, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Defaults", this.jPanel5);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Hardware Acceleration"));
        this.jLabel31.setText("<html>Select a method of hardware accelerated painting. Experiment with this<br>to improve the general editor performance or solve visual problems:</html>");
        this.buttonGroup2.add(this.radioButtonAccelDefault);
        this.radioButtonAccelDefault.setText("Default");
        this.buttonGroup2.add(this.radioButtonAccelDirect3D);
        this.radioButtonAccelDirect3D.setText("Direct3D");
        this.buttonGroup2.add(this.radioButtonAccelOpenGL);
        this.radioButtonAccelOpenGL.setText("OpenGL");
        this.buttonGroup2.add(this.radioButtonAccelQuartz);
        this.radioButtonAccelQuartz.setText("Quartz");
        this.buttonGroup2.add(this.radioButtonAccelXRender);
        this.radioButtonAccelXRender.setText("XRender");
        this.buttonGroup2.add(this.radioButtonAccelUnaccelerated);
        this.radioButtonAccelUnaccelerated.setText("Unaccelerated");
        this.jLabel33.setText("Disable all hardware acceleration");
        this.jLabel34.setText("Uses the XRender X11 extension on Linux");
        this.jLabel36.setText("<html><em>Effective after restart  </em></html>");
        this.jLabel37.setText("Uses the OpenGL rendering system ");
        this.jLabel38.setText("Uses the Direct3D rendering system on Windows");
        this.jLabel39.setText("Uses Java's default rendering settings");
        this.jLabel35.setText("Uses Apple's Quartz rendering system on Mac OS X");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel36, -2, -1, -2).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.radioButtonAccelUnaccelerated).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel34).addComponent(this.jLabel33).addComponent(this.jLabel35).addComponent(this.jLabel37).addComponent(this.jLabel38).addComponent(this.jLabel39))).addComponent(this.radioButtonAccelDirect3D).addComponent(this.radioButtonAccelDefault).addComponent(this.radioButtonAccelXRender).addComponent(this.radioButtonAccelQuartz).addComponent(this.radioButtonAccelOpenGL).addComponent(this.jLabel31)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel31, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel36, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonAccelDefault).addComponent(this.jLabel39)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonAccelDirect3D).addComponent(this.jLabel38)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonAccelOpenGL).addComponent(this.jLabel37)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonAccelQuartz).addComponent(this.jLabel35)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonAccelXRender).addComponent(this.jLabel34)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonAccelUnaccelerated).addComponent(this.jLabel33)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Overlay Scaling and Painting"));
        this.jLabel40.setText("<html>Select a method of overlay image scaling and painting. Experiment<br>with this to improve overlay image performance:</html>");
        this.jLabel41.setText("<html><em>Effective after reload  </em></html>");
        this.buttonGroup3.add(this.radioButtonOverlayScaleOnLoad);
        this.radioButtonOverlayScaleOnLoad.setText("Scale on load");
        this.buttonGroup3.add(this.radioButtonOverlayOptimiseOnLoad);
        this.radioButtonOverlayOptimiseOnLoad.setText("<html>Optimise on load,<br>scale on paint</html>");
        this.radioButtonOverlayOptimiseOnLoad.setVerticalTextPosition(1);
        this.buttonGroup3.add(this.radioButtonOverlayScaleOnPaint);
        this.radioButtonOverlayScaleOnPaint.setText("Scale on paint");
        this.jLabel42.setText("<html>Optimises the image when it is first loaded,<br>but scales it when painting. Uses less memory.</html>");
        this.jLabel43.setText("<html>Scales and optimises the image in memory<br>when it is first loaded. Uses a lot of memory.</html>");
        this.jLabel44.setText("<html>Does not optimise the image at all and<br>scales it when painting. Uses least memory.</html>");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel40, -2, -1, -2).addComponent(this.jLabel41, -2, -1, -2).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioButtonOverlayOptimiseOnLoad, -2, -1, -2).addComponent(this.radioButtonOverlayScaleOnLoad).addComponent(this.radioButtonOverlayScaleOnPaint)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel44, -2, -1, -2).addComponent(this.jLabel43, -2, -1, -2).addComponent(this.jLabel42, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel40, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel41, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonOverlayScaleOnLoad).addComponent(this.jLabel43, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonOverlayOptimiseOnLoad, -2, -1, -2).addComponent(this.jLabel42, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonOverlayScaleOnPaint).addComponent(this.jLabel44, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder("Exporting"));
        this.jLabel53.setText("Maximum thread count:");
        this.buttonGroup5.add(this.radioButtonThreadCountAuto);
        this.radioButtonThreadCountAuto.setText("manage automatically");
        this.radioButtonThreadCountAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.radioButtonThreadCountAutoActionPerformed(evt);
            }
        });
        this.buttonGroup5.add(this.radioButtonThreadCountManual);
        this.radioButtonThreadCountManual.setText("manual:");
        this.radioButtonThreadCountManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.radioButtonThreadCountManualActionPerformed(evt);
            }
        });
        this.spinnerManualThreadCount.setModel(new SpinnerNumberModel(1, 1, 99, 1));
        this.jLabel54.setText("<html><i>Effective on next Export </i></html>");
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel53).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.radioButtonThreadCountManual).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerManualThreadCount, -2, -1, -2)).addComponent(this.radioButtonThreadCountAuto))).addComponent(this.jLabel54, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel53).addComponent(this.radioButtonThreadCountAuto)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonThreadCountManual).addComponent(this.spinnerManualThreadCount, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel54, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -2, -1, -2).addContainerGap(77, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Performance", this.jPanel2);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.buttonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK)).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void checkBoxUndoActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void labelTerrainAndLayerSettingsMouseClicked(MouseEvent evt) {
        this.editTerrainAndLayerSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void comboBoxHeightActionPerformed(ActionEvent evt) {
        block9: {
            if (this.programmaticChange) {
                return;
            }
            this.programmaticChange = true;
            try {
                int maxHeight = (Integer)this.comboBoxHeight.getSelectedItem();
                if (maxHeight == this.previousMaxHeight) break block9;
                this.previousMaxHeight = maxHeight;
                int terrainLevel = (Integer)this.spinnerGroundLevel.getValue();
                int waterLevel = (Integer)this.spinnerWaterLevel.getValue();
                if (terrainLevel >= maxHeight) {
                    this.spinnerGroundLevel.setValue(maxHeight - 1);
                }
                if (waterLevel >= maxHeight) {
                    this.spinnerWaterLevel.setValue(maxHeight - 1);
                }
                ((SpinnerNumberModel)this.spinnerGroundLevel.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
                ((SpinnerNumberModel)this.spinnerWaterLevel.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
                int range = (Integer)this.spinnerRange.getValue();
                if (range >= maxHeight) {
                    this.spinnerRange.setValue(maxHeight - 1);
                }
                ((SpinnerNumberModel)this.spinnerRange.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
                try {
                    WorldUtils.resizeDimension((Dimension)this.defaultTerrainAndLayerSettings, (int)this.defaultTerrainAndLayerSettings.getMinHeight(), (int)maxHeight, (HeightTransform)HeightTransform.IDENTITY, (boolean)true, null);
                }
                catch (ProgressReceiver.OperationCancelled e) {
                    throw new InternalError(e);
                }
                this.setControlStates();
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void spinnerWaterLevelStateChanged(ChangeEvent evt) {
        int waterLevel = ((Number)this.spinnerWaterLevel.getValue()).intValue();
        this.defaultTerrainAndLayerSettings.setBorderLevel(waterLevel);
        TileFactory tileFactory = this.defaultTerrainAndLayerSettings.getTileFactory();
        if (tileFactory instanceof HeightMapTileFactory) {
            ((HeightMapTileFactory)tileFactory).setWaterHeight(waterLevel);
        }
    }

    private void checkBoxBeachesActionPerformed(ActionEvent evt) {
        TileFactory tileFactory = this.defaultTerrainAndLayerSettings.getTileFactory();
        if (tileFactory instanceof HeightMapTileFactory) {
            ((HeightMapTileFactory)tileFactory).setBeaches(this.checkBoxBeaches.isSelected());
        }
    }

    private void comboBoxSurfaceMaterialActionPerformed(ActionEvent evt) {
        Configuration config = Configuration.getInstance();
        TileFactory tileFactory = this.defaultTerrainAndLayerSettings.getTileFactory();
        if (tileFactory instanceof HeightMapTileFactory && ((HeightMapTileFactory)tileFactory).getTheme() instanceof SimpleTheme) {
            SortedMap defaultTerrainRanges = ((SimpleTheme)((HeightMapTileFactory)tileFactory).getTheme()).getTerrainRanges();
            int waterLevel = (Integer)this.spinnerWaterLevel.getValue();
            int surfaceLevel = defaultTerrainRanges.headMap(waterLevel + 3).lastKey();
            defaultTerrainRanges.put(surfaceLevel, (Terrain)this.comboBoxSurfaceMaterial.getSelectedItem());
        }
    }

    private void buttonResetActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to reset all default world settings,\nincluding the border, terrain and layer settings, to the defaults?", "Confirm Reset", 0) == 0) {
            Configuration config = Configuration.getInstance();
            this.spinnerWidth.setValue(640);
            this.spinnerHeight.setValue(640);
            Platform defaultPlatform = config.getDefaultPlatform();
            this.comboBoxPlatform.setSelectedItem(defaultPlatform);
            this.radioButtonHilly.setSelected(true);
            this.spinnerGroundLevel.setValue(58);
            this.spinnerWaterLevel.setValue(62);
            this.checkBoxLava.setSelected(false);
            this.checkBoxBeaches.setSelected(true);
            this.comboBoxSurfaceMaterial.setSelectedItem(Terrain.GRASS);
            this.checkBoxResourcesEverywhere.setSelected(true);
            this.defaultTerrainAndLayerSettings = new World2(defaultPlatform, 27594263L, (TileFactory)TileFactoryFactory.createNoiseTileFactory((long)new Random().nextLong(), (Terrain)Terrain.GRASS, (int)defaultPlatform.minZ, (int)defaultPlatform.standardMaxHeight, (int)58, (int)62, (boolean)false, (boolean)true, (float)20.0f, (double)1.0)).getDimension(Dimension.Anchor.NORMAL_DETAIL);
            config.setDefaultTerrainAndLayerSettings(this.defaultTerrainAndLayerSettings);
            this.defaultExportSettings = null;
        }
    }

    private void spinnerWidthStateChanged(ChangeEvent evt) {
        int value = (Integer)this.spinnerWidth.getValue();
        if ((value = Math.round((float)value / 128.0f) * 128) < 128) {
            value = 128;
        }
        this.spinnerWidth.setValue(value);
    }

    private void spinnerHeightStateChanged(ChangeEvent evt) {
        int value = (Integer)this.spinnerHeight.getValue();
        if ((value = Math.round((float)value / 128.0f) * 128) < 128) {
            value = 128;
        }
        this.spinnerHeight.setValue(value);
    }

    private void radioButtonHillyActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonFlatActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxCircularActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void buttonModePresetActionPerformed(ActionEvent evt) {
        String editedGeneratorOptions = JOptionPane.showInputDialog(this, "Edit the Superflat mode preset:", this.generatorOptions);
        if (editedGeneratorOptions != null) {
            this.generatorOptions = editedGeneratorOptions;
        }
    }

    private void comboBoxWorldTypeActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void comboBoxModeActionPerformed(ActionEvent evt) {
        if (this.comboBoxMode.getSelectedItem() == GameType.CREATIVE) {
            this.checkBoxCheats.setSelected(true);
        }
    }

    private void checkBoxPingActionPerformed(ActionEvent evt) {
        this.pingNotSet = false;
    }

    private void checkBoxAutoSaveActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonUIScaleAutoActionPerformed(ActionEvent evt) {
        this.setControlStates();
        this.sliderUIScale.setValue((int)(GUIUtils.SYSTEM_UI_SCALE_FLOAT * 100.0f));
        this.updateLabelUIScale();
    }

    private void radioButtonUIScaleManualActionPerformed(ActionEvent evt) {
        this.setControlStates();
        this.updateLabelUIScale();
    }

    private void sliderUIScaleStateChanged(ChangeEvent evt) {
        this.updateLabelUIScale();
    }

    private void comboBoxLookAndFeelActionPerformed(ActionEvent evt) {
    }

    private void checkBoxAutoDeleteBackupsActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void buttonCleanUpBackupsNowActionPerformed(ActionEvent evt) {
        this.cleanUpBackupsNow();
    }

    private void comboBoxPlatformActionPerformed(ActionEvent evt) {
        this.platformSelected();
    }

    private void labelEditExportSettingsLinkMouseClicked(MouseEvent evt) {
        this.editDefaultExportSettings();
    }

    private void radioButtonThreadCountAutoActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonThreadCountManualActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }
}

