/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import com.google.common.primitives.Ints;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pepsoft.minecraft.MapGenerator;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.SeededGenerator;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.Version;
import org.pepsoft.util.mdc.MDCThreadPoolExecutor;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.util.swing.SpinnerUtils;
import org.pepsoft.util.swing.TiledImageViewer;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.HeightTransform;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileFactoryFactory;
import org.pepsoft.worldpainter.TileProvider;
import org.pepsoft.worldpainter.WPTileProvider;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.Caverns;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.NotPresent;
import org.pepsoft.worldpainter.layers.Resources;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.layers.exporters.CavernsExporter;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.exporters.ResourcesExporter;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.themes.SimpleTheme;
import org.pepsoft.worldpainter.themes.TerrainListCellRenderer;
import org.pepsoft.worldpainter.themes.Theme;
import org.pepsoft.worldpainter.themes.impl.simple.EditSimpleThemeDialog;
import org.pepsoft.worldpainter.util.MathUtils;
import org.pepsoft.worldpainter.util.MinecraftUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewWorldDialog
extends WorldPainterDialog {
    private JButton buttonCancel;
    private JButton buttonCreate;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private JButton buttonMasterInfo;
    private JButton buttonRandomSeed;
    private JCheckBox checkBoxBeaches;
    private JCheckBox checkBoxCircular;
    private JCheckBox checkBoxExtendedBlockIds;
    private JCheckBox checkBoxLava;
    private JCheckBox checkBoxMasterDimension;
    private JComboBox<Integer> comboBoxMaxHeight;
    private JComboBox<Integer> comboBoxMinHeight;
    private JComboBox comboBoxSurfaceMaterial;
    private JComboBox<Platform> comboBoxTarget;
    private JTextField fieldName;
    private JTextField fieldSeed;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel labelAdvancedTerrain;
    private JLabel labelScaledDimensions;
    private JLabel labelWalkingTimes;
    private JLabel labelWarning;
    private JRadioButton radioButtonAdvancedTerrain;
    private JRadioButton radioButtonCustomSeed;
    private JRadioButton radioButtonFlat;
    private JRadioButton radioButtonHilly;
    private JRadioButton radioButtonLandSeed;
    private JRadioButton radioButtonOceanSeed;
    private JRadioButton radioButtonSimpleTerrain;
    private JSpinner spinnerLength;
    private JSpinner spinnerRange;
    private JSpinner spinnerScale;
    private JSpinner spinnerTerrainLevel;
    private JSpinner spinnerWaterLevel;
    private JSpinner spinnerWidth;
    private TiledImageViewer tiledImageViewer1;
    private final App app;
    private final Set<Point> tiles;
    private final ColourScheme colourScheme;
    private final Dimension baseDimension;
    private final Dimension.Anchor anchor;
    private Platform platform;
    private int previousMinHeight = Integer.MIN_VALUE;
    private int previousMaxHeight = Integer.MIN_VALUE;
    private int savedTerrainLevel;
    private long worldpainterSeed;
    private SimpleTheme theme;
    private boolean programmaticChange = true;
    private float scale;
    static final int ESTIMATED_TILE_DATA_SIZE = 81;
    private static final Icon ICON_WARNING = IconUtils.loadScaledIcon((String)"/org/pepsoft/worldpainter/icons/error.png");
    private static final Logger logger = LoggerFactory.getLogger(NewWorldDialog.class);
    private static final long serialVersionUID = 1L;

    public NewWorldDialog(App app, ColourScheme colourScheme, String name, long seed, Platform platform, Dimension.Anchor anchor, int defaultMinHeight, int defaultMaxHeight, Dimension baseDimension) {
        this(app, colourScheme, name, seed, platform, anchor, defaultMinHeight, defaultMaxHeight, baseDimension, null);
    }

    public NewWorldDialog(App app, ColourScheme colourScheme, String name, long seed, Platform platform, Dimension.Anchor anchor, int defaultMinHeight, int defaultMaxHeight, Dimension baseDimension, Set<Point> tiles) {
        super((Window)app);
        this.app = app;
        this.colourScheme = colourScheme;
        this.platform = platform;
        this.anchor = anchor;
        this.tiles = tiles;
        this.baseDimension = baseDimension;
        this.initComponents();
        List allPlatforms = PlatformManager.getInstance().getAllPlatforms();
        this.comboBoxTarget.setModel(new DefaultComboBoxModel<Object>(allPlatforms.toArray()));
        this.comboBoxTarget.setSelectedItem(platform);
        this.comboBoxTarget.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof Platform) {
                    this.setText(((Platform)value).displayName);
                }
                return this;
            }
        });
        this.comboBoxSurfaceMaterial.setModel(new DefaultComboBoxModel<Terrain>(Terrain.PICK_LIST));
        this.comboBoxSurfaceMaterial.setRenderer(new TerrainListCellRenderer(app.getColourScheme()));
        this.initPlatform();
        this.comboBoxMaxHeight.setSelectedItem(defaultMaxHeight);
        this.comboBoxMinHeight.setSelectedItem(defaultMinHeight);
        this.processBuildLimits(true);
        this.scale = 1.0f;
        Configuration config = Configuration.getInstance();
        if (anchor.dim == 0 && !anchor.invert) {
            if (!config.isHilly()) {
                this.radioButtonFlat.setSelected(true);
                this.spinnerRange.setEnabled(false);
                this.spinnerScale.setEnabled(false);
            }
            this.spinnerWidth.setValue(config.getDefaultWidth() * 128);
            this.spinnerLength.setValue(config.getDefaultHeight() * 128);
            this.spinnerTerrainLevel.setValue(config.getLevel());
            this.spinnerWaterLevel.setValue(config.getWaterLevel());
            this.spinnerRange.setValue(Math.round(config.getDefaultRange()));
            this.spinnerScale.setValue((int)Math.round(config.getDefaultScale() * 100.0));
            this.checkBoxLava.setSelected(config.isLava());
            this.comboBoxSurfaceMaterial.setSelectedItem(config.getSurface());
            this.checkBoxBeaches.setSelected(config.isBeaches());
            this.checkBoxCircular.setSelected(config.isDefaultCircularWorld());
        }
        ((JSpinner.DefaultEditor)this.spinnerWidth.getEditor()).getTextField().setColumns(4);
        ((JSpinner.DefaultEditor)this.spinnerLength.getEditor()).getTextField().setColumns(4);
        if (!anchor.equals((Object)Dimension.Anchor.NORMAL_DETAIL)) {
            this.setTitle("Add " + anchor.getDefaultName());
        }
        if (anchor.role == Dimension.Role.MASTER) {
            this.fieldName.setEnabled(false);
            this.comboBoxTarget.setEnabled(false);
            this.comboBoxMinHeight.setEnabled(false);
            this.comboBoxMaxHeight.setEnabled(false);
            this.scale = 16.0f;
            this.checkBoxMasterDimension.setSelected(true);
        } else if (anchor.dim == 0 && anchor.invert) {
            this.fieldName.setEnabled(false);
            this.comboBoxTarget.setEnabled(false);
            this.comboBoxSurfaceMaterial.setSelectedItem(Terrain.STONE_MIX);
            this.spinnerTerrainLevel.setValue(58);
            this.spinnerWaterLevel.setValue(0);
            this.checkBoxBeaches.setSelected(false);
            this.comboBoxMinHeight.setEnabled(false);
            this.comboBoxMaxHeight.setEnabled(false);
        } else if (anchor.dim == 1) {
            if (!anchor.invert) {
                this.fieldName.setEnabled(false);
                this.comboBoxTarget.setEnabled(false);
                this.comboBoxSurfaceMaterial.setSelectedItem(Terrain.NETHERLIKE);
                int lavaLevel = defaultMaxHeight * 3 / 4;
                this.spinnerTerrainLevel.setValue(lavaLevel - 4);
                this.spinnerWaterLevel.setValue(lavaLevel);
                this.checkBoxLava.setSelected(true);
            } else {
                this.fieldName.setEnabled(false);
                this.comboBoxTarget.setEnabled(false);
                this.comboBoxSurfaceMaterial.setSelectedItem(Terrain.NETHERLIKE);
                this.spinnerTerrainLevel.setValue(58);
                this.spinnerWaterLevel.setValue(0);
            }
            this.checkBoxBeaches.setSelected(false);
            this.comboBoxMinHeight.setEnabled(false);
            this.comboBoxMaxHeight.setEnabled(false);
        } else if (anchor.dim == 2) {
            if (!anchor.invert) {
                this.fieldName.setEnabled(false);
                this.comboBoxTarget.setEnabled(false);
                this.comboBoxSurfaceMaterial.setSelectedItem(Terrain.END_STONE);
                this.spinnerTerrainLevel.setValue(32);
            } else {
                this.fieldName.setEnabled(false);
                this.comboBoxTarget.setEnabled(false);
                this.comboBoxSurfaceMaterial.setSelectedItem(Terrain.END_STONE);
                this.spinnerTerrainLevel.setValue(58);
            }
            this.spinnerWaterLevel.setValue(0);
            this.checkBoxBeaches.setSelected(false);
            this.comboBoxMinHeight.setEnabled(false);
            this.comboBoxMaxHeight.setEnabled(false);
        }
        this.checkBoxMasterDimension.setEnabled(anchor.role == Dimension.Role.DETAIL && !anchor.invert);
        if (tiles != null) {
            int lowestX = Integer.MAX_VALUE;
            int highestX = Integer.MIN_VALUE;
            int lowestY = Integer.MAX_VALUE;
            int highestY = Integer.MIN_VALUE;
            for (Point tileCoords : tiles) {
                if (tileCoords.x < lowestX) {
                    lowestX = tileCoords.x;
                }
                if (tileCoords.x > highestX) {
                    highestX = tileCoords.x;
                }
                if (tileCoords.y < lowestY) {
                    lowestY = tileCoords.y;
                }
                if (tileCoords.y <= highestY) continue;
                highestY = tileCoords.y;
            }
            int width = highestX - lowestX + 1;
            int height = highestY - lowestY + 1;
            this.spinnerWidth.setValue(width * 128);
            this.spinnerLength.setValue(height * 128);
            this.spinnerWidth.setEnabled(false);
            this.spinnerLength.setEnabled(false);
            this.checkBoxCircular.setEnabled(false);
        }
        this.updateWalkingTimes();
        TileFactory defaultTileFactory = config.getDefaultTerrainAndLayerSettings().getTileFactory();
        this.theme = defaultTileFactory instanceof HeightMapTileFactory && ((HeightMapTileFactory)defaultTileFactory).getTheme() instanceof SimpleTheme ? (SimpleTheme)((HeightMapTileFactory)defaultTileFactory).getTheme().clone() : SimpleTheme.createDefault((Terrain)((Terrain)this.comboBoxSurfaceMaterial.getSelectedItem()), (int)((Integer)this.comboBoxMinHeight.getSelectedItem()), (int)((Integer)this.comboBoxMaxHeight.getSelectedItem()), (int)((Integer)this.spinnerWaterLevel.getValue()));
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(app);
        this.fieldSeed.setText(Long.toString(seed));
        if (seed == 27594263L) {
            this.worldpainterSeed = new Random().nextLong();
        } else if (seed == 227290L) {
            this.radioButtonLandSeed.setSelected(true);
            this.worldpainterSeed = new Random().nextLong();
        } else {
            this.radioButtonCustomSeed.setSelected(true);
            this.buttonRandomSeed.setEnabled(true);
            this.worldpainterSeed = seed;
        }
        this.fieldName.setText(name);
        this.fieldName.selectAll();
        this.fieldName.requestFocusInWindow();
        this.labelWarning.setIcon(null);
        this.labelWarning.setText(" ");
        this.checkBoxExtendedBlockIds.setSelected(config.isDefaultExtendedBlockIds());
        this.rootPane.setDefaultButton(this.buttonCreate);
        this.programmaticChange = false;
        this.setControlStates();
        this.updatePreview();
    }

    public boolean checkMemoryRequirements(Window parent) {
        long tileCount;
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long maxMemory = runtime.maxMemory();
        long freeMemory = runtime.freeMemory();
        long totalMemory = runtime.totalMemory();
        long memoryInUse = totalMemory - freeMemory;
        long availableMemory = maxMemory - memoryInUse;
        availableMemory /= 1024L;
        if (this.checkBoxCircular.isSelected()) {
            int r = (Integer)this.spinnerWidth.getValue() / 128;
            tileCount = (int)(Math.PI * (double)r * (double)r);
        } else {
            tileCount = this.tiles != null ? (long)this.tiles.size() : (long)((Integer)this.spinnerWidth.getValue() / 128) * (long)((Integer)this.spinnerLength.getValue() / 128);
        }
        long totalEstimatedDataSize = tileCount * 81L;
        if (totalEstimatedDataSize > availableMemory) {
            return JOptionPane.showConfirmDialog(parent, "There may not be enough memory to create a world of that size!\nIt may fail to be created, or cause errors later on.\nPlease consider creating a smaller world, or installing more memory.\nDo you want to continue?", "Large World", 0, 2) == 0;
        }
        return true;
    }

    public World2 getSelectedWorld(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        String name = this.fieldName.getText().trim();
        World2 world = new World2(this.platform, ((Integer)this.comboBoxMinHeight.getSelectedItem()).intValue(), ((Integer)this.comboBoxMaxHeight.getSelectedItem()).intValue());
        Dimension dimension = this.getSelectedDimension(world, progressReceiver);
        if (dimension == null) {
            return null;
        }
        world.addHistoryEntry(3, new Serializable[0]);
        world.setName(name);
        Configuration config = Configuration.getInstance();
        world.setCreateGoodiesChest(config.isDefaultCreateGoodiesChest());
        world.setMapFeatures(config.isDefaultMapFeatures());
        world.setGameType(config.getDefaultGameType());
        world.setAllowCheats(config.isDefaultAllowCheats());
        world.addDimension(dimension);
        if (!this.platform.capabilities.contains(Platform.Capability.NAME_BASED) && this.platform != DefaultPlugin.JAVA_MCREGION) {
            world.setExtendedBlockIds(this.checkBoxExtendedBlockIds.isSelected());
        }
        if (this.tiles != null) {
            int lowestX = Integer.MAX_VALUE;
            int highestX = Integer.MIN_VALUE;
            int lowestY = Integer.MAX_VALUE;
            int highestY = Integer.MIN_VALUE;
            for (Point tileCoords : this.tiles) {
                if (tileCoords.x < lowestX) {
                    lowestX = tileCoords.x;
                }
                if (tileCoords.x > highestX) {
                    highestX = tileCoords.x;
                }
                if (tileCoords.y < lowestY) {
                    lowestY = tileCoords.y;
                }
                if (tileCoords.y <= highestY) continue;
                highestY = tileCoords.y;
            }
            int middleX = Math.round((float)(lowestX + highestX) / 2.0f);
            int middleY = Math.round((float)(lowestY + highestY) / 2.0f);
            Point mostCenteredTileCoords = null;
            float mostCenteredTileDistance = Float.MAX_VALUE;
            for (Point tileCoords : this.tiles) {
                float distance = (float)Math.sqrt((tileCoords.x - middleX) * (tileCoords.x - middleX) + (tileCoords.y - middleY) * (tileCoords.y - middleY));
                if (!(distance < mostCenteredTileDistance)) continue;
                mostCenteredTileCoords = tileCoords;
                mostCenteredTileDistance = distance;
            }
            if (mostCenteredTileCoords != null) {
                world.setSpawnPoint(new Point(mostCenteredTileCoords.x * 128 + 64, mostCenteredTileCoords.y * 128 + 64));
                if (dimension.getAnchor().dim == 0) {
                    dimension.setLastViewPosition(world.getSpawnPoint());
                }
            }
        }
        if ("true".equals(System.getProperty("org.pepsoft.worldpainter.fancyworlds"))) {
            world.setMixedMaterial(0, new MixedMaterial("Dirt/Gravel", new MixedMaterial.Row[]{new MixedMaterial.Row(Material.DIRT, 750, 1.0f), new MixedMaterial.Row(Material.GRAVEL, 250, 1.0f)}, 1, null, 1.0f));
            world.setMixedMaterial(1, new MixedMaterial("Stone/Gravel", new MixedMaterial.Row[]{new MixedMaterial.Row(Material.STONE, 750, 1.0f), new MixedMaterial.Row(Material.GRAVEL, 250, 1.0f)}, 1, null, 1.0f));
        }
        if (dimension.getAnchor().role == Dimension.Role.MASTER) {
            world.addDimension(this.createDimension(world, new Dimension.Anchor(this.anchor.dim, Dimension.Role.DETAIL, this.anchor.invert, 0)));
        }
        return world;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getSelectedDimension(World2 world, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        Dimension.Anchor anchor = this.checkBoxMasterDimension.isSelected() ? new Dimension.Anchor(this.anchor.dim, Dimension.Role.MASTER, this.anchor.invert, 0) : this.anchor;
        Dimension dimension = this.createDimension(world, anchor);
        dimension.setEventsInhibited(true);
        try {
            ExecutorService executorService = MDCThreadPoolExecutor.newFixedThreadPool((int)Runtime.getRuntime().availableProcessors());
            AtomicBoolean cancelled = new AtomicBoolean();
            TileFactory tileFactory = dimension.getTileFactory();
            if (this.tiles != null) {
                logger.info("Creating new dimension with " + this.tiles.size() + " preselected tiles");
                int[] tileCount = new int[1];
                int totalTiles = this.tiles.size();
                for (Point tileCoords : this.tiles) {
                    executorService.execute(() -> {
                        if (cancelled.get()) {
                            return;
                        }
                        Tile tile = this.createTile(tileFactory, anchor, tileCoords.x, tileCoords.y);
                        dimension.addTile(tile);
                        if (progressReceiver == null) return;
                        int[] nArray = tileCount;
                        synchronized (tileCount) {
                            tileCount[0] = tileCount[0] + 1;
                            try {
                                progressReceiver.setProgress((float)tileCount[0] / (float)totalTiles);
                            }
                            catch (ProgressReceiver.OperationCancelled e) {
                                cancelled.set(true);
                            }
                            return;
                        }
                    });
                }
            } else if (this.checkBoxCircular.isSelected()) {
                int radius = (Integer)this.spinnerWidth.getValue() / 2;
                int diameter = radius * 2;
                logger.info("Creating new circular dimension with diameter " + diameter + " blocks");
                int tileRadius = (radius + 127) / 128;
                int[] tileCount = new int[1];
                int approximateTotalTiles = (int)Math.ceil(Math.PI * (double)tileRadius * (double)tileRadius);
                for (int x = -tileRadius; x < tileRadius; ++x) {
                    for (int y = -tileRadius; y < tileRadius; ++y) {
                        if (!(MathUtils.getSmallestDistanceFromOrigin((int)x, (int)y) < (float)radius)) continue;
                        int tileX = x;
                        int tileY = y;
                        executorService.execute(() -> {
                            if (cancelled.get()) {
                                return;
                            }
                            Tile tile = this.createTile(tileFactory, anchor, tileX, tileY);
                            dimension.addTile(tile);
                            if (MathUtils.getLargestDistanceFromOrigin((int)tileX, (int)tileY) >= (float)radius) {
                                int tileXOffset = tileX << 7;
                                int tileYOffset = tileY << 7;
                                for (int chunkXInTile = 0; chunkXInTile < 8; ++chunkXInTile) {
                                    for (int chunkYInTile = 0; chunkYInTile < 8; ++chunkYInTile) {
                                        int voidColumnsInChunk = 0;
                                        int chunkXOffsetInTile = chunkXInTile << 4;
                                        int chunkYOffsetInTile = chunkYInTile << 4;
                                        for (int xx = 0; xx < 16; ++xx) {
                                            for (int yy = 0; yy < 16; ++yy) {
                                                float distance = org.pepsoft.util.MathUtils.getDistance((float)((float)(tileXOffset | chunkXOffsetInTile | xx) + 0.5f), (float)((float)(tileYOffset | chunkYOffsetInTile | yy) + 0.5f));
                                                if (!(distance > (float)radius)) continue;
                                                tile.setBitLayerValue((Layer)Void.INSTANCE, chunkXOffsetInTile | xx, chunkYOffsetInTile | yy, true);
                                                ++voidColumnsInChunk;
                                            }
                                        }
                                        if (voidColumnsInChunk != 256) continue;
                                        tile.setBitLayerValue((Layer)NotPresent.INSTANCE, chunkXOffsetInTile, chunkYOffsetInTile, true);
                                    }
                                }
                            }
                            if (progressReceiver == null) return;
                            int[] nArray = tileCount;
                            synchronized (tileCount) {
                                tileCount[0] = tileCount[0] + 1;
                                try {
                                    progressReceiver.setProgress(Math.min((float)tileCount[0] / (float)approximateTotalTiles, 1.0f));
                                }
                                catch (ProgressReceiver.OperationCancelled e) {
                                    cancelled.set(true);
                                }
                                return;
                            }
                        });
                    }
                }
                dimension.setBorder(Dimension.Border.ENDLESS_VOID);
            } else {
                int width = (Integer)this.spinnerWidth.getValue() / 128;
                int height = (Integer)this.spinnerLength.getValue() / 128;
                logger.info("Creating new dimension of size " + width + "x" + height + " for a total of " + width * height + " tiles");
                int[] tileCount = new int[1];
                int totalTiles = width * height;
                int startX = -width / 2;
                int startY = -height / 2;
                for (int x = startX; x < startX + width; ++x) {
                    int y = startY;
                    while (y < startY + height) {
                        int tileX = x;
                        int tileY = y++;
                        executorService.execute(() -> {
                            if (cancelled.get()) {
                                return;
                            }
                            Tile tile = this.createTile(tileFactory, anchor, tileX, tileY);
                            dimension.addTile(tile);
                            if (progressReceiver == null) return;
                            int[] nArray = tileCount;
                            synchronized (tileCount) {
                                tileCount[0] = tileCount[0] + 1;
                                try {
                                    progressReceiver.setProgress((float)tileCount[0] / (float)totalTiles);
                                }
                                catch (ProgressReceiver.OperationCancelled e) {
                                    cancelled.set(true);
                                }
                                return;
                            }
                        });
                    }
                }
            }
            executorService.shutdown();
            try {
                executorService.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread interrupted", e);
            }
            if (cancelled.get()) {
                Dimension dimension2 = null;
                return dimension2;
            }
        }
        finally {
            dimension.setEventsInhibited(false);
        }
        return dimension;
    }

    private Tile createTile(TileFactory tileFactory, Dimension.Anchor anchor, int tileX, int tileY) {
        Tile tile = tileFactory.createTile(tileX, tileY);
        if (anchor.role == Dimension.Role.MASTER && this.baseDimension != null) {
            for (int xInMasterTile = 0; xInMasterTile < 128; ++xInMasterTile) {
                for (int yInMasterTile = 0; yInMasterTile < 128; ++yInMasterTile) {
                    int yInDetailTile;
                    int xInDetailTile;
                    int masterX = tileX << 7 | xInMasterTile;
                    int detailX = masterX << 4;
                    int detailTileX = detailX >> 7;
                    int masterY = tileY << 7 | yInMasterTile;
                    int detailY = masterY << 4;
                    int detailTileY = detailY >> 7;
                    Tile detailTile = this.baseDimension.getTile(detailTileX, detailTileY);
                    if (detailTile == null || detailTile.getBitLayerValue((Layer)NotPresent.INSTANCE, xInDetailTile = detailX & 0x7F, yInDetailTile = detailY & 0x7F)) continue;
                    HashMap<Integer, Integer> waterHeights = new HashMap<Integer, Integer>();
                    HashMap<Terrain, Integer> terrainTypes = new HashMap<Terrain, Integer>();
                    float terrainHeightTotal = 0.0f;
                    for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
                        for (int yInChunk = 0; yInChunk < 16; ++yInChunk) {
                            int myX = xInDetailTile + xInChunk;
                            int myY = yInDetailTile + yInChunk;
                            terrainHeightTotal += detailTile.getHeight(myX, myY);
                            int waterHeight = detailTile.getWaterLevel(myX, myY);
                            int waterHeightTotal = waterHeights.computeIfAbsent(waterHeight, k -> 0);
                            waterHeights.put(waterHeight, waterHeightTotal + 1);
                            Terrain terrain = detailTile.getTerrain(myX, myY);
                            int terrainTotal = terrainTypes.computeIfAbsent(terrain, k -> 0);
                            terrainTypes.put(terrain, terrainTotal + 1);
                        }
                    }
                    float averageTerrainHeight = terrainHeightTotal / 256.0f;
                    int mostPrevalentWaterHeight = Integer.MIN_VALUE;
                    int mostPrevalentWaterHeightCount = 0;
                    for (Map.Entry entry : waterHeights.entrySet()) {
                        if ((Integer)entry.getValue() <= mostPrevalentWaterHeightCount) continue;
                        mostPrevalentWaterHeight = (Integer)entry.getKey();
                        mostPrevalentWaterHeightCount = (Integer)entry.getValue();
                    }
                    Terrain mostPrevalentTerrain = null;
                    int mostPrevalentTerrainCount = 0;
                    for (Map.Entry entry : terrainTypes.entrySet()) {
                        if ((Integer)entry.getValue() <= mostPrevalentTerrainCount) continue;
                        mostPrevalentTerrain = (Terrain)entry.getKey();
                        mostPrevalentTerrainCount = (Integer)entry.getValue();
                    }
                    tile.setHeight(xInMasterTile, yInMasterTile, averageTerrainHeight);
                    tile.setWaterLevel(xInMasterTile, yInMasterTile, mostPrevalentWaterHeight);
                    tile.setTerrain(xInMasterTile, yInMasterTile, mostPrevalentTerrain);
                }
            }
        }
        return tile;
    }

    private Dimension createDimension(World2 world, Dimension.Anchor anchor) {
        long minecraftSeed;
        try {
            minecraftSeed = Long.parseLong(this.fieldSeed.getText());
        }
        catch (NumberFormatException e) {
            minecraftSeed = this.fieldSeed.getText().hashCode();
        }
        if (this.radioButtonCustomSeed.isSelected()) {
            this.worldpainterSeed = minecraftSeed;
        }
        int waterHeight = (Integer)this.spinnerWaterLevel.getValue();
        TileFactory tileFactory = this.createTileFactory(this.worldpainterSeed, anchor.role);
        Dimension dimension = new Dimension(world, anchor.getDefaultName(), minecraftSeed, tileFactory, anchor);
        ResourcesExporter.ResourcesExporterSettings resourcesSettings = (ResourcesExporter.ResourcesExporterSettings)dimension.getLayerSettings((Layer)Resources.INSTANCE);
        if (anchor.invert) {
            int maxZ = dimension.getMaxHeight() + dimension.getMinHeight() - 1;
            for (Object material : resourcesSettings.getMaterials()) {
                int n = resourcesSettings.getMinLevel((Material)material);
                resourcesSettings.setMinLevel((Material)material, maxZ - resourcesSettings.getMaxLevel((Material)material));
                resourcesSettings.setMaxLevel((Material)material, maxZ - n);
            }
        }
        if (anchor.dim == 1) {
            if (!anchor.invert) {
                dimension.setSubsurfaceMaterial(Terrain.NETHERLIKE);
                CavernsExporter.CavernsSettings cavernsSettings = new CavernsExporter.CavernsSettings();
                cavernsSettings.setCavernsEverywhereLevel(16);
                cavernsSettings.setSurfaceBreaking(true);
                cavernsSettings.setFloodWithLava(true);
                cavernsSettings.setWaterLevel(16);
                cavernsSettings.setCaveDecorationSettings(null);
                dimension.setLayerSettings((Layer)Caverns.INSTANCE, (ExporterSettings)cavernsSettings);
            } else {
                dimension.setSubsurfaceMaterial(Terrain.NETHERLIKE);
            }
        } else if (anchor.dim == 2) {
            dimension.setSubsurfaceMaterial(Terrain.END_STONE);
        }
        Configuration config = Configuration.getInstance();
        Dimension defaults = config.getDefaultTerrainAndLayerSettings();
        if (anchor.dim == 0 && !anchor.invert) {
            if (!this.checkBoxCircular.isSelected()) {
                dimension.setBorder(defaults.getBorder());
                dimension.setBorderSize(defaults.getBorderSize());
            }
            dimension.setWallType(defaults.getWallType());
            dimension.setRoofType(defaults.getRoofType());
            dimension.setSubsurfaceMaterial(defaults.getSubsurfaceMaterial());
            dimension.setPopulate(defaults.isPopulate());
            dimension.setTopLayerMinDepth(defaults.getTopLayerMinDepth());
            dimension.setTopLayerVariation(defaults.getTopLayerVariation());
            dimension.setBottomless(defaults.isBottomless());
            for (Map.Entry entry : defaults.getAllLayerSettings().entrySet()) {
                dimension.setLayerSettings((Layer)entry.getKey(), ((ExporterSettings)entry.getValue()).clone());
            }
            MapGenerator generator = config.getDefaultGenerator();
            if (generator instanceof SeededGenerator) {
                ((SeededGenerator)generator).setSeed(dimension.getMinecraftSeed());
            }
            dimension.setGenerator(generator);
        }
        if (anchor.role == Dimension.Role.MASTER) {
            dimension.setScale(this.scale);
        }
        if (this.baseDimension != null) {
            resourcesSettings.setMinimumLevel(((ResourcesExporter.ResourcesExporterSettings)this.baseDimension.getLayerSettings((Layer)Resources.INSTANCE)).getMinimumLevel());
        } else {
            resourcesSettings.setMinimumLevel(config.getDefaultResourcesMinimumLevel());
        }
        dimension.setBorderLevel(waterHeight);
        dimension.setCoverSteepTerrain(defaults.isCoverSteepTerrain());
        dimension.setGridEnabled(config.isDefaultGridEnabled());
        dimension.setGridSize(config.getDefaultGridSize());
        dimension.setContoursEnabled(config.isDefaultContoursEnabled());
        dimension.setContourSeparation(config.getDefaultContourSeparation());
        dimension.setExportSettings(config.getDefaultExportSettings());
        return dimension;
    }

    private void setControlStates() {
        boolean surfaceDimension = this.anchor.dim == 0 && !this.anchor.invert;
        this.checkBoxExtendedBlockIds.setEnabled(this.platform.capabilities.contains(Platform.Capability.BLOCK_BASED) && !this.platform.capabilities.contains(Platform.Capability.NAME_BASED) && this.platform != DefaultPlugin.JAVA_MCREGION);
        boolean hilly = this.radioButtonHilly.isSelected();
        this.spinnerRange.setEnabled(hilly);
        this.spinnerScale.setEnabled(hilly);
        this.spinnerLength.setEnabled(this.tiles == null && !this.checkBoxCircular.isSelected());
        boolean seedLocked = this.tiles != null || !this.platform.capabilities.contains(Platform.Capability.SEED) || this.anchor.invert || this.anchor.role != Dimension.Role.DETAIL;
        this.radioButtonOceanSeed.setEnabled(surfaceDimension && !seedLocked);
        this.radioButtonLandSeed.setEnabled(surfaceDimension && !seedLocked);
        this.radioButtonCustomSeed.setEnabled(surfaceDimension && !seedLocked);
        this.buttonRandomSeed.setEnabled(surfaceDimension && this.radioButtonCustomSeed.isSelected() && !seedLocked);
        this.fieldSeed.setEnabled(surfaceDimension && this.radioButtonCustomSeed.isSelected() && !seedLocked);
        boolean advancedTerrain = this.radioButtonAdvancedTerrain.isSelected();
        this.comboBoxSurfaceMaterial.setEnabled(!advancedTerrain);
        this.labelAdvancedTerrain.setEnabled(advancedTerrain);
        this.labelAdvancedTerrain.setCursor(advancedTerrain ? Cursor.getPredefinedCursor(12) : null);
    }

    private void updatePreview() {
        long tmpSeed;
        if (this.programmaticChange) {
            return;
        }
        if (this.radioButtonCustomSeed.isSelected()) {
            try {
                tmpSeed = Long.parseLong(this.fieldSeed.getText());
            }
            catch (NumberFormatException e) {
                tmpSeed = this.fieldSeed.getText().hashCode();
            }
        } else {
            tmpSeed = this.worldpainterSeed;
        }
        final TileFactory tileFactory = this.createTileFactory(tmpSeed, Dimension.Role.DETAIL);
        TileProvider tileProvider = new TileProvider(){
            private final Map<Point, Tile> cache = new HashMap<Point, Tile>();

            public Rectangle getExtent() {
                return null;
            }

            public boolean isTilePresent(int x, int y) {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Tile getTile(int x, int y) {
                Point coords = new Point(x, y);
                Map<Point, Tile> map = this.cache;
                synchronized (map) {
                    Tile tile = this.cache.get(coords);
                    if (tile == null) {
                        tile = tileFactory.createTile(x, y);
                        this.cache.put(coords, tile);
                    }
                    return tile;
                }
            }
        };
        Configuration config = Configuration.getInstance();
        this.tiledImageViewer1.setTileProvider((org.pepsoft.util.swing.TileProvider)new WPTileProvider(tileProvider, this.colourScheme, this.app.getCustomBiomeManager(), Collections.singleton(Biome.INSTANCE), config.isDefaultContoursEnabled(), config.getDefaultContourSeparation(), config.getDefaultLightOrigin(), null));
    }

    private TileFactory createTileFactory(long seed, Dimension.Role role) {
        HeightMapTileFactory tileFactory;
        double additionalScale;
        Terrain terrain = (Terrain)this.comboBoxSurfaceMaterial.getSelectedItem();
        int baseHeight = (Integer)this.spinnerTerrainLevel.getValue();
        int waterHeight = (Integer)this.spinnerWaterLevel.getValue();
        float range = ((Number)this.spinnerRange.getValue()).floatValue();
        double scale = (double)((Integer)this.spinnerScale.getValue()).intValue() / 100.0;
        boolean floodWithLava = this.checkBoxLava.isSelected();
        boolean beaches = this.checkBoxBeaches.isSelected();
        int minHeight = (Integer)this.comboBoxMinHeight.getSelectedItem();
        int maxHeight = (Integer)this.comboBoxMaxHeight.getSelectedItem();
        double d = additionalScale = role == Dimension.Role.MASTER ? 16.0 : 1.0;
        if ("true".equals(System.getProperty("org.pepsoft.worldpainter.fancyworlds"))) {
            tileFactory = TileFactoryFactory.createFancyTileFactory((long)seed, (Terrain)terrain, (int)minHeight, (int)maxHeight, (int)baseHeight, (int)waterHeight, (boolean)floodWithLava, (float)range, (double)(scale / additionalScale));
        } else {
            tileFactory = this.radioButtonHilly.isSelected() ? TileFactoryFactory.createNoiseTileFactory((long)seed, (Terrain)terrain, (int)minHeight, (int)maxHeight, (int)baseHeight, (int)waterHeight, (boolean)floodWithLava, (boolean)beaches, (float)range, (double)(scale / additionalScale)) : TileFactoryFactory.createFlatTileFactory((long)seed, (Terrain)terrain, (int)minHeight, (int)maxHeight, (int)baseHeight, (int)waterHeight, (boolean)floodWithLava, (boolean)beaches);
            if (this.radioButtonAdvancedTerrain.isSelected()) {
                this.theme.setWaterHeight(((Integer)this.spinnerWaterLevel.getValue()).intValue());
                this.theme.setBeaches(this.checkBoxBeaches.isSelected());
                tileFactory.setTheme((Theme)this.theme);
            }
            Configuration config = Configuration.getInstance();
            Dimension defaults = config.getDefaultTerrainAndLayerSettings();
            if (this.anchor.dim == 0 && !this.anchor.invert && defaults.getTileFactory() instanceof HeightMapTileFactory && ((HeightMapTileFactory)defaults.getTileFactory()).getTheme() instanceof SimpleTheme && ((SimpleTheme)((HeightMapTileFactory)defaults.getTileFactory()).getTheme()).getTerrainRanges() != null && this.radioButtonSimpleTerrain.isSelected()) {
                HeightMapTileFactory defaultTileFactory = (HeightMapTileFactory)defaults.getTileFactory();
                SimpleTheme defaultTheme = (SimpleTheme)defaultTileFactory.getTheme().clone();
                defaultTheme.setMinMaxHeight(minHeight, maxHeight, HeightTransform.IDENTITY);
                TreeMap<Integer, Terrain> terrainRanges = new TreeMap<Integer, Terrain>(defaultTheme.getTerrainRanges());
                int surfaceLevel = terrainRanges.headMap(waterHeight + 3).lastKey();
                terrainRanges.put(surfaceLevel, terrain);
                SimpleTheme theme = (SimpleTheme)tileFactory.getTheme();
                theme.setTerrainRanges(terrainRanges);
                theme.setRandomise(defaultTheme.isRandomise());
            } else if ((this.anchor.dim != 0 || this.anchor.invert) && this.radioButtonSimpleTerrain.isSelected()) {
                TreeMap<Integer, Terrain> terrainMap = new TreeMap<Integer, Terrain>();
                terrainMap.put(-1, terrain);
                SimpleTheme theme = (SimpleTheme)tileFactory.getTheme();
                theme.setTerrainRanges(terrainMap);
            }
        }
        return tileFactory;
    }

    private void updateWalkingTimes() {
        int width = Math.round((float)((Integer)this.spinnerWidth.getValue()).intValue() * this.scale);
        int length = Math.round((float)((Integer)this.spinnerLength.getValue()).intValue() * this.scale);
        if (this.checkBoxCircular.isSelected()) {
            this.labelWalkingTimes.setText(MinecraftUtil.blocksToWalkingTime((int)width));
        } else {
            String northSouthTime;
            String westEastTime = MinecraftUtil.blocksToWalkingTime((int)width);
            if (westEastTime.equals(northSouthTime = MinecraftUtil.blocksToWalkingTime((int)length))) {
                this.labelWalkingTimes.setText(westEastTime);
            } else {
                this.labelWalkingTimes.setText("West to east: " + westEastTime + ", north to south: " + northSouthTime);
            }
        }
        if (this.scale == 1.0f) {
            this.labelScaledDimensions.setText(" ");
        } else if (this.checkBoxCircular.isSelected()) {
            this.labelScaledDimensions.setText("(Scaled: " + App.INT_NUMBER_FORMAT.format(width) + ")");
        } else {
            this.labelScaledDimensions.setText("(Scaled: " + App.INT_NUMBER_FORMAT.format(width) + " x " + App.INT_NUMBER_FORMAT.format(length) + ")");
        }
    }

    private void editTheme() {
        this.theme.setWaterHeight(((Integer)this.spinnerWaterLevel.getValue()).intValue());
        this.theme.setBeaches(this.checkBoxBeaches.isSelected());
        EditSimpleThemeDialog dialog = new EditSimpleThemeDialog((Window)this, this.theme);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            this.theme = dialog.getTheme();
            this.spinnerWaterLevel.setValue(this.theme.getWaterHeight());
            this.checkBoxBeaches.setSelected(this.theme.isBeaches());
            this.setControlStates();
            this.updatePreview();
        }
    }

    private void initPlatform() {
        int minMinHeight;
        int maxWidth = (int)Math.min(((long)this.platform.maxX - (long)this.platform.minX) / 128L * 128L, Integer.MAX_VALUE);
        int maxLength = (int)Math.min(((long)this.platform.maxY - (long)this.platform.minY) / 128L * 128L, Integer.MAX_VALUE);
        SpinnerNumberModel model = (SpinnerNumberModel)this.spinnerWidth.getModel();
        model.setMaximum(Integer.valueOf(maxWidth));
        if ((Integer)model.getValue() > maxWidth) {
            model.setValue(maxWidth);
        }
        model = (SpinnerNumberModel)this.spinnerLength.getModel();
        model.setMaximum(Integer.valueOf(maxLength));
        if ((Integer)model.getValue() > maxLength) {
            model.setValue(maxLength);
        }
        this.updateWalkingTimes();
        int maxMaxHeight = switch (this.anchor.dim) {
            case 1 -> {
                minMinHeight = Math.max(this.platform.minMinHeight, 0);
                yield Math.min(this.platform.maxMaxHeight, 256);
            }
            case 2 -> {
                minMinHeight = Math.max(this.platform.minMinHeight, 0);
                yield Math.min(this.platform.maxMaxHeight, 256);
            }
            default -> {
                minMinHeight = this.platform.minMinHeight;
                yield this.platform.maxMaxHeight;
            }
        };
        ArrayList<Integer> maxHeights = new ArrayList<Integer>(Ints.asList((int[])this.platform.maxHeights));
        maxHeights.removeIf(height -> height.compareTo(maxMaxHeight) > 0);
        this.comboBoxMaxHeight.setModel(new DefaultComboBoxModel<Integer>(maxHeights.toArray(new Integer[maxHeights.size()])));
        this.comboBoxMaxHeight.setEnabled(this.anchor.role == Dimension.Role.DETAIL && !this.anchor.invert && maxHeights.size() > 1);
        ArrayList<Integer> minHeights = new ArrayList<Integer>(Ints.asList((int[])this.platform.minHeights));
        minHeights.removeIf(height -> height.compareTo(minMinHeight) < 0);
        this.comboBoxMinHeight.setModel(new DefaultComboBoxModel<Integer>(minHeights.toArray(new Integer[minHeights.size()])));
        this.comboBoxMinHeight.setEnabled(this.anchor.role == Dimension.Role.DETAIL && !this.anchor.invert && minHeights.size() > 1);
    }

    private void setPlatform(Platform platform) {
        boolean minHeightAtDefault;
        boolean maxHeightAtDefault;
        int defaultMaxHeight;
        int previousDefaultMaxHeight;
        int defaultMinHeight;
        int previousDefaultMinHeight;
        if (this.programmaticChange) {
            return;
        }
        Platform previousPlatform = this.platform;
        Integer previousMinHeight = (Integer)this.comboBoxMinHeight.getSelectedItem();
        Integer previousMaxHeight = (Integer)this.comboBoxMaxHeight.getSelectedItem();
        this.platform = platform;
        this.initPlatform();
        switch (this.anchor.dim) {
            case 1: {
                previousDefaultMinHeight = 0;
                defaultMinHeight = 0;
                previousDefaultMaxHeight = 256;
                defaultMaxHeight = 256;
                break;
            }
            case 2: {
                previousDefaultMinHeight = 0;
                defaultMinHeight = 0;
                previousDefaultMaxHeight = 256;
                defaultMaxHeight = 256;
                break;
            }
            default: {
                defaultMinHeight = platform.minZ;
                defaultMaxHeight = platform.standardMaxHeight;
                previousDefaultMinHeight = previousPlatform != null ? previousPlatform.minZ : Integer.MIN_VALUE;
                previousDefaultMaxHeight = previousPlatform != null ? previousPlatform.standardMaxHeight : Integer.MIN_VALUE;
            }
        }
        boolean bl = maxHeightAtDefault = previousMaxHeight == null || previousMaxHeight == previousDefaultMaxHeight;
        if (maxHeightAtDefault) {
            this.comboBoxMaxHeight.setSelectedItem(defaultMaxHeight);
        } else if (previousMaxHeight < platform.minMaxHeight) {
            this.comboBoxMaxHeight.setSelectedItem(platform.minMaxHeight);
        } else if (previousMaxHeight > platform.maxMaxHeight) {
            this.comboBoxMaxHeight.setSelectedItem(platform.maxMaxHeight);
        } else {
            this.comboBoxMaxHeight.setSelectedItem(previousMaxHeight);
        }
        boolean bl2 = minHeightAtDefault = previousMinHeight == null || previousMinHeight == previousDefaultMinHeight;
        if (minHeightAtDefault) {
            this.comboBoxMinHeight.setSelectedItem(defaultMinHeight);
        } else if (previousMinHeight < platform.minMinHeight) {
            this.comboBoxMinHeight.setSelectedItem(platform.minMinHeight);
        } else if (previousMinHeight > platform.maxMinHeight) {
            this.comboBoxMinHeight.setSelectedItem(platform.maxMinHeight);
        } else {
            this.comboBoxMinHeight.setSelectedItem(previousMinHeight);
        }
        this.processBuildLimits(true);
        this.setControlStates();
    }

    private void processBuildLimits(boolean force) {
        int minHeight = (Integer)this.comboBoxMinHeight.getSelectedItem();
        int maxHeight = (Integer)this.comboBoxMaxHeight.getSelectedItem();
        if (force || minHeight != this.previousMinHeight || maxHeight != this.previousMaxHeight) {
            this.previousMinHeight = minHeight;
            this.previousMaxHeight = maxHeight;
            int terrainLevel = (Integer)this.spinnerTerrainLevel.getValue();
            int waterLevel = (Integer)this.spinnerWaterLevel.getValue();
            int newWaterLevel = Math.min(waterLevel, maxHeight - 1);
            int newTerrainLevel = Math.min(terrainLevel, maxHeight - 1);
            this.spinnerTerrainLevel.setValue(newTerrainLevel);
            this.spinnerWaterLevel.setValue(newWaterLevel);
            SpinnerUtils.setMinimum((JSpinner)this.spinnerTerrainLevel, (Comparable)Integer.valueOf(minHeight));
            SpinnerUtils.setMaximum((JSpinner)this.spinnerTerrainLevel, (Comparable)Integer.valueOf(maxHeight - 1));
            SpinnerUtils.setMinimum((JSpinner)this.spinnerWaterLevel, (Comparable)Integer.valueOf(minHeight));
            SpinnerUtils.setMaximum((JSpinner)this.spinnerWaterLevel, (Comparable)Integer.valueOf(maxHeight - 1));
            if (this.platform == DefaultPlugin.JAVA_MCREGION && maxHeight != 128) {
                this.labelWarning.setIcon(ICON_WARNING);
                this.labelWarning.setText("Only with mods!");
            } else if (((Version)this.platform.getAttribute(DefaultPlugin.ATTRIBUTE_MC_VERSION)).isAtLeast(Constants.V_1_17) && maxHeight - minHeight > 384) {
                this.labelWarning.setIcon(ICON_WARNING);
                this.labelWarning.setText("May impact performance");
            } else {
                this.labelWarning.setIcon(null);
                this.labelWarning.setText(" ");
            }
            int range = (Integer)this.spinnerRange.getValue();
            if (range >= maxHeight - minHeight) {
                this.spinnerRange.setValue(maxHeight - 1);
            }
            ((SpinnerNumberModel)this.spinnerRange.getModel()).setMaximum(Integer.valueOf(maxHeight - 1 - minHeight));
            this.setControlStates();
            this.updatePreview();
        }
    }

    public static void showMasterDimensionInfo(Window parent) {
        MessageUtils.showInfo((Component)parent, (String)"<html><h1>Master Dimensions</h1><p>A Master Dimension is a WorldPainter dimension type (similar to a Ceiling Dimension). It is Exported<br>at 1:16 scale wherever the regular Surface Dimension does not exist. Because the Master Dimension is<br>only scaled at Export, operations such as saving, loading and editing it are <em>much</em> faster than<br>creating a regular Surface Dimension of that size. Note that exporting it takes just as long though.<p><p>Use a Master Dimension to quickly create large featureless areas of your world (oceans, continents,<br>deserts, etc.). When you add tiles to the surface Dimension, they will be initialised to the contents<br>of the Master Dimension in that location. This allows you to quickly sketch out the rough shapes of<br>your world in the Master Dimension, and then fill in the details where necessary in the surface Dimension.<p><p>Master Dimensions can use all the features of regular surface Dimensions (terrain types, layers, etc.)<br>so large forests, cave systems, etc. are also easily created with it.</html>", (String)"What Is A Master Dimension");
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel14 = new JLabel();
        this.buttonCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.spinnerWaterLevel = new JSpinner();
        this.jLabel20 = new JLabel();
        this.radioButtonFlat = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.comboBoxMaxHeight = new JComboBox();
        this.spinnerLength = new JSpinner();
        this.jLabel6 = new JLabel();
        this.jLabel9 = new JLabel();
        this.fieldSeed = new JTextField();
        this.spinnerRange = new JSpinner();
        this.checkBoxCircular = new JCheckBox();
        this.jLabel19 = new JLabel();
        this.spinnerTerrainLevel = new JSpinner();
        this.jLabel8 = new JLabel();
        this.jLabel11 = new JLabel();
        this.checkBoxBeaches = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.spinnerScale = new JSpinner();
        this.jLabel7 = new JLabel();
        this.radioButtonHilly = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.buttonRandomSeed = new JButton();
        this.comboBoxSurfaceMaterial = new JComboBox();
        this.jLabel10 = new JLabel();
        this.jLabel17 = new JLabel();
        this.fieldName = new JTextField();
        this.jLabel1 = new JLabel();
        this.checkBoxLava = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jLabel18 = new JLabel();
        this.spinnerWidth = new JSpinner();
        this.radioButtonOceanSeed = new JRadioButton();
        this.radioButtonLandSeed = new JRadioButton();
        this.radioButtonCustomSeed = new JRadioButton();
        this.labelWarning = new JLabel();
        this.checkBoxExtendedBlockIds = new JCheckBox();
        this.jLabel12 = new JLabel();
        this.labelWalkingTimes = new JLabel();
        this.radioButtonSimpleTerrain = new JRadioButton();
        this.radioButtonAdvancedTerrain = new JRadioButton();
        this.labelAdvancedTerrain = new JLabel();
        this.jLabel13 = new JLabel();
        this.comboBoxTarget = new JComboBox();
        this.checkBoxMasterDimension = new JCheckBox();
        this.buttonMasterInfo = new JButton();
        this.labelScaledDimensions = new JLabel();
        this.jLabel15 = new JLabel();
        this.comboBoxMinHeight = new JComboBox();
        this.jLabel16 = new JLabel();
        this.jPanel3 = new JPanel();
        this.tiledImageViewer1 = new TiledImageViewer();
        this.buttonCreate = new JButton();
        this.jCheckBox1.setText("jCheckBox1");
        this.jLabel14.setText("jLabel14");
        this.setDefaultCloseOperation(2);
        this.setTitle("Create New World");
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.spinnerWaterLevel.setModel(new SpinnerNumberModel(62, 0, 127, 1));
        this.spinnerWaterLevel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NewWorldDialog.this.spinnerWaterLevelStateChanged(evt);
            }
        });
        this.jLabel20.setText("%");
        this.buttonGroup1.add(this.radioButtonFlat);
        this.radioButtonFlat.setText("Flat");
        this.radioButtonFlat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.radioButtonFlatActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Level:");
        this.comboBoxMaxHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.comboBoxMaxHeightActionPerformed(evt);
            }
        });
        this.spinnerLength.setModel(new SpinnerNumberModel((Number)640, Integer.valueOf(1), null, (Number)128));
        this.spinnerLength.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NewWorldDialog.this.spinnerLengthStateChanged(evt);
            }
        });
        this.jLabel6.setText("Surface material:");
        this.jLabel9.setText("Water level:");
        this.fieldSeed.setText("202961");
        this.fieldSeed.setEnabled(false);
        this.fieldSeed.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                NewWorldDialog.this.fieldSeedFocusLost(evt);
            }
        });
        this.spinnerRange.setModel(new SpinnerNumberModel(20, 1, 255, 1));
        this.spinnerRange.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NewWorldDialog.this.spinnerRangeStateChanged(evt);
            }
        });
        this.checkBoxCircular.setText("Circular world");
        this.checkBoxCircular.setToolTipText("<html>This will create a cirular world. The dimension indicates the diameter of the circle, and<br>\nthe origin (0,0) will be the centre. The Void layer will be used to create the circular edge of the world.</html>");
        this.checkBoxCircular.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.checkBoxCircularActionPerformed(evt);
            }
        });
        this.jLabel19.setText("Horizontal hill size:");
        this.spinnerTerrainLevel.setModel(new SpinnerNumberModel(58, 1, 127, 1));
        this.spinnerTerrainLevel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NewWorldDialog.this.spinnerTerrainLevelStateChanged(evt);
            }
        });
        this.jLabel8.setText("Name:");
        this.jLabel11.setText("blocks");
        this.checkBoxBeaches.setSelected(true);
        this.checkBoxBeaches.setText("Beaches:");
        this.checkBoxBeaches.setHorizontalTextPosition(10);
        this.checkBoxBeaches.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.checkBoxBeachesActionPerformed(evt);
            }
        });
        this.jLabel2.setText("x");
        this.spinnerScale.setModel(new SpinnerNumberModel(100, 1, 999, 1));
        this.spinnerScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NewWorldDialog.this.spinnerScaleStateChanged(evt);
            }
        });
        this.jLabel7.setText("Minecraft seed:");
        this.buttonGroup1.add(this.radioButtonHilly);
        this.radioButtonHilly.setSelected(true);
        this.radioButtonHilly.setText("Hilly");
        this.radioButtonHilly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.radioButtonHillyActionPerformed(evt);
            }
        });
        this.jLabel3.setText("blocks (in multiples of 128)");
        this.buttonRandomSeed.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/arrow_rotate_clockwise.png")));
        this.buttonRandomSeed.setToolTipText("Choose a random seed");
        this.buttonRandomSeed.setEnabled(false);
        this.buttonRandomSeed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.buttonRandomSeedActionPerformed(evt);
            }
        });
        this.comboBoxSurfaceMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.comboBoxSurfaceMaterialActionPerformed(evt);
            }
        });
        this.jLabel10.setText(", upper:");
        this.jLabel17.setText("(Minecraft default: 62)");
        this.fieldName.setText("Generated World");
        this.jLabel1.setText("Dimensions:");
        this.checkBoxLava.setText("Lava instead of water:");
        this.checkBoxLava.setHorizontalTextPosition(10);
        this.checkBoxLava.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.checkBoxLavaActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Topography:");
        this.jLabel18.setText("Hill height:");
        this.spinnerWidth.setModel(new SpinnerNumberModel((Number)640, Integer.valueOf(1), null, (Number)128));
        this.spinnerWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NewWorldDialog.this.spinnerWidthStateChanged(evt);
            }
        });
        this.buttonGroup2.add(this.radioButtonOceanSeed);
        this.radioButtonOceanSeed.setSelected(true);
        this.radioButtonOceanSeed.setText("Ocean");
        this.radioButtonOceanSeed.setToolTipText("A seed with a huge ocean around the origin");
        this.radioButtonOceanSeed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.radioButtonOceanSeedActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.radioButtonLandSeed);
        this.radioButtonLandSeed.setText("Land");
        this.radioButtonLandSeed.setToolTipText("A seed with a large continent around the origin");
        this.radioButtonLandSeed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.radioButtonLandSeedActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.radioButtonCustomSeed);
        this.radioButtonCustomSeed.setText(" ");
        this.radioButtonCustomSeed.setToolTipText("Set your own custom Minecraft seed");
        this.radioButtonCustomSeed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.radioButtonCustomSeedActionPerformed(evt);
            }
        });
        this.labelWarning.setFont(this.labelWarning.getFont().deriveFont(this.labelWarning.getFont().getStyle() | 1));
        this.labelWarning.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/error.png")));
        this.labelWarning.setText("Only with mods!");
        this.checkBoxExtendedBlockIds.setText("Extended block IDs:");
        this.checkBoxExtendedBlockIds.setToolTipText("Wether to support block IDs higher than 255 but lower than 4096, as used by various mods");
        this.checkBoxExtendedBlockIds.setHorizontalTextPosition(10);
        this.jLabel12.setText("Edge to edge walking time:");
        this.labelWalkingTimes.setText("...");
        this.buttonGroup3.add(this.radioButtonSimpleTerrain);
        this.radioButtonSimpleTerrain.setSelected(true);
        this.radioButtonSimpleTerrain.setText("Simple:");
        this.radioButtonSimpleTerrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.radioButtonSimpleTerrainActionPerformed(evt);
            }
        });
        this.buttonGroup3.add(this.radioButtonAdvancedTerrain);
        this.radioButtonAdvancedTerrain.setText("Advanced:");
        this.radioButtonAdvancedTerrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.radioButtonAdvancedTerrainActionPerformed(evt);
            }
        });
        this.labelAdvancedTerrain.setForeground(new Color(0, 51, 255));
        this.labelAdvancedTerrain.setText("<html><u>configure default terrain and layers</u></html>");
        this.labelAdvancedTerrain.setCursor(new Cursor(12));
        this.labelAdvancedTerrain.setEnabled(false);
        this.labelAdvancedTerrain.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewWorldDialog.this.labelAdvancedTerrainMouseClicked(evt);
            }
        });
        this.jLabel13.setText("Map format:");
        this.comboBoxTarget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.comboBoxTargetActionPerformed(evt);
            }
        });
        this.checkBoxMasterDimension.setText("create as master dimension (1:16 scale)");
        this.checkBoxMasterDimension.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.checkBoxMasterDimensionActionPerformed(evt);
            }
        });
        this.buttonMasterInfo.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/information.png")));
        this.buttonMasterInfo.setMargin(new Insets(0, 0, 0, 0));
        this.buttonMasterInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.buttonMasterInfoActionPerformed(evt);
            }
        });
        this.labelScaledDimensions.setText("(Scaled: 99999 x 99999)");
        this.jLabel15.setText("Build limits:");
        this.comboBoxMinHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.comboBoxMinHeightActionPerformed(evt);
            }
        });
        this.jLabel16.setText("lower:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fieldName).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.radioButtonOceanSeed).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonLandSeed).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonCustomSeed).addGap(0, 0, 0).addComponent(this.fieldSeed).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRandomSeed)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jLabel1).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.spinnerWidth, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerLength, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel3)).addComponent(this.jLabel4).addComponent(this.radioButtonFlat).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerTerrainLevel, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxLava).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerWaterLevel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel17)).addComponent(this.checkBoxBeaches))).addComponent(this.jLabel7).addComponent(this.checkBoxCircular).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.radioButtonHilly).addGap(18, 18, 18).addComponent(this.jLabel18).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerRange, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerScale, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel20)).addComponent(this.radioButtonSimpleTerrain).addComponent(this.jLabel6).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelWarning).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxMinHeight, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxMaxHeight, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel11))))).addContainerGap(14, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelScaledDimensions).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.checkBoxMasterDimension).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMasterInfo)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxTarget, -2, -1, -2)).addComponent(this.labelWalkingTimes).addComponent(this.jLabel12).addComponent(this.checkBoxExtendedBlockIds).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.radioButtonAdvancedTerrain).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboBoxSurfaceMaterial, -2, -1, -2).addComponent(this.labelAdvancedTerrain, -2, -1, -2)))).addGap(0, 0, Short.MAX_VALUE)))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldName, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.comboBoxTarget, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxMasterDimension).addComponent(this.buttonMasterInfo)).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spinnerWidth, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.spinnerLength, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelScaledDimensions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxCircular).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.comboBoxMaxHeight, -2, -1, -2).addComponent(this.jLabel11).addComponent(this.jLabel15).addComponent(this.comboBoxMinHeight, -2, -1, -2).addComponent(this.jLabel16)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelWarning).addGap(6, 6, 6).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelWalkingTimes).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonHilly).addComponent(this.jLabel18).addComponent(this.spinnerRange, -2, -1, -2).addComponent(this.jLabel19).addComponent(this.spinnerScale, -2, -1, -2).addComponent(this.jLabel20)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonFlat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.spinnerTerrainLevel, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.spinnerWaterLevel, -2, -1, -2).addComponent(this.jLabel17)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxLava).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxBeaches).addGap(18, 18, 18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboBoxSurfaceMaterial, -2, -1, -2).addComponent(this.radioButtonSimpleTerrain)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonAdvancedTerrain).addComponent(this.labelAdvancedTerrain, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.checkBoxExtendedBlockIds).addGap(18, 18, 18).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonRandomSeed).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonOceanSeed).addComponent(this.radioButtonLandSeed).addComponent(this.radioButtonCustomSeed).addComponent(this.fieldSeed, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createBevelBorder(1));
        GroupLayout tiledImageViewer1Layout = new GroupLayout((Container)this.tiledImageViewer1);
        this.tiledImageViewer1.setLayout((LayoutManager)tiledImageViewer1Layout);
        tiledImageViewer1Layout.setHorizontalGroup(tiledImageViewer1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 242, Short.MAX_VALUE));
        tiledImageViewer1Layout.setVerticalGroup(tiledImageViewer1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.tiledImageViewer1, -1, -1, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.tiledImageViewer1, -1, -1, Short.MAX_VALUE));
        this.buttonCreate.setText("Create");
        this.buttonCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewWorldDialog.this.buttonCreateActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonCreate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonCreate)).addContainerGap()));
        this.pack();
    }

    private void buttonCreateActionPerformed(ActionEvent evt) {
        Configuration config;
        if (this.checkBoxMasterDimension.isSelected() && !(config = Configuration.getInstance()).isMessageDisplayedCountAtLeast("org.pepsoft.worldpainter.ImportHeightMapDialog.masterDimension", 3)) {
            DesktopUtils.beep();
            if (JOptionPane.showConfirmDialog(this, "<html><h1>About Master Dimensions</h1><p>A master dimension will be exported at 256 times the size (by area)<br>and is meant for speeding up the creation of very large maps.</p><ul>    <li>You <b>cannot change your mind</b> later; if you do not want this to be<br>a master dimension later you will have to start over.    <li>Loading, editing and saving are quicker, but Exporting is not!<br><b>Exporting takes 256 times longer</b> than a regular dimension<br>of the same pixel size in WorldPainter.    <li>You can detail areas of the Master Dimension at 1:1 scale by<br>switching to the Surface Dimension (" + App.COMMAND_KEY_NAME + "+M or View menu)<br>and then adding tiles (" + App.COMMAND_KEY_NAME + "+T or Edit menu).</ul><p>Are you sure?</p></html>", "Create Master Dimension?", 0, 2) != 0) {
                return;
            }
            config.setMessageDisplayed("org.pepsoft.worldpainter.ImportHeightMapDialog.masterDimension");
        }
        this.ok();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void radioButtonFlatActionPerformed(ActionEvent evt) {
        if (this.radioButtonFlat.isSelected()) {
            int minimumSpawnHeight;
            int terrainLevel = (Integer)this.spinnerTerrainLevel.getValue();
            int waterLevel = (Integer)this.spinnerWaterLevel.getValue();
            int maxHeight = (Integer)this.comboBoxMaxHeight.getSelectedItem();
            int n = minimumSpawnHeight = maxHeight == 128 || maxHeight == 256 || maxHeight == 320 ? 63 : maxHeight / 2 - 1;
            if (terrainLevel < minimumSpawnHeight + 1 && waterLevel < minimumSpawnHeight) {
                this.savedTerrainLevel = terrainLevel;
                terrainLevel = minimumSpawnHeight + 1;
                this.spinnerTerrainLevel.setValue(terrainLevel);
            } else {
                this.savedTerrainLevel = 0;
            }
        }
        this.setControlStates();
        this.updatePreview();
    }

    private void radioButtonHillyActionPerformed(ActionEvent evt) {
        if (this.savedTerrainLevel != 0) {
            this.spinnerTerrainLevel.setValue(this.savedTerrainLevel);
            this.savedTerrainLevel = 0;
        }
        this.setControlStates();
        this.updatePreview();
    }

    private void comboBoxMaxHeightActionPerformed(ActionEvent evt) {
        this.processBuildLimits(false);
    }

    private void spinnerWidthStateChanged(ChangeEvent evt) {
        int value = (Integer)this.spinnerWidth.getValue();
        if (!this.checkBoxCircular.isSelected()) {
            if ((value = Math.round((float)value / 128.0f) * 128) < 128) {
                value = 128;
            }
            this.spinnerWidth.setValue(value);
        } else if (value % 2 != 0) {
            this.spinnerWidth.setValue(value + 1);
        }
        this.updateWalkingTimes();
    }

    private void spinnerLengthStateChanged(ChangeEvent evt) {
        int value = (Integer)this.spinnerLength.getValue();
        if (!this.checkBoxCircular.isSelected()) {
            if ((value = Math.round((float)value / 128.0f) * 128) < 128) {
                value = 128;
            }
            this.spinnerLength.setValue(value);
        } else if (value % 2 != 0) {
            this.spinnerLength.setValue(value + 1);
        }
        this.updateWalkingTimes();
    }

    private void checkBoxCircularActionPerformed(ActionEvent evt) {
        if (this.checkBoxCircular.isSelected()) {
            ((SpinnerNumberModel)this.spinnerWidth.getModel()).setStepSize(2);
            this.jLabel3.setText("blocks (even number)");
        } else {
            ((SpinnerNumberModel)this.spinnerWidth.getModel()).setStepSize(128);
            this.spinnerWidth.setValue(Math.max(Math.round((float)((Integer)this.spinnerWidth.getValue()).intValue() / 128.0f) * 128, 128));
            this.jLabel3.setText("blocks (in multiples of 128)");
        }
        this.setControlStates();
        this.updateWalkingTimes();
    }

    private void buttonRandomSeedActionPerformed(ActionEvent evt) {
        this.fieldSeed.setText(Long.toString(new Random().nextLong()));
        this.updatePreview();
    }

    private void spinnerRangeStateChanged(ChangeEvent evt) {
        this.updatePreview();
    }

    private void spinnerScaleStateChanged(ChangeEvent evt) {
        this.updatePreview();
    }

    private void spinnerTerrainLevelStateChanged(ChangeEvent evt) {
        this.updatePreview();
    }

    private void spinnerWaterLevelStateChanged(ChangeEvent evt) {
        this.updatePreview();
    }

    private void checkBoxLavaActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void checkBoxBeachesActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void comboBoxSurfaceMaterialActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void fieldSeedFocusLost(FocusEvent evt) {
        this.updatePreview();
    }

    private void radioButtonOceanSeedActionPerformed(ActionEvent evt) {
        if (this.radioButtonOceanSeed.isSelected()) {
            this.fieldSeed.setText(Long.toString(27594263L));
            this.updatePreview();
            this.setControlStates();
        }
    }

    private void radioButtonLandSeedActionPerformed(ActionEvent evt) {
        if (this.radioButtonLandSeed.isSelected()) {
            this.fieldSeed.setText(Long.toString(227290L));
            this.updatePreview();
            this.setControlStates();
        }
    }

    private void radioButtonCustomSeedActionPerformed(ActionEvent evt) {
        if (this.radioButtonCustomSeed.isSelected()) {
            this.updatePreview();
            this.setControlStates();
        }
    }

    private void labelAdvancedTerrainMouseClicked(MouseEvent evt) {
        if (this.radioButtonAdvancedTerrain.isSelected()) {
            this.editTheme();
        }
    }

    private void radioButtonSimpleTerrainActionPerformed(ActionEvent evt) {
        this.setControlStates();
        this.updatePreview();
    }

    private void radioButtonAdvancedTerrainActionPerformed(ActionEvent evt) {
        this.setControlStates();
        this.updatePreview();
    }

    private void comboBoxTargetActionPerformed(ActionEvent evt) {
        this.setPlatform((Platform)this.comboBoxTarget.getSelectedItem());
    }

    private void buttonMasterInfoActionPerformed(ActionEvent evt) {
        NewWorldDialog.showMasterDimensionInfo(this);
    }

    private void checkBoxMasterDimensionActionPerformed(ActionEvent evt) {
        this.scale = this.checkBoxMasterDimension.isSelected() ? 16.0f : 1.0f;
        this.updateWalkingTimes();
        this.updatePreview();
    }

    private void comboBoxMinHeightActionPerformed(ActionEvent evt) {
        this.processBuildLimits(false);
    }
}

