/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.pepsoft.minecraft.exception.IncompatibleMaterialException;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.ExceptionUtils;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.util.swing.MultiProgressComponent;
import org.pepsoft.util.swing.ProgressComponent;
import org.pepsoft.util.swing.ProgressTask;
import org.pepsoft.worldpainter.ExceptionHandler;
import org.pepsoft.worldpainter.MissingCustomTerrainException;
import org.pepsoft.worldpainter.merging.InvalidMapException;
import org.pepsoft.worldpainter.util.FileInUseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiProgressDialog<T>
extends JDialog
implements ProgressComponent.Listener<T>,
ComponentListener {
    private MultiProgressComponent<T> multiProgressComponent1;
    private long start;
    private static final Logger logger = LoggerFactory.getLogger(MultiProgressDialog.class);
    private static final long serialVersionUID = 1L;

    public MultiProgressDialog(Window parent, String title) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.setTitle(title);
        GUIUtils.scaleToUI((Container)this);
        this.setLocationRelativeTo(parent);
        this.addComponentListener(this);
    }

    protected abstract String getVerb();

    protected abstract String getResultsReport(T var1, long var2);

    protected abstract String getCancellationMessage();

    protected abstract ProgressTask<T> getTask();

    protected void addButton(JButton button) {
        this.multiProgressComponent1.addButton(button);
    }

    public void exceptionThrown(Throwable exception) {
        AwtUtils.doLaterOnEventThread(() -> {
            if (ExceptionUtils.chainContains((Throwable)exception, FileInUseException.class)) {
                MessageUtils.beepAndShowError((Component)this, (String)("Could not " + this.getVerb().toLowerCase() + " the world because the existing map directory is in use.\nPlease close Minecraft and all other windows and try again."), (String)"Map In Use");
            } else if (ExceptionUtils.chainContains((Throwable)exception, MissingCustomTerrainException.class)) {
                MessageUtils.beepAndShowError((Component)this, (String)("Custom Terrain " + ((MissingCustomTerrainException)ExceptionUtils.getFromChainOfType((Throwable)exception, MissingCustomTerrainException.class)).getIndex() + " not configured!\nPlease configure it on the Custom Terrain panel.\n\nThe partially processed map is now probably corrupted.\nYou should replace it from the backup, or " + this.getVerb().toLowerCase() + " the map again."), (String)"Unconfigured Custom Terrain");
            } else if (ExceptionUtils.chainContains((Throwable)exception, InvalidMapException.class)) {
                MessageUtils.beepAndShowError((Component)this, (String)((InvalidMapException)ExceptionUtils.getFromChainOfType((Throwable)exception, InvalidMapException.class)).getMessage(), (String)"Invalid Map");
            } else if (ExceptionUtils.chainContains((Throwable)exception, IncompatibleMaterialException.class)) {
                MessageUtils.beepAndShowError((Component)this, (String)((IncompatibleMaterialException)ExceptionUtils.getFromChainOfType((Throwable)exception, IncompatibleMaterialException.class)).getMessage(), (String)"Incompatible Material");
            } else {
                ExceptionHandler.handleException(exception, this);
            }
            this.close();
        });
    }

    public void done(T result) {
        long end = System.currentTimeMillis();
        long duration = (end - this.start) / 1000L;
        AwtUtils.doLaterOnEventThread(() -> {
            String resultsReport = this.getResultsReport(result, duration);
            MessageUtils.showInfo((Component)this, (String)resultsReport, (String)"Success");
            this.close();
        });
    }

    public void cancelled() {
        logger.info(this.getVerb() + " cancelled by user");
        AwtUtils.doLaterOnEventThread(() -> {
            MessageUtils.showWarning((Component)this, (String)this.getCancellationMessage(), (String)(this.getVerb() + " Cancelled"));
            this.close();
        });
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.setDefaultCloseOperation(0);
        this.multiProgressComponent1.setTask(this.getTask());
        this.multiProgressComponent1.setListener((ProgressComponent.Listener)this);
        this.start = System.currentTimeMillis();
        this.multiProgressComponent1.start();
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private void close() {
        this.dispose();
    }

    private void initComponents() {
        this.multiProgressComponent1 = new MultiProgressComponent();
        this.setDefaultCloseOperation(2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent((Component)this.multiProgressComponent1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent((Component)this.multiProgressComponent1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }
}

