/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.util.FileFilter;
import org.pepsoft.worldpainter.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedMaterialHelper {
    private static final Logger logger = LoggerFactory.getLogger(MixedMaterialHelper.class);

    private MixedMaterialHelper() {
    }

    public static MixedMaterial load(Component parent) {
        block10: {
            File selectedFile;
            Configuration config = Configuration.getInstance();
            File terrainDirectory = config.getTerrainDirectory();
            if (terrainDirectory == null || !terrainDirectory.isDirectory()) {
                terrainDirectory = DesktopUtils.getDocumentsFolder();
            }
            if ((selectedFile = FileUtils.selectFileForOpen(SwingUtilities.getWindowAncestor(parent), "Select WorldPainter custom terrain file", terrainDirectory, new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".terrain");
                }

                @Override
                public String getDescription() {
                    return "WorldPainter Custom Terrains (*.terrain)";
                }

                @Override
                public String getExtensions() {
                    return "*.terrain";
                }
            })) != null) {
                MixedMaterial mixedMaterial;
                ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(selectedFile))));
                try {
                    mixedMaterial = (MixedMaterial)MixedMaterial.duplicateNewMaterialsWhile(() -> (MixedMaterial)in.readObject());
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        logger.error("{} while reading {}", new Object[]{e.getClass().getSimpleName(), selectedFile, e});
                        MessageUtils.beepAndShowError((Component)parent, (String)("An input error occurred while reading the file (message: " + e.getMessage() + ")"), (String)"Input Error");
                        break block10;
                    }
                    catch (ClassCastException e) {
                        logger.error("{} while reading {}", new Object[]{e.getClass().getSimpleName(), selectedFile, e});
                        MessageUtils.beepAndShowError((Component)parent, (String)"The selected file is not a valid WorldPainter custom terrain file", (String)"Invalid File");
                    }
                }
                in.close();
                return mixedMaterial;
            }
        }
        return null;
    }

    public static MixedMaterial[] loadMultiple(Component parent) {
        File[] selectedFiles;
        Configuration config = Configuration.getInstance();
        File terrainDirectory = config.getTerrainDirectory();
        if (terrainDirectory == null || !terrainDirectory.isDirectory()) {
            terrainDirectory = DesktopUtils.getDocumentsFolder();
        }
        if ((selectedFiles = FileUtils.selectFilesForOpen(SwingUtilities.getWindowAncestor(parent), "Select WorldPainter custom terrain file(s)", terrainDirectory, new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".terrain");
            }

            @Override
            public String getDescription() {
                return "WorldPainter Custom Terrains (*.terrain)";
            }

            @Override
            public String getExtensions() {
                return "*.terrain";
            }
        })) != null) {
            return (MixedMaterial[])MixedMaterial.duplicateNewMaterialsWhile(() -> {
                ArrayList<MixedMaterial> materials = new ArrayList<MixedMaterial>(selectedFiles.length);
                for (File selectedFile : selectedFiles) {
                    try (ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(selectedFile))));){
                        materials.add((MixedMaterial)in.readObject());
                    }
                    catch (IOException e) {
                        logger.error("{} while reading {}", new Object[]{e.getClass().getSimpleName(), selectedFile, e});
                        MessageUtils.beepAndShowError((Component)parent, (String)("An input error occurred while reading " + selectedFile + " (message: " + e.getMessage() + ")"), (String)"Input Error");
                    }
                    catch (ClassCastException e) {
                        logger.error("{} while reading {}", new Object[]{e.getClass().getSimpleName(), selectedFile, e});
                        MessageUtils.beepAndShowError((Component)parent, (String)(selectedFile + " is not a valid WorldPainter custom terrain file"), (String)"Invalid File");
                    }
                }
                return !materials.isEmpty() ? materials.toArray(new MixedMaterial[materials.size()]) : null;
            });
        }
        return null;
    }

    public static void save(Component parent, MixedMaterial material) {
        Configuration config = Configuration.getInstance();
        File terrainDirectory = config.getTerrainDirectory();
        if (terrainDirectory == null || !terrainDirectory.isDirectory()) {
            terrainDirectory = DesktopUtils.getDocumentsFolder();
        }
        File selectedFile = new File(terrainDirectory, org.pepsoft.util.FileUtils.sanitiseName((String)material.getName()) + ".terrain");
        selectedFile = FileUtils.selectFileForSave(SwingUtilities.getWindowAncestor(parent), "Export as WorldPainter custom terrain file", selectedFile, new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".terrain");
            }

            @Override
            public String getDescription() {
                return "WorldPainter Custom Terrains (*.terrain)";
            }

            @Override
            public String getExtensions() {
                return "*.terrain";
            }
        });
        if (selectedFile != null) {
            if (!selectedFile.getName().toLowerCase().endsWith(".terrain")) {
                selectedFile = new File(selectedFile.getPath() + ".terrain");
            }
            if (selectedFile.isFile() && JOptionPane.showConfirmDialog(parent, "The file " + selectedFile.getName() + " already exists.\nDo you want to overwrite it?", "Overwrite File", 0) == 1) {
                return;
            }
            try (ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(selectedFile))));){
                out.writeObject(material);
            }
            catch (IOException e) {
                throw new RuntimeException("I/O error while trying to write " + selectedFile, e);
            }
            config.setTerrainDirectory(selectedFile.getParentFile());
            MessageUtils.showInfo((Component)parent, (String)("Custom terrain " + material.getName() + " exported successfully"), (String)"Success");
        }
    }
}

