/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.CustomMaterialDialog;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.MixedMaterialListCellRenderer;
import org.pepsoft.worldpainter.MixedMaterialManager;
import org.pepsoft.worldpainter.Platform;

public class MixedMaterialChooser
extends JPanel {
    private JButton buttonAdd;
    private JButton buttonEdit;
    private JComboBox<MixedMaterial> jComboBox1;
    private final MixedMaterialListCellRenderer cellRenderer = new MixedMaterialListCellRenderer();
    private final boolean allowNull;
    private boolean extendedBlockIds;
    private ColourScheme colourScheme;
    private Platform platform;

    public MixedMaterialChooser() {
        this(false);
    }

    public MixedMaterialChooser(boolean allowNull) {
        this.allowNull = allowNull;
        this.initComponents();
        this.initComboBox(null);
        this.setControlStates();
    }

    public MixedMaterial getMaterial() {
        return (MixedMaterial)this.jComboBox1.getSelectedItem();
    }

    public void setMaterial(MixedMaterial material) {
        if (((DefaultComboBoxModel)this.jComboBox1.getModel()).getIndexOf(material) == -1) {
            this.initComboBox(material);
        }
        this.jComboBox1.setSelectedItem(material);
        this.setControlStates();
        this.firePropertyChange("material", null, material);
    }

    public boolean isExtendedBlockIds() {
        return this.extendedBlockIds;
    }

    public void setExtendedBlockIds(boolean extendedBlockIds) {
        this.extendedBlockIds = extendedBlockIds;
    }

    public ColourScheme getColourScheme() {
        return this.colourScheme;
    }

    public void setColourScheme(ColourScheme colourScheme) {
        this.colourScheme = colourScheme;
        this.cellRenderer.setColourScheme(colourScheme);
        this.repaint();
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public void refresh() {
        MixedMaterial selectedMaterial = (MixedMaterial)this.jComboBox1.getSelectedItem();
        this.initComboBox(selectedMaterial);
        this.jComboBox1.setSelectedItem(selectedMaterial);
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.jComboBox1.getBaseline(width, height);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setControlStates();
    }

    private void initComboBox(MixedMaterial unlistedMaterial) {
        MixedMaterial[] materials = MixedMaterialManager.getInstance().getMaterials();
        ArrayList<MixedMaterial> list = new ArrayList<MixedMaterial>(materials.length + 2);
        if (this.allowNull) {
            list.add(null);
        }
        list.addAll(Arrays.asList(materials));
        if (unlistedMaterial != null && !list.contains(unlistedMaterial)) {
            list.add(this.allowNull ? 1 : 0, unlistedMaterial);
        }
        this.jComboBox1.setModel(new DefaultComboBoxModel<MixedMaterial>(list.toArray(new MixedMaterial[list.size()])));
    }

    private void addMaterial() {
        MixedMaterial material = MixedMaterial.create((Platform)this.platform, (Material)Material.DIRT);
        CustomMaterialDialog dialog = new CustomMaterialDialog(SwingUtilities.getWindowAncestor(this), this.platform, material, this.extendedBlockIds, this.colourScheme);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            material = MixedMaterialManager.getInstance().register(material);
            this.initComboBox(null);
            this.jComboBox1.setSelectedItem(material);
            this.setControlStates();
        }
    }

    private void editMaterial() {
        CustomMaterialDialog dialog = new CustomMaterialDialog(SwingUtilities.getWindowAncestor(this), this.platform, (MixedMaterial)this.jComboBox1.getSelectedItem(), this.extendedBlockIds, this.colourScheme);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            this.jComboBox1.repaint();
            this.firePropertyChange("material", null, this.jComboBox1.getSelectedItem());
        }
    }

    private void setControlStates() {
        this.jComboBox1.setEnabled(this.isEnabled());
        this.buttonAdd.setEnabled(this.isEnabled());
        this.buttonEdit.setEnabled(this.isEnabled() && this.jComboBox1.getSelectedItem() != null);
    }

    private void initComponents() {
        this.jComboBox1 = new JComboBox();
        this.buttonEdit = new JButton();
        this.buttonAdd = new JButton();
        this.jComboBox1.setRenderer(this.cellRenderer);
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixedMaterialChooser.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.buttonEdit.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/brick_edit.png")));
        this.buttonEdit.setToolTipText("Edit the selected custom material");
        this.buttonEdit.setEnabled(false);
        this.buttonEdit.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixedMaterialChooser.this.buttonEditActionPerformed(evt);
            }
        });
        this.buttonAdd.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/brick_add.png")));
        this.buttonAdd.setToolTipText("Create a new custom material");
        this.buttonAdd.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixedMaterialChooser.this.buttonAddActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jComboBox1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEdit)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonEdit).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.buttonAdd));
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        this.addMaterial();
    }

    private void buttonEditActionPerformed(ActionEvent evt) {
        this.editMaterial();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.setControlStates();
        this.firePropertyChange("material", null, this.jComboBox1.getSelectedItem());
    }
}

