/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.ExportTileSelectionDialog;
import org.pepsoft.worldpainter.ImportWarningsDialog;
import org.pepsoft.worldpainter.MergeProgressDialog;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.TileRenderer;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.exporting.WorldExportSettings;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.merging.JavaWorldMerger;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.plugins.PlatformProvider;
import org.pepsoft.worldpainter.util.BackupUtils;
import org.pepsoft.worldpainter.util.MapUtils;
import org.pepsoft.worldpainter.util.MaterialUtils;
import org.pepsoft.worldpainter.util.MinecraftUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeWorldDialog
extends WorldPainterDialog {
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton buttonMerge;
    private JButton buttonSelectDirectory;
    private JCheckBox checkBoxAboveMergeBiomes;
    private JCheckBox checkBoxAboveMergeBlocks;
    private JCheckBox checkBoxBelowMergeBiomes;
    private JCheckBox checkBoxBelowMergeBlocks;
    private JCheckBox checkBoxEnd;
    private JCheckBox checkBoxFillCaves;
    private JCheckBox checkBoxNether;
    private JCheckBox checkBoxRemoveManMadeAboveGround;
    private JCheckBox checkBoxRemoveManMadeBelowGround;
    private JCheckBox checkBoxRemoveResources;
    private JCheckBox checkBoxRemoveTrees;
    private JCheckBox checkBoxRemoveVegetation;
    private JCheckBox checkBoxSurface;
    private JTextField fieldSelectedMapDir;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel labelPlatform;
    private JLabel labelSelectTiles;
    private JRadioButton radioButtonAll;
    private JRadioButton radioButtonExportEverything;
    private JRadioButton radioButtonExportSelection;
    private JRadioButton radioButtonReplaceChunks;
    private JSpinner spinnerSurfaceThickness;
    private final World2 world;
    private final ColourScheme colourScheme;
    private final Set<Layer> hiddenLayers;
    private final boolean contourLines;
    private final int contourSeparation;
    private final TileRenderer.LightOrigin lightOrigin;
    private final CustomBiomeManager customBiomeManager;
    private final WorldPainter view;
    private final Set<WorldExportSettings.Step> savedSteps;
    private File mapDir;
    private Platform platform;
    private volatile File backupDir;
    private int selectedDimension;
    private Set<Point> selectedTiles;
    private boolean disableTileSelectionWarning;
    private static final AttributeKey<MergeSettings> ATTRIBUTE_MERGE_SETTINGS = new AttributeKey("MergeWorldDialog.mergeSettings");
    private static final Logger logger = LoggerFactory.getLogger(MergeWorldDialog.class);
    private static final long serialVersionUID = 1L;

    public MergeWorldDialog(Window parent, World2 world, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, Set<Layer> hiddenLayers, boolean contourLines, int contourSeparation, TileRenderer.LightOrigin lightOrigin, WorldPainter view) {
        super(parent);
        this.world = world;
        this.colourScheme = colourScheme;
        this.hiddenLayers = hiddenLayers;
        this.contourLines = contourLines;
        this.contourSeparation = contourSeparation;
        this.lightOrigin = lightOrigin;
        this.customBiomeManager = customBiomeManager;
        this.view = view;
        WorldExportSettings exportSettings = world.getExportSettings() != null ? world.getExportSettings() : WorldExportSettings.EXPORT_EVERYTHING;
        this.selectedTiles = exportSettings.getTilesToExport();
        this.selectedDimension = this.selectedTiles != null ? (Integer)exportSettings.getDimensionsToExport().iterator().next() : 0;
        this.savedSteps = exportSettings.getStepsToSkip();
        this.initComponents();
        Configuration config = Configuration.getInstance();
        if (world.getMergedWith() != null) {
            this.fieldSelectedMapDir.setText(world.getMergedWith().getParentFile().getAbsolutePath());
        } else if (world.getImportedFrom() != null) {
            this.fieldSelectedMapDir.setText(world.getImportedFrom().getParentFile().getAbsolutePath());
        } else if (config != null && config.getSavesDirectory() != null) {
            this.fieldSelectedMapDir.setText(config.getSavesDirectory().getAbsolutePath());
        } else {
            File minecraftDir = MinecraftUtil.findMinecraftDir();
            if (minecraftDir != null) {
                this.fieldSelectedMapDir.setText(new File(minecraftDir, "saves").getAbsolutePath());
            } else {
                this.fieldSelectedMapDir.setText(DesktopUtils.getDocumentsFolder().getAbsolutePath());
            }
        }
        ((SpinnerNumberModel)this.spinnerSurfaceThickness.getModel()).setMaximum(Integer.valueOf(world.getMaxHeight()));
        if (this.selectedTiles != null) {
            this.radioButtonExportSelection.setText("merge " + this.selectedTiles.size() + " selected tiles");
            this.radioButtonExportSelection.setSelected(true);
            this.checkBoxSurface.setSelected(this.selectedDimension == 0);
            this.checkBoxNether.setSelected(this.selectedDimension == 1);
            this.checkBoxEnd.setSelected(this.selectedDimension == 2);
        } else if (exportSettings.getDimensionsToExport() != null) {
            this.checkBoxSurface.setSelected(exportSettings.getDimensionsToExport().contains(0));
            this.checkBoxNether.setSelected(exportSettings.getDimensionsToExport().contains(1));
            this.checkBoxEnd.setSelected(exportSettings.getDimensionsToExport().contains(2));
        } else {
            this.checkBoxSurface.setSelected(world.isDimensionPresent(Dimension.Anchor.NORMAL_DETAIL));
            this.checkBoxNether.setSelected(world.isDimensionPresent(Dimension.Anchor.NETHER_DETAIL));
            this.checkBoxEnd.setSelected(world.isDimensionPresent(Dimension.Anchor.END_DETAIL));
        }
        world.getAttribute(ATTRIBUTE_MERGE_SETTINGS).ifPresent(mergeSettings -> {
            if (mergeSettings.replaceChunks) {
                this.radioButtonReplaceChunks.setSelected(true);
            } else {
                this.radioButtonAll.setSelected(true);
            }
            this.checkBoxAboveMergeBlocks.setSelected(mergeSettings.mergeBlocksAboveGround);
            this.checkBoxBelowMergeBlocks.setSelected(mergeSettings.mergeBlocksUnderground);
            this.checkBoxAboveMergeBiomes.setSelected(mergeSettings.mergeBiomesAboveGround);
            this.checkBoxBelowMergeBiomes.setSelected(mergeSettings.mergeBiomesUnderground);
            this.checkBoxRemoveTrees.setSelected(mergeSettings.clearTrees);
            this.checkBoxRemoveVegetation.setSelected(mergeSettings.clearVegetation);
            this.checkBoxRemoveManMadeAboveGround.setSelected(mergeSettings.clearManMadeAboveGround);
            this.checkBoxRemoveResources.setSelected(mergeSettings.clearResources);
            this.checkBoxFillCaves.setSelected(mergeSettings.fillCaves);
            this.checkBoxRemoveManMadeBelowGround.setSelected(mergeSettings.clearManMadeBelowGround);
            this.spinnerSurfaceThickness.setValue(mergeSettings.surfaceMergeDepth);
        });
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MergeWorldDialog.this.setControlStates();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MergeWorldDialog.this.setControlStates();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MergeWorldDialog.this.setControlStates();
            }
        };
        this.fieldSelectedMapDir.getDocument().addDocumentListener(documentListener);
        this.setLocationRelativeTo(parent);
        this.rootPane.setDefaultButton(this.buttonMerge);
        this.setControlStates();
        this.scaleToUI();
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge() {
        WorldExportSettings exportSettings;
        if (this.mapDir == null) {
            this.fieldSelectedMapDir.requestFocusInWindow();
            MessageUtils.beepAndShowError((Component)this, (String)"No existing map selected.", (String)"Error");
            return;
        }
        if (this.platform == null) {
            this.fieldSelectedMapDir.requestFocusInWindow();
            MessageUtils.beepAndShowError((Component)this, (String)"Selected map does not have a supported format.", (String)"Error");
            return;
        }
        if (!this.checkCompatibility(this.platform)) {
            return;
        }
        if (!this.radioButtonExportEverything.isSelected() && (this.selectedTiles == null || this.selectedTiles.isEmpty())) {
            this.radioButtonExportEverything.requestFocusInWindow();
            MessageUtils.beepAndShowError((Component)this, (String)"No tiles selected for merging.", (String)"Error");
            return;
        }
        if (!(this.checkBoxSurface.isSelected() || this.checkBoxNether.isSelected() || this.checkBoxEnd.isSelected())) {
            this.checkBoxSurface.requestFocusInWindow();
            MessageUtils.beepAndShowError((Component)this, (String)"No dimension selected for merging.", (String)"Error");
            return;
        }
        if (this.radioButtonExportEverything.isSelected()) {
            HashSet<Integer> dimensionsToExport = new HashSet<Integer>();
            if (this.checkBoxSurface.isSelected()) {
                dimensionsToExport.add(0);
            }
            if (this.checkBoxNether.isSelected()) {
                dimensionsToExport.add(1);
            }
            if (this.checkBoxEnd.isSelected()) {
                dimensionsToExport.add(2);
            }
            boolean allDimensionsSelected = true;
            for (Dimension dimension : this.world.getDimensions()) {
                if (dimensionsToExport.contains(dimension.getAnchor().dim)) continue;
                allDimensionsSelected = false;
                break;
            }
            exportSettings = allDimensionsSelected ? (this.savedSteps != null ? new WorldExportSettings(null, null, this.savedSteps) : WorldExportSettings.EXPORT_EVERYTHING) : new WorldExportSettings(dimensionsToExport, null, this.savedSteps);
        } else {
            exportSettings = new WorldExportSettings(Collections.singleton(this.selectedDimension), this.selectedTiles, this.savedSteps);
        }
        boolean replaceChunks = this.radioButtonReplaceChunks.isSelected();
        JavaWorldMerger merger = new JavaWorldMerger(this.world, exportSettings, this.mapDir, this.platform);
        try {
            if (replaceChunks) {
                merger.setReplaceChunks(true);
            } else {
                merger.setMergeBlocksAboveGround(this.checkBoxAboveMergeBlocks.isSelected());
                merger.setMergeBlocksUnderground(this.checkBoxBelowMergeBlocks.isSelected());
                merger.setMergeBiomesAboveGround(this.platform.supportsBiomes() && this.checkBoxAboveMergeBiomes.isSelected());
                merger.setMergeBiomesUnderground((this.platform.capabilities.contains(Platform.Capability.BIOMES_3D) || this.platform.capabilities.contains(Platform.Capability.NAMED_BIOMES)) && this.checkBoxBelowMergeBiomes.isSelected());
                merger.setClearManMadeAboveGround(this.checkBoxRemoveManMadeAboveGround.isSelected());
                merger.setClearManMadeBelowGround(this.checkBoxRemoveManMadeBelowGround.isSelected());
                merger.setClearResources(this.checkBoxRemoveResources.isSelected());
                merger.setClearTrees(this.checkBoxRemoveTrees.isSelected());
                merger.setClearVegetation(this.checkBoxRemoveVegetation.isSelected());
                merger.setFillCaves(this.checkBoxFillCaves.isSelected());
                merger.setSurfaceMergeDepth(((Integer)this.spinnerSurfaceThickness.getValue()).intValue());
            }
            merger.performSanityChecks();
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getClass().getSimpleName() + ": " + e.getMessage(), (Throwable)e);
            MessageUtils.beepAndShowError((Component)this, (String)e.getLocalizedMessage(), (String)"Error");
            return;
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error reading level.dat file", e);
        }
        StringBuilder sb = new StringBuilder("<html>Please confirm that you want to merge the world<br>notwithstanding the following warnings:<br><ul>");
        boolean showWarning = false;
        if (this.radioButtonExportSelection.isSelected() && !this.disableTileSelectionWarning) {
            sb.append("<li>A tile selection is active! Only " + this.selectedTiles.size() + " tiles of the<br>" + (switch (this.selectedDimension) {
                case 0 -> "Surface";
                case 1 -> "Nether";
                case 2 -> "End";
                default -> throw new InternalError();
            }) + " dimension are going to be merged.");
            showWarning = true;
        }
        sb.append("</ul>Do you want to continue with the merge?</html>");
        if (showWarning && JOptionPane.showConfirmDialog(this, sb.toString(), "Review Warnings", 0, 2) != 0) {
            return;
        }
        try {
            if (!BackupUtils.cleanUpBackups((File)this.mapDir.getParentFile(), null)) {
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while cleaning backups", e);
        }
        this.fieldSelectedMapDir.setEnabled(false);
        this.buttonSelectDirectory.setEnabled(false);
        this.buttonMerge.setEnabled(false);
        this.radioButtonAll.setEnabled(false);
        this.radioButtonReplaceChunks.setEnabled(false);
        this.radioButtonExportEverything.setEnabled(false);
        this.radioButtonExportSelection.setEnabled(false);
        this.checkBoxFillCaves.setEnabled(false);
        this.checkBoxRemoveManMadeAboveGround.setEnabled(false);
        this.checkBoxRemoveManMadeBelowGround.setEnabled(false);
        this.checkBoxRemoveResources.setEnabled(false);
        this.checkBoxRemoveTrees.setEnabled(false);
        this.checkBoxRemoveVegetation.setEnabled(false);
        this.spinnerSurfaceThickness.setEnabled(false);
        this.labelSelectTiles.setForeground(null);
        this.labelSelectTiles.setCursor(null);
        this.checkBoxSurface.setEnabled(false);
        this.checkBoxNether.setEnabled(false);
        this.checkBoxEnd.setEnabled(false);
        this.checkBoxAboveMergeBlocks.setEnabled(false);
        this.checkBoxBelowMergeBlocks.setEnabled(false);
        this.checkBoxAboveMergeBiomes.setEnabled(false);
        this.checkBoxBelowMergeBiomes.setEnabled(false);
        Configuration config = Configuration.getInstance();
        config.setSavesDirectory(this.mapDir.getParentFile());
        config.setMessageDisplayed("org.pepsoft.worldpainter.mergeWarning");
        this.world.setMergedWith(new File(this.mapDir, "level.dat"));
        try {
            this.backupDir = merger.selectBackupDir(this.mapDir);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while creating backup directory", e);
        }
        this.setDefaultCloseOperation(0);
        MergeProgressDialog dialog = new MergeProgressDialog((Window)this, merger, this.backupDir);
        this.view.setInhibitUpdates(true);
        try {
            dialog.setVisible(true);
        }
        finally {
            this.view.setInhibitUpdates(false);
        }
        JavaWorldMerger javaWorldMerger = merger;
        synchronized (javaWorldMerger) {
            if (!merger.isAborted()) {
                if (!this.radioButtonExportEverything.isSelected()) {
                    this.world.setExportSettings(exportSettings);
                }
                this.world.setAttribute(ATTRIBUTE_MERGE_SETTINGS, (Object)new MergeSettings(this.radioButtonReplaceChunks.isSelected(), this.checkBoxAboveMergeBlocks.isSelected(), this.checkBoxBelowMergeBlocks.isSelected(), this.checkBoxAboveMergeBiomes.isSelected(), this.checkBoxBelowMergeBiomes.isSelected(), this.checkBoxRemoveTrees.isSelected(), this.checkBoxRemoveVegetation.isSelected(), this.checkBoxRemoveManMadeAboveGround.isSelected(), this.checkBoxRemoveResources.isSelected(), this.checkBoxFillCaves.isSelected(), this.checkBoxRemoveManMadeBelowGround.isSelected(), (Integer)this.spinnerSurfaceThickness.getValue()));
            }
            if (merger.getWarnings() != null) {
                DesktopUtils.beep();
                ImportWarningsDialog warningsDialog = new ImportWarningsDialog((Window)this, "Merge Warnings", "<html>The merge process generated warnings! The existing map may have had pre-<br>existing damage or corruption. Not all chunks may have been merged correctly.<br>Please review the warnings below:</html>");
                warningsDialog.setWarnings(merger.getWarnings());
                warningsDialog.setVisible(true);
            }
        }
        this.ok();
    }

    private void setControlStates() {
        boolean mergeAll = this.radioButtonAll.isSelected();
        boolean mergeEverything = this.radioButtonExportEverything.isSelected();
        boolean surfacePresent = this.world.isDimensionPresent(Dimension.Anchor.NORMAL_DETAIL);
        boolean netherPresent = this.world.isDimensionPresent(Dimension.Anchor.NETHER_DETAIL);
        boolean endPresent = this.world.isDimensionPresent(Dimension.Anchor.END_DETAIL);
        boolean oneDimensionPresent = this.world.getDimensions().size() == 1;
        boolean biomesSupported = false;
        boolean threeDeeBiomesSupported = false;
        File mapDir = new File(this.fieldSelectedMapDir.getText().trim());
        if (mapDir.isDirectory()) {
            this.mapDir = mapDir;
            PlatformProvider.MapInfo mapInfo = PlatformManager.getInstance().identifyMap(mapDir);
            Platform platform = this.platform = mapInfo != null ? mapInfo.platform : null;
            if (this.platform != null) {
                biomesSupported = this.platform.supportsBiomes();
                threeDeeBiomesSupported = this.platform.capabilities.contains(Platform.Capability.BIOMES_3D) || this.platform.capabilities.contains(Platform.Capability.NAMED_BIOMES);
                this.labelPlatform.setText(this.platform.displayName);
                this.labelPlatform.setIcon(mapInfo.icon);
            } else {
                this.labelPlatform.setText("no supported format detected");
                this.labelPlatform.setIcon(null);
            }
        } else {
            this.mapDir = null;
            this.labelPlatform.setText(null);
        }
        this.checkBoxAboveMergeBlocks.setEnabled(mergeAll);
        this.checkBoxBelowMergeBlocks.setEnabled(mergeAll);
        this.checkBoxAboveMergeBiomes.setEnabled(mergeAll && biomesSupported);
        this.checkBoxBelowMergeBiomes.setEnabled(mergeAll && threeDeeBiomesSupported);
        this.checkBoxFillCaves.setEnabled(mergeAll);
        this.checkBoxRemoveManMadeAboveGround.setEnabled(mergeAll);
        this.checkBoxRemoveManMadeBelowGround.setEnabled(mergeAll);
        this.checkBoxRemoveResources.setEnabled(mergeAll);
        this.checkBoxRemoveTrees.setEnabled(mergeAll);
        this.checkBoxRemoveVegetation.setEnabled(mergeAll);
        this.spinnerSurfaceThickness.setEnabled(mergeAll);
        this.checkBoxSurface.setEnabled(mergeEverything && surfacePresent && !oneDimensionPresent);
        this.checkBoxNether.setEnabled(mergeEverything && netherPresent && !oneDimensionPresent);
        this.checkBoxEnd.setEnabled(mergeEverything && endPresent && !oneDimensionPresent);
        if (this.radioButtonExportSelection.isSelected()) {
            this.labelSelectTiles.setForeground(Color.BLUE);
            this.labelSelectTiles.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.labelSelectTiles.setForeground(null);
            this.labelSelectTiles.setCursor(null);
        }
    }

    private void selectMap() {
        File file = new File(this.fieldSelectedMapDir.getText().trim());
        PlatformProvider.MapInfo selectedMap = MapUtils.selectMap(this, file.isDirectory() ? (this.platform != null ? file.getParentFile() : file) : null);
        if (selectedMap != null) {
            this.fieldSelectedMapDir.setText(selectedMap.dir.getAbsolutePath());
        }
    }

    private void selectTiles() {
        if (this.radioButtonExportSelection.isSelected()) {
            ExportTileSelectionDialog dialog = new ExportTileSelectionDialog(this, this.world, this.selectedDimension, this.selectedTiles, this.colourScheme, this.customBiomeManager, this.hiddenLayers, this.contourLines, this.contourSeparation, this.lightOrigin);
            dialog.setVisible(true);
            this.selectedDimension = dialog.getSelectedDimension();
            this.checkBoxSurface.setSelected(this.selectedDimension == 0);
            this.checkBoxNether.setSelected(this.selectedDimension == 1);
            this.checkBoxEnd.setSelected(this.selectedDimension == 2);
            this.selectedTiles = dialog.getSelectedTiles();
            this.radioButtonExportSelection.setText("merge " + this.selectedTiles.size() + " selected tiles");
            this.pack();
            this.setControlStates();
            this.disableTileSelectionWarning = true;
        }
    }

    private boolean checkCompatibility(Platform platform) {
        Map nameOnlyMaterials;
        if (!platform.capabilities.contains(Platform.Capability.NAME_BASED) && !(nameOnlyMaterials = MaterialUtils.gatherBlocksWithoutIds((World2)this.world, (Platform)platform)).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("<p>The selected map's format ").append(platform.displayName).append(" is not compatible with this world because this world contains the following incompatible block types:");
            sb.append("<table><tr><th align='left'>Block Type</th><th align='left'>Source</th></tr>");
            nameOnlyMaterials.forEach((name, sources) -> sb.append("<tr><td>").append((String)name).append("</td><td>").append(String.join((CharSequence)",", sources)).append("</td></tr>"));
            sb.append("</table>");
            MessageUtils.beepAndShowError((Component)this, (String)sb.toString(), (String)"Map Format Not Compatible");
            this.fieldSelectedMapDir.requestFocusInWindow();
            return false;
        }
        String incompatibilityReason = platform.isCompatible(this.world);
        if (incompatibilityReason != null) {
            DesktopUtils.beep();
            JOptionPane.showMessageDialog(this, String.format("<html><p>The selected map's format %s is not compatible with this world, for the following reason:<ul><li>%s</ul></html>", platform.displayName, incompatibilityReason), "Map Format Not Compatible", 0);
            this.fieldSelectedMapDir.requestFocusInWindow();
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jLabel2 = new JLabel();
        this.fieldSelectedMapDir = new JTextField();
        this.buttonSelectDirectory = new JButton();
        this.buttonMerge = new JButton();
        this.radioButtonAll = new JRadioButton();
        this.radioButtonReplaceChunks = new JRadioButton();
        this.radioButtonExportEverything = new JRadioButton();
        this.radioButtonExportSelection = new JRadioButton();
        this.labelSelectTiles = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.checkBoxRemoveTrees = new JCheckBox();
        this.checkBoxRemoveVegetation = new JCheckBox();
        this.checkBoxRemoveManMadeAboveGround = new JCheckBox();
        this.checkBoxRemoveResources = new JCheckBox();
        this.checkBoxFillCaves = new JCheckBox();
        this.checkBoxRemoveManMadeBelowGround = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel8 = new JLabel();
        this.spinnerSurfaceThickness = new JSpinner();
        this.jLabel9 = new JLabel();
        this.checkBoxSurface = new JCheckBox();
        this.checkBoxNether = new JCheckBox();
        this.checkBoxEnd = new JCheckBox();
        this.jLabel10 = new JLabel();
        this.labelPlatform = new JLabel();
        this.checkBoxAboveMergeBlocks = new JCheckBox();
        this.checkBoxAboveMergeBiomes = new JCheckBox();
        this.checkBoxBelowMergeBlocks = new JCheckBox();
        this.checkBoxBelowMergeBiomes = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Merging");
        this.jLabel2.setText("Select the existing map to merge your changes with:");
        this.buttonSelectDirectory.setText("...");
        this.buttonSelectDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeWorldDialog.this.buttonSelectDirectoryActionPerformed(evt);
            }
        });
        this.buttonMerge.setText("Merge");
        this.buttonMerge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeWorldDialog.this.buttonMergeActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonAll);
        this.radioButtonAll.setSelected(true);
        this.radioButtonAll.setText("Merge old and new chunks");
        this.radioButtonAll.setToolTipText("<html><i>Will merge everything (terrain type and height changes,<br>\nnew layers, etc.). Takes a long time.</i></html>");
        this.radioButtonAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeWorldDialog.this.radioButtonAllActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonReplaceChunks);
        this.radioButtonReplaceChunks.setText("Completely replace chunks with new chunks");
        this.radioButtonReplaceChunks.setToolTipText("<html><i>This will </i>replace<i> all non-read-only chunks,<br>destroying everything that's there in the existing map! </i></html>");
        this.radioButtonReplaceChunks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeWorldDialog.this.radioButtonReplaceChunksActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.radioButtonExportEverything);
        this.radioButtonExportEverything.setSelected(true);
        this.radioButtonExportEverything.setText("Merge all tiles");
        this.radioButtonExportEverything.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeWorldDialog.this.radioButtonExportEverythingActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.radioButtonExportSelection);
        this.radioButtonExportSelection.setText("merge selected tiles");
        this.radioButtonExportSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeWorldDialog.this.radioButtonExportSelectionActionPerformed(evt);
            }
        });
        this.labelSelectTiles.setText("<html><u>select tiles</u></html>");
        this.labelSelectTiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MergeWorldDialog.this.labelSelectTilesMouseClicked(evt);
            }
        });
        this.jLabel1.setText("Choose which part of the map to merge:");
        this.jLabel4.setText("<html>Choose what kind of merge to perform (<b>non-read-only</b> chunks in <b>selected tiles</b> only):</html>");
        this.jLabel5.setText("Options for the existing map:");
        this.jLabel6.setText("<html><b>Above</b> ground:</html>");
        this.checkBoxRemoveTrees.setText("Remove all trees and huge mushrooms");
        this.checkBoxRemoveTrees.setToolTipText("Removes all wood and leaf blocks, as wells as cocoa plants, vines and saplings.");
        this.checkBoxRemoveVegetation.setText("Remove all other vegetation and crops");
        this.checkBoxRemoveVegetation.setToolTipText("Removes all tall grass, flowers, mushrooms, nether wart, pumpkins and melons, carrots and potatoes, wheat, etc.");
        this.checkBoxRemoveManMadeAboveGround.setText("Remove all man-made structures");
        this.checkBoxRemoveManMadeAboveGround.setToolTipText("Removes any block which cannot occur naturally, above ground.");
        this.checkBoxRemoveResources.setText("Remove all resources/ores");
        this.checkBoxRemoveResources.setToolTipText("Replaces all resource/ore blocks with stone (or netherrack in the case of quartz).");
        this.checkBoxFillCaves.setText("Fill in all caves and other hollow spaces");
        this.checkBoxFillCaves.setToolTipText("<html>Replaces all air, water, lava and other insubstantial blocks with stone.<br>\nTo replace man-made blocks as well, use \"remove all man-made structures\" also.</html>");
        this.checkBoxRemoveManMadeBelowGround.setText("Remove all man-made structures");
        this.checkBoxRemoveManMadeBelowGround.setToolTipText("Replaces any block which cannot occur naturally with stone or air, below ground.");
        this.jLabel7.setText("<html><b>Below</b> ground:</html>");
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/error.png")));
        this.jLabel3.setText(" ");
        this.jLabel3.setToolTipText("<html>This removes <em>all</em> wood and leaf blocks, including man-made ones!<br>\nWorldPainter can't tell the difference between natural and man-made wood blocks.<br>\nBe sure to protect your builds with the Read-Only layer.</html>");
        this.jLabel8.setText("Thickness of surface layer to replace:");
        this.spinnerSurfaceThickness.setModel(new SpinnerNumberModel(3, 1, 256, 1));
        this.jLabel9.setText("blocks");
        this.checkBoxSurface.setText("Surface");
        this.checkBoxSurface.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeWorldDialog.this.checkBoxSurfaceActionPerformed(evt);
            }
        });
        this.checkBoxNether.setText("Nether");
        this.checkBoxNether.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeWorldDialog.this.checkBoxNetherActionPerformed(evt);
            }
        });
        this.checkBoxEnd.setText("End");
        this.checkBoxEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeWorldDialog.this.checkBoxEndActionPerformed(evt);
            }
        });
        this.jLabel10.setText("Map format:");
        this.checkBoxAboveMergeBlocks.setSelected(true);
        this.checkBoxAboveMergeBlocks.setText("Merge blocks");
        this.checkBoxAboveMergeBiomes.setText("Replace biomes");
        this.checkBoxBelowMergeBlocks.setText("Merge blocks");
        this.checkBoxBelowMergeBiomes.setText("Replace biomes");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.fieldSelectedMapDir).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelectDirectory)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.radioButtonExportEverything).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonExportSelection).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelSelectTiles, -2, -1, -2)).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxSurface).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxNether).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxEnd)).addComponent(this.jLabel2).addComponent(this.jLabel4, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioButtonAll).addComponent(this.radioButtonReplaceChunks).addComponent(this.jLabel6, -2, -1, -2)))).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerSurfaceThickness, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonMerge))).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxRemoveTrees).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3)).addComponent(this.checkBoxRemoveVegetation).addComponent(this.checkBoxRemoveManMadeAboveGround).addComponent(this.jLabel5).addComponent(this.checkBoxAboveMergeBlocks).addComponent(this.checkBoxAboveMergeBiomes)).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxRemoveManMadeBelowGround).addComponent(this.checkBoxFillCaves).addComponent(this.checkBoxRemoveResources).addComponent(this.jLabel7, -2, -1, -2).addComponent(this.checkBoxBelowMergeBlocks).addComponent(this.checkBoxBelowMergeBiomes)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelPlatform).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fieldSelectedMapDir, -2, -1, -2).addComponent(this.buttonSelectDirectory)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.labelPlatform)).addGap(18, 18, 18).addComponent(this.jLabel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonReplaceChunks).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6, -2, -1, -2).addComponent(this.jLabel7, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxAboveMergeBlocks).addComponent(this.checkBoxBelowMergeBlocks)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxAboveMergeBiomes).addComponent(this.checkBoxBelowMergeBiomes)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxRemoveTrees).addComponent(this.checkBoxRemoveResources).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxRemoveVegetation).addComponent(this.checkBoxFillCaves)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxRemoveManMadeAboveGround).addComponent(this.checkBoxRemoveManMadeBelowGround)).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonExportEverything).addComponent(this.radioButtonExportSelection).addComponent(this.labelSelectTiles, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxSurface).addComponent(this.checkBoxNether).addComponent(this.checkBoxEnd)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.spinnerSurfaceThickness, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.buttonMerge)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void buttonMergeActionPerformed(ActionEvent evt) {
        this.merge();
    }

    private void buttonSelectDirectoryActionPerformed(ActionEvent evt) {
        this.selectMap();
    }

    private void radioButtonExportEverythingActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonExportSelectionActionPerformed(ActionEvent evt) {
        if (this.radioButtonExportSelection.isSelected()) {
            this.selectTiles();
        } else {
            this.setControlStates();
        }
    }

    private void labelSelectTilesMouseClicked(MouseEvent evt) {
        this.selectTiles();
    }

    private void radioButtonAllActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonReplaceChunksActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxSurfaceActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxNetherActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxEndActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    static class MergeSettings
    implements Serializable {
        final boolean replaceChunks;
        final boolean mergeBlocksAboveGround;
        final boolean mergeBlocksUnderground;
        final boolean mergeBiomesAboveGround;
        final boolean mergeBiomesUnderground;
        final boolean clearTrees;
        final boolean clearVegetation;
        final boolean clearManMadeAboveGround;
        final boolean clearResources;
        final boolean fillCaves;
        final boolean clearManMadeBelowGround;
        final int surfaceMergeDepth;
        private static final long serialVersionUID = 1L;

        public MergeSettings(boolean replaceChunks, boolean mergeBlocksAboveGround, boolean mergeBlocksUnderground, boolean mergeBiomesAboveGround, boolean mergeBiomesUnderground, boolean clearTrees, boolean clearVegetation, boolean clearManMadeAboveGround, boolean clearResources, boolean fillCaves, boolean clearManMadeBelowGround, int surfaceMergeDepth) {
            this.replaceChunks = replaceChunks;
            this.mergeBlocksAboveGround = mergeBlocksAboveGround;
            this.mergeBlocksUnderground = mergeBlocksUnderground;
            this.mergeBiomesAboveGround = mergeBiomesAboveGround;
            this.mergeBiomesUnderground = mergeBiomesUnderground;
            this.clearTrees = clearTrees;
            this.clearVegetation = clearVegetation;
            this.clearManMadeAboveGround = clearManMadeAboveGround;
            this.clearResources = clearResources;
            this.fillCaves = fillCaves;
            this.clearManMadeBelowGround = clearManMadeBelowGround;
            this.surfaceMergeDepth = surfaceMergeDepth;
        }
    }
}

