/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.TaskbarProgressReceiver;
import org.pepsoft.util.swing.ProgressTask;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.MultiProgressDialog;
import org.pepsoft.worldpainter.merging.JavaWorldMerger;

public class MergeProgressDialog
extends MultiProgressDialog<Void>
implements WindowListener {
    private final File backupDir;
    private final JavaWorldMerger merger;

    public MergeProgressDialog(Window parent, JavaWorldMerger merger, File backupDir) {
        super(parent, "Merging");
        this.merger = merger;
        this.backupDir = backupDir;
        this.addWindowListener(this);
        JButton minimiseButton = new JButton("Minimize");
        minimiseButton.addActionListener(e -> App.getInstance().setState(1));
        this.addButton(minimiseButton);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        DesktopUtils.setProgressDone((Window)App.getInstance());
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    protected String getVerb() {
        return "Merge";
    }

    @Override
    protected String getResultsReport(Void results, long duration) {
        StringBuilder sb = new StringBuilder();
        sb.append("World merged with ").append(this.merger.getMapDir());
        int hours = (int)(duration / 3600L);
        int minutes = (int)((duration -= (long)hours * 3600L) / 60L);
        int seconds = (int)(duration - (long)(minutes * 60));
        sb.append("\nMerge took ").append(hours).append(":").append(minutes < 10 ? "0" : "").append(minutes).append(":").append(seconds < 10 ? "0" : "").append(seconds);
        sb.append("\n\nBackup of existing map created in:\n").append(this.backupDir);
        return sb.toString();
    }

    @Override
    protected String getCancellationMessage() {
        return "Merge cancelled by user.\n\nThe partially merged map is now probably corrupted!\nYou should delete it, and restore it from the backup at:\n" + this.backupDir;
    }

    @Override
    protected ProgressTask<Void> getTask() {
        return new ProgressTask<Void>(){

            public String getName() {
                return "Merging world " + MergeProgressDialog.this.merger.getWorld().getName();
            }

            public Void execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                progressReceiver = new TaskbarProgressReceiver((Window)App.getInstance(), progressReceiver);
                try {
                    MergeProgressDialog.this.merger.merge(MergeProgressDialog.this.backupDir, progressReceiver);
                }
                catch (IOException e) {
                    throw new RuntimeException("I/O error while merging world " + MergeProgressDialog.this.merger.getWorld().getName() + " with map " + MergeProgressDialog.this.merger.getMapDir(), e);
                }
                return null;
            }
        };
    }
}

