/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.vo.EventVO;

public final class MerchDialog
extends WorldPainterDialog {
    private JButton buttonMerchStore;
    private JButton buttonNoThanks;
    private JLabel jLabel1;
    private JTextArea jTextArea1;
    private final Configuration config = Configuration.getInstance();
    private static final long serialVersionUID = 1L;

    public MerchDialog(Window parent) {
        super(parent);
        this.initComponents();
        this.jTextArea1.setFont(UIManager.getFont("TextField.font").deriveFont((float)UIManager.getFont("TextField.font").getSize() + 6.0f));
        this.rootPane.setDefaultButton(this.buttonMerchStore);
        this.pack();
    }

    public static void maybeShowMerchDialog(Window parent) {
        Configuration config = Configuration.getInstance();
        if (config.getMerchStoreDialogDisplayed() == null || config.getLaunchCount() - config.getMerchStoreDialogDisplayed() > 40) {
            config.setMerchStoreDialogDisplayed(Integer.valueOf(config.getLaunchCount()));
            MerchDialog dialog = new MerchDialog(parent);
            dialog.setLocationRelativeTo(parent);
            dialog.setVisible(true);
        }
    }

    private void noThanks() {
        MessageUtils.showInfo((Component)this, (String)"Alright, no problem. You can access the merch store\nlater from the Help menu.", (String)"No Problem");
        this.ok();
    }

    private void openMerchStore() {
        try {
            DesktopUtils.open((URL)new URL("https://www.worldpainter.store/"));
            this.config.logEvent(new EventVO("store.merch.opened").addTimestamp());
            this.ok();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextArea1 = new JTextArea();
        this.buttonNoThanks = new JButton();
        this.buttonMerchStore = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("WorldPainter Has A Merch Store");
        this.setResizable(false);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/resources/about.png")));
        this.jLabel1.setBorder(BorderFactory.createBevelBorder(1));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(this.jTextArea1.getFont().deriveFont((float)this.jTextArea1.getFont().getSize() + 6.0f));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText("WorldPainter has a merch store! Get your WorldPainter paraphernalia, be the envy of all your friends and support the development of WorldPainter.");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setOpaque(false);
        this.buttonNoThanks.setFont(this.buttonNoThanks.getFont().deriveFont((float)this.buttonNoThanks.getFont().getSize() + 3.0f));
        this.buttonNoThanks.setMnemonic('n');
        this.buttonNoThanks.setText("No thank you");
        this.buttonNoThanks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MerchDialog.this.buttonNoThanksActionPerformed(evt);
            }
        });
        this.buttonMerchStore.setFont(this.buttonMerchStore.getFont().deriveFont((float)this.buttonMerchStore.getFont().getSize() + 3.0f));
        this.buttonMerchStore.setText("Open merch store");
        this.buttonMerchStore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MerchDialog.this.buttonMerchStoreActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonMerchStore).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonNoThanks)).addComponent(this.jTextArea1)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jTextArea1).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonNoThanks).addComponent(this.buttonMerchStore)).addContainerGap()));
        this.pack();
    }

    private void buttonNoThanksActionPerformed(ActionEvent evt) {
        this.noThanks();
    }

    private void buttonMerchStoreActionPerformed(ActionEvent evt) {
        this.openMerchStore();
    }
}

