/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pepsoft.minecraft.Block;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.CollectionUtils;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialSelector
extends JPanel {
    private JButton buttonAddProperty;
    private ButtonGroup buttonGroup1;
    private JComboBox<String> comboBoxBlockType;
    private JComboBox<String> comboBoxCustomName;
    private JComboBox<String> comboBoxMinecraftName;
    private JComboBox<String> comboBoxNamespace;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JLabel labelMaterialName;
    private JPanel panelProperties;
    private JRadioButton radioButtonCustom;
    private JRadioButton radioButtonMinecraft;
    private JSpinner spinnerDataValue;
    private final Map<String, Component> propertyEditors = new HashMap<String, Component>();
    private boolean extendedBlockIds;
    private boolean programmaticChange;
    private boolean legacyMode;
    private Platform platform;
    private Material material;
    private String namespace;
    private String simpleName;
    private Map<String, String> properties;
    private static final Logger logger = LoggerFactory.getLogger(MaterialSelector.class);

    public MaterialSelector() {
        this.initComponents();
        Vector minecraftNames = new Vector(Material.getAllSimpleNamesForNamespace((String)"minecraft"));
        Collections.sort(minecraftNames);
        this.comboBoxMinecraftName.setModel(new DefaultComboBoxModel(minecraftNames));
        Vector namespaces = new Vector(Material.getAllNamespaces());
        Collections.sort(namespaces);
        this.comboBoxNamespace.setModel(new DefaultComboBoxModel(namespaces));
        String[] blockIds = new String[256];
        for (int i = 0; i < blockIds.length; ++i) {
            blockIds[i] = Block.BLOCKS[i].name != null ? i + ": " + Block.BLOCKS[i].name : Integer.toString(i);
        }
        this.comboBoxBlockType.setModel(new DefaultComboBoxModel<String>(blockIds));
    }

    public void setMaterial(Material material) {
        this.programmaticChange = true;
        try {
            this.material = material;
            this.namespace = material.namespace;
            this.simpleName = material.simpleName;
            this.loadActualProperties();
            if (this.legacyMode) {
                int blockType = material.blockType;
                if (blockType >= 0) {
                    this.comboBoxBlockType.setSelectedIndex(blockType);
                    this.spinnerDataValue.setValue(material.data);
                } else {
                    this.comboBoxBlockType.setSelectedItem(null);
                    this.spinnerDataValue.setValue(0);
                    AwtUtils.doLaterOnEventThread(() -> MessageUtils.beepAndShowError((Component)this, (String)("The material (" + material.name + ") is not compatible with the current map format (" + this.platform.displayName + ").\nSelect a compatible material."), (String)"Incompatible Material"));
                }
                this.updateMaterialName();
            } else if (this.namespace.equals("minecraft")) {
                this.radioButtonMinecraft.setSelected(true);
                this.comboBoxMinecraftName.setSelectedItem(this.simpleName);
            } else {
                this.radioButtonCustom.setSelected(true);
                this.comboBoxNamespace.setSelectedItem(this.namespace);
                this.updateKnownCustomNames();
                this.comboBoxCustomName.setSelectedItem(this.simpleName);
            }
            this.setControlStates();
        }
        finally {
            this.programmaticChange = false;
        }
    }

    public Material getMaterial() {
        this.updateMaterial();
        return this.material;
    }

    public boolean isExtendedBlockIds() {
        return this.extendedBlockIds;
    }

    public void setExtendedBlockIds(boolean extendedBlockIds) {
        if (extendedBlockIds != this.extendedBlockIds) {
            this.extendedBlockIds = extendedBlockIds;
            String[] blockIds = new String[extendedBlockIds ? 4096 : 256];
            for (int i = 0; i < blockIds.length; ++i) {
                blockIds[i] = Block.BLOCKS[i].name != null ? i + ": " + Block.BLOCKS[i].name : Integer.toString(i);
            }
            this.comboBoxBlockType.setModel(new DefaultComboBoxModel<String>(blockIds));
        }
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        if (platform == null) {
            throw new NullPointerException();
        }
        if (this.platform != null) {
            throw new IllegalStateException("Platform already set");
        }
        this.platform = platform;
        boolean bl = this.legacyMode = !platform.capabilities.contains(Platform.Capability.NAME_BASED);
        if (this.legacyMode) {
            this.remove(0);
            ((TitledBorder)this.jScrollPane1.getBorder()).setTitle("Modern properties");
        } else {
            this.remove(1);
        }
        this.setControlStates();
    }

    private void loadActualProperties() {
        this.properties = CollectionUtils.copyOf((Map)this.material.getProperties());
        this.updateProperties();
    }

    private void loadDefaultProperties() {
        Material defaultMaterial = Material.getPrototype((String)(this.namespace + ":" + this.simpleName));
        this.properties = CollectionUtils.copyOf((Map)defaultMaterial.getProperties());
        this.updateProperties();
    }

    private void updateProperties() {
        Window parentWindow;
        boolean propertiesChanged;
        block8: {
            propertiesChanged = false;
            if (this.panelProperties.getComponentCount() > 0) {
                this.panelProperties.removeAll();
                this.propertyEditors.clear();
                propertiesChanged = true;
            }
            if (this.properties == null) break block8;
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                block10: {
                    String value;
                    String name;
                    block9: {
                        Material.PropertyDescriptor descriptor;
                        name = entry.getKey();
                        value = entry.getValue();
                        Material.PropertyDescriptor propertyDescriptor = descriptor = this.material.propertyDescriptors != null ? (Material.PropertyDescriptor)this.material.propertyDescriptors.get(name) : null;
                        if (descriptor == null) break block9;
                        switch (descriptor.type) {
                            case BOOLEAN: {
                                this.addBooleanProperty(name, Boolean.parseBoolean(value));
                                break block10;
                            }
                            case INTEGER: {
                                this.addIntProperty(name, descriptor.minValue, Integer.parseInt(value), descriptor.maxValue);
                                break block10;
                            }
                            case ENUM: {
                                this.addStringProperty(name, value, descriptor.enumValues, false);
                                break block10;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown property type: " + descriptor.type);
                            }
                        }
                    }
                    this.addStringProperty(name, value, null, false);
                }
                propertiesChanged = true;
            }
        }
        if (propertiesChanged && (parentWindow = SwingUtilities.windowForComponent(this)) != null) {
            parentWindow.validate();
            this.repaint();
        }
    }

    private void updateMaterialName() {
        this.labelMaterialName.setText(this.namespace + ":" + this.simpleName);
    }

    private void addStringProperty(final String key, String value, String[] values, boolean focus) {
        JComponent control;
        if (this.propertyEditors.containsKey(key)) {
            throw new IllegalStateException("Property " + key + " already present");
        }
        if (focus && this.legacyMode) {
            throw new IllegalArgumentException("focus may not be true in legacy mode");
        }
        if (values != null) {
            control = new JComboBox<String>(values);
            ((JComboBox)control).setSelectedItem(value);
        } else {
            control = new JTextField(value, 15);
        }
        control.setEnabled(!this.legacyMode);
        this.propertyEditors.put(key, control);
        if (!this.legacyMode) {
            if (control instanceof JComboBox) {
                ((JComboBox)control).addActionListener(e -> {
                    if (this.properties == null) {
                        this.properties = new HashMap<String, String>();
                    }
                    this.properties.put(key, (String)((JComboBox)control).getSelectedItem());
                    this.updateMaterial();
                });
            } else {
                control.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        if (MaterialSelector.this.properties == null) {
                            MaterialSelector.this.properties = new HashMap<String, String>();
                        }
                        MaterialSelector.this.properties.put(key, ((JTextField)control).getText());
                        MaterialSelector.this.updateMaterial();
                    }
                });
            }
        }
        JLabel label = new JLabel(this.uppercaseFirst(key) + ":");
        label.setLabelFor(control);
        this.addControlsRow(label, control);
        if (focus) {
            control.requestFocusInWindow();
        }
    }

    private void addIntProperty(String key, int minValue, int value, int maxValue) {
        if (this.propertyEditors.containsKey(key)) {
            throw new IllegalStateException("Property " + key + " already present");
        }
        JSpinner control = new JSpinner(new SpinnerNumberModel(value, minValue, maxValue, 1));
        control.setEnabled(!this.legacyMode);
        this.propertyEditors.put(key, control);
        if (!this.legacyMode) {
            control.addChangeListener(e -> {
                if (this.properties == null) {
                    this.properties = new HashMap<String, String>();
                }
                this.properties.put(key, Integer.toString((Integer)control.getValue()));
                this.updateMaterial();
            });
        }
        JLabel label = new JLabel(this.uppercaseFirst(key) + ":");
        label.setLabelFor(control);
        this.addControlsRow(label, control);
    }

    private void addBooleanProperty(String key, boolean value) {
        if (this.propertyEditors.containsKey(key)) {
            throw new IllegalStateException("Property " + key + " already present");
        }
        JCheckBox control = new JCheckBox("\u200b", value);
        control.setEnabled(!this.legacyMode);
        this.propertyEditors.put(key, control);
        if (!this.legacyMode) {
            control.addActionListener(e -> {
                if (this.properties == null) {
                    this.properties = new HashMap<String, String>();
                }
                this.properties.put(key, Boolean.toString(control.isSelected()));
                this.updateMaterial();
            });
        }
        JLabel label = new JLabel(this.uppercaseFirst(key) + ":");
        label.setLabelFor(control);
        this.addControlsRow(label, control);
    }

    private String uppercaseFirst(String str) {
        return str.isEmpty() ? str : Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    private void addControlsRow(Component ... controls) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 512;
        constraints.insets = new Insets(2, 2, 0, 0);
        for (Component control : controls) {
            this.panelProperties.add(control, constraints);
        }
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        this.panelProperties.add(Box.createGlue(), constraints);
    }

    private void addProperty() {
        String name = JOptionPane.showInputDialog(this, "Enter the name of the property to add:", "Add Property", 3);
        if (name != null && !name.trim().isEmpty()) {
            this.addStringProperty(name.trim(), "", null, true);
            SwingUtilities.windowForComponent(this).validate();
            this.repaint();
        }
    }

    private void setControlStates() {
        if (!this.legacyMode) {
            boolean minecraft = this.radioButtonMinecraft.isSelected();
            this.comboBoxMinecraftName.setEnabled(minecraft);
            this.comboBoxNamespace.setEnabled(!minecraft);
            this.comboBoxCustomName.setEnabled(!minecraft);
            this.buttonAddProperty.setEnabled(!minecraft);
        }
    }

    private void blockIdOrDataChanged() {
        int blockType = this.comboBoxBlockType.getSelectedIndex();
        int dataValue = (Integer)this.spinnerDataValue.getValue();
        if (blockType < 0 || blockType > 4095 || dataValue < 0 || dataValue > 15) {
            logger.error("blockIdOrDataChanged(): blockType = {}, dataValue = {}, comboBoxMinecraftName.selectedItem = {}, comboBoxNamespace.selectedItem = {}, comboBoxCustomName.selectedItem = {}", new Object[]{blockType, dataValue, this.comboBoxMinecraftName.getSelectedItem(), this.comboBoxNamespace.getSelectedItem(), this.comboBoxCustomName.getSelectedItem()});
            return;
        }
        this.material = Material.get((int)blockType, (int)dataValue);
        this.namespace = this.material.namespace;
        this.simpleName = this.material.simpleName;
        this.loadActualProperties();
        this.updateMaterialName();
        this.firePropertyChange("material", null, this.getMaterial());
    }

    private void minecraftNameChanged() {
        this.namespace = "minecraft";
        this.simpleName = (String)this.comboBoxMinecraftName.getSelectedItem();
        this.material = Material.getPrototype((String)(this.namespace + ":" + this.simpleName));
        this.loadDefaultProperties();
        this.firePropertyChange("material", null, this.getMaterial());
    }

    private void updateMaterial() {
        Material oldMaterial = this.material;
        boolean previousProgrammaticChange = this.programmaticChange;
        this.programmaticChange = true;
        try {
            if (this.legacyMode) {
                if (this.comboBoxBlockType.getSelectedItem() != null) {
                    this.material = Material.get((int)this.comboBoxBlockType.getSelectedIndex(), (int)((Integer)this.spinnerDataValue.getValue()));
                }
            } else {
                this.simpleName = this.radioButtonCustom.isSelected() ? (String)this.comboBoxCustomName.getSelectedItem() : (String)this.comboBoxMinecraftName.getSelectedItem();
                if (this.simpleName != null && !this.simpleName.trim().isEmpty()) {
                    if (this.namespace == null || this.namespace.trim().isEmpty()) {
                        this.namespace = "minecraft";
                    }
                    this.material = Material.get((String)(this.namespace.trim() + ":" + this.simpleName.trim()), this.properties);
                }
            }
            if (this.material != oldMaterial) {
                this.firePropertyChange("material", null, this.material);
            }
        }
        finally {
            this.programmaticChange = previousProgrammaticChange;
        }
    }

    private void updateKnownCustomNames() {
        Vector simpleNames;
        if ("minecraft".equals(this.namespace)) {
            simpleNames = new Vector();
        } else {
            simpleNames = new Vector(Material.getAllSimpleNamesForNamespace((String)this.namespace));
            Collections.sort(simpleNames);
        }
        this.comboBoxCustomName.setModel(new DefaultComboBoxModel(simpleNames));
        this.comboBoxCustomName.setSelectedItem(this.simpleName);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.radioButtonCustom = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.comboBoxMinecraftName = new JComboBox();
        this.comboBoxNamespace = new JComboBox();
        this.radioButtonMinecraft = new JRadioButton();
        this.comboBoxCustomName = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.comboBoxBlockType = new JComboBox();
        this.jLabel4 = new JLabel();
        this.spinnerDataValue = new JSpinner();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.labelMaterialName = new JLabel();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.panelProperties = new JPanel();
        this.buttonAddProperty = new JButton();
        this.setLayout(new BoxLayout(this, 3));
        this.buttonGroup1.add(this.radioButtonCustom);
        this.radioButtonCustom.setText("<html><em>Custom:</em></html>");
        this.radioButtonCustom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaterialSelector.this.radioButtonCustomActionPerformed(evt);
            }
        });
        this.jLabel1.setText(":");
        this.jLabel2.setText("minecraft:");
        this.comboBoxMinecraftName.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboBoxMinecraftName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaterialSelector.this.comboBoxMinecraftNameActionPerformed(evt);
            }
        });
        this.comboBoxNamespace.setEditable(true);
        this.comboBoxNamespace.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboBoxNamespace.setEnabled(false);
        this.comboBoxNamespace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaterialSelector.this.comboBoxNamespaceActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonMinecraft);
        this.radioButtonMinecraft.setSelected(true);
        this.radioButtonMinecraft.setText("<html><em>Minecraft:</em></html>");
        this.radioButtonMinecraft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaterialSelector.this.radioButtonMinecraftActionPerformed(evt);
            }
        });
        this.comboBoxCustomName.setEditable(true);
        this.comboBoxCustomName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MaterialSelector.this.comboBoxCustomNameFocusLost(evt);
            }
        });
        this.comboBoxCustomName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaterialSelector.this.comboBoxCustomNameActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioButtonCustom, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.radioButtonMinecraft, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(0, 0, 0).addComponent(this.comboBoxMinecraftName, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.comboBoxNamespace, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxCustomName, -2, -1, -2))).addContainerGap(62, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonMinecraft, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.comboBoxMinecraftName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonCustom, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.comboBoxNamespace, -2, -1, -2).addComponent(this.comboBoxCustomName, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.add(this.jPanel1);
        this.jLabel3.setText("Block ID:");
        this.comboBoxBlockType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaterialSelector.this.comboBoxBlockTypeActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Data value:");
        this.spinnerDataValue.setModel(new SpinnerNumberModel(0, 0, 15, 1));
        this.spinnerDataValue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MaterialSelector.this.spinnerDataValueStateChanged(evt);
            }
        });
        this.jLabel5.setForeground(new Color(0, 0, 255));
        this.jLabel5.setText("<html><u>look up legacy block IDs and data values</u></html>");
        this.jLabel5.setVerticalAlignment(1);
        this.jLabel5.setCursor(new Cursor(12));
        this.jLabel5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MaterialSelector.this.jLabel5MouseClicked(evt);
            }
        });
        this.jLabel6.setText("Modern name:");
        this.labelMaterialName.setText("minecraft:grass_block");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, -2, -1, -2).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxBlockType, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerDataValue, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelMaterialName))).addContainerGap(135, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboBoxBlockType, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.spinnerDataValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.labelMaterialName)).addContainerGap(-1, Short.MAX_VALUE)));
        this.add(this.jPanel2);
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder("Properties"));
        this.panelProperties.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.panelProperties);
        this.buttonAddProperty.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/brick_add.png")));
        this.buttonAddProperty.setToolTipText("Add a property");
        this.buttonAddProperty.setEnabled(false);
        this.buttonAddProperty.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAddProperty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaterialSelector.this.buttonAddPropertyActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 307, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonAddProperty).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.buttonAddProperty).addGap(0, 62, Short.MAX_VALUE)).addComponent(this.jScrollPane1)).addContainerGap()));
        this.add(this.jPanel3);
    }

    private void radioButtonCustomActionPerformed(ActionEvent evt) {
        this.namespace = (String)this.comboBoxNamespace.getSelectedItem();
        this.simpleName = (String)this.comboBoxCustomName.getSelectedItem();
        this.updateKnownCustomNames();
        this.setControlStates();
        this.properties = null;
        this.updateProperties();
        this.updateMaterial();
    }

    private void comboBoxNamespaceActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.programmaticChange = true;
            try {
                this.namespace = (String)this.comboBoxNamespace.getSelectedItem();
                this.updateKnownCustomNames();
                this.updateMaterial();
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void comboBoxBlockTypeActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.programmaticChange = true;
            try {
                this.spinnerDataValue.setValue(0);
                this.blockIdOrDataChanged();
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void spinnerDataValueStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.programmaticChange = true;
            try {
                this.blockIdOrDataChanged();
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void radioButtonMinecraftActionPerformed(ActionEvent evt) {
        this.namespace = "minecraft";
        this.updateMaterial();
        this.setControlStates();
        this.loadDefaultProperties();
        this.firePropertyChange("material", null, this.getMaterial());
    }

    private void jLabel5MouseClicked(MouseEvent evt) {
        try {
            DesktopUtils.open((URL)new URL("https://www.worldpainter.net/links/dataValues"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL exception while trying to open https://www.worldpainter.net/links/dataValues", e);
        }
    }

    private void comboBoxMinecraftNameActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.programmaticChange = true;
            try {
                this.minecraftNameChanged();
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void comboBoxCustomNameFocusLost(FocusEvent evt) {
        this.simpleName = (String)this.comboBoxCustomName.getSelectedItem();
        this.programmaticChange = true;
        try {
            this.updateMaterial();
        }
        finally {
            this.programmaticChange = false;
        }
    }

    private void comboBoxCustomNameActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.simpleName = (String)this.comboBoxCustomName.getSelectedItem();
            this.programmaticChange = true;
            try {
                this.updateMaterial();
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void buttonAddPropertyActionPerformed(ActionEvent evt) {
        this.addProperty();
    }
}

