/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.utils.Lm;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.intellij.lang.annotations.Language;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.SystemUtils;
import org.pepsoft.util.plugins.PluginManager;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.AccelerationType;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.DonationDialog;
import org.pepsoft.worldpainter.EventLogger;
import org.pepsoft.worldpainter.ExceptionHandler;
import org.pepsoft.worldpainter.MerchDialog;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.PrivateContext;
import org.pepsoft.worldpainter.StartupMessages;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.WPContext;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldFactory;
import org.pepsoft.worldpainter.biomeschemes.BiomeSchemeManager;
import org.pepsoft.worldpainter.layers.renderers.VoidRenderer;
import org.pepsoft.worldpainter.operations.MouseOrTabletOperation;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.plugins.WPPluginManager;
import org.pepsoft.worldpainter.util.BetterAction;
import org.pepsoft.worldpainter.vo.EventVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Main {
    @Language(value="HTML")
    private static final String SNAPSHOT_MESSAGE = "<html><h1>Warning: Snapshot Release</h1><p>This is a snapshot release of WorldPainter. It is for testing <em>only</em>!<p>Any worlds you edit with this version <strong>may not be loadable</strong> by the next production version<br>when that is released and <strong>will not be loadable</strong> by the current production version!<p><strong>Make backups</strong> of any existing worlds you wish to test with this release, in a safe location.<p>Any or all work you do with this test release may be lost, and if you don't create backups,<br>you may lose your current worlds.<p>Please report bugs on GitHub: https://github.com/Captain-Chaos/WorldPainter<p>Type \"I understand\" below to proceed with testing the next release of WorldPainter:</p></html>";
    private static final String SNAPSHOT_MESSAGE_KEY = "org.pepsoft.worldpainter.snapshotWarning";
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    static PrivateContext privateContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        World2 world;
        File dynmapDir;
        boolean autosaveInhibited;
        File configDir;
        Locale.setDefault(Locale.US);
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        if (SystemUtils.isMac()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        System.setProperty("docking.focusWorkaround1", "true");
        System.setProperty("sun.java2d.uiScale.enabled", "false");
        String devMode = System.getProperty("org.pepsoft.worldpainter.devMode");
        if (devMode != null) {
            System.setProperty("org.pepsoft.devMode", devMode);
        }
        boolean safeMode = "true".equalsIgnoreCase(System.getProperty("org.pepsoft.worldpainter.safeMode"));
        for (String arg : args) {
            if (!arg.trim().equalsIgnoreCase("--safe")) continue;
            safeMode = true;
        }
        if (safeMode) {
            logger.info("WorldPainter running in safe mode");
            System.setProperty("org.pepsoft.worldpainter.safeMode", "true");
            System.setProperty("org.pepsoft.util.GUIUtils.disableScaling", "true");
        }
        if (Version.isSnapshot()) {
            System.setProperty("org.pepsoft.snapshotVersion", "true");
        }
        if (!(configDir = Configuration.getConfigDir()).isDirectory()) {
            configDir.mkdirs();
        }
        final Path lockFilePath = new File(configDir, "wpsession.lock").toPath();
        try {
            Files.createFile(lockFilePath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        final FileChannel lockFileChannel = FileChannel.open(lockFilePath, StandardOpenOption.WRITE);
        final FileLock lock = lockFileChannel.tryLock();
        if (lock == null) {
            lockFileChannel.close();
            autosaveInhibited = true;
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread("Lock File Eraser"){

                @Override
                public void run() {
                    try {
                        lock.release();
                        lockFileChannel.close();
                        Files.delete(lockFilePath);
                    }
                    catch (IOException e) {
                        logger.error("Could not delete lock file " + lockFilePath, (Throwable)e);
                    }
                }
            });
            autosaveInhibited = false;
        }
        String logLevel = "true".equalsIgnoreCase(System.getProperty("org.pepsoft.worldpainter.debugLogging")) ? "DEBUG" : ("extra".equalsIgnoreCase(System.getProperty("org.pepsoft.worldpainter.debugLogging")) ? "TRACE" : "INFO");
        LoggerContext logContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)logContext);
            logContext.reset();
            System.setProperty("org.pepsoft.worldpainter.configDir", configDir.getAbsolutePath());
            System.setProperty("org.pepsoft.worldpainter.logLevel", logLevel);
            configurator.doConfigure(ClassLoader.getSystemResourceAsStream("logback-main.xml"));
        }
        catch (JoranException configurator) {
            // empty catch block
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)logContext);
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        logger.info("Starting WorldPainter " + Version.VERSION + " (" + Version.BUILD + ")");
        logger.info("Running on {} version {}; architecture: {}", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")});
        logger.info("Running on {} Java version {}; maximum heap size: {} MB", new Object[]{System.getProperty("java.vendor"), System.getProperty("java.specification.version"), Runtime.getRuntime().maxMemory() / 1000000L});
        if (autosaveInhibited) {
            logger.warn("Another instance of WorldPainter is already running; disabling autosave");
        }
        File myFile = null;
        for (String arg : args) {
            if (!new File(arg).isFile() || myFile != null) {
                throw new IllegalArgumentException("Unrecognised or invalid command line option, or file does not exist: " + arg);
            }
            myFile = new File(arg);
        }
        File file = myFile;
        final boolean snapshot = Version.isSnapshot();
        if (!Configuration.getConfigFile().isFile()) {
            try {
                Preferences prefs = Preferences.userNodeForPackage(Main.class);
                prefs.remove((snapshot ? "snapshot." : "") + "accelerationType");
                prefs.flush();
                prefs = Preferences.userNodeForPackage(GUIUtils.class);
                prefs.remove((snapshot ? "snapshot." : "") + "manualUIScale");
                prefs.flush();
            }
            catch (BackingStoreException e) {
                logger.error("Error resetting user preferences", (Throwable)e);
            }
        }
        String accelTypeName = Preferences.userNodeForPackage(Main.class).get((snapshot ? "snapshot." : "") + "accelerationType", null);
        AccelerationType accelerationType = accelTypeName != null ? AccelerationType.valueOf((String)accelTypeName) : AccelerationType.DEFAULT;
        if (!safeMode) {
            switch (accelerationType) {
                case UNACCELERATED: {
                    System.setProperty("sun.java2d.d3d", "false");
                    System.setProperty("sun.java2d.opengl", "false");
                    System.setProperty("sun.java2d.xrender", "false");
                    System.setProperty("apple.awt.graphics.UseQuartz", "false");
                    logger.info("Hardware acceleration method: unaccelerated");
                    break;
                }
                case DIRECT3D: {
                    System.setProperty("sun.java2d.translaccel", "true");
                    System.setProperty("sun.java2d.ddscale", "true");
                    logger.info("Hardware acceleration method: Direct3D");
                    break;
                }
                case OPENGL: {
                    System.setProperty("sun.java2d.opengl", "True");
                    logger.info("Hardware acceleration method: OpenGL");
                    break;
                }
                case XRENDER: {
                    System.setProperty("sun.java2d.xrender", "True");
                    logger.info("Hardware acceleration method: XRender");
                    break;
                }
                case QUARTZ: {
                    System.setProperty("apple.awt.graphics.UseQuartz", "true");
                    logger.info("Hardware acceleration method: Quartz");
                    break;
                }
                default: {
                    logger.info("Hardware acceleration method: default");
                    break;
                }
            }
        } else {
            logger.info("[SAFE MODE] Hardware acceleration method: default");
        }
        try {
            Class.forName("org.pepsoft.worldpainter.DefaultPlugin");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Configuration config = null;
        try {
            config = Configuration.load();
        }
        catch (IOException | ClassNotFoundException | Error | RuntimeException e) {
            Main.configError(e);
        }
        if (config == null) {
            if (!logger.isDebugEnabled()) {
                logger.info("Creating new configuration");
            }
            config = new Configuration();
        }
        config.setSafeMode(safeMode);
        config.setAutosaveInhibited(autosaveInhibited);
        Configuration.setInstance((Configuration)config);
        logger.info("Installation ID: " + config.getUuid());
        if (config.getPreviousVersion() >= 0 && config.getPreviousVersion() < 18 && (dynmapDir = new File(Configuration.getConfigDir(), "dynmap")).isDirectory()) {
            FileUtils.deleteDir((File)dynmapDir);
        }
        if (config.isAutosaveEnabled() && autosaveInhibited) {
            StartupMessages.addWarning((String)"Another instance of WorldPainter is already running.\nAutosave will therefore be disabled in this instance of WorldPainter!");
        }
        config.setAccelerationType(accelerationType);
        BiomeSchemeManager.initialiseInBackground();
        X509Certificate trustedCert = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            trustedCert = (X509Certificate)certificateFactory.generateCertificate(Main.class.getResourceAsStream("/wproot.pem"));
        }
        catch (CertificateException e) {
            logger.error("Certificate exception while loading trusted root certificate", (Throwable)e);
        }
        if (!safeMode) {
            if (trustedCert != null) {
                PluginManager.loadPlugins((File)new File(configDir, "plugins"), (PublicKey)trustedCert.getPublicKey(), (String)"org.pepsoft.worldpainter.plugins", (org.pepsoft.util.Version)Version.VERSION_OBJ, (boolean)true);
            } else {
                logger.error("Trusted root certificate not available; not loading plugins");
            }
        } else {
            logger.info("[SAFE MODE] Not loading plugins");
        }
        WPPluginManager.initialise((UUID)config.getUuid(), (WPContext)WPContext.INSTANCE);
        for (Object platform : PlatformManager.getInstance().getAllPlatforms()) {
            logger.info("Available platform: {}", (Object)((Platform)platform).displayName);
        }
        String httpAgent = "WorldPainter " + Version.VERSION + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ";";
        System.setProperty("http.agent", httpAgent);
        for (PrivateContext aPrivateContextLoader : ServiceLoader.load(PrivateContext.class)) {
            if (privateContext == null) {
                privateContext = aPrivateContextLoader;
                continue;
            }
            throw new IllegalStateException("More than one private context found on classpath");
        }
        if (privateContext == null) {
            logger.debug("No private context found on classpath; update checks and usage data submission disabled");
            config.setPingAllowed(Boolean.valueOf(false));
        }
        if (privateContext != null) {
            privateContext.checkForUpdates();
        }
        final long start = System.currentTimeMillis();
        config.setLaunchCount(config.getLaunchCount() + 1);
        Runtime.getRuntime().addShutdownHook(new Thread("Configuration Saver"){

            @Override
            public void run() {
                try {
                    Configuration config = Configuration.getInstance();
                    MouseOrTabletOperation.flushEvents((EventLogger)config);
                    BetterAction.flushEvents((EventLogger)config);
                    EventVO sessionEvent = new EventVO("worldpainter.session").setAttribute(EventVO.ATTRIBUTE_TIMESTAMP, (Serializable)new Date(start)).duration(System.currentTimeMillis() - start);
                    StringBuilder sb = new StringBuilder();
                    List plugins = WPPluginManager.getInstance().getAllPlugins();
                    plugins.stream().filter(plugin -> !plugin.getClass().getName().startsWith("org.pepsoft.worldpainter")).forEach(plugin -> {
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append("{name=");
                        sb.append(plugin.getName().replaceAll("[ \\t\\n\\x0B\\f\\r\\.]", ""));
                        sb.append(",version=");
                        sb.append(plugin.getVersion());
                        sb.append('}');
                    });
                    if (sb.length() > 0) {
                        sessionEvent.setAttribute(Constants.ATTRIBUTE_KEY_PLUGINS, (Serializable)((Object)sb.toString()));
                    }
                    sessionEvent.setAttribute(Constants.ATTRIBUTE_KEY_SAFE_MODE, (Serializable)Boolean.valueOf(config.isSafeMode()));
                    config.logEvent(sessionEvent);
                    config.save();
                    Preferences prefs = Preferences.userNodeForPackage(Main.class);
                    prefs.put((snapshot ? "snapshot." : "") + "accelerationType", config.getAccelerationType().name());
                    prefs.flush();
                    prefs = Preferences.userNodeForPackage(GUIUtils.class);
                    prefs.putFloat((snapshot ? "snapshot." : "") + "manualUIScale", config.getUiScale());
                    prefs.flush();
                }
                catch (IOException e) {
                    logger.error("I/O error saving configuration", (Throwable)e);
                }
                catch (BackingStoreException e) {
                    logger.error("Backing store exception saving acceleration type", (Throwable)e);
                }
                logger.info("Shutting down WorldPainter");
            }
        });
        URL.setURLStreamHandlerFactory(protocol -> {
            switch (protocol) {
                case "action": {
                    return new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL u) throws IOException {
                            throw new UnsupportedOperationException("Not supported");
                        }
                    };
                }
            }
            return null;
        });
        File autosaveFile = new File(configDir, "autosave.world");
        if (!(file != null || !autosaveInhibited && config.isAutosaveEnabled() && autosaveFile.isFile())) {
            if (!safeMode) {
                world = WorldFactory.createDefaultWorld(config, new Random().nextLong());
            } else {
                logger.info("[SAFE MODE] Using default configuration for default world");
                world = WorldFactory.createDefaultWorld(new Configuration(), new Random().nextLong());
            }
        } else {
            world = null;
        }
        InputStream in = ClassLoader.getSystemResourceAsStream("jide_licence.properties");
        if (in != null) {
            try {
                Properties jideLicenceProps = new Properties();
                jideLicenceProps.load(in);
                Lm.verifyLicense((String)jideLicenceProps.getProperty("companyName"), (String)jideLicenceProps.getProperty("projectName"), (String)jideLicenceProps.getProperty("licenceKey"));
            }
            finally {
                in.close();
            }
        }
        Configuration.LookAndFeel lookAndFeel = config.getLookAndFeel() != null ? config.getLookAndFeel() : Configuration.LookAndFeel.SYSTEM;
        SwingUtilities.invokeLater(() -> {
            Configuration myConfig = Configuration.getInstance();
            if (myConfig.isSafeMode()) {
                GUIUtils.setUIScale((float)1.0f);
                logger.info("[SAFE MODE] Not installing visual theme");
            } else {
                try {
                    String laf;
                    switch (lookAndFeel) {
                        case SYSTEM: {
                            laf = UIManager.getSystemLookAndFeelClassName();
                            break;
                        }
                        case METAL: {
                            laf = "javax.swing.plaf.metal.MetalLookAndFeel";
                            break;
                        }
                        case NIMBUS: {
                            laf = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
                            break;
                        }
                        case DARK_METAL: {
                            laf = "org.netbeans.swing.laf.dark.DarkMetalLookAndFeel";
                            IconUtils.setTheme((String)"dark_metal");
                            break;
                        }
                        case DARK_NIMBUS: {
                            laf = "org.netbeans.swing.laf.dark.DarkNimbusLookAndFeel";
                            IconUtils.setTheme((String)"dark_nimbus");
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                    logger.debug("Installing look and feel: " + laf);
                    UIManager.setLookAndFeel(laf);
                    LookAndFeelFactory.installJideExtension();
                    if (lookAndFeel == Configuration.LookAndFeel.DARK_METAL || lookAndFeel == Configuration.LookAndFeel.DARK_NIMBUS) {
                        VoidRenderer.setColour((int)UIManager.getColor("Panel.background").getRGB());
                        if (lookAndFeel == Configuration.LookAndFeel.DARK_METAL) {
                            UIManager.put("ContentContainer.background", UIManager.getColor("desktop"));
                            UIManager.put("JideTabbedPane.foreground", new Color(222, 222, 222));
                        }
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                    logger.warn("Could not install selected look and feel", (Throwable)e);
                }
                if (GUIUtils.getUIScale() != 1.0f) {
                    GUIUtils.scaleLookAndFeel((float)GUIUtils.getUIScale());
                }
            }
            UIManager.put("Slider.paintValue", Boolean.FALSE);
            App app = App.getInstance();
            app.setVisible(true);
            if (myConfig.isMaximised() && System.getProperty("org.pepsoft.worldpainter.size") == null) {
                app.setExtendedState(6);
            }
            SwingUtilities.invokeLater(() -> {
                if (Version.isSnapshot() && !myConfig.isMessageDisplayed(SNAPSHOT_MESSAGE_KEY)) {
                    String result = JOptionPane.showInputDialog(app, SNAPSHOT_MESSAGE, "Snapshot Release", 2);
                    if (result == null) {
                        System.exit(0);
                    }
                    while (!result.toLowerCase().replace(" ", "").equals("iunderstand")) {
                        DesktopUtils.beep();
                        result = JOptionPane.showInputDialog(app, SNAPSHOT_MESSAGE, "Snapshot Release", 2);
                        if (result != null) continue;
                        System.exit(0);
                    }
                    myConfig.setMessageDisplayed(SNAPSHOT_MESSAGE_KEY);
                }
                if (world != null) {
                    app.setWorld(world, true);
                } else if (!autosaveInhibited && myConfig.isAutosaveEnabled() && autosaveFile.isFile()) {
                    logger.info("Recovering autosaved world");
                    app.open(autosaveFile);
                    StartupMessages.addWarning((String)"WorldPainter was not shut down correctly.\nYour world has been recovered from the most recent autosave.\nMake sure to Save it if you want to keep it!");
                } else {
                    app.open(file);
                }
                for (String error : StartupMessages.getErrors()) {
                    MessageUtils.beepAndShowError((Component)app, (String)error, (String)"Startup Error");
                }
                for (String warning : StartupMessages.getWarnings()) {
                    MessageUtils.beepAndShowWarning((Component)app, (String)warning, (String)"Startup Warning");
                }
                for (String message : StartupMessages.getMessages()) {
                    MessageUtils.showInfo((Component)app, (String)message, (String)"Startup Message");
                }
                if (StartupMessages.getErrors().isEmpty() && StartupMessages.getWarnings().isEmpty() && StartupMessages.getMessages().isEmpty() && !DonationDialog.maybeShowDonationDialog(app)) {
                    MerchDialog.maybeShowMerchDialog(app);
                }
            });
        });
    }

    private static void configError(Throwable e) {
        File configFile = Configuration.getConfigFile();
        if (configFile.isFile() && configFile.canRead()) {
            File backupConfigFile = new File(configFile.getParentFile(), configFile.getName() + ".old");
            try {
                FileUtils.copyFileToFile((File)configFile, (File)backupConfigFile, (boolean)true);
            }
            catch (IOException e1) {
                logger.error("I/O error while trying to preserve faulty config file", (Throwable)e1);
            }
        }
        logger.error("Exception while initialising configuration", e);
        StartupMessages.addError((String)("Could not read configuration file! Configuration was reset.\n\nException type: " + e.getClass().getSimpleName() + "\nMessage: " + e.getMessage()));
    }
}

