/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import com.google.common.primitives.Ints;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.util.swing.ProgressDialog;
import org.pepsoft.util.swing.ProgressTask;
import org.pepsoft.util.swing.SpinnerUtils;
import org.pepsoft.util.swing.TiledImageViewer;
import org.pepsoft.util.swing.TiledImageViewerContainer;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.HeightTransform;
import org.pepsoft.worldpainter.NewWorldDialog;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.PlatformListCellRenderer;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileProvider;
import org.pepsoft.worldpainter.TileRenderer;
import org.pepsoft.worldpainter.WPTileProvider;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.heightMaps.BitmapHeightMap;
import org.pepsoft.worldpainter.heightMaps.ConstantHeightMap;
import org.pepsoft.worldpainter.heightMaps.DifferenceHeightMap;
import org.pepsoft.worldpainter.heightMaps.ImportPreset;
import org.pepsoft.worldpainter.heightMaps.NoiseHeightMap;
import org.pepsoft.worldpainter.heightMaps.SumHeightMap;
import org.pepsoft.worldpainter.heightMaps.TransformingHeightMap;
import org.pepsoft.worldpainter.heightMaps.gui.ImportPresetListCellRenderer;
import org.pepsoft.worldpainter.importing.HeightMapImporter;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.themes.SimpleTheme;
import org.pepsoft.worldpainter.themes.TerrainListCellRenderer;
import org.pepsoft.worldpainter.themes.Theme;
import org.pepsoft.worldpainter.themes.impl.simple.SimpleThemeEditor;
import org.pepsoft.worldpainter.util.ImageUtils;
import org.pepsoft.worldpainter.util.LayoutUtils;
import org.pepsoft.worldpainter.util.MinecraftUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportHeightMapDialog
extends WorldPainterDialog
implements DocumentListener,
SimpleThemeEditor.ChangeListener {
    private JButton buttonCancel;
    private JButton buttonLoadDefaults;
    private JButton buttonMasterInfo;
    private JButton buttonOk;
    private JButton buttonResetDefaults;
    private JButton buttonSaveAsDefaults;
    private JButton buttonSelectFile;
    private JCheckBox checkBoxCreateTiles;
    private JCheckBox checkBoxInvert;
    private JCheckBox checkBoxMasterDimension;
    private JCheckBox checkBoxOnlyRaise;
    private JCheckBox checkBoxVoid;
    private JComboBox<Integer> comboBoxMaxHeight;
    private JComboBox<Integer> comboBoxMinHeight;
    private JComboBox<Platform> comboBoxPlatform;
    private JComboBox<ImportPreset> comboBoxPreset;
    private JComboBox<Terrain> comboBoxSingleTerrain;
    private JTextField fieldFilename;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTabbedPane jTabbedPane1;
    private JLabel labelExportedOffset;
    private JLabel labelExportedSize;
    private JLabel labelImageDimensions;
    private JLabel labelImageHighestLevel;
    private JLabel labelImageLowestLevel;
    private JLabel labelImageWaterLevel;
    private JLabel labelMaxHeight;
    private JLabel labelMinHeight;
    private JLabel labelNoUndo;
    private JLabel labelWalkingTime;
    private JLabel labelWarning;
    private JLabel labelWarningCutOffAbove;
    private JLabel labelWarningCutOffBelow;
    private JLabel labelWorldDimensions;
    private JLabel labelWorldHighestLevel;
    private JLabel labelWorldLowestLevel;
    private JRadioButton radioButtonApplyTheme;
    private JRadioButton radioButtonLeaveTerrain;
    private JRadioButton radioButtonSingleTerrain;
    private JSpinner spinnerImageHigh;
    private JSpinner spinnerImageLow;
    private JSpinner spinnerOffsetX;
    private JSpinner spinnerOffsetY;
    private JSpinner spinnerScale;
    private JSpinner spinnerVoidBelow;
    private JSpinner spinnerWorldHigh;
    private JSpinner spinnerWorldLow;
    private JSpinner spinnerWorldMiddle;
    private ButtonGroup themeButtonGroup;
    private SimpleThemeEditor themeEditor;
    private TiledImageViewer tiledImageViewer2;
    private TiledImageViewerContainer tiledImageViewerContainer1;
    private final long seed = new Random().nextLong();
    private final Dimension currentDimension;
    private final ColourScheme colourScheme;
    private final boolean contourLines;
    private final int contourSeparation;
    private final TileRenderer.LightOrigin lightOrigin;
    private final CustomBiomeManager customBiomeManager;
    private File selectedFile;
    private File heightMapDir;
    private volatile BufferedImage image;
    private int bitDepth = 8;
    private double imageLowValue;
    private double imageHighValue = 255.0;
    private double imageMinHeight;
    private double imageMaxHeight = 255.0;
    private boolean programmaticChange = true;
    private Platform platform;
    private static final String UPDATE_HEIGHT_MAP_PREVIEW = ImportHeightMapDialog.class.getName() + ".updateHeightMap";
    private static final Icon ICON_WARNING = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/error.png");
    private static final int LAYER_HEIGHT_MAP = 0;
    private static final int LAYER_CURRENT_DIMENSION = -1;
    private static final Logger logger = LoggerFactory.getLogger(ImportHeightMapDialog.class);
    private static final long serialVersionUID = 1L;

    public ImportHeightMapDialog(Window parent, ColourScheme colourScheme, boolean contourLines, int contourSeparation, TileRenderer.LightOrigin lightOrigin, File preselectedFile) {
        this(parent, null, colourScheme, null, contourLines, contourSeparation, lightOrigin, preselectedFile);
    }

    public ImportHeightMapDialog(Window parent, Dimension currentDimension, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, boolean contourLines, int contourSeparation, TileRenderer.LightOrigin lightOrigin, final File preselectedFile) {
        super(parent);
        this.currentDimension = currentDimension;
        this.colourScheme = colourScheme;
        this.customBiomeManager = customBiomeManager;
        this.contourLines = contourLines;
        this.contourSeparation = contourSeparation;
        this.lightOrigin = lightOrigin;
        this.initComponents();
        this.tiledImageViewer2.setZoom(0);
        this.tiledImageViewer2.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int oldZoom = ImportHeightMapDialog.this.tiledImageViewer2.getZoom();
                int zoom = e.getWheelRotation() < 0 ? Math.min(oldZoom - e.getWheelRotation(), 6) : Math.max(oldZoom - e.getWheelRotation(), -4);
                if (zoom != oldZoom) {
                    ImportHeightMapDialog.this.tiledImageViewer2.setZoom(zoom, e.getX(), e.getY());
                }
            }
        });
        this.tiledImageViewerContainer1.setView((Component)this.tiledImageViewer2);
        this.themeEditor.setColourScheme(colourScheme);
        this.spinnerOffsetX.setEditor(new JSpinner.NumberEditor(this.spinnerOffsetX, "0"));
        this.spinnerOffsetY.setEditor(new JSpinner.NumberEditor(this.spinnerOffsetY, "0"));
        this.checkBoxCreateTiles.setSelected(true);
        this.labelWarning.setVisible(false);
        this.comboBoxPlatform.setModel(new DefaultComboBoxModel<Platform>(PlatformManager.getInstance().getAllPlatforms().toArray(new Platform[0])));
        this.labelWarningCutOffBelow.setVisible(false);
        this.labelWarningCutOffAbove.setVisible(false);
        this.comboBoxSingleTerrain.setRenderer(new TerrainListCellRenderer(colourScheme));
        this.comboBoxSingleTerrain.setSelectedItem(Terrain.GRASS);
        this.comboBoxPreset.setRenderer(new ImportPresetListCellRenderer());
        this.fieldFilename.getDocument().addDocumentListener(this);
        this.rootPane.setDefaultButton(this.buttonOk);
        if (currentDimension != null) {
            this.platform = currentDimension.getWorld().getPlatform();
            this.jTabbedPane1.setEnabledAt(1, false);
            this.comboBoxPlatform.setSelectedItem(this.platform);
            this.comboBoxPlatform.setEnabled(false);
            this.buttonResetDefaults.setEnabled(false);
            this.spinnerWorldMiddle.setValue(((HeightMapTileFactory)currentDimension.getTileFactory()).getTheme().clone().getWaterHeight());
            this.buttonLoadDefaults.setEnabled(true);
            this.buttonSaveAsDefaults.setEnabled(true);
            this.checkBoxOnlyRaise.setSelected(true);
            this.comboBoxSingleTerrain.setModel(new DefaultComboBoxModel<Terrain>(Terrain.getConfiguredValues()));
            this.checkBoxMasterDimension.setSelected(currentDimension.getAnchor().role == Dimension.Role.MASTER);
            this.checkBoxMasterDimension.setEnabled(false);
        } else {
            this.platform = Configuration.getInstance().getDefaultPlatform();
            this.themeEditor.setTheme(SimpleTheme.createDefault((Terrain)Terrain.GRASS, (int)this.platform.minZ, (int)this.platform.standardMaxHeight, (int)62, (boolean)true, (boolean)true));
            this.themeEditor.setChangeListener(this);
            this.comboBoxPlatform.setSelectedItem(this.platform);
            this.labelNoUndo.setText(" ");
            this.checkBoxCreateTiles.setEnabled(false);
            this.checkBoxOnlyRaise.setEnabled(false);
            this.comboBoxSingleTerrain.setModel(new DefaultComboBoxModel<Terrain>(Terrain.PICK_LIST));
            this.radioButtonLeaveTerrain.setEnabled(false);
            this.loadDefaults();
        }
        boolean masterDimensionSelected = this.checkBoxMasterDimension.isSelected();
        this.jLabel20.setVisible(masterDimensionSelected);
        this.labelExportedSize.setVisible(masterDimensionSelected);
        this.jLabel22.setVisible(masterDimensionSelected);
        this.labelExportedOffset.setVisible(masterDimensionSelected);
        this.scaleToUI();
        this.pack();
        LayoutUtils.setDefaultSizeAndLocation(this, 60);
        this.programmaticChange = false;
        this.platformChanged();
        this.updateImageLevelLabels();
        this.setControlStates();
        this.updatePreview(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (preselectedFile != null && preselectedFile.isFile()) {
                    ImportHeightMapDialog.this.fieldFilename.setText(preselectedFile.getAbsolutePath());
                } else {
                    ImportHeightMapDialog.this.selectFile();
                }
            }
        });
    }

    public World2 getImportedWorld() {
        if (this.currentDimension != null) {
            throw new IllegalStateException();
        }
        final HeightMapImporter importer = this.createImporter(true);
        if (importer == null) {
            return null;
        }
        World2 world = (World2)ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<World2>(){

            public String getName() {
                return "Importing height map";
            }

            public World2 execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                return importer.importToNewWorld(ImportHeightMapDialog.this.checkBoxMasterDimension.isSelected() ? Dimension.Anchor.NORMAL_MASTER : Dimension.Anchor.NORMAL_DETAIL, progressReceiver);
            }
        }, (ProgressDialog.Option[])new ProgressDialog.Option[]{ProgressDialog.NOT_CANCELABLE});
        Configuration.getInstance().setHeightMapsDirectory(this.selectedFile.getParentFile());
        return world;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setControlStates();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setControlStates();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setControlStates();
    }

    @Override
    public void settingsModified(SimpleThemeEditor editor) {
        if (this.currentDimension != null) {
            this.buttonResetDefaults.setEnabled(true);
        }
        this.buttonSaveAsDefaults.setEnabled(true);
        this.buttonLoadDefaults.setEnabled(true);
        this.updatePreview(false);
    }

    private HeightMapImporter createImporter(boolean interactive) {
        String name;
        int p;
        if (this.selectedFile == null || !this.selectedFile.exists()) {
            if (interactive) {
                MessageUtils.beepAndShowError((Component)this, (String)"Please select an image file to import.", (String)"No File Selected");
            }
            return null;
        }
        if (this.image == null) {
            if (interactive) {
                MessageUtils.beepAndShowError((Component)this, (String)"Please select a valid image file to import.", (String)"No Valid Image Selected");
            }
            return null;
        }
        float scale = ((Float)this.spinnerScale.getValue()).floatValue();
        BitmapHeightMap heightMap = BitmapHeightMap.build().withName(this.selectedFile.getName()).withImage(this.image).withFile(this.selectedFile).now();
        if (scale != 100.0f) {
            heightMap = heightMap.smoothed();
        }
        int offsetX = (Integer)this.spinnerOffsetX.getValue();
        int offsetY = (Integer)this.spinnerOffsetY.getValue();
        if (scale != 100.0f || offsetX != 0 || offsetY != 0) {
            heightMap = new TransformingHeightMap(heightMap.getName() + " transformed", (HeightMap)heightMap, scale / 100.0f, scale / 100.0f, offsetX, offsetY, 0.0f);
        }
        if (this.checkBoxInvert.isSelected()) {
            heightMap = new DifferenceHeightMap((HeightMap)new ConstantHeightMap((double)((float)(Math.pow(2.0, this.bitDepth) - 1.0))), (HeightMap)heightMap);
        }
        if ((p = (name = this.selectedFile.getName()).lastIndexOf(46)) != -1) {
            name = name.substring(0, p);
        }
        int waterLevel = (Integer)this.spinnerWorldMiddle.getValue();
        int minHeight = (Integer)this.comboBoxMinHeight.getSelectedItem();
        int maxHeight = (Integer)this.comboBoxMaxHeight.getSelectedItem();
        HeightMapImporter importer = new HeightMapImporter();
        Platform platform = (Platform)this.comboBoxPlatform.getSelectedItem();
        importer.setPlatform(platform);
        importer.setHeightMap((HeightMap)heightMap);
        importer.setImageFile(this.selectedFile);
        importer.setName(name);
        if (this.currentDimension != null) {
            importer.setTileFactory(this.currentDimension.getTileFactory());
            if (this.radioButtonSingleTerrain.isSelected()) {
                SimpleTheme theme = SimpleTheme.createSingleTerrain((Terrain)((Terrain)this.comboBoxSingleTerrain.getSelectedItem()), (int)minHeight, (int)maxHeight, (int)waterLevel);
                theme.setSeed(this.seed);
                importer.setTheme((Theme)theme);
            } else if (this.radioButtonLeaveTerrain.isSelected()) {
                importer.setTheme(null);
            }
        } else {
            SimpleTheme theme;
            this.themeEditor.save();
            if (this.radioButtonSingleTerrain.isSelected()) {
                theme = SimpleTheme.createSingleTerrain((Terrain)((Terrain)this.comboBoxSingleTerrain.getSelectedItem()), (int)minHeight, (int)maxHeight, (int)waterLevel);
            } else {
                theme = this.themeEditor.getTheme();
                theme.setMinMaxHeight(minHeight, maxHeight, HeightTransform.IDENTITY);
            }
            theme.setSeed(this.seed);
            importer.setTileFactory((TileFactory)new HeightMapTileFactory(this.seed, (HeightMap)new SumHeightMap((HeightMap)new ConstantHeightMap((double)(waterLevel - 4)), (HeightMap)new NoiseHeightMap(20.0, 1.0, 1, 0L)), minHeight, maxHeight, false, (Theme)theme));
        }
        importer.setMinHeight(minHeight);
        importer.setMaxHeight(maxHeight);
        importer.setImageLowLevel(((Double)this.spinnerImageLow.getValue()).doubleValue());
        importer.setImageHighLevel(((Double)this.spinnerImageHigh.getValue()).doubleValue());
        importer.setWorldLowLevel(((Integer)this.spinnerWorldLow.getValue()).intValue());
        importer.setWorldWaterLevel(waterLevel);
        importer.setWorldHighLevel(((Integer)this.spinnerWorldHigh.getValue()).intValue());
        importer.setVoidBelow(this.checkBoxVoid.isSelected());
        if (this.checkBoxVoid.isSelected()) {
            importer.setVoidBelowLevel(((Double)this.spinnerVoidBelow.getValue()).doubleValue());
        }
        return importer;
    }

    private void setControlStates() {
        File file = new File(this.fieldFilename.getText());
        if (file.isFile() && !file.equals(this.selectedFile)) {
            this.selectedFile = file;
            this.loadImage();
        }
        boolean fileSelected = this.selectedFile != null && this.selectedFile.isFile();
        this.comboBoxPreset.setEnabled(fileSelected);
        this.buttonOk.setEnabled(fileSelected);
        this.spinnerImageLow.setEnabled(fileSelected);
        this.spinnerImageHigh.setEnabled(fileSelected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImage() {
        block15: {
            try {
                this.image = null;
                this.image = ImageIO.read(this.selectedFile);
                if (this.image == null) {
                    this.labelImageDimensions.setForeground(Color.RED);
                    this.labelImageDimensions.setIcon(ICON_WARNING);
                    this.labelImageDimensions.setText("Not an image file of a supported type, or damaged file!");
                    this.selectedFile = null;
                    break block15;
                }
                if (this.image.getType() == 12 || this.image.getType() == 13) {
                    this.labelImageDimensions.setForeground(Color.RED);
                    this.labelImageDimensions.setIcon(ICON_WARNING);
                    this.labelImageDimensions.setText("Indexed image not supported! Please convert to non-indexed.");
                    this.selectedFile = null;
                    break block15;
                }
                if (this.image.isAlphaPremultiplied()) {
                    this.labelImageDimensions.setForeground(Color.RED);
                    this.labelImageDimensions.setIcon(ICON_WARNING);
                    this.labelImageDimensions.setText("Premultiplied alpha not supported! Please convert to non-premultiplied.");
                    this.selectedFile = null;
                    break block15;
                }
                BitmapHeightMap heightMap = BitmapHeightMap.build().withImage(this.image).now();
                int width = heightMap.getWidth();
                int height = heightMap.getHeight();
                this.programmaticChange = true;
                try {
                    double delta;
                    this.labelImageDimensions.setForeground(null);
                    this.labelImageDimensions.setIcon(null);
                    this.bitDepth = heightMap.getBitDepth();
                    this.imageMinHeight = heightMap.getMinHeight();
                    this.imageMaxHeight = heightMap.getMaxHeight();
                    boolean invert = this.checkBoxInvert.isSelected();
                    double[] range = heightMap.getRange();
                    this.imageLowValue = invert ? this.imageMaxHeight - range[1] : range[0];
                    double d = this.imageHighValue = invert ? this.imageMaxHeight - range[0] : range[1];
                    double stepSize = heightMap.isFloatingPoint() ? ((delta = this.imageHighValue - this.imageLowValue) <= 1.0 ? 0.001 : (delta <= 10.0 ? 0.01 : (delta <= 100.0 ? 0.1 : 1.0))) : 1.0;
                    SpinnerUtils.setMinimum((JSpinner)this.spinnerImageLow, (Comparable)Double.valueOf(this.imageMinHeight));
                    SpinnerUtils.setMaximum((JSpinner)this.spinnerImageLow, (Comparable)Double.valueOf(this.imageMaxHeight));
                    ((SpinnerNumberModel)this.spinnerImageLow.getModel()).setStepSize(stepSize);
                    SpinnerUtils.setMinimum((JSpinner)this.spinnerImageHigh, (Comparable)Double.valueOf(this.imageMinHeight));
                    SpinnerUtils.setMaximum((JSpinner)this.spinnerImageHigh, (Comparable)Double.valueOf(this.imageMaxHeight));
                    ((SpinnerNumberModel)this.spinnerImageHigh.getModel()).setStepSize(stepSize);
                    SpinnerUtils.setMinimum((JSpinner)this.spinnerVoidBelow, (Comparable)Double.valueOf(this.imageMinHeight));
                    SpinnerUtils.setMaximum((JSpinner)this.spinnerVoidBelow, (Comparable)Double.valueOf(this.imageMaxHeight));
                    ((SpinnerNumberModel)this.spinnerVoidBelow.getModel()).setStepSize(stepSize);
                    this.spinnerVoidBelow.setValue(this.imageLowValue);
                }
                finally {
                    this.programmaticChange = false;
                }
                if (heightMap.isFloatingPoint()) {
                    this.labelImageLowestLevel.setText(App.FLOAT_NUMBER_FORMAT.format(this.imageLowValue));
                    this.labelImageHighestLevel.setText(App.FLOAT_NUMBER_FORMAT.format(this.imageHighValue));
                } else {
                    this.labelImageLowestLevel.setText(App.INT_NUMBER_FORMAT.format(this.imageLowValue));
                    this.labelImageHighestLevel.setText(App.INT_NUMBER_FORMAT.format(this.imageHighValue));
                }
                this.selectDefaultVerticalScaling(false);
                if (heightMap.isFloatingPoint()) {
                    this.labelImageDimensions.setText(String.format("Image size: %,d x %,d, %d bits, lowest value: %,f, highest value: %,f", width, height, this.bitDepth, this.imageLowValue, this.imageHighValue));
                } else {
                    this.labelImageDimensions.setText(String.format("Image size: %,d x %,d, %d bits, lowest value: %,d, highest value: %,d", width, height, this.bitDepth, Math.round(this.imageLowValue), Math.round(this.imageHighValue)));
                }
                this.updateWorldDimensions();
                this.updatePreview(true);
            }
            catch (IOException e) {
                logger.error("I/O error loading image " + this.selectedFile, (Throwable)e);
                this.labelImageDimensions.setForeground(Color.RED);
                this.labelImageDimensions.setText(String.format("I/O error loading image (message: %s)!", e.getMessage()));
                this.selectedFile = null;
            }
            catch (IllegalArgumentException e) {
                logger.error("IllegalArgumentException loading image " + this.selectedFile, (Throwable)e);
                this.labelImageDimensions.setForeground(Color.RED);
                if (e.getMessage().equals("Invalid scanline stride")) {
                    this.labelImageDimensions.setText("Image data too large to load; try reducing dimensions or bit depth");
                } else {
                    this.labelImageDimensions.setText("Error in image data: " + e.getMessage());
                }
                this.selectedFile = null;
            }
        }
    }

    private void selectDefaultVerticalScaling(boolean preserveCurrent) {
        if (this.image == null) {
            return;
        }
        ImportPreset currentPreset = preserveCurrent ? (ImportPreset)this.comboBoxPreset.getSelectedItem() : null;
        Vector<ImportPreset> presets = new Vector<ImportPreset>(ImportPreset.PRESETS.length + 1);
        presets.add(null);
        for (ImportPreset preset : ImportPreset.PRESETS) {
            if (!preset.isValid(this.imageMinHeight, this.imageMaxHeight, this.imageLowValue, this.imageHighValue, this.platform, (Integer)this.comboBoxMinHeight.getSelectedItem(), (Integer)this.comboBoxMaxHeight.getSelectedItem())) continue;
            presets.add(preset);
        }
        DefaultComboBoxModel presetsModel = new DefaultComboBoxModel(presets);
        this.comboBoxPreset.setModel(presetsModel);
        this.comboBoxPreset.setEnabled(presets.size() > 1);
        if (currentPreset != null && presets.contains(currentPreset)) {
            this.comboBoxPreset.setSelectedItem(currentPreset);
        } else {
            this.comboBoxPreset.setSelectedItem(presets.lastElement());
        }
        this.applyPreset((ImportPreset)this.comboBoxPreset.getSelectedItem());
    }

    private void updateWorldDimensions() {
        float dimensionScale = this.checkBoxMasterDimension.isSelected() ? 16.0f : 1.0f;
        this.labelExportedOffset.setText(App.INT_NUMBER_FORMAT.format(Math.round((float)((Integer)this.spinnerOffsetX.getValue()).intValue() * dimensionScale)) + ", " + App.INT_NUMBER_FORMAT.format(Math.round((float)((Integer)this.spinnerOffsetY.getValue()).intValue() * dimensionScale)));
        if (this.image == null) {
            return;
        }
        float importScale = ((Float)this.spinnerScale.getValue()).floatValue();
        int scaledWidth = Math.round((float)this.image.getWidth() * (importScale / 100.0f));
        int scaledHeight = Math.round((float)this.image.getHeight() * (importScale / 100.0f));
        this.labelWorldDimensions.setText("Scaled size: " + App.INT_NUMBER_FORMAT.format(scaledWidth) + " x " + App.INT_NUMBER_FORMAT.format(scaledHeight) + " blocks");
        int exportedWidth = Math.round((float)scaledWidth * dimensionScale);
        int exportedHeight = Math.round((float)scaledHeight * dimensionScale);
        this.labelExportedSize.setText(App.INT_NUMBER_FORMAT.format(exportedWidth) + " x " + App.INT_NUMBER_FORMAT.format(exportedHeight) + " blocks");
        String westEastTime = MinecraftUtil.blocksToWalkingTime((int)exportedWidth);
        String northSouthTime = MinecraftUtil.blocksToWalkingTime((int)exportedHeight);
        if (westEastTime.equals(northSouthTime)) {
            this.labelWalkingTime.setText(westEastTime);
        } else {
            this.labelWalkingTime.setText("West to east: " + westEastTime + ", north to south: " + northSouthTime);
        }
    }

    private void updateImageLevelLabels() {
        if (this.programmaticChange) {
            return;
        }
        int minHeight = (Integer)this.comboBoxMinHeight.getSelectedItem();
        int maxHeight = (Integer)this.comboBoxMaxHeight.getSelectedItem() - 1;
        double imageLowLevel = (Double)this.spinnerImageLow.getValue();
        double imageHighLevel = (Double)this.spinnerImageHigh.getValue();
        int worldLowLevel = (Integer)this.spinnerWorldLow.getValue();
        int worldMiddleLevel = (Integer)this.spinnerWorldMiddle.getValue();
        int worldHighLevel = (Integer)this.spinnerWorldHigh.getValue();
        double levelScale = (double)(worldHighLevel - worldLowLevel) / (imageHighLevel - imageLowLevel);
        long imageMiddleLevel = (long)((double)(worldMiddleLevel - worldLowLevel) / levelScale + imageLowLevel);
        int worldLowestLevel = (int)((this.imageLowValue - imageLowLevel) * levelScale + (double)worldLowLevel);
        int worldHighestLevel = (int)((this.imageHighValue - imageLowLevel) * levelScale + (double)worldLowLevel);
        if ((double)imageMiddleLevel < this.imageLowValue) {
            this.labelImageWaterLevel.setText("-");
        } else if ((double)imageMiddleLevel > this.imageHighValue) {
            this.labelImageWaterLevel.setText("> " + App.FLOAT_NUMBER_FORMAT.format(this.imageHighValue));
        } else {
            this.labelImageWaterLevel.setText(App.INT_NUMBER_FORMAT.format(imageMiddleLevel));
        }
        if (worldLowestLevel < minHeight) {
            this.labelWorldLowestLevel.setText("<html><b>&lt; " + App.INT_NUMBER_FORMAT.format(minHeight) + "</b></html>");
            this.labelWarningCutOffBelow.setVisible(true);
        } else if (worldLowestLevel > maxHeight) {
            this.labelWorldLowestLevel.setText("<html><b>&gt; " + App.INT_NUMBER_FORMAT.format(maxHeight) + "</b></html>");
            this.labelWarningCutOffBelow.setVisible(false);
        } else {
            this.labelWorldLowestLevel.setText(App.INT_NUMBER_FORMAT.format(worldLowestLevel));
            this.labelWarningCutOffBelow.setVisible(false);
        }
        if (worldHighestLevel < minHeight) {
            this.labelWorldHighestLevel.setText("<html><b>&lt; " + App.INT_NUMBER_FORMAT.format(minHeight) + "</b></html>");
            this.labelWarningCutOffAbove.setVisible(false);
        } else if (worldHighestLevel > maxHeight) {
            this.labelWorldHighestLevel.setText("<html><b>&gt; " + App.INT_NUMBER_FORMAT.format(maxHeight) + "</b></html>");
            this.labelWarningCutOffAbove.setVisible(true);
        } else {
            this.labelWorldHighestLevel.setText(App.INT_NUMBER_FORMAT.format(worldHighestLevel));
            this.labelWarningCutOffAbove.setVisible(false);
        }
    }

    private void loadDefaults() {
        this.loadDefaultTheme();
        this.updateImageLevelLabels();
        this.updatePreview(false);
    }

    private void loadDefaultTheme() {
        int minHeight = this.comboBoxMinHeight.getSelectedItem() != null ? (Integer)this.comboBoxMinHeight.getSelectedItem() : this.platform.minZ;
        int maxHeight = this.comboBoxMaxHeight.getSelectedItem() != null ? (Integer)this.comboBoxMaxHeight.getSelectedItem() : this.platform.standardMaxHeight;
        Theme defaultTheme = Configuration.getInstance().getHeightMapDefaultTheme();
        if (defaultTheme == null) {
            defaultTheme = SimpleTheme.createDefault((Terrain)Terrain.GRASS, (int)minHeight, (int)maxHeight, (int)62, (boolean)true, (boolean)true);
            if (this.currentDimension == null) {
                this.buttonResetDefaults.setEnabled(false);
            }
        } else {
            this.buttonResetDefaults.setEnabled(true);
        }
        defaultTheme.setMinMaxHeight(minHeight, maxHeight, HeightTransform.IDENTITY);
        this.spinnerWorldMiddle.setValue(defaultTheme.getWaterHeight());
        this.themeEditor.setTheme((SimpleTheme)defaultTheme);
        this.buttonLoadDefaults.setEnabled(false);
        this.buttonSaveAsDefaults.setEnabled(false);
    }

    private void saveAsDefaults() {
        if (this.themeEditor.save()) {
            SimpleTheme defaults = this.themeEditor.getTheme();
            Configuration.getInstance().setHeightMapDefaultTheme((Theme)defaults);
            this.buttonResetDefaults.setEnabled(true);
            this.buttonLoadDefaults.setEnabled(false);
            this.buttonSaveAsDefaults.setEnabled(false);
        }
    }

    private void resetDefaults() {
        if (this.currentDimension != null) {
            Theme theme = ((HeightMapTileFactory)this.currentDimension.getTileFactory()).getTheme();
            this.buttonResetDefaults.setEnabled(false);
            this.spinnerWorldMiddle.setValue(theme.getWaterHeight());
            this.updateImageLevelLabels();
            this.updatePreview(false);
            this.themeEditor.setTheme((SimpleTheme)theme);
            this.buttonLoadDefaults.setEnabled(true);
            this.buttonSaveAsDefaults.setEnabled(true);
        } else {
            Configuration.getInstance().setHeightMapDefaultTheme(null);
            this.loadDefaults();
            this.buttonSaveAsDefaults.setEnabled(false);
            MessageUtils.showInfo((Component)this, (String)"Theme reset to factory defaults.", (String)"Default Theme Reset");
        }
    }

    private void importToDimension() {
        if (this.currentDimension == null) {
            throw new IllegalStateException();
        }
        final HeightMapImporter importer = this.createImporter(true);
        if (importer == null) {
            return;
        }
        importer.setOnlyRaise(this.checkBoxOnlyRaise.isSelected());
        ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<Void>(){

            public String getName() {
                return "Importing height map";
            }

            public Void execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                importer.importToDimension(ImportHeightMapDialog.this.currentDimension, ImportHeightMapDialog.this.checkBoxCreateTiles.isSelected(), progressReceiver);
                return null;
            }
        }, (ProgressDialog.Option[])new ProgressDialog.Option[]{ProgressDialog.NOT_CANCELABLE});
        Configuration.getInstance().setHeightMapsDirectory(this.selectedFile.getParentFile());
        this.currentDimension.clearUndo();
        this.currentDimension.armSavePoint();
    }

    @Override
    protected void ok() {
        Configuration config;
        if (this.currentDimension != null) {
            this.importToDimension();
        } else if (this.checkBoxMasterDimension.isSelected() && !(config = Configuration.getInstance()).isMessageDisplayedCountAtLeast("org.pepsoft.worldpainter.ImportHeightMapDialog.masterDimension", 3)) {
            DesktopUtils.beep();
            if (JOptionPane.showConfirmDialog(this, "<html><h1>About Master Dimensions</h1><p>A master dimension will be exported at 256 times the size (by area)<br>and is meant for speeding up the creation of very large maps.</p><ul>    <li>You <b>cannot change your mind</b> later; if you do not want this to be<br>a master dimension later you will have to start over.    <li>Loading, editing and saving are quicker, but Exporting is not!<br><b>Exporting takes 256 times longer</b> than a regular dimension<br>of the same pixel size in WorldPainter.    <li>You can detail areas of the Master Dimension at 1:1 scale by<br>switching to the Surface Dimension (" + App.COMMAND_KEY_NAME + "+M or View menu)<br>and then adding tiles (" + App.COMMAND_KEY_NAME + "+T or Edit menu).</ul><p>Are you sure?</p></html>", "Create Master Dimension?", 0, 2) != 0) {
                return;
            }
            config.setMessageDisplayed("org.pepsoft.worldpainter.ImportHeightMapDialog.masterDimension");
        }
        super.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void platformChanged() {
        if (this.programmaticChange) {
            return;
        }
        this.platform = (Platform)this.comboBoxPlatform.getSelectedItem();
        this.programmaticChange = true;
        try {
            int maxHeight;
            if (this.currentDimension != null) {
                int minHeight = this.currentDimension.getMinHeight();
                maxHeight = this.currentDimension.getMaxHeight();
                this.comboBoxMinHeight.setModel(new DefaultComboBoxModel<Integer>(new Integer[]{minHeight}));
                this.comboBoxMinHeight.setSelectedItem(minHeight);
                this.comboBoxMinHeight.setEnabled(false);
                this.comboBoxMaxHeight.setModel(new DefaultComboBoxModel<Integer>(new Integer[]{maxHeight}));
                this.comboBoxMaxHeight.setSelectedItem(maxHeight);
                this.comboBoxMaxHeight.setEnabled(false);
            } else {
                ArrayList<Integer> minHeights = new ArrayList<Integer>(Ints.asList((int[])this.platform.minHeights));
                minHeights.removeIf(height -> height < -8388608);
                if (minHeights.isEmpty()) {
                    minHeights.add(-8388608);
                }
                this.comboBoxMinHeight.setModel(new DefaultComboBoxModel<Integer>(minHeights.toArray(new Integer[minHeights.size()])));
                this.comboBoxMinHeight.setSelectedItem(Math.max(this.platform.minZ, -8388608));
                this.comboBoxMinHeight.setEnabled(minHeights.size() > 1);
                maxHeight = this.platform.standardMaxHeight;
                ArrayList<Integer> maxHeights = new ArrayList<Integer>(Ints.asList((int[])this.platform.maxHeights));
                maxHeights.removeIf(height -> height > 0x800000);
                if (maxHeights.isEmpty()) {
                    maxHeights.add(0x800000);
                }
                this.comboBoxMaxHeight.setModel(new DefaultComboBoxModel<Integer>(maxHeights.toArray(new Integer[maxHeights.size()])));
                this.comboBoxMaxHeight.setSelectedItem(Math.min(this.platform.standardMaxHeight, 0x800000));
                this.comboBoxMaxHeight.setEnabled(maxHeights.size() > 1);
            }
            this.minHeightChanged();
            this.maxHeightChanged();
            this.spinnerWorldHigh.setValue((int)Math.min((long)(maxHeight - 1), (long)Math.pow(2.0, this.bitDepth) - 1L));
            this.loadDefaultTheme();
        }
        finally {
            this.programmaticChange = false;
        }
    }

    private void minHeightChanged() {
        int minHeight = (Integer)this.comboBoxMinHeight.getSelectedItem();
        this.programmaticChange = true;
        try {
            SpinnerUtils.setMinimum((JSpinner)this.spinnerWorldLow, (Comparable)Integer.valueOf(minHeight));
            SpinnerUtils.setMinimum((JSpinner)this.spinnerWorldMiddle, (Comparable)Integer.valueOf(minHeight));
            SpinnerUtils.setMinimum((JSpinner)this.spinnerWorldHigh, (Comparable)Integer.valueOf(minHeight));
            this.labelMinHeight.setText(App.INT_NUMBER_FORMAT.format(minHeight));
        }
        finally {
            this.programmaticChange = false;
        }
        this.selectDefaultVerticalScaling(true);
        this.updatePreview(false);
    }

    private void maxHeightChanged() {
        int maxHeight = (Integer)this.comboBoxMaxHeight.getSelectedItem();
        this.programmaticChange = true;
        try {
            SpinnerUtils.setMaximum((JSpinner)this.spinnerWorldLow, (Comparable)Integer.valueOf(maxHeight - 1));
            SpinnerUtils.setMaximum((JSpinner)this.spinnerWorldMiddle, (Comparable)Integer.valueOf(maxHeight - 1));
            SpinnerUtils.setMaximum((JSpinner)this.spinnerWorldHigh, (Comparable)Integer.valueOf(maxHeight - 1));
            this.labelMaxHeight.setText(App.INT_NUMBER_FORMAT.format(maxHeight - 1));
        }
        finally {
            this.programmaticChange = false;
        }
        this.selectDefaultVerticalScaling(true);
        this.updatePreview(false);
        this.labelWarning.setVisible(this.comboBoxPlatform.getSelectedItem() == DefaultPlugin.JAVA_MCREGION && maxHeight != 128);
    }

    private void updatePreview(boolean recentre) {
        AwtUtils.doLaterOnEventThread((String)UPDATE_HEIGHT_MAP_PREVIEW, (int)250, () -> {
            org.pepsoft.util.swing.TileProvider previewProvider;
            HeightMapImporter importer;
            if (this.image != null && (importer = this.createImporter(false)) != null && (previewProvider = importer.getPreviewProvider(this.checkBoxOnlyRaise.isSelected() ? this.currentDimension : null, this.colourScheme, this.contourLines, this.contourSeparation, this.lightOrigin)) != null) {
                this.tiledImageViewer2.setTileProvider(0, previewProvider);
                if (recentre) {
                    this.tiledImageViewer2.moveTo(this.image.getWidth() / 2, this.image.getHeight() / 2);
                }
            }
            if (this.currentDimension != null) {
                this.tiledImageViewer2.setTileProvider(-1, (org.pepsoft.util.swing.TileProvider)new WPTileProvider((TileProvider)this.currentDimension, this.colourScheme, this.customBiomeManager, WPTileProvider.HIDE_ALL_LAYERS, this.contourLines, this.contourSeparation, this.lightOrigin, false, WPTileProvider.Effect.FADE_TO_FIFTY_PERCENT, true, null));
            }
        });
    }

    private void applyPreset(ImportPreset preset) {
        if (preset != null) {
            this.programmaticChange = true;
            try {
                ImportPreset.Mapping mapping = preset.getMapping(this.imageMaxHeight, this.imageLowValue, this.imageHighValue, this.platform, (Integer)this.comboBoxMaxHeight.getSelectedItem());
                this.spinnerImageLow.setValue(mapping.imageLow);
                this.spinnerWorldLow.setValue(mapping.worldLow);
                this.spinnerImageHigh.setValue(mapping.imageHigh);
                this.spinnerWorldHigh.setValue(mapping.worldHigh);
            }
            finally {
                this.programmaticChange = false;
            }
        }
        this.updateImageLevelLabels();
    }

    private void resetPreset() {
        if (this.programmaticChange) {
            return;
        }
        this.programmaticChange = true;
        try {
            this.comboBoxPreset.setSelectedItem(null);
        }
        finally {
            this.programmaticChange = false;
        }
    }

    private void selectFile() {
        File file;
        File myHeightMapDir = this.heightMapDir;
        if (myHeightMapDir == null) {
            myHeightMapDir = Configuration.getInstance().getHeightMapsDirectory();
        }
        if (myHeightMapDir == null) {
            myHeightMapDir = Configuration.getInstance().getMasksDirectory();
        }
        if ((file = ImageUtils.selectImageForOpen(this, "a height map image file", myHeightMapDir)) != null) {
            this.heightMapDir = file.getParentFile();
            this.fieldFilename.setText(file.getAbsolutePath());
        }
    }

    private void initComponents() {
        this.tiledImageViewer2 = new TiledImageViewer();
        this.themeButtonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.fieldFilename = new JTextField();
        this.buttonSelectFile = new JButton();
        this.labelImageDimensions = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.checkBoxInvert = new JCheckBox();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.spinnerScale = new JSpinner();
        this.labelWorldDimensions = new JLabel();
        this.comboBoxMaxHeight = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.spinnerImageLow = new JSpinner();
        this.spinnerWorldLow = new JSpinner();
        this.jLabel8 = new JLabel();
        this.labelImageWaterLevel = new JLabel();
        this.spinnerWorldMiddle = new JSpinner();
        this.jLabel9 = new JLabel();
        this.spinnerImageHigh = new JSpinner();
        this.spinnerWorldHigh = new JSpinner();
        this.jLabel15 = new JLabel();
        this.labelImageLowestLevel = new JLabel();
        this.labelWorldLowestLevel = new JLabel();
        this.jLabel18 = new JLabel();
        this.labelImageHighestLevel = new JLabel();
        this.labelWorldHighestLevel = new JLabel();
        this.labelWarningCutOffAbove = new JLabel();
        this.labelWarningCutOffBelow = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.labelMinHeight = new JLabel();
        this.labelMaxHeight = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel10 = new JLabel();
        this.checkBoxVoid = new JCheckBox();
        this.spinnerVoidBelow = new JSpinner();
        this.labelWarning = new JLabel();
        this.jLabel11 = new JLabel();
        this.spinnerOffsetX = new JSpinner();
        this.jLabel12 = new JLabel();
        this.spinnerOffsetY = new JSpinner();
        this.jLabel14 = new JLabel();
        this.labelWalkingTime = new JLabel();
        this.radioButtonApplyTheme = new JRadioButton();
        this.radioButtonSingleTerrain = new JRadioButton();
        this.comboBoxSingleTerrain = new JComboBox();
        this.jLabel19 = new JLabel();
        this.comboBoxPreset = new JComboBox();
        this.jLabel20 = new JLabel();
        this.labelExportedSize = new JLabel();
        this.jLabel22 = new JLabel();
        this.labelExportedOffset = new JLabel();
        this.comboBoxMinHeight = new JComboBox();
        this.jLabel21 = new JLabel();
        this.jLabel23 = new JLabel();
        this.radioButtonLeaveTerrain = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.themeEditor = new SimpleThemeEditor();
        this.buttonLoadDefaults = new JButton();
        this.buttonSaveAsDefaults = new JButton();
        this.buttonResetDefaults = new JButton();
        this.checkBoxCreateTiles = new JCheckBox();
        this.labelNoUndo = new JLabel();
        this.checkBoxOnlyRaise = new JCheckBox();
        this.jLabel13 = new JLabel();
        this.comboBoxPlatform = new JComboBox();
        this.tiledImageViewerContainer1 = new TiledImageViewerContainer();
        this.checkBoxMasterDimension = new JCheckBox();
        this.buttonMasterInfo = new JButton();
        this.tiledImageViewer2.setBorder(BorderFactory.createEtchedBorder());
        this.setDefaultCloseOperation(2);
        this.setTitle("Import Height Map");
        this.jLabel1.setText("Select the image to import as a height map:");
        this.buttonSelectFile.setText("...");
        this.buttonSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.buttonSelectFileActionPerformed(evt);
            }
        });
        this.labelImageDimensions.setText("Image size: ? x ?, bit depth: ?, lowest value: ?, highest value: ?");
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOk.setText("OK");
        this.buttonOk.setEnabled(false);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.buttonOkActionPerformed(evt);
            }
        });
        this.checkBoxInvert.setText("Invert (white is low, black is high)");
        this.checkBoxInvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.checkBoxInvertActionPerformed(evt);
            }
        });
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImportHeightMapDialog.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jLabel3.setText("Scale:");
        this.spinnerScale.setModel(new SpinnerNumberModel(Float.valueOf(100.0f), Float.valueOf(0.01f), Float.valueOf(999.99f), Float.valueOf(0.1f)));
        this.spinnerScale.setEditor(new JSpinner.NumberEditor(this.spinnerScale, "0.00"));
        this.spinnerScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImportHeightMapDialog.this.spinnerScaleStateChanged(evt);
            }
        });
        this.labelWorldDimensions.setText("Scaled size: ? x ? blocks");
        this.comboBoxMaxHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.comboBoxMaxHeightActionPerformed(evt);
            }
        });
        this.jLabel4.setText("%");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel5.setText("From image:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText("To Minecraft:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText("Low mapping:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel7, gridBagConstraints);
        this.spinnerImageLow.setModel(new SpinnerNumberModel(0.0, 0.0, 4.294967295E9, 1.0));
        this.spinnerImageLow.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImportHeightMapDialog.this.spinnerImageLowStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.spinnerImageLow, gridBagConstraints);
        this.spinnerWorldLow.setModel(new SpinnerNumberModel(0, 0, 65535, 1));
        this.spinnerWorldLow.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImportHeightMapDialog.this.spinnerWorldLowStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.spinnerWorldLow, gridBagConstraints);
        this.jLabel8.setText("Water level:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel8, gridBagConstraints);
        this.labelImageWaterLevel.setText("62");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(2, 2, 2, 19);
        this.jPanel1.add((Component)this.labelImageWaterLevel, gridBagConstraints);
        this.spinnerWorldMiddle.setModel(new SpinnerNumberModel(62, 0, 65535, 1));
        this.spinnerWorldMiddle.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImportHeightMapDialog.this.spinnerWorldMiddleStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.spinnerWorldMiddle, gridBagConstraints);
        this.jLabel9.setText("High mapping:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel9, gridBagConstraints);
        this.spinnerImageHigh.setModel(new SpinnerNumberModel(255.0, 0.0, 4.294967295E9, 1.0));
        this.spinnerImageHigh.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImportHeightMapDialog.this.spinnerImageHighStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.spinnerImageHigh, gridBagConstraints);
        this.spinnerWorldHigh.setModel(new SpinnerNumberModel(255, 0, 65535, 1));
        this.spinnerWorldHigh.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImportHeightMapDialog.this.spinnerWorldHighStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.spinnerWorldHigh, gridBagConstraints);
        this.jLabel15.setText("Lowest value:");
        this.jLabel15.setToolTipText("The lowest value that actually occurs on the height map.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel15, gridBagConstraints);
        this.labelImageLowestLevel.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(2, 2, 2, 19);
        this.jPanel1.add((Component)this.labelImageLowestLevel, gridBagConstraints);
        this.labelWorldLowestLevel.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(2, 2, 2, 19);
        this.jPanel1.add((Component)this.labelWorldLowestLevel, gridBagConstraints);
        this.jLabel18.setText("Highest value:");
        this.jLabel18.setToolTipText("The highest value that actually occurs on the height map.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel18, gridBagConstraints);
        this.labelImageHighestLevel.setText("255");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(2, 2, 2, 19);
        this.jPanel1.add((Component)this.labelImageHighestLevel, gridBagConstraints);
        this.labelWorldHighestLevel.setText("255");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(2, 2, 2, 19);
        this.jPanel1.add((Component)this.labelWorldHighestLevel, gridBagConstraints);
        this.labelWarningCutOffAbove.setFont(this.labelWarningCutOffAbove.getFont().deriveFont(this.labelWarningCutOffAbove.getFont().getStyle() | 1));
        this.labelWarningCutOffAbove.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/error.png")));
        this.labelWarningCutOffAbove.setText("Cut off above!");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.labelWarningCutOffAbove, gridBagConstraints);
        this.labelWarningCutOffBelow.setFont(this.labelWarningCutOffBelow.getFont().deriveFont(this.labelWarningCutOffBelow.getFont().getStyle() | 1));
        this.labelWarningCutOffBelow.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/error.png")));
        this.labelWarningCutOffBelow.setText("Cut off below!");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.labelWarningCutOffBelow, gridBagConstraints);
        this.jLabel16.setText("Build limit:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel16, gridBagConstraints);
        this.jLabel17.setText("Build limit:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel17, gridBagConstraints);
        this.labelMinHeight.setText("-64");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(2, 2, 2, 19);
        this.jPanel1.add((Component)this.labelMinHeight, gridBagConstraints);
        this.labelMaxHeight.setText("319");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(2, 2, 2, 19);
        this.jPanel1.add((Component)this.labelMaxHeight, gridBagConstraints);
        this.jLabel2.setText("Build limits: lower:");
        this.jLabel10.setText("blocks");
        this.checkBoxVoid.setText("create Void below image value:");
        this.checkBoxVoid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.checkBoxVoidActionPerformed(evt);
            }
        });
        this.spinnerVoidBelow.setModel(new SpinnerNumberModel(1.0, 1.0, 4.294967295E9, 1.0));
        this.spinnerVoidBelow.setEnabled(false);
        this.spinnerVoidBelow.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImportHeightMapDialog.this.spinnerVoidBelowStateChanged(evt);
            }
        });
        this.labelWarning.setFont(this.labelWarning.getFont().deriveFont(this.labelWarning.getFont().getStyle() | 1));
        this.labelWarning.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/error.png")));
        this.labelWarning.setText("Only with mods!");
        this.jLabel11.setText("Offset:");
        this.jLabel11.setToolTipText("The origin of the height map will be at these coordinates in the map");
        this.spinnerOffsetX.setModel(new SpinnerNumberModel(0, -999999, 999999, 1));
        this.spinnerOffsetX.setToolTipText("The origin of the height map will be at these coordinates in the map");
        this.spinnerOffsetX.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImportHeightMapDialog.this.spinnerOffsetXStateChanged(evt);
            }
        });
        this.jLabel12.setText(",");
        this.jLabel12.setToolTipText("The origin of the height map will be at these coordinates in the map");
        this.spinnerOffsetY.setModel(new SpinnerNumberModel(0, -999999, 999999, 1));
        this.spinnerOffsetY.setToolTipText("The origin of the height map will be at these coordinates in the map");
        this.spinnerOffsetY.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImportHeightMapDialog.this.spinnerOffsetYStateChanged(evt);
            }
        });
        this.jLabel14.setText("Edge to edge walking time:");
        this.labelWalkingTime.setText("...");
        this.themeButtonGroup.add(this.radioButtonApplyTheme);
        this.radioButtonApplyTheme.setSelected(true);
        this.radioButtonApplyTheme.setText("apply theme");
        this.radioButtonApplyTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.radioButtonApplyThemeActionPerformed(evt);
            }
        });
        this.themeButtonGroup.add(this.radioButtonSingleTerrain);
        this.radioButtonSingleTerrain.setText("single:");
        this.radioButtonSingleTerrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.radioButtonSingleTerrainActionPerformed(evt);
            }
        });
        this.comboBoxSingleTerrain.setEnabled(false);
        this.comboBoxSingleTerrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.comboBoxSingleTerrainActionPerformed(evt);
            }
        });
        this.jLabel19.setText("Preset:");
        this.comboBoxPreset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.comboBoxPresetActionPerformed(evt);
            }
        });
        this.jLabel20.setText("Exported size:");
        this.labelExportedSize.setText("? x ? blocks");
        this.jLabel22.setText("Exported offset:");
        this.labelExportedOffset.setText("0, 0");
        this.comboBoxMinHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.comboBoxMinHeightActionPerformed(evt);
            }
        });
        this.jLabel21.setText(", upper:");
        this.jLabel23.setText("Terrain:");
        this.themeButtonGroup.add(this.radioButtonLeaveTerrain);
        this.radioButtonLeaveTerrain.setText("leave");
        this.radioButtonLeaveTerrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.radioButtonLeaveTerrainActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel23).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonApplyTheme).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonSingleTerrain).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxSingleTerrain, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonLeaveTerrain)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerScale, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerOffsetX, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerOffsetY, -2, -1, -2)).addComponent(this.labelWorldDimensions).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxMinHeight, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel21).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxMaxHeight, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel10).addGap(18, 18, 18).addComponent(this.labelWarning)).addComponent(this.jPanel1, -2, -1, -2).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.checkBoxVoid).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerVoidBelow, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelWalkingTime)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxPreset, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelExportedSize).addGap(18, 18, 18).addComponent(this.jLabel22).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelExportedOffset))).addContainerGap(71, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.spinnerScale, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jLabel11).addComponent(this.spinnerOffsetX, -2, -1, -2).addComponent(this.jLabel12).addComponent(this.spinnerOffsetY, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelWorldDimensions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel20).addComponent(this.labelExportedSize).addComponent(this.jLabel22).addComponent(this.labelExportedOffset)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.labelWalkingTime)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboBoxMaxHeight, -2, -1, -2).addComponent(this.jLabel10).addComponent(this.labelWarning).addComponent(this.comboBoxMinHeight, -2, -1, -2).addComponent(this.jLabel21)).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel19).addComponent(this.comboBoxPreset, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxVoid).addComponent(this.spinnerVoidBelow, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonApplyTheme).addComponent(this.radioButtonSingleTerrain).addComponent(this.comboBoxSingleTerrain, -2, -1, -2).addComponent(this.jLabel23).addComponent(this.radioButtonLeaveTerrain)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Scaling", this.jPanel2);
        this.buttonLoadDefaults.setText("Load Defaults");
        this.buttonLoadDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.buttonLoadDefaultsActionPerformed(evt);
            }
        });
        this.buttonSaveAsDefaults.setText("Save As Defaults");
        this.buttonSaveAsDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.buttonSaveAsDefaultsActionPerformed(evt);
            }
        });
        this.buttonResetDefaults.setText("Reset");
        this.buttonResetDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.buttonResetDefaultsActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.themeEditor, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonResetDefaults).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSaveAsDefaults).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonLoadDefaults))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.themeEditor, -1, 413, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonLoadDefaults).addComponent(this.buttonSaveAsDefaults).addComponent(this.buttonResetDefaults)).addContainerGap()));
        this.jTabbedPane1.addTab("Theme", this.jPanel3);
        this.checkBoxCreateTiles.setText("Create new tiles");
        this.labelNoUndo.setText("<html><b>Note:</b> this cannot be undone!</html>");
        this.checkBoxOnlyRaise.setText("Only where higher");
        this.checkBoxOnlyRaise.setToolTipText("When selected, the height map will only be applied where it is higher than the existing terrain");
        this.checkBoxOnlyRaise.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.checkBoxOnlyRaiseActionPerformed(evt);
            }
        });
        this.jLabel13.setText("Map format:");
        this.comboBoxPlatform.setRenderer(new PlatformListCellRenderer());
        this.comboBoxPlatform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.comboBoxPlatformActionPerformed(evt);
            }
        });
        this.tiledImageViewerContainer1.setMinimumSize(new java.awt.Dimension(384, 22));
        this.checkBoxMasterDimension.setText("create as master dimension (1:16 scale)");
        this.checkBoxMasterDimension.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.checkBoxMasterDimensionActionPerformed(evt);
            }
        });
        this.buttonMasterInfo.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/information.png")));
        this.buttonMasterInfo.setMargin(new Insets(0, 0, 0, 0));
        this.buttonMasterInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportHeightMapDialog.this.buttonMasterInfoActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.fieldFilename).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelectFile)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxPlatform, -2, -1, -2)).addComponent(this.jLabel1).addComponent(this.labelImageDimensions).addComponent(this.checkBoxInvert).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxCreateTiles).addGap(18, 18, 18).addComponent(this.checkBoxOnlyRaise).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.labelNoUndo, -2, -1, -2)).addComponent(this.jTabbedPane1, -2, -1, -2)).addGap(18, 18, 18).addComponent((Component)this.tiledImageViewerContainer1, -1, 397, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxMasterDimension).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMasterInfo).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fieldFilename, -2, -1, -2).addComponent(this.buttonSelectFile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelImageDimensions).addGap(4, 4, 4).addComponent(this.checkBoxInvert).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.comboBoxPlatform, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxMasterDimension).addComponent(this.buttonMasterInfo)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxCreateTiles).addComponent(this.labelNoUndo, -2, -1, -2).addComponent(this.checkBoxOnlyRaise)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1)).addComponent((Component)this.tiledImageViewerContainer1, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOk)).addContainerGap()));
        this.pack();
    }

    private void spinnerImageLowStateChanged(ChangeEvent evt) {
        double highLevel;
        double lowLevel = (Double)this.spinnerImageLow.getValue();
        if (lowLevel > (highLevel = ((Double)this.spinnerImageHigh.getValue()).doubleValue())) {
            this.spinnerImageHigh.setValue(lowLevel);
        }
        this.resetPreset();
        this.updateImageLevelLabels();
        this.updatePreview(false);
        this.setControlStates();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void spinnerImageHighStateChanged(ChangeEvent evt) {
        double lowLevel = (Double)this.spinnerImageLow.getValue();
        double highLevel = (Double)this.spinnerImageHigh.getValue();
        if (highLevel < lowLevel) {
            this.spinnerImageLow.setValue(highLevel);
        }
        this.resetPreset();
        this.updateImageLevelLabels();
        this.updatePreview(false);
        this.setControlStates();
    }

    private void spinnerWorldLowStateChanged(ChangeEvent evt) {
        int highLevel;
        int lowLevel = (Integer)this.spinnerWorldLow.getValue();
        if (lowLevel > (highLevel = ((Integer)this.spinnerWorldHigh.getValue()).intValue())) {
            this.spinnerWorldHigh.setValue(lowLevel);
        }
        this.resetPreset();
        this.updateImageLevelLabels();
        this.updatePreview(false);
        this.setControlStates();
    }

    private void spinnerWorldMiddleStateChanged(ChangeEvent evt) {
        this.updateImageLevelLabels();
        this.updatePreview(false);
    }

    private void spinnerWorldHighStateChanged(ChangeEvent evt) {
        int lowLevel = (Integer)this.spinnerWorldLow.getValue();
        int highLevel = (Integer)this.spinnerWorldHigh.getValue();
        if (highLevel < lowLevel) {
            this.spinnerWorldLow.setValue(highLevel);
        }
        this.resetPreset();
        this.updateImageLevelLabels();
        this.updatePreview(false);
        this.setControlStates();
    }

    private void buttonSelectFileActionPerformed(ActionEvent evt) {
        this.selectFile();
    }

    private void spinnerScaleStateChanged(ChangeEvent evt) {
        if (this.image != null) {
            this.updateWorldDimensions();
            this.updatePreview(false);
        }
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.themeEditor.setWaterHeight((Integer)this.spinnerWorldMiddle.getValue());
            if (this.themeEditor.save()) {
                this.ok();
            } else {
                this.jTabbedPane1.setSelectedIndex(1);
            }
        } else if (this.themeEditor.save()) {
            this.spinnerWorldMiddle.setValue(this.themeEditor.getTheme().getWaterHeight());
            this.ok();
        }
    }

    private void comboBoxMaxHeightActionPerformed(ActionEvent evt) {
        this.maxHeightChanged();
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            switch (this.jTabbedPane1.getSelectedIndex()) {
                case 0: {
                    this.themeEditor.save();
                    this.spinnerWorldMiddle.setValue(this.themeEditor.getTheme().getWaterHeight());
                    break;
                }
                case 1: {
                    this.themeEditor.setWaterHeight((Integer)this.spinnerWorldMiddle.getValue());
                }
            }
        }
    }

    private void checkBoxVoidActionPerformed(ActionEvent evt) {
        this.spinnerVoidBelow.setEnabled(this.checkBoxVoid.isSelected());
        this.updatePreview(false);
    }

    private void spinnerOffsetXStateChanged(ChangeEvent evt) {
        this.updateWorldDimensions();
        if (this.image != null) {
            this.updatePreview(false);
        }
    }

    private void spinnerOffsetYStateChanged(ChangeEvent evt) {
        this.updateWorldDimensions();
        if (this.image != null) {
            this.updatePreview(false);
        }
    }

    private void buttonLoadDefaultsActionPerformed(ActionEvent evt) {
        this.loadDefaults();
    }

    private void buttonSaveAsDefaultsActionPerformed(ActionEvent evt) {
        this.saveAsDefaults();
    }

    private void buttonResetDefaultsActionPerformed(ActionEvent evt) {
        this.resetDefaults();
    }

    private void comboBoxPlatformActionPerformed(ActionEvent evt) {
        this.platformChanged();
    }

    private void checkBoxInvertActionPerformed(ActionEvent evt) {
        if (this.selectedFile != null) {
            this.loadImage();
        }
    }

    private void radioButtonApplyThemeActionPerformed(ActionEvent evt) {
        this.comboBoxSingleTerrain.setEnabled(false);
        this.jTabbedPane1.setEnabledAt(1, this.currentDimension == null);
        this.updatePreview(false);
    }

    private void radioButtonSingleTerrainActionPerformed(ActionEvent evt) {
        this.comboBoxSingleTerrain.setEnabled(true);
        this.jTabbedPane1.setEnabledAt(1, false);
        this.updatePreview(false);
    }

    private void comboBoxSingleTerrainActionPerformed(ActionEvent evt) {
        this.updatePreview(false);
    }

    private void comboBoxPresetActionPerformed(ActionEvent evt) {
        this.applyPreset((ImportPreset)this.comboBoxPreset.getSelectedItem());
    }

    private void spinnerVoidBelowStateChanged(ChangeEvent evt) {
        this.updatePreview(false);
    }

    private void checkBoxOnlyRaiseActionPerformed(ActionEvent evt) {
        this.updatePreview(false);
    }

    private void checkBoxMasterDimensionActionPerformed(ActionEvent evt) {
        boolean masterDimensionSelected = this.checkBoxMasterDimension.isSelected();
        this.jLabel20.setVisible(masterDimensionSelected);
        this.labelExportedSize.setVisible(masterDimensionSelected);
        this.jLabel22.setVisible(masterDimensionSelected);
        this.labelExportedOffset.setVisible(masterDimensionSelected);
        this.updateWorldDimensions();
    }

    private void buttonMasterInfoActionPerformed(ActionEvent evt) {
        NewWorldDialog.showMasterDimensionInfo(this);
    }

    private void comboBoxMinHeightActionPerformed(ActionEvent evt) {
        this.minHeightChanged();
    }

    private void radioButtonLeaveTerrainActionPerformed(ActionEvent evt) {
        this.comboBoxSingleTerrain.setEnabled(false);
        this.jTabbedPane1.setEnabledAt(1, false);
        this.updatePreview(false);
    }
}

