/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.Layer;

public class GlassPane
extends JPanel {
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private WorldPainter view;
    private final Map<Layer, JLabel> hiddenLayers = new HashMap<Layer, JLabel>();
    private JLabel soloLayerLabel;
    private List<Component> panelComponentStack = new ArrayList<Component>();
    private static final NumberFormat SCALE_FORMAT = new DecimalFormat("#,##0.# blocks");
    private static final BufferedImage PROHIBITED_SIGN_BACKGROUND = IconUtils.loadScaledImage((String)"org/pepsoft/worldpainter/icons/prohibited_sign_background.png");
    private static final BufferedImage PROHIBITED_SIGN_FOREGROUND = IconUtils.loadScaledImage((String)"org/pepsoft/worldpainter/icons/prohibited_sign_foreground.png");
    private static final long serialVersionUID = 1L;

    public GlassPane() {
        this.initComponents();
        if (GUIUtils.getUIScale() != 1.0f) {
            this.jLabel1.setIcon(IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/scale_bar.png"));
            this.jLabel2.setIcon(IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/north_arrow_up.png"));
        }
    }

    public void setScale(float scale) {
        int scaleBarSize = (int)(100.0f / scale * GUIUtils.getUIScale());
        this.jLabel1.setText(SCALE_FORMAT.format(scaleBarSize));
        this.repaint();
    }

    public void setHiddenLayers(Set<Layer> hiddenLayers) {
        hiddenLayers.stream().filter(layer -> !layer.equals((Object)Biome.INSTANCE) && layer.getIcon() != null && !this.hiddenLayers.containsKey(layer)).forEach(layer -> {
            JLabel label = this.createLabel((Layer)layer);
            this.hiddenLayers.put((Layer)layer, label);
        });
        this.hiddenLayers.entrySet().removeIf(entry -> !hiddenLayers.contains(entry.getKey()));
        this.updateIcons();
    }

    public void setSoloLayer(Layer soloLayer) {
        this.soloLayerLabel = soloLayer != null && soloLayer.getIcon() != null ? this.createSoloLabel(soloLayer) : null;
        this.updateIcons();
    }

    public void pushPanelComponent(Component component) {
        this.panelComponentStack.add(component);
        this.jPanel2.removeAll();
        this.jPanel2.add(component, "Center");
        this.jPanel2.revalidate();
    }

    public Component popPanelComponent() {
        if (this.panelComponentStack.isEmpty()) {
            return null;
        }
        this.jPanel2.removeAll();
        Component component = this.panelComponentStack.remove(this.panelComponentStack.size() - 1);
        if (!this.panelComponentStack.isEmpty()) {
            this.jPanel2.add(this.panelComponentStack.get(this.panelComponentStack.size() - 1), "Center");
        }
        this.jPanel2.revalidate();
        return component;
    }

    public void removePanelComponents() {
        this.panelComponentStack.clear();
        this.jPanel2.removeAll();
        this.jPanel2.revalidate();
    }

    private void updateIcons() {
        this.jPanel1.removeAll();
        if (this.soloLayerLabel != null) {
            this.jPanel1.add(this.soloLayerLabel);
        } else {
            this.hiddenLayers.values().forEach(this.jPanel1::add);
        }
        this.jPanel1.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JLabel createLabel(Layer layer) {
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(Math.round(20.0f * GUIUtils.getUIScale()), Math.round(20.0f * GUIUtils.getUIScale()), 3);
        Graphics2D g2 = image.createGraphics();
        try {
            g2.drawImage((Image)PROHIBITED_SIGN_BACKGROUND, 0, 0, null);
            g2.drawImage((Image)layer.getIcon(), Math.round(2.0f * GUIUtils.getUIScale()), Math.round(2.0f * GUIUtils.getUIScale()), null);
            g2.drawImage((Image)PROHIBITED_SIGN_FOREGROUND, 0, 0, null);
        }
        finally {
            g2.dispose();
        }
        JLabel label = new JLabel(new ImageIcon(image));
        label.setBorder(new EmptyBorder(1, 1, 1, 1));
        label.setToolTipText(layer.getName() + " layer hidden");
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JLabel createSoloLabel(Layer layer) {
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(Math.round(20.0f * GUIUtils.getUIScale()), Math.round(20.0f * GUIUtils.getUIScale()), 3);
        Graphics2D g2 = image.createGraphics();
        try {
            g2.drawImage((Image)layer.getIcon(), Math.round(2.0f * GUIUtils.getUIScale()), Math.round(2.0f * GUIUtils.getUIScale()), null);
        }
        finally {
            g2.dispose();
        }
        JLabel label = new JLabel(new ImageIcon(image));
        label.setBorder(new EmptyBorder(1, 1, 1, 1));
        label.setToolTipText("Showing only " + layer.getName() + " layer");
        return label;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.setOpaque(false);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/scale_bar.png")));
        this.jLabel1.setText("100 blocks");
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/north_arrow_up.png")));
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        this.jPanel2.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.jPanel2, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(20, 20, 20)));
    }
}

