/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pepsoft.minecraft.datapack.DataPack;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.DimensionPropertiesEditor;
import org.pepsoft.worldpainter.ExceptionHandler;
import org.pepsoft.worldpainter.ExportProgressDialog;
import org.pepsoft.worldpainter.GameType;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.TestExportDialog;
import org.pepsoft.worldpainter.TileRenderer;
import org.pepsoft.worldpainter.WPDialogWithPaintSelection;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.exporting.WorldExportSettings;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.Populate;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.util.BackupUtils;
import org.pepsoft.worldpainter.util.EnumListCellRenderer;
import org.pepsoft.worldpainter.util.FileFilter;
import org.pepsoft.worldpainter.util.FileUtils;
import org.pepsoft.worldpainter.util.MaterialUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportWorldDialog
extends WPDialogWithPaintSelection {
    private JButton buttonAddDataPack;
    private JButton buttonCancel;
    private JButton buttonExport;
    private ButtonGroup buttonGroup2;
    private JButton buttonRemoveDataPack;
    private JButton buttonSelectDirectory;
    private JButton buttonTestExport;
    private JCheckBox checkBoxAllowCheats;
    private JCheckBox checkBoxGoodies;
    private JCheckBox checkBoxMapFeatures;
    private JComboBox comboBoxDifficulty;
    private JComboBox<GameType> comboBoxGameType;
    private JTextField fieldDirectory;
    private JTextField fieldName;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel79;
    private JLabel jLabel8;
    private JLabel jLabel80;
    private JLabel jLabel81;
    private JLabel jLabel85;
    private JLabel jLabel86;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTabbedPane jTabbedPane1;
    private JLabel labelPlatform;
    private JLabel labelPlatformWarning;
    private JList<File> listDataPacks;
    private JPanel panelMinecraftWorldBorder;
    private JSpinner spinnerMcBorderCentreX;
    private JSpinner spinnerMcBorderCentreY;
    private JSpinner spinnerMcBorderSize;
    private final World2 world;
    private final ColourScheme colourScheme;
    private final Set<Layer> hiddenLayers;
    private final boolean contourLines;
    private final int contourSeparation;
    private final TileRenderer.LightOrigin lightOrigin;
    private final CustomBiomeManager customBiomeManager;
    private final WorldPainter view;
    private final Map<Dimension.Anchor, DimensionPropertiesEditor> dimensionPropertiesEditors = new HashMap<Dimension.Anchor, DimensionPropertiesEditor>();
    private final List<Platform> supportedPlatforms = new ArrayList<Platform>();
    private final DefaultListModel<File> dataPacksListModel = new DefaultListModel();
    private boolean disableDisabledLayersWarning;
    private static String previouslyAcknowledgedWarnings;
    private static Reference<World2> warningsForWorld;
    private static final Logger logger;
    private static final long serialVersionUID = 1L;

    public ExportWorldDialog(Window parent, World2 world, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, Set<Layer> hiddenLayers, boolean contourLines, int contourSeparation, TileRenderer.LightOrigin lightOrigin, WorldPainter view) {
        super(parent);
        this.world = world;
        Dimension dim0 = world.getDimension(Dimension.Anchor.NORMAL_DETAIL);
        this.colourScheme = colourScheme;
        this.hiddenLayers = hiddenLayers;
        this.contourLines = contourLines;
        this.contourSeparation = contourSeparation;
        this.lightOrigin = lightOrigin;
        this.customBiomeManager = customBiomeManager;
        this.view = view;
        this.initComponents();
        Configuration config = Configuration.getInstance();
        if (config.isEasyMode()) {
            this.checkBoxMapFeatures.setVisible(false);
            this.jLabel1.setVisible(false);
            this.labelPlatform.setVisible(false);
        }
        this.supportedPlatforms.addAll(PlatformManager.getInstance().getAllPlatforms());
        Platform platform = world.getPlatform();
        if (this.supportedPlatforms.contains(platform)) {
            this.labelPlatformWarning.setVisible(false);
            if (config.getExportDirectory(platform) != null) {
                this.fieldDirectory.setText(config.getExportDirectory(platform).getAbsolutePath());
            } else {
                File exportDir = PlatformManager.getInstance().getDefaultExportDir(platform);
                if (exportDir != null) {
                    this.fieldDirectory.setText(exportDir.getAbsolutePath());
                } else {
                    this.fieldDirectory.setText(DesktopUtils.getDocumentsFolder().getAbsolutePath());
                }
            }
        } else {
            this.fieldDirectory.setText(null);
        }
        this.fieldName.setText(world.getName());
        this.createDimensionPropertiesEditors();
        this.checkBoxGoodies.setSelected(world.isCreateGoodiesChest());
        this.labelPlatform.setText("<html><u>" + platform.displayName + "</u></html>");
        this.labelPlatform.setToolTipText("Click to change the map format");
        this.comboBoxGameType.setModel(new DefaultComboBoxModel<GameType>(platform.supportedGameTypes.toArray(new GameType[platform.supportedGameTypes.size()])));
        this.comboBoxGameType.setSelectedItem(world.getGameType());
        this.comboBoxGameType.setEnabled(this.comboBoxGameType.getItemCount() > 1);
        this.comboBoxGameType.setRenderer(new EnumListCellRenderer());
        this.checkBoxAllowCheats.setSelected(world.isAllowCheats());
        if (world.getDataPacks() != null) {
            for (File dataPackFile : world.getDataPacks()) {
                this.dataPacksListModel.addElement(dataPackFile);
            }
        }
        this.listDataPacks.setModel(this.dataPacksListModel);
        this.listDataPacks.setEnabled(platform.capabilities.contains(Platform.Capability.DATA_PACKS));
        this.checkBoxMapFeatures.setSelected(world.isMapFeatures());
        this.comboBoxDifficulty.setSelectedIndex(world.getDifficulty());
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExportWorldDialog.this.setControlStates();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExportWorldDialog.this.setControlStates();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExportWorldDialog.this.setControlStates();
            }
        };
        this.fieldDirectory.getDocument().addDocumentListener(documentListener);
        this.fieldName.getDocument().addDocumentListener(documentListener);
        World2.BorderSettings borderSettings = world.getBorderSettings();
        this.spinnerMcBorderCentreX.setValue(borderSettings.getCentreX());
        this.spinnerMcBorderCentreY.setValue(borderSettings.getCentreY());
        this.spinnerMcBorderSize.setValue(borderSettings.getSize());
        this.disableDisabledLayersWarning = true;
        block1: for (Dimension dim : world.getDimensions()) {
            for (CustomLayer customLayer : dim.getCustomLayers()) {
                if (customLayer.isExport()) continue;
                this.disableDisabledLayersWarning = false;
                break block1;
            }
        }
        this.rootPane.setDefaultButton(this.buttonExport);
        this.setControlStates();
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void createDimensionPropertiesEditors() {
        SortedMap dimensions = this.world.getDimensions().stream().collect(Collectors.toMap(Dimension::getAnchor, Function.identity(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, TreeMap::new));
        for (Dimension dimension : dimensions.values()) {
            DimensionPropertiesEditor editor = new DimensionPropertiesEditor();
            editor.init(this.colourScheme, this.customBiomeManager, dimension, DimensionPropertiesEditor.Mode.EXPORT);
            this.jTabbedPane1.addTab(dimension.getName(), editor);
            this.dimensionPropertiesEditors.put(dimension.getAnchor(), editor);
        }
    }

    private boolean checkCompatibility(Platform platform) {
        Map nameOnlyMaterials;
        if (!platform.capabilities.contains(Platform.Capability.NAME_BASED) && !(nameOnlyMaterials = MaterialUtils.gatherBlocksWithoutIds((World2)this.world, (Platform)platform)).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("<p>The world cannot be exported in format ").append(platform.displayName).append(" because it contains the following incompatible block types:");
            sb.append("<table><tr><th align='left'>Block Type</th><th align='left'>Source</th></tr>");
            nameOnlyMaterials.forEach((name, sources) -> sb.append("<tr><td>").append((String)name).append("</td><td>").append(String.join((CharSequence)", ", sources)).append("</td></tr>"));
            sb.append("</table>");
            MessageUtils.beepAndShowError((Component)this, (String)sb.toString(), (String)"Map Format Not Compatible");
            return false;
        }
        String incompatibilityReason = PlatformManager.getInstance().getPlatformProvider(platform).isCompatible(platform, this.world);
        if (incompatibilityReason != null) {
            MessageUtils.beepAndShowError((Component)this, (String)String.format("<html><p>The world cannot be exported in format %s because it is not compatible:</p><p>%s</p></html>", platform.displayName, incompatibilityReason), (String)"Map Format Not Compatible");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void export(WorldExportSettings exportSettings) {
        int selectedDimension;
        exportSettings = exportSettings != null ? exportSettings : (this.world.getExportSettings() != null ? this.world.getExportSettings() : WorldExportSettings.EXPORT_EVERYTHING);
        boolean exportAllDimensions = exportSettings.getDimensionsToExport() == null;
        boolean inhibitWarnings = exportSettings != WorldExportSettings.EXPORT_EVERYTHING;
        Set selectedTiles = exportAllDimensions ? null : exportSettings.getTilesToExport();
        int n = selectedDimension = exportAllDimensions ? 0 : (Integer)exportSettings.getDimensionsToExport().iterator().next();
        if (!new File(this.fieldDirectory.getText().trim()).isDirectory()) {
            this.fieldDirectory.requestFocusInWindow();
            MessageUtils.beepAndShowError((Component)this, (String)"The selected output directory does not exist or is not a directory.", (String)"Error");
            return;
        }
        if (this.fieldName.getText().trim().isEmpty()) {
            this.fieldName.requestFocusInWindow();
            MessageUtils.beepAndShowError((Component)this, (String)"You have not specified a name for the map.", (String)"Error");
            return;
        }
        Platform platform = this.world.getPlatform();
        StringBuilder sb = new StringBuilder("<ul>");
        boolean showWarning = false;
        for (DimensionPropertiesEditor editor : this.dimensionPropertiesEditors.values()) {
            Generator generatorType = editor.getSelectedGeneratorType();
            Dimension dimension = editor.getDimension();
            if ((editor.isPopulateSelected() || dimension.getAllLayers(true).contains(Populate.INSTANCE)) && !platform.capabilities.contains(Platform.Capability.POPULATE)) {
                sb.append("<li>Population not supported for<br>map format " + platform.displayName + "; it will not have an effect");
                showWarning = true;
            } else if ((exportAllDimensions || selectedDimension == dimension.getAnchor().dim) && generatorType == Generator.FLAT && (editor.isPopulateSelected() || dimension.getAllLayers(true).contains(Populate.INSTANCE))) {
                sb.append("<li>The Superflat world type is selected and Populate is in use.<br>Minecraft will <em>not</em> populate generated chunks for Superflat maps.");
                showWarning = true;
            }
            if (generatorType == null || platform.supportedGenerators.contains(generatorType)) continue;
            sb.append("<li>Map format " + platform.displayName + " does not support world type " + generatorType.getDisplayName() + ".<br>The world type will be reset to " + ((Generator)platform.supportedGenerators.get(0)).getDisplayName() + ".");
            editor.setSelectedGeneratorType((Generator)platform.supportedGenerators.get(0));
            showWarning = true;
        }
        if (selectedTiles != null && selectedDimension == 0) {
            boolean spawnInSelection = false;
            Point spawnPoint = this.world.getSpawnPoint();
            for (Object tile : selectedTiles) {
                if (spawnPoint.x < ((Point)tile).x << 7 || spawnPoint.x >= ((Point)tile).x + 1 << 7 || spawnPoint.y < ((Point)tile).y << 7 || spawnPoint.y >= ((Point)tile).y + 1 << 7) continue;
                spawnInSelection = true;
                break;
            }
            if (!spawnInSelection) {
                sb.append("<li>The spawn point is not inside the selected area.<br>It will temporarily be moved to the middle of the selected area.");
                showWarning = true;
            }
        }
        int disabledLayerCount = 0;
        for (Dimension dimension : this.world.getDimensions()) {
            for (Object customLayer : dimension.getCustomLayers()) {
                if (customLayer.getExporterType() == null || customLayer.isExport()) continue;
                ++disabledLayerCount;
            }
        }
        if (disabledLayerCount > 0) {
            if (disabledLayerCount == 1) {
                sb.append("<li>There are disabled custom layers!<br>One layer is not going to be exported.");
            } else {
                sb.append("<li>There are disabled custom layers!<br>" + disabledLayerCount + " layers are not going to be exported.");
            }
            showWarning = showWarning || !this.disableDisabledLayersWarning;
        }
        for (int i = 0; i < this.dataPacksListModel.size(); ++i) {
            File dataPackFile = this.dataPacksListModel.getElementAt(i);
            if (!dataPackFile.exists()) {
                sb.append("<li>Data pack file " + dataPackFile.getName() + " cannot be found.<br>It will not be installed.");
                showWarning = true;
                continue;
            }
            if (!dataPackFile.isFile()) {
                sb.append("<li>Data pack file " + dataPackFile.getName() + " is not a regular file.<br>It will not be installed.");
                showWarning = true;
                continue;
            }
            if (dataPackFile.canRead()) continue;
            sb.append("<li>Data pack file " + dataPackFile.getName() + " is not accessible.<br>It will not be installed.");
            showWarning = true;
        }
        sb.append("</ul>");
        if (showWarning) {
            String warnings = sb.toString();
            if (inhibitWarnings && warningsForWorld != null && warningsForWorld.get() == this.world && warnings.equals(previouslyAcknowledgedWarnings)) {
                logger.warn("Skipping previously acknowledged warnings for this world: {}", (Object)previouslyAcknowledgedWarnings);
            } else {
                DesktopUtils.beep();
                String text = "<html>Please confirm that you want to export the world<br>notwithstanding the following warnings:<br>" + warnings + "Do you want to continue with the export?";
                if (inhibitWarnings) {
                    text = text + "<br><br><strong>Note:</strong> on the next Test Export this screen will be skipped<br>if the warnings are identical.</html>";
                }
                if (JOptionPane.showConfirmDialog(this, text, "Review Warnings", 0, 2) != 0) {
                    previouslyAcknowledgedWarnings = null;
                    warningsForWorld = null;
                    return;
                }
                previouslyAcknowledgedWarnings = warnings;
                warningsForWorld = new WeakReference<World2>(this.world);
            }
        } else {
            previouslyAcknowledgedWarnings = null;
            warningsForWorld = null;
        }
        File baseDir = new File(this.fieldDirectory.getText().trim());
        String name = this.fieldName.getText().trim();
        try {
            if (!BackupUtils.cleanUpBackups((File)baseDir, null)) {
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while cleaning backups", e);
        }
        if (!this.saveDimensionSettings()) {
            return;
        }
        if (!this.checkCompatibility(this.world.getPlatform())) {
            return;
        }
        this.world.setCreateGoodiesChest(this.checkBoxGoodies.isSelected());
        this.world.setGameType((GameType)this.comboBoxGameType.getSelectedItem());
        this.world.setAllowCheats(this.checkBoxAllowCheats.isSelected());
        this.world.setMapFeatures(this.checkBoxMapFeatures.isSelected());
        this.world.setDifficulty(this.comboBoxDifficulty.getSelectedIndex());
        this.world.setDataPacks(this.dataPacksListModel.isEmpty() ? null : Collections.list(this.dataPacksListModel.elements()));
        World2.BorderSettings borderSettings = this.world.getBorderSettings();
        borderSettings.setCentreX(((Integer)this.spinnerMcBorderCentreX.getValue()).intValue());
        borderSettings.setCentreY(((Integer)this.spinnerMcBorderCentreY.getValue()).intValue());
        borderSettings.setSize(((Integer)this.spinnerMcBorderSize.getValue()).intValue());
        this.fieldDirectory.setEnabled(false);
        this.fieldName.setEnabled(false);
        this.buttonSelectDirectory.setEnabled(false);
        this.buttonExport.setEnabled(false);
        this.buttonTestExport.setEnabled(false);
        this.buttonCancel.setEnabled(false);
        for (DimensionPropertiesEditor editor : this.dimensionPropertiesEditors.values()) {
            editor.setEnabled(false);
        }
        this.checkBoxGoodies.setEnabled(false);
        this.comboBoxGameType.setEnabled(false);
        this.checkBoxAllowCheats.setEnabled(false);
        this.checkBoxMapFeatures.setEnabled(false);
        this.comboBoxDifficulty.setEnabled(false);
        this.listDataPacks.setEnabled(false);
        this.buttonAddDataPack.setEnabled(false);
        this.buttonRemoveDataPack.setEnabled(false);
        Configuration config = Configuration.getInstance();
        config.setExportDirectory(this.world.getPlatform(), baseDir);
        ExportProgressDialog dialog = new ExportProgressDialog(this, this.world, exportSettings, baseDir, name, previouslyAcknowledgedWarnings);
        this.view.setInhibitUpdates(true);
        try {
            dialog.setVisible(true);
        }
        finally {
            this.view.setInhibitUpdates(false);
        }
        if (!dialog.isAllowRetry()) {
            this.ok();
        } else {
            this.fieldName.setEnabled(true);
            this.buttonCancel.setEnabled(true);
            for (DimensionPropertiesEditor editor : this.dimensionPropertiesEditors.values()) {
                editor.setEnabled(true);
            }
            this.checkBoxGoodies.setEnabled(true);
            this.comboBoxGameType.setEnabled(true);
            this.checkBoxMapFeatures.setEnabled(true);
            this.listDataPacks.setEnabled(platform.capabilities.contains(Platform.Capability.DATA_PACKS));
            this.setControlStates();
        }
    }

    private boolean saveDimensionSettings() {
        for (DimensionPropertiesEditor editor : this.dimensionPropertiesEditors.values()) {
            if (editor.saveSettings()) continue;
            this.jTabbedPane1.setSelectedComponent(editor);
            return false;
        }
        return true;
    }

    private void testExport() {
        TestExportDialog dialog = new TestExportDialog(this, this.world, this.colourScheme, this.customBiomeManager, this.hiddenLayers, this.contourLines, this.contourSeparation, this.lightOrigin);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            this.export(this.world.getExportSettings());
        }
    }

    private void setControlStates() {
        boolean notHardcore = this.comboBoxGameType.getSelectedItem() != GameType.HARDCORE;
        boolean platformSupported = this.supportedPlatforms.contains(this.world.getPlatform());
        this.checkBoxAllowCheats.setEnabled(this.world.getPlatform() != DefaultPlugin.JAVA_MCREGION && notHardcore);
        this.comboBoxDifficulty.setEnabled(notHardcore);
        this.fieldDirectory.setEnabled(platformSupported);
        this.buttonSelectDirectory.setEnabled(platformSupported);
        this.buttonExport.setEnabled(platformSupported);
        this.buttonTestExport.setEnabled(platformSupported);
        boolean dataPacksEnabled = this.listDataPacks.isEnabled();
        this.buttonAddDataPack.setEnabled(dataPacksEnabled);
        this.buttonRemoveDataPack.setEnabled(dataPacksEnabled && this.listDataPacks.getSelectedIndex() != -1);
        if (!platformSupported) {
            this.buttonExport.setToolTipText(this.labelPlatformWarning.getToolTipText());
            this.buttonTestExport.setToolTipText(this.labelPlatformWarning.getToolTipText());
        } else {
            this.buttonExport.setToolTipText(null);
            this.buttonTestExport.setToolTipText(null);
        }
    }

    private void selectDir() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File(this.fieldDirectory.getText().trim()));
        fileChooser.setFileSelectionMode(1);
        if (ExceptionHandler.doWithoutExceptionReporting(() -> fileChooser.showOpenDialog(this)) == 0) {
            this.fieldDirectory.setText(fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void changePlatform() {
        if (!this.saveDimensionSettings()) {
            return;
        }
        if (App.getInstance().changeWorldHeight(this)) {
            while (this.jTabbedPane1.getTabCount() > 1) {
                this.jTabbedPane1.removeTabAt(this.jTabbedPane1.getTabCount() - 1);
            }
            this.createDimensionPropertiesEditors();
            this.platformChanged();
        }
    }

    private void addDataPack() {
        File dataPackFile = FileUtils.selectFileForOpen(this, "Select a data pack", null, new FileFilter(){

            @Override
            public String getExtensions() {
                return "*.zip";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return "Data packs (*.zip)";
            }
        });
        if (dataPackFile != null) {
            if (!DataPack.isDataPackFile((File)dataPackFile)) {
                MessageUtils.beepAndShowError((Component)this, (String)("The selected file \"" + dataPackFile.getName() + "\" is not a Minecraft data pack."), (String)"Not A Data Pack");
                return;
            }
            if (dataPackFile.getName().equalsIgnoreCase("worldpainter.zip")) {
                MessageUtils.beepAndShowError((Component)this, (String)"The WorldPainter data pack is managed by WorldPainter.", (String)"Cannot Add WorldPainter Data Pack");
                return;
            }
            Enumeration<File> e = this.dataPacksListModel.elements();
            while (e.hasMoreElements()) {
                File existingDataPack = e.nextElement();
                if (!existingDataPack.getName().equalsIgnoreCase(dataPackFile.getName())) continue;
                if (JOptionPane.showConfirmDialog(this, "There is already a data pack selected with the mame \"" + dataPackFile.getName() + "\"\nDo you want to replaced it?", "Data Pack Name Already Present", 0) == 0) {
                    this.dataPacksListModel.removeElement(existingDataPack);
                    break;
                }
                return;
            }
            this.dataPacksListModel.addElement(dataPackFile);
        }
    }

    private void removeSelectedDataPacks() {
        int[] selectedIndices = this.listDataPacks.getSelectedIndices();
        for (int i = selectedIndices.length - 1; i >= 0; --i) {
            this.dataPacksListModel.remove(selectedIndices[i]);
        }
    }

    private void initComponents() {
        this.buttonGroup2 = new ButtonGroup();
        this.buttonCancel = new JButton();
        this.buttonExport = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.checkBoxGoodies = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.labelPlatform = new JLabel();
        this.labelPlatformWarning = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.comboBoxGameType = new JComboBox();
        this.checkBoxAllowCheats = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.comboBoxDifficulty = new JComboBox();
        this.checkBoxMapFeatures = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.fieldDirectory = new JTextField();
        this.fieldName = new JTextField();
        this.buttonSelectDirectory = new JButton();
        this.jLabel11 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.listDataPacks = new JList();
        this.buttonAddDataPack = new JButton();
        this.buttonRemoveDataPack = new JButton();
        this.jLabel12 = new JLabel();
        this.panelMinecraftWorldBorder = new JPanel();
        this.jLabel79 = new JLabel();
        this.spinnerMcBorderCentreX = new JSpinner();
        this.jLabel80 = new JLabel();
        this.spinnerMcBorderCentreY = new JSpinner();
        this.jLabel81 = new JLabel();
        this.spinnerMcBorderSize = new JSpinner();
        this.jLabel85 = new JLabel();
        this.jLabel86 = new JLabel();
        this.buttonTestExport = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Exporting");
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWorldDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonExport.setText("Export");
        this.buttonExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWorldDialog.this.buttonExportActionPerformed(evt);
            }
        });
        this.jTabbedPane1.setTabPlacement(4);
        this.checkBoxGoodies.setSelected(true);
        this.checkBoxGoodies.setText(" ");
        this.checkBoxGoodies.setToolTipText("Include a chest with tools and resources near spawn for you as the level designer");
        this.jLabel1.setText("Map format:");
        this.labelPlatform.setForeground(new Color(0, 0, 255));
        this.labelPlatform.setText("<html><u>[EXPERIMENTAL] Minecraft 1.17</u></html>");
        this.labelPlatform.setCursor(new Cursor(12));
        this.labelPlatform.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ExportWorldDialog.this.labelPlatformMouseClicked(evt);
            }
        });
        this.labelPlatformWarning.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/error.png")));
        this.labelPlatformWarning.setText("<html><b>unknown format</b></html>");
        this.labelPlatformWarning.setToolTipText("<html>This map format is unknown and cannot be Exported. Most likely it<br>\nis supported by a plugin that is not installed or cannot be loaded.</html>");
        this.jLabel4.setText("Game settings");
        this.jLabel5.setText("Game mode:");
        this.comboBoxGameType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWorldDialog.this.comboBoxGameTypeActionPerformed(evt);
            }
        });
        this.checkBoxAllowCheats.setSelected(true);
        this.checkBoxAllowCheats.setText(" ");
        this.checkBoxAllowCheats.setToolTipText("Whether to allow cheats (single player commands)");
        this.jLabel6.setText("Difficulty:");
        this.comboBoxDifficulty.setModel(new DefaultComboBoxModel<String>(new String[]{"Peaceful", "Easy", "Normal", "Hard"}));
        this.checkBoxMapFeatures.setSelected(true);
        this.checkBoxMapFeatures.setText(" ");
        this.jLabel7.setText("General settings");
        this.jLabel8.setLabelFor(this.checkBoxAllowCheats);
        this.jLabel8.setText("Allow cheats:");
        this.jLabel9.setLabelFor(this.checkBoxMapFeatures);
        this.jLabel9.setText("Generate structures:");
        this.jLabel10.setLabelFor(this.checkBoxGoodies);
        this.jLabel10.setText("Include chest of goodies:");
        this.jLabel2.setText("Directory:");
        this.jLabel3.setText("Name:");
        this.fieldDirectory.setText("jTextField1");
        this.fieldName.setText("jTextField2");
        this.buttonSelectDirectory.setText("...");
        this.buttonSelectDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWorldDialog.this.buttonSelectDirectoryActionPerformed(evt);
            }
        });
        this.jLabel11.setText("Data packs:");
        this.listDataPacks.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ExportWorldDialog.this.listDataPacksValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listDataPacks);
        this.buttonAddDataPack.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/brick_add.png")));
        this.buttonAddDataPack.setToolTipText("Add a data pack");
        this.buttonAddDataPack.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAddDataPack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWorldDialog.this.buttonAddDataPackActionPerformed(evt);
            }
        });
        this.buttonRemoveDataPack.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/brick_delete.png")));
        this.buttonRemoveDataPack.setToolTipText("Remove the selected data pack(s)");
        this.buttonRemoveDataPack.setEnabled(false);
        this.buttonRemoveDataPack.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveDataPack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWorldDialog.this.buttonRemoveDataPackActionPerformed(evt);
            }
        });
        this.jLabel12.setText("<html><i>Use at own risk. WorldPainter does</i> not <i>check the validity or version! <i></html>");
        this.panelMinecraftWorldBorder.setBorder(BorderFactory.createTitledBorder("World Border"));
        this.jLabel79.setText("Centre:");
        this.spinnerMcBorderCentreX.setModel(new SpinnerNumberModel(0, -99999, 99999, 1));
        this.jLabel80.setText(", ");
        this.spinnerMcBorderCentreY.setModel(new SpinnerNumberModel(0, -99999, 99999, 1));
        this.jLabel81.setText("Size:");
        this.spinnerMcBorderSize.setModel(new SpinnerNumberModel(0, 0, 60000000, 1));
        this.jLabel85.setText(" blocks");
        this.jLabel86.setText(" blocks");
        GroupLayout panelMinecraftWorldBorderLayout = new GroupLayout(this.panelMinecraftWorldBorder);
        this.panelMinecraftWorldBorder.setLayout(panelMinecraftWorldBorderLayout);
        panelMinecraftWorldBorderLayout.setHorizontalGroup(panelMinecraftWorldBorderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelMinecraftWorldBorderLayout.createSequentialGroup().addContainerGap().addGroup(panelMinecraftWorldBorderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelMinecraftWorldBorderLayout.createSequentialGroup().addComponent(this.jLabel79).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerMcBorderCentreX, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel80).addGap(0, 0, 0).addComponent(this.spinnerMcBorderCentreY, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel85)).addGroup(panelMinecraftWorldBorderLayout.createSequentialGroup().addComponent(this.jLabel81).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerMcBorderSize, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel86))).addContainerGap(-1, Short.MAX_VALUE)));
        panelMinecraftWorldBorderLayout.setVerticalGroup(panelMinecraftWorldBorderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelMinecraftWorldBorderLayout.createSequentialGroup().addContainerGap().addGroup(panelMinecraftWorldBorderLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel79).addComponent(this.spinnerMcBorderCentreX, -2, -1, -2).addComponent(this.jLabel80).addComponent(this.spinnerMcBorderCentreY, -2, -1, -2).addComponent(this.jLabel85)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelMinecraftWorldBorderLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel81).addComponent(this.spinnerMcBorderSize, -2, -1, -2).addComponent(this.jLabel86)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldDirectory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelectDirectory)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldName)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonAddDataPack, GroupLayout.Alignment.TRAILING).addComponent(this.buttonRemoveDataPack, GroupLayout.Alignment.TRAILING))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxGoodies)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelPlatform, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelPlatformWarning, -2, -1, -2)).addComponent(this.jLabel12, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jLabel11)).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxAllowCheats)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxDifficulty, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxGameType, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxMapFeatures))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.panelMinecraftWorldBorder, -2, -1, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.fieldDirectory, -2, -1, -2).addComponent(this.buttonSelectDirectory)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.fieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.labelPlatform, -2, -1, -2).addComponent(this.labelPlatformWarning, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxGoodies).addComponent(this.jLabel10)).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.comboBoxGameType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.comboBoxDifficulty, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxAllowCheats).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.checkBoxMapFeatures)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11)).addComponent(this.panelMinecraftWorldBorder, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel12, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.buttonAddDataPack).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveDataPack))).addContainerGap()));
        this.jTabbedPane1.addTab("General", this.jPanel1);
        this.buttonTestExport.setText("Test Export...");
        this.buttonTestExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWorldDialog.this.buttonTestExportActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonTestExport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonExport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addComponent(this.jTabbedPane1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonExport).addComponent(this.buttonTestExport)).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonExportActionPerformed(ActionEvent evt) {
        this.export(WorldExportSettings.EXPORT_EVERYTHING);
    }

    private void buttonSelectDirectoryActionPerformed(ActionEvent evt) {
        this.selectDir();
    }

    private void platformChanged() {
        Platform newPlatform = this.world.getPlatform();
        this.labelPlatform.setText("<html><u>" + newPlatform.displayName + "</u></html>");
        GameType gameType = (GameType)this.comboBoxGameType.getSelectedItem();
        this.comboBoxGameType.setModel(new DefaultComboBoxModel<GameType>(newPlatform.supportedGameTypes.toArray(new GameType[newPlatform.supportedGameTypes.size()])));
        if (newPlatform.supportedGameTypes.contains(gameType)) {
            this.comboBoxGameType.setSelectedItem(gameType);
        } else {
            this.comboBoxGameType.setSelectedItem(GameType.SURVIVAL);
        }
        this.comboBoxGameType.setEnabled(newPlatform.supportedGameTypes.size() > 1);
        if (newPlatform != DefaultPlugin.JAVA_MCREGION) {
            this.checkBoxAllowCheats.setSelected(gameType == GameType.CREATIVE);
        } else {
            this.checkBoxAllowCheats.setSelected(false);
        }
        this.listDataPacks.setEnabled(newPlatform.capabilities.contains(Platform.Capability.DATA_PACKS));
        if (this.supportedPlatforms.contains(newPlatform)) {
            this.labelPlatformWarning.setVisible(false);
            File exportDir = Configuration.getInstance().getExportDirectory(newPlatform);
            if (exportDir == null || !exportDir.isDirectory()) {
                exportDir = PlatformManager.getInstance().getDefaultExportDir(newPlatform);
            }
            if (exportDir != null && exportDir.isDirectory()) {
                this.fieldDirectory.setText(exportDir.getAbsolutePath());
            }
        } else {
            this.labelPlatformWarning.setVisible(true);
        }
        this.checkBoxGoodies.setSelected(this.world.isCreateGoodiesChest());
        this.pack();
        this.setControlStates();
    }

    private void comboBoxGameTypeActionPerformed(ActionEvent evt) {
        if (this.world.getPlatform() != DefaultPlugin.JAVA_MCREGION && this.comboBoxGameType.getSelectedItem() == GameType.CREATIVE) {
            this.checkBoxAllowCheats.setSelected(true);
            this.comboBoxDifficulty.setSelectedIndex(0);
        } else if (this.comboBoxGameType.getSelectedItem() == GameType.HARDCORE) {
            this.checkBoxAllowCheats.setSelected(false);
            this.comboBoxDifficulty.setSelectedIndex(3);
        }
        this.setControlStates();
    }

    private void labelPlatformMouseClicked(MouseEvent evt) {
        this.changePlatform();
    }

    private void buttonTestExportActionPerformed(ActionEvent evt) {
        this.testExport();
    }

    private void buttonAddDataPackActionPerformed(ActionEvent evt) {
        this.addDataPack();
    }

    private void buttonRemoveDataPackActionPerformed(ActionEvent evt) {
        this.removeSelectedDataPacks();
    }

    private void listDataPacksValueChanged(ListSelectionEvent evt) {
        this.setControlStates();
    }

    static {
        logger = LoggerFactory.getLogger(ExportWorldDialog.class);
    }
}

