/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Window;
import java.nio.file.InvalidPathException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.pepsoft.util.ExceptionUtils;
import org.pepsoft.util.mdc.MDCWrappingRuntimeException;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.ErrorDialog;
import org.slf4j.LoggerFactory;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final AtomicInteger reportingDisabled = new AtomicInteger();
    private static boolean handlingException;

    public static void handleException(Throwable t) {
        ExceptionHandler.handleException(t, App.getInstanceIfExists());
    }

    public static void handleException(Throwable t, Window parent) {
        if (reportingDisabled.get() > 0) {
            LoggerFactory.getLogger(ExceptionHandler.class).error("{} occurred while exception reporting was disabled (message: {})", new Object[]{t.getClass().getSimpleName(), t.getMessage(), t});
        } else if (ExceptionHandler.shouldIgnore(t)) {
            t.printStackTrace();
        } else {
            Runnable task = () -> {
                if (!handlingException) {
                    handlingException = true;
                    try {
                        ErrorDialog dialog = new ErrorDialog(parent);
                        dialog.setException(t);
                        dialog.setVisible(true);
                    }
                    finally {
                        handlingException = false;
                    }
                } else {
                    LoggerFactory.getLogger(ExceptionHandler.class).error("{} occurred while exception dialog was open (message: {})", new Object[]{t.getClass().getSimpleName(), t.getMessage(), t});
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                task.run();
            } else {
                SwingUtilities.invokeLater(task);
            }
        }
    }

    public static void doWithoutExceptionReporting(Runnable task) {
        reportingDisabled.incrementAndGet();
        try {
            task.run();
        }
        finally {
            reportingDisabled.decrementAndGet();
        }
    }

    public static <T> T doWithoutExceptionReporting(Callable<T> task) {
        reportingDisabled.incrementAndGet();
        try {
            T t = task.call();
            return t;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new MDCWrappingRuntimeException((Throwable)e);
        }
        finally {
            reportingDisabled.decrementAndGet();
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        ExceptionHandler.handleException(e);
    }

    private static boolean shouldIgnore(Throwable t) {
        Throwable rootCause = ExceptionUtils.getUltimateCause((Throwable)t);
        if (rootCause.getStackTrace() != null && rootCause.getStackTrace().length > 0) {
            StackTraceElement topOfStack = rootCause.getStackTrace()[0];
            if (rootCause instanceof NullPointerException) {
                return topOfStack.getClassName().equals("javax.swing.SwingUtilities") && topOfStack.getMethodName().equals("getWindowAncestor") || topOfStack.getClassName().equals("javax.swing.plaf.basic.BasicProgressBarUI") && topOfStack.getMethodName().equals("sizeChanged");
            }
            if (rootCause instanceof InvalidPathException) {
                return topOfStack.getClassName().equals("sun.nio.fs.WindowsPathParser") && topOfStack.getMethodName().equals("normalize");
            }
            if (rootCause instanceof NoClassDefFoundError) {
                return topOfStack.getClassName().equalsIgnoreCase("sun.dc.DuctusRenderingEngine") && topOfStack.getMethodName().equalsIgnoreCase("getRasterizer");
            }
        }
        return false;
    }
}

