/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.vo.EventVO;

public final class DonationDialog
extends WorldPainterDialog {
    private JButton buttonAlreadyDonated;
    private JButton buttonAskLater;
    private JButton buttonDonate;
    private JButton buttonMerchStore;
    private JButton buttonNoThanks;
    private JLabel jLabel1;
    private JTextArea jTextArea1;
    private final Configuration config = Configuration.getInstance();
    private static final long serialVersionUID = 1L;

    public DonationDialog(Window parent) {
        super(parent);
        this.initComponents();
        this.jTextArea1.setFont(UIManager.getFont("TextField.font").deriveFont((float)UIManager.getFont("TextField.font").getSize() + 6.0f));
        this.rootPane.setDefaultButton(this.buttonDonate);
        this.pack();
    }

    public static boolean maybeShowDonationDialog(Window parent) {
        Configuration config = Configuration.getInstance();
        if (config.getLaunchCount() >= config.getShowDonationDialogAfter()) {
            DonationDialog dialog = new DonationDialog(parent);
            dialog.setLocationRelativeTo(parent);
            dialog.setVisible(true);
            if (dialog.isCancelled()) {
                config.logEvent(new EventVO("donation.closed").addTimestamp());
            }
            return true;
        }
        return false;
    }

    private void donate() {
        try {
            DesktopUtils.open((URL)new URL("https://www.worldpainter.net/donate/paypal"));
            this.config.setDonationStatus(Configuration.DonationStatus.DONATED);
            this.config.setShowDonationDialogAfter(this.config.getLaunchCount() + 100);
            MessageUtils.showInfo((Component)this, (String)"The donation PayPal page has been opened in your browser.\n\nThank you very much for donating!", (String)"Thank You");
            this.config.logEvent(new EventVO("donation.donate").addTimestamp());
            this.ok();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void alreadyDonated() {
        this.config.setDonationStatus(Configuration.DonationStatus.DONATED);
        this.config.setShowDonationDialogAfter(this.config.getLaunchCount() + 100);
        MessageUtils.showInfo((Component)this, (String)"Thank you very much for donating!", (String)"Thank You");
        this.config.logEvent(new EventVO("donation.alreadyDonated").addTimestamp());
        this.ok();
    }

    private void askLater() {
        this.config.logEvent(new EventVO("donation.askLater").addTimestamp());
        this.ok();
    }

    private void noThanks() {
        this.config.setDonationStatus(Configuration.DonationStatus.NO_THANK_YOU);
        this.config.setShowDonationDialogAfter(this.config.getLaunchCount() + 50);
        MessageUtils.showInfo((Component)this, (String)"Alright, no problem. We will not ask you again for a while.\nIf you change your mind, you can donate from the About screen!", (String)"No Problem");
        this.config.logEvent(new EventVO("donation.noThanks").addTimestamp());
        this.ok();
    }

    private void openMerchStore() {
        try {
            DesktopUtils.open((URL)new URL("https://www.worldpainter.store/"));
            this.config.logEvent(new EventVO("store.merch.opened").addTimestamp());
            this.ok();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextArea1 = new JTextArea();
        this.buttonDonate = new JButton();
        this.buttonAlreadyDonated = new JButton();
        this.buttonAskLater = new JButton();
        this.buttonNoThanks = new JButton();
        this.buttonMerchStore = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Please Support WorldPainter");
        this.setResizable(false);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/resources/about.png")));
        this.jLabel1.setBorder(BorderFactory.createBevelBorder(1));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(this.jTextArea1.getFont().deriveFont((float)this.jTextArea1.getFont().getSize() + 6.0f));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText("Thank you for using WorldPainter!\n\nWorldPainter takes a lot of effort to create and maintain. Please consider helping out with a donation, or by buying merchandise from our merch store.");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setOpaque(false);
        this.buttonDonate.setBackground(new Color(255, 196, 58));
        this.buttonDonate.setFont(this.buttonDonate.getFont().deriveFont(this.buttonDonate.getFont().getStyle() | 1, this.buttonDonate.getFont().getSize() + 3));
        this.buttonDonate.setMnemonic('d');
        this.buttonDonate.setText("Donate");
        this.buttonDonate.setBorderPainted(false);
        this.buttonDonate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DonationDialog.this.buttonDonateActionPerformed(evt);
            }
        });
        this.buttonAlreadyDonated.setFont(this.buttonAlreadyDonated.getFont().deriveFont((float)this.buttonAlreadyDonated.getFont().getSize() + 3.0f));
        this.buttonAlreadyDonated.setMnemonic('a');
        this.buttonAlreadyDonated.setText("I have already donated");
        this.buttonAlreadyDonated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DonationDialog.this.buttonAlreadyDonatedActionPerformed(evt);
            }
        });
        this.buttonAskLater.setFont(this.buttonAskLater.getFont().deriveFont((float)this.buttonAskLater.getFont().getSize() + 3.0f));
        this.buttonAskLater.setMnemonic('l');
        this.buttonAskLater.setText("Ask me later");
        this.buttonAskLater.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DonationDialog.this.buttonAskLaterActionPerformed(evt);
            }
        });
        this.buttonNoThanks.setFont(this.buttonNoThanks.getFont().deriveFont((float)this.buttonNoThanks.getFont().getSize() + 3.0f));
        this.buttonNoThanks.setMnemonic('n');
        this.buttonNoThanks.setText("No thank you");
        this.buttonNoThanks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DonationDialog.this.buttonNoThanksActionPerformed(evt);
            }
        });
        this.buttonMerchStore.setFont(this.buttonMerchStore.getFont().deriveFont((float)this.buttonMerchStore.getFont().getSize() + 3.0f));
        this.buttonMerchStore.setText("Merch store");
        this.buttonMerchStore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DonationDialog.this.buttonMerchStoreActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonDonate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMerchStore).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonAlreadyDonated).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonAskLater).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonNoThanks)).addComponent(this.jTextArea1)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jTextArea1).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonDonate).addComponent(this.buttonAlreadyDonated).addComponent(this.buttonAskLater).addComponent(this.buttonNoThanks).addComponent(this.buttonMerchStore)).addContainerGap()));
        this.pack();
    }

    private void buttonDonateActionPerformed(ActionEvent evt) {
        this.donate();
    }

    private void buttonAlreadyDonatedActionPerformed(ActionEvent evt) {
        this.alreadyDonated();
    }

    private void buttonAskLaterActionPerformed(ActionEvent evt) {
        this.askLater();
    }

    private void buttonNoThanksActionPerformed(ActionEvent evt) {
        this.noThanks();
    }

    private void buttonMerchStoreActionPerformed(ActionEvent evt) {
        this.openMerchStore();
    }
}

