/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.LayerListCellRenderer;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.layers.CustomLayer;

public class DeleteLayersDialog
extends WorldPainterDialog {
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JList<CustomLayer> jList1;
    private JScrollPane jScrollPane1;
    private final DefaultListModel<CustomLayer> listModel = new DefaultListModel();

    public DeleteLayersDialog(Window parent, Collection<CustomLayer> layers) {
        super(parent);
        this.initComponents();
        layers.forEach(this.listModel::addElement);
        this.jList1.setModel(this.listModel);
        this.jList1.setSelectionInterval(0, this.listModel.getSize() - 1);
        this.jList1.setCellRenderer(new LayerListCellRenderer());
        this.jList1.getSelectionModel().addListSelectionListener(e -> this.setControlStates());
        this.setControlStates();
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void deleteSelectedLayers() {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to delete " + this.jList1.getSelectedIndices().length + " layer(s)?\nThis cannot be undone!", "Confirm Deletion", 0) == 0) {
            App app = App.getInstance();
            this.jList1.getSelectedValuesList().forEach(app::deleteCustomLayer);
            app.validate();
            this.ok();
        }
    }

    private void setControlStates() {
        this.jButton2.setEnabled(this.jList1.getSelectedIndex() != -1);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Delete Layers");
        this.jLabel1.setText("<html>The following layers will be deleted. Deselect<br>any layers which you do not want to be deleted:</html>");
        this.jScrollPane1.setViewportView(this.jList1);
        this.jButton1.setText("Cancel");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeleteLayersDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Delete Selected Layers");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeleteLayersDialog.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, -1, -2).addGap(0, 122, Short.MAX_VALUE)).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 212, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.deleteSelectedLayers();
    }
}

