/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.MaterialSelector;
import org.pepsoft.worldpainter.MaterialTableCellRenderer;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.MixedMaterialHelper;
import org.pepsoft.worldpainter.MixedMaterialTableModel;
import org.pepsoft.worldpainter.MouseAdapter;
import org.pepsoft.worldpainter.NoiseSettings;
import org.pepsoft.worldpainter.NoiseSettingsEditor;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.themes.JSpinnerTableCellEditor;

public class CustomMaterialDialog
extends WorldPainterDialog
implements PropertyChangeListener {
    private JButton buttonAddMaterial;
    private JButton buttonCancel;
    private ButtonGroup buttonGroup1;
    private JButton buttonLoad;
    private JButton buttonOK;
    private JButton buttonRemoveMaterial;
    private JButton buttonSave;
    private JButton buttonSelectColour;
    private JCheckBox checkBoxColour;
    private JCheckBox checkBoxLayeredRepeat;
    private JTextField fieldName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JLabel labelColour;
    private JLabel labelPreview;
    private MaterialSelector materialEditor1;
    private NoiseSettingsEditor noiseSettingsEditorLayeredVariation;
    private JRadioButton radioButtonBlobs;
    private JRadioButton radioButtonLayered;
    private JRadioButton radioButtonNoise;
    private JSpinner spinnerLayeredXAngle;
    private JSpinner spinnerLayeredYAngle;
    private JSpinner spinnerScale;
    private JTable tableMaterialRows;
    private final Platform platform;
    private final boolean extendedBlockIds;
    private final ColourScheme colourScheme;
    private final MixedMaterial material;
    private MixedMaterialTableModel tableModel;
    private int biome;
    private String previousCalculatedName;
    private int selectedColour = Color.ORANGE.getRGB();
    private Timer previewUpdateTimer;
    private boolean programmaticChange;
    private static final double DEGREES_TO_RADIANS = 57.29577951308232;
    private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private static final long serialVersionUID = 1L;

    public CustomMaterialDialog(Window parent, final Platform platform, MixedMaterial material, final boolean extendedBlockIds, ColourScheme colourScheme) {
        super(parent);
        this.platform = platform;
        this.material = material;
        this.extendedBlockIds = extendedBlockIds;
        this.colourScheme = colourScheme;
        this.initComponents();
        this.materialEditor1.setExtendedBlockIds(extendedBlockIds);
        this.materialEditor1.setPlatform(platform);
        this.materialEditor1.addPropertyChangeListener("material", this);
        this.fieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!CustomMaterialDialog.this.programmaticChange) {
                    CustomMaterialDialog.this.setControlStates();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!CustomMaterialDialog.this.programmaticChange) {
                    CustomMaterialDialog.this.setControlStates();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!CustomMaterialDialog.this.programmaticChange) {
                    CustomMaterialDialog.this.setControlStates();
                }
            }
        });
        this.tableMaterialRows.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tableMaterialRows.getSelectionModel().addListSelectionListener(e -> {
            if (!this.programmaticChange) {
                this.setControlStates();
            }
        });
        this.tableMaterialRows.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point point = e.getPoint();
                int column = CustomMaterialDialog.this.tableMaterialRows.columnAtPoint(point);
                int row = CustomMaterialDialog.this.tableMaterialRows.rowAtPoint(point);
                if (row != -1 && column == 0) {
                    WorldPainterDialog dialog = new WorldPainterDialog((Window)CustomMaterialDialog.this);
                    ((Dialog)dialog).setTitle("Edit Material");
                    MaterialSelector materialSelector = new MaterialSelector();
                    materialSelector.setPlatform(platform);
                    materialSelector.setExtendedBlockIds(extendedBlockIds);
                    materialSelector.setMaterial((Material)CustomMaterialDialog.this.tableModel.getValueAt(row, 0));
                    dialog.getContentPane().add((Component)materialSelector, "Center");
                    JPanel buttonPanel = new JPanel(new FlowLayout(2));
                    JButton okButton = new JButton("OK");
                    okButton.addActionListener(event -> {
                        Material material = materialSelector.getMaterial();
                        CustomMaterialDialog.this.tableModel.setValueAt(material, row, 0);
                        dialog.dispose();
                    });
                    buttonPanel.add(okButton);
                    JButton cancelButton = new JButton("Cancel");
                    cancelButton.addActionListener(event -> dialog.dispose());
                    buttonPanel.add(cancelButton);
                    dialog.getRootPane().setDefaultButton(okButton);
                    dialog.getContentPane().add((Component)buttonPanel, "South");
                    dialog.pack();
                    dialog.setLocationRelativeTo(CustomMaterialDialog.this);
                    dialog.setVisible(true);
                }
            }
        });
        this.tableMaterialRows.addMouseMotionListener(new MouseAdapter(){
            private boolean cursorSet;

            @Override
            public void mouseMoved(MouseEvent e) {
                Point point = e.getPoint();
                int column = CustomMaterialDialog.this.tableMaterialRows.columnAtPoint(point);
                int row = CustomMaterialDialog.this.tableMaterialRows.rowAtPoint(point);
                if (row != -1 && column == 0) {
                    if (!this.cursorSet) {
                        CustomMaterialDialog.this.tableMaterialRows.setCursor(HAND_CURSOR);
                        this.cursorSet = true;
                    }
                } else if (this.cursorSet) {
                    CustomMaterialDialog.this.tableMaterialRows.setCursor(null);
                    this.cursorSet = false;
                }
            }
        });
        this.init(material);
        this.rootPane.setDefaultButton(this.buttonOK);
        this.scaleToUI();
        this.pack();
        this.scaleWindowToUI();
        this.setLocationRelativeTo(parent);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("material")) {
            this.updateName();
            this.schedulePreviewUpdate();
        }
    }

    @Override
    protected void ok() {
        if (this.tableMaterialRows.isEditing()) {
            this.tableMaterialRows.getCellEditor().stopCellEditing();
        }
        this.saveSettings();
        super.ok();
    }

    private void saveSettings() {
        switch (this.jTabbedPane1.getSelectedIndex()) {
            case 0: {
                Material selectedMaterial = this.materialEditor1.getMaterial();
                String name = this.fieldName.getText().equals(this.previousCalculatedName) ? this.createName(selectedMaterial) : this.fieldName.getText();
                this.material.edit(name, new MixedMaterial.Row[]{new MixedMaterial.Row(selectedMaterial, 1000, 1.0f)}, this.biome, MixedMaterial.Mode.SIMPLE, 1.0f, this.checkBoxColour.isSelected() ? Integer.valueOf(this.selectedColour) : null, null, 0.0, 0.0, false);
                break;
            }
            case 1: {
                MixedMaterial.Row[] rows = this.tableModel.getRows();
                if (rows.length == 1) {
                    this.material.edit(this.fieldName.getText(), rows, this.biome, MixedMaterial.Mode.SIMPLE, 1.0f, this.checkBoxColour.isSelected() ? Integer.valueOf(this.selectedColour) : null, null, 0.0, 0.0, false);
                    break;
                }
                if (this.radioButtonNoise.isSelected()) {
                    this.material.edit(this.fieldName.getText(), rows, this.biome, MixedMaterial.Mode.NOISE, 1.0f, this.checkBoxColour.isSelected() ? Integer.valueOf(this.selectedColour) : null, null, 0.0, 0.0, false);
                    break;
                }
                if (this.radioButtonBlobs.isSelected()) {
                    this.material.edit(this.fieldName.getText(), rows, this.biome, MixedMaterial.Mode.BLOBS, (float)((Integer)this.spinnerScale.getValue()).intValue() / 100.0f, this.checkBoxColour.isSelected() ? Integer.valueOf(this.selectedColour) : null, null, 0.0, 0.0, false);
                    break;
                }
                NoiseSettings variation = this.noiseSettingsEditorLayeredVariation.getNoiseSettings();
                boolean repeat = this.checkBoxLayeredRepeat.isSelected();
                this.material.edit(this.fieldName.getText(), rows, this.biome, MixedMaterial.Mode.LAYERED, (float)((Integer)this.spinnerScale.getValue()).intValue() / 100.0f, this.checkBoxColour.isSelected() ? Integer.valueOf(this.selectedColour) : null, (NoiseSettings)(variation.getRange() != 0 ? variation : null), repeat ? Math.tan((double)(-((Integer)this.spinnerLayeredXAngle.getValue()).intValue()) / 57.29577951308232) : 0.0, repeat ? Math.tan((double)(-((Integer)this.spinnerLayeredYAngle.getValue()).intValue()) / 57.29577951308232) : 0.0, repeat);
            }
        }
    }

    private MixedMaterial getNewMaterial() {
        switch (this.jTabbedPane1.getSelectedIndex()) {
            case 0: {
                return new MixedMaterial(this.fieldName.getText(), new MixedMaterial.Row(this.materialEditor1.getMaterial(), 1000, 1.0f), this.biome, this.checkBoxColour.isSelected() ? Integer.valueOf(this.selectedColour) : null);
            }
            case 1: {
                MixedMaterialTableModel tableModelClone = this.tableModel.clone();
                MixedMaterial.Row[] rows = tableModelClone.getRows();
                if (rows.length == 1) {
                    return new MixedMaterial(this.fieldName.getText(), rows[0], this.biome, this.checkBoxColour.isSelected() ? Integer.valueOf(this.selectedColour) : null);
                }
                if (this.radioButtonNoise.isSelected()) {
                    return new MixedMaterial(this.fieldName.getText(), rows, this.biome, this.checkBoxColour.isSelected() ? Integer.valueOf(this.selectedColour) : null);
                }
                if (this.radioButtonBlobs.isSelected()) {
                    return new MixedMaterial(this.fieldName.getText(), rows, this.biome, this.checkBoxColour.isSelected() ? Integer.valueOf(this.selectedColour) : null, (float)((Integer)this.spinnerScale.getValue()).intValue() / 100.0f);
                }
                NoiseSettings variation = this.noiseSettingsEditorLayeredVariation.getNoiseSettings().clone();
                boolean repeat = this.checkBoxLayeredRepeat.isSelected();
                return new MixedMaterial(this.fieldName.getText(), rows, this.biome, this.checkBoxColour.isSelected() ? Integer.valueOf(this.selectedColour) : null, (NoiseSettings)(variation.getRange() != 0 ? variation : null), repeat ? Math.tan((double)(-((Integer)this.spinnerLayeredXAngle.getValue()).intValue()) / 57.29577951308232) : 0.0, repeat ? Math.tan((double)(-((Integer)this.spinnerLayeredYAngle.getValue()).intValue()) / 57.29577951308232) : 0.0, repeat);
            }
        }
        throw new InternalError();
    }

    private void init(MixedMaterial mixedMaterial) {
        this.programmaticChange = true;
        try {
            this.biome = mixedMaterial.getBiome();
            this.fieldName.setText(mixedMaterial.getName());
            this.tableModel = new MixedMaterialTableModel(mixedMaterial);
            this.tableModel.addTableModelListener(e -> {
                if (!this.checkBoxColour.isSelected() && this.isExtendedBlockIds()) {
                    this.checkBoxColour.setSelected(true);
                }
                this.setControlStates();
                this.updateName();
                this.schedulePreviewUpdate();
            });
            switch (mixedMaterial.getMode()) {
                case SIMPLE: {
                    this.jTabbedPane1.setSelectedIndex(0);
                    this.materialEditor1.setMaterial(mixedMaterial.getSingleMaterial());
                    break;
                }
                case NOISE: {
                    this.jTabbedPane1.setSelectedIndex(1);
                    this.radioButtonNoise.setSelected(true);
                    break;
                }
                case BLOBS: {
                    this.jTabbedPane1.setSelectedIndex(1);
                    this.radioButtonBlobs.setSelected(true);
                    this.spinnerScale.setValue(Math.round(mixedMaterial.getScale() * 100.0f));
                    break;
                }
                case LAYERED: {
                    this.jTabbedPane1.setSelectedIndex(1);
                    this.radioButtonLayered.setSelected(true);
                    this.checkBoxLayeredRepeat.setSelected(mixedMaterial.isRepeat());
                    if (mixedMaterial.getVariation() != null) {
                        this.noiseSettingsEditorLayeredVariation.setNoiseSettings(mixedMaterial.getVariation());
                    }
                    this.spinnerLayeredXAngle.setValue(-((int)Math.round(Math.atan(mixedMaterial.getLayerXSlope()) * 57.29577951308232)));
                    this.spinnerLayeredYAngle.setValue(-((int)Math.round(Math.atan(mixedMaterial.getLayerYSlope()) * 57.29577951308232)));
                }
            }
            if (this.materialEditor1.getMaterial() == null) {
                this.materialEditor1.setMaterial(mixedMaterial.getRows()[0].material);
            }
            this.tableMaterialRows.setModel(this.tableModel);
            this.previousCalculatedName = this.createName();
            this.selectedColour = mixedMaterial.getColour() != null ? mixedMaterial.getColour().intValue() : Color.ORANGE.getRGB();
            this.checkBoxColour.setSelected(mixedMaterial.getColour() != null);
            this.setControlStates();
            this.updatePreview();
            this.configureTable();
        }
        finally {
            this.programmaticChange = false;
        }
    }

    private void addMaterial() {
        if (this.tableMaterialRows.isEditing()) {
            this.tableMaterialRows.getCellEditor().stopCellEditing();
        }
        this.tableModel.addMaterial(new MixedMaterial.Row(Material.DIRT, this.tableModel.getAverageCount(), 1.0f));
    }

    private void removeMaterial() {
        if (this.tableMaterialRows.isEditing()) {
            this.tableMaterialRows.getCellEditor().stopCellEditing();
        }
        int[] selectedRows = this.tableMaterialRows.getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            this.tableModel.removeMaterial(selectedRows[i]);
        }
    }

    private void setControlStates() {
        boolean nameSet = !this.fieldName.getText().trim().isEmpty();
        switch (this.jTabbedPane1.getSelectedIndex()) {
            case 0: {
                this.buttonOK.setEnabled(nameSet);
                break;
            }
            case 1: {
                boolean countValid = (Integer)this.tableModel.getValueAt(0, 1) >= 0;
                this.buttonOK.setEnabled(nameSet && countValid);
                this.buttonRemoveMaterial.setEnabled(this.tableModel.getRowCount() > 1 && this.tableMaterialRows.getSelectedRows().length > 0);
                this.spinnerScale.setEnabled(this.radioButtonBlobs.isSelected());
                this.checkBoxLayeredRepeat.setEnabled(this.radioButtonLayered.isSelected());
                this.noiseSettingsEditorLayeredVariation.setEnabled(this.radioButtonLayered.isSelected());
                this.spinnerLayeredXAngle.setEnabled(this.radioButtonLayered.isSelected() && this.checkBoxLayeredRepeat.isSelected());
                this.spinnerLayeredYAngle.setEnabled(this.radioButtonLayered.isSelected() && this.checkBoxLayeredRepeat.isSelected());
                if (this.radioButtonNoise.isSelected()) {
                    this.tableModel.setMode(MixedMaterial.Mode.NOISE);
                    break;
                }
                if (this.radioButtonBlobs.isSelected()) {
                    this.tableModel.setMode(MixedMaterial.Mode.BLOBS);
                    break;
                }
                this.tableModel.setMode(MixedMaterial.Mode.LAYERED);
            }
        }
        if (this.checkBoxColour.isSelected()) {
            this.setLabelColour();
            this.buttonSelectColour.setEnabled(true);
        } else {
            this.labelColour.setBackground(null);
            this.buttonSelectColour.setEnabled(false);
        }
    }

    private String createName() {
        switch (this.jTabbedPane1.getSelectedIndex()) {
            case 0: {
                return this.createName(this.materialEditor1.getMaterial());
            }
            case 1: {
                MixedMaterial.Row[] rows = this.tableModel.getRows();
                rows = Arrays.copyOf(rows, rows.length);
                Arrays.sort(rows, (r1, r2) -> r2.occurrence - r1.occurrence);
                StringBuilder sb = new StringBuilder();
                for (MixedMaterial.Row row : rows) {
                    if (sb.length() > 0) {
                        sb.append('/');
                    }
                    sb.append(this.createName(row.material));
                }
                if (sb.length() > 30) {
                    return sb.substring(0, 27) + "...";
                }
                return sb.toString();
            }
        }
        throw new InternalError();
    }

    private String createName(Material material) {
        return this.platform.capabilities.contains(Platform.Capability.NAME_BASED) ? material.toString() : material.toLegacyString();
    }

    private boolean isExtendedBlockIds() {
        for (MixedMaterial.Row row : this.tableModel.getRows()) {
            if (row.material.blockType <= 255) continue;
            return true;
        }
        return false;
    }

    private void pickColour() {
        Color pick = JColorChooser.showDialog(this, "Select Colour", new Color(this.selectedColour));
        if (pick != null) {
            this.selectedColour = pick.getRGB();
            this.setLabelColour();
        }
    }

    private void setLabelColour() {
        this.labelColour.setBackground(new Color(this.selectedColour));
    }

    private void configureTable() {
        if (this.jTabbedPane1.getSelectedIndex() == 1) {
            TableColumnModel columnModel = this.tableMaterialRows.getColumnModel();
            TableColumn materialColumn = columnModel.getColumn(0);
            materialColumn.setCellRenderer(new MaterialTableCellRenderer(this.platform));
            SpinnerNumberModel countSpinnerModel = new SpinnerNumberModel(1000, 1, 1000, 1);
            columnModel.getColumn(1).setCellEditor(new JSpinnerTableCellEditor(countSpinnerModel));
            if (this.tableModel.getMode() == MixedMaterial.Mode.BLOBS) {
                SpinnerNumberModel scaleSpinnerModel = new SpinnerNumberModel(100, 1, 9999, 1);
                columnModel.getColumn(2).setCellEditor(new JSpinnerTableCellEditor(scaleSpinnerModel));
            }
        }
    }

    private void schedulePreviewUpdate() {
        if (this.previewUpdateTimer == null) {
            this.previewUpdateTimer = new Timer(250, e -> this.updatePreview());
            this.previewUpdateTimer.setRepeats(false);
        }
        this.previewUpdateTimer.restart();
    }

    private void updatePreview() {
        if (this.previewUpdateTimer != null) {
            this.previewUpdateTimer.stop();
            this.previewUpdateTimer = null;
        }
        int width = this.labelPreview.getWidth();
        int height = this.labelPreview.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        MixedMaterial mixedMaterial = this.getNewMaterial();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, this.colourScheme.getColour(mixedMaterial.getMaterial(0L, x, 0, height - y - 1)));
            }
        }
        this.labelPreview.setIcon(new ImageIcon(image));
    }

    private void saveMaterial() {
        MixedMaterialHelper.save(this, this.getNewMaterial());
    }

    private void loadMaterial() {
        MixedMaterial material = MixedMaterialHelper.load(this);
        if (material != null) {
            this.init(material);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel8 = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonOK = new JButton();
        this.jLabel2 = new JLabel();
        this.fieldName = new JTextField();
        this.jLabel5 = new JLabel();
        this.labelColour = new JLabel();
        this.buttonSelectColour = new JButton();
        this.checkBoxColour = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.labelPreview = new JLabel();
        this.buttonLoad = new JButton();
        this.buttonSave = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.materialEditor1 = new MaterialSelector();
        this.jPanel2 = new JPanel();
        this.spinnerScale = new JSpinner();
        this.buttonAddMaterial = new JButton();
        this.buttonRemoveMaterial = new JButton();
        this.jLabel6 = new JLabel();
        this.spinnerLayeredXAngle = new JSpinner();
        this.jLabel9 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableMaterialRows = new JTable();
        this.jLabel7 = new JLabel();
        this.jLabel3 = new JLabel();
        this.noiseSettingsEditorLayeredVariation = new NoiseSettingsEditor();
        this.radioButtonLayered = new JRadioButton();
        this.radioButtonNoise = new JRadioButton();
        this.spinnerLayeredYAngle = new JSpinner();
        this.radioButtonBlobs = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.checkBoxLayeredRepeat = new JCheckBox();
        this.jLabel8.setText("jLabel8");
        this.setDefaultCloseOperation(2);
        this.setTitle("Select Custom Material");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                CustomMaterialDialog.this.formComponentResized(evt);
            }
        });
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomMaterialDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomMaterialDialog.this.buttonOKActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Name:");
        this.fieldName.setColumns(20);
        this.jLabel5.setText("Colour:");
        this.labelColour.setText("                 ");
        this.labelColour.setToolTipText("Select to override actual block colours");
        this.labelColour.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.labelColour.setOpaque(true);
        this.buttonSelectColour.setText("...");
        this.buttonSelectColour.setEnabled(false);
        this.buttonSelectColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomMaterialDialog.this.buttonSelectColourActionPerformed(evt);
            }
        });
        this.checkBoxColour.setText(" ");
        this.checkBoxColour.setToolTipText("Select to override actual block colours");
        this.checkBoxColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomMaterialDialog.this.checkBoxColourActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createBevelBorder(1));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelPreview, -1, 53, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelPreview, -1, -1, Short.MAX_VALUE));
        this.buttonLoad.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/folder_page_white.png")));
        this.buttonLoad.setToolTipText("Load this custom material from a file");
        this.buttonLoad.setMargin(new Insets(2, 2, 2, 2));
        this.buttonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomMaterialDialog.this.buttonLoadActionPerformed(evt);
            }
        });
        this.buttonSave.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/disk.png")));
        this.buttonSave.setToolTipText("Save this custom material to a file");
        this.buttonSave.setMargin(new Insets(2, 2, 2, 2));
        this.buttonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomMaterialDialog.this.buttonSaveActionPerformed(evt);
            }
        });
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CustomMaterialDialog.this.jTabbedPane1StateChanged(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.materialEditor1, -1, -1, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.materialEditor1, -2, -1, -2).addGap(0, 222, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Simple", this.jPanel3);
        this.spinnerScale.setModel(new SpinnerNumberModel(100, 1, 9999, 1));
        this.spinnerScale.setEnabled(false);
        this.spinnerScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CustomMaterialDialog.this.spinnerScaleStateChanged(evt);
            }
        });
        this.buttonAddMaterial.setText("Add Material");
        this.buttonAddMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomMaterialDialog.this.buttonAddMaterialActionPerformed(evt);
            }
        });
        this.buttonRemoveMaterial.setText("Remove Material");
        this.buttonRemoveMaterial.setEnabled(false);
        this.buttonRemoveMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomMaterialDialog.this.buttonRemoveMaterialActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Variation:");
        this.spinnerLayeredXAngle.setModel(new SpinnerNumberModel(0, -89, 89, 1));
        this.spinnerLayeredXAngle.setEnabled(false);
        this.spinnerLayeredXAngle.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CustomMaterialDialog.this.spinnerLayeredXAngleStateChanged(evt);
            }
        });
        this.jLabel9.setText("Z-axis angle:");
        this.tableMaterialRows.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.tableMaterialRows);
        this.jLabel7.setText("X-axis angle:");
        this.jLabel3.setText("Scale:");
        this.noiseSettingsEditorLayeredVariation.setEnabled(false);
        this.noiseSettingsEditorLayeredVariation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CustomMaterialDialog.this.noiseSettingsEditorLayeredVariationStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonLayered);
        this.radioButtonLayered.setText("Layers");
        this.radioButtonLayered.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomMaterialDialog.this.radioButtonLayeredActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonNoise);
        this.radioButtonNoise.setSelected(true);
        this.radioButtonNoise.setText("Noise");
        this.radioButtonNoise.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomMaterialDialog.this.radioButtonNoiseActionPerformed(evt);
            }
        });
        this.spinnerLayeredYAngle.setModel(new SpinnerNumberModel(0, -89, 89, 1));
        this.spinnerLayeredYAngle.setEnabled(false);
        this.buttonGroup1.add(this.radioButtonBlobs);
        this.radioButtonBlobs.setText("Blobs");
        this.radioButtonBlobs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomMaterialDialog.this.radioButtonBlobsActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Select the block ID and data value(s) for your custom material:");
        this.checkBoxLayeredRepeat.setSelected(true);
        this.checkBoxLayeredRepeat.setText("Repeat:");
        this.checkBoxLayeredRepeat.setEnabled(false);
        this.checkBoxLayeredRepeat.setHorizontalTextPosition(10);
        this.checkBoxLayeredRepeat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomMaterialDialog.this.checkBoxLayeredRepeatActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioButtonNoise).addComponent(this.jLabel1).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioButtonLayered).addComponent(this.radioButtonBlobs)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noiseSettingsEditorLayeredVariation, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerLayeredXAngle, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerLayeredYAngle, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerScale, -2, -1, -2)).addComponent(this.checkBoxLayeredRepeat)))).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonRemoveMaterial).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonAddMaterial))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.radioButtonNoise).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonBlobs).addComponent(this.jLabel3).addComponent(this.spinnerScale, -2, -1, -2)).addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonLayered).addComponent(this.checkBoxLayeredRepeat)).addGap(11, 11, 11).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.noiseSettingsEditorLayeredVariation, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.spinnerLayeredXAngle, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.spinnerLayeredYAngle, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 205, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonAddMaterial).addComponent(this.buttonRemoveMaterial)).addContainerGap()));
        this.jTabbedPane1.addTab("Complex", this.jPanel2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonLoad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxColour).addGap(0, 0, 0).addComponent(this.labelColour).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelectColour)).addComponent(this.fieldName, -2, -1, -2))).addComponent(this.jTabbedPane1, -2, -1, -2)).addGap(7, 7, 7).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.fieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.labelColour).addComponent(this.buttonSelectColour).addComponent(this.checkBoxColour)).addGap(18, 18, 18).addComponent(this.jTabbedPane1)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK).addComponent(this.buttonLoad).addComponent(this.buttonSave)).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void buttonAddMaterialActionPerformed(ActionEvent evt) {
        this.addMaterial();
    }

    private void buttonRemoveMaterialActionPerformed(ActionEvent evt) {
        this.removeMaterial();
    }

    private void radioButtonNoiseActionPerformed(ActionEvent evt) {
        this.setControlStates();
        this.configureTable();
        this.schedulePreviewUpdate();
    }

    private void radioButtonBlobsActionPerformed(ActionEvent evt) {
        this.setControlStates();
        this.configureTable();
        this.schedulePreviewUpdate();
    }

    private void checkBoxColourActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void buttonSelectColourActionPerformed(ActionEvent evt) {
        this.pickColour();
    }

    private void radioButtonLayeredActionPerformed(ActionEvent evt) {
        this.setControlStates();
        this.configureTable();
        this.schedulePreviewUpdate();
    }

    private void spinnerScaleStateChanged(ChangeEvent evt) {
        this.schedulePreviewUpdate();
    }

    private void checkBoxLayeredRepeatActionPerformed(ActionEvent evt) {
        this.setControlStates();
        this.schedulePreviewUpdate();
    }

    private void noiseSettingsEditorLayeredVariationStateChanged(ChangeEvent evt) {
        this.schedulePreviewUpdate();
    }

    private void spinnerLayeredXAngleStateChanged(ChangeEvent evt) {
        this.schedulePreviewUpdate();
    }

    private void formComponentResized(ComponentEvent evt) {
        this.schedulePreviewUpdate();
    }

    private void buttonSaveActionPerformed(ActionEvent evt) {
        this.saveMaterial();
    }

    private void buttonLoadActionPerformed(ActionEvent evt) {
        this.loadMaterial();
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.setControlStates();
            this.updateName();
            this.configureTable();
            this.schedulePreviewUpdate();
        }
    }

    private void updateName() {
        if (this.fieldName.getText().equals(this.previousCalculatedName)) {
            String calculatedName = this.createName();
            this.fieldName.setText(this.createName());
            this.previousCalculatedName = calculatedName;
        }
    }
}

