/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pepsoft.worldpainter.exporting.FirstPassLayerExporter;
import org.pepsoft.worldpainter.exporting.SecondPassLayerExporter;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;

public class CustomLayersTableModel
implements TableModel {
    private final List<CustomLayer> customLayers;
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private boolean orderPristine = true;
    private boolean exportsPristine = true;
    public static final int COLUMN_LAYER = 0;
    public static final int COLUMN_PALETTE = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_EXPORT = 3;
    private static final String[] COLUMN_NAMES = new String[]{"Layer", "Palette", "Type", "Export"};
    private static final Class<?>[] COLUMN_TYPES = new Class[]{CustomLayer.class, String.class, String.class, Boolean.class};
    public static final CustomLayer FIRST_PASS_HEADER = new CustomLayer("First export pass", null, null, -1, null){};
    public static final CustomLayer SECOND_PASS_HEADER = new CustomLayer("Second export pass", null, null, -1, null){};

    public CustomLayersTableModel(Collection<CustomLayer> allCustomLayers) {
        this.customLayers = new ArrayList<CustomLayer>(allCustomLayers);
        this.customLayers.sort((layer1, layer2) -> {
            boolean layer1FirstPass = FirstPassLayerExporter.class.isAssignableFrom(layer1.getExporterType());
            boolean layer2FirstPass = FirstPassLayerExporter.class.isAssignableFrom(layer2.getExporterType());
            if (layer1FirstPass && !layer2FirstPass) {
                return -1;
            }
            if (!layer1FirstPass && layer2FirstPass) {
                return 1;
            }
            return layer1.compareTo((Layer)layer2);
        });
        if (!this.customLayers.isEmpty()) {
            this.customLayers.add(0, FIRST_PASS_HEADER);
            for (int i = this.customLayers.size() - 1; i > 1; --i) {
                if (SecondPassLayerExporter.class.isAssignableFrom(this.customLayers.get(i).getExporterType())) continue;
                this.customLayers.add(i + 1, SECOND_PASS_HEADER);
                break;
            }
        }
    }

    public void swap(int rowIndex1, int rowIndex2) {
        if (this.isHeaderRow(rowIndex1) || this.isHeaderRow(rowIndex2)) {
            throw new IllegalArgumentException("Cannot swap with header rows");
        }
        CustomLayer layer = this.customLayers.get(rowIndex1);
        this.customLayers.set(rowIndex1, this.customLayers.get(rowIndex2));
        this.customLayers.set(rowIndex2, layer);
        this.orderPristine = false;
        TableModelEvent event = new TableModelEvent(this, Math.min(rowIndex1, rowIndex2), Math.max(rowIndex1, rowIndex2));
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }

    public void setExport(int rowIndex, boolean export) {
        CustomLayer layer = this.customLayers.get(rowIndex);
        if (this.isHeader(layer)) {
            throw new IllegalArgumentException("Cannot set export property of header rows");
        }
        if (export != layer.isExport()) {
            layer.setExport(export);
            TableModelEvent event = new TableModelEvent(this, rowIndex, rowIndex, 3);
            for (TableModelListener listener : this.listeners) {
                listener.tableChanged(event);
            }
        }
    }

    public boolean isPristine() {
        return this.orderPristine && this.exportsPristine;
    }

    public boolean isHeaderRow(int rowIndex) {
        return this.isHeader(this.customLayers.get(rowIndex));
    }

    public boolean isHeader(CustomLayer layer) {
        return layer == FIRST_PASS_HEADER || layer == SECOND_PASS_HEADER;
    }

    public void save() {
        if (!this.orderPristine) {
            int index = 0;
            for (CustomLayer layer : this.customLayers) {
                if (this.isHeader(layer)) continue;
                layer.setExportIndex(Integer.valueOf(index++));
            }
        }
    }

    public int getLayerIndex(CustomLayer layer) {
        return this.customLayers.indexOf(layer);
    }

    @Override
    public int getRowCount() {
        return this.customLayers.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_TYPES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 3 && !this.isHeaderRow(rowIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CustomLayer layer = this.customLayers.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return layer;
            }
            case 2: {
                return this.isHeader(layer) ? null : layer.getType();
            }
            case 1: {
                return this.isHeader(layer) ? null : layer.getPalette();
            }
            case 3: {
                return this.isHeader(layer) ? null : Boolean.valueOf(layer.isExport());
            }
        }
        throw new IndexOutOfBoundsException("columnIndex " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 3 || this.isHeaderRow(rowIndex)) {
            throw new IllegalArgumentException();
        }
        this.customLayers.get(rowIndex).setExport(((Boolean)aValue).booleanValue());
        this.exportsPristine = false;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }
}

