/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AtomicDouble;
import com.jidesoft.docking.DockableFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.zip.GZIPOutputStream;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.swing.BetterJPopupMenu;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.DeleteLayersDialog;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.importing.CustomItemsTreeModel;
import org.pepsoft.worldpainter.layers.AbstractEditLayerDialog;
import org.pepsoft.worldpainter.layers.Bo2Layer;
import org.pepsoft.worldpainter.layers.CombinedLayer;
import org.pepsoft.worldpainter.layers.CustomAnnotationLayer;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.EditLayerDialog;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.LayerContainer;
import org.pepsoft.worldpainter.layers.annotation.CustomAnnotationLayerDialog;
import org.pepsoft.worldpainter.layers.groundcover.GroundCoverLayer;
import org.pepsoft.worldpainter.layers.plants.PlantLayer;
import org.pepsoft.worldpainter.layers.pockets.UndergroundPocketsDialog;
import org.pepsoft.worldpainter.layers.pockets.UndergroundPocketsLayer;
import org.pepsoft.worldpainter.layers.tunnel.FloatingLayerDialog;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayer;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayerDialog;
import org.pepsoft.worldpainter.operations.Filter;
import org.pepsoft.worldpainter.operations.PaintOperation;
import org.pepsoft.worldpainter.painting.LayerPaint;
import org.pepsoft.worldpainter.palettes.Palette;
import org.pepsoft.worldpainter.palettes.PaletteManager;
import org.pepsoft.worldpainter.panels.DefaultFilter;
import org.pepsoft.worldpainter.plugins.CustomLayerProvider;
import org.pepsoft.worldpainter.plugins.WPPluginManager;
import org.pepsoft.worldpainter.util.FileFilter;
import org.pepsoft.worldpainter.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLayerController
implements PropertyChangeListener {
    private final App app;
    final PaletteManager paletteManager = new PaletteManager(this);
    private static final ResourceBundle strings = ResourceBundle.getBundle("org.pepsoft.worldpainter.resources.strings");
    private static final String EDITING_FLOOR_DIMENSION_KEY = "org.pepsoft.worldpainter.TunnelLayer.editingFloorDimension";
    private static final String LAYER_PALETTE_TIP_KEY = "org.pepsoft.worldpainter.layerPaletteTip";
    private static final Icon ADD_CUSTOM_LAYER_BUTTON_ICON = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/plus.png");
    private static final Logger logger = LoggerFactory.getLogger(CustomLayerController.class);

    CustomLayerController(App app) {
        this.app = app;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof Palette && (evt.getPropertyName().equals("show") || evt.getPropertyName().equals("solo"))) {
            if (evt.getPropertyName().equals("solo") && evt.getNewValue() == Boolean.TRUE) {
                for (Palette palette : this.paletteManager.getPalettes()) {
                    if (palette == evt.getSource() || !palette.isSolo()) continue;
                    palette.setSolo(false);
                }
            }
            this.app.updateLayerVisibility();
        }
    }

    public List<Component> createCustomLayerButton(final CustomLayer layer) {
        List<Component> buttonComponents = this.app.createLayerButton((Layer)layer, '\u0000');
        final JToggleButton button = (JToggleButton)buttonComponents.get(2);
        button.setToolTipText(button.getToolTipText() + "; right-click for options");
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            private void showPopup(MouseEvent e) {
                TunnelLayer tunnelLayer;
                Object floorDimensionId;
                BetterJPopupMenu popup = new BetterJPopupMenu();
                JMenuItem menuItem = new JMenuItem(strings.getString("edit") + "...");
                menuItem.addActionListener(e1 -> CustomLayerController.this.editCustomLayer(layer));
                popup.add(menuItem);
                Dimension dimension = CustomLayerController.this.app.getDimension();
                if (layer instanceof TunnelLayer && (floorDimensionId = (tunnelLayer = (TunnelLayer)layer).getFloorDimensionId()) != null) {
                    String shortName;
                    String longName = switch (tunnelLayer.getLayerMode()) {
                        case TunnelLayer.LayerMode.CAVE -> {
                            shortName = "floor dimension";
                            yield "Custom Cave/Tunnel layer floor dimension";
                        }
                        case TunnelLayer.LayerMode.FLOATING -> {
                            shortName = "floating dimension";
                            yield "Floating Dimension";
                        }
                        default -> throw new InternalError("Unknown layer mode " + tunnelLayer.getLayerMode());
                    };
                    menuItem = new JMenuItem("Edit " + shortName);
                    if (dimension.containsOneOf(new Layer[]{tunnelLayer})) {
                        menuItem.addActionListener(e1 -> {
                            Configuration config;
                            Point viewPosition = CustomLayerController.this.app.view.getViewCentreInWorldCoords();
                            Dimension floorDimension = tunnelLayer.updateFloorDimension(dimension, null);
                            CustomLayerController.this.app.setDimension(floorDimension);
                            CustomLayerController.this.app.view.moveTo(viewPosition);
                            int minX = Integer.MAX_VALUE;
                            int maxX = Integer.MIN_VALUE;
                            int minY = Integer.MAX_VALUE;
                            int maxY = Integer.MIN_VALUE;
                            Rectangle visibleArea = CustomLayerController.this.app.view.getVisibleArea();
                            boolean floorTileVisible = false;
                            for (Tile tile : floorDimension.getTiles()) {
                                if (visibleArea.contains(tile.getX() << 7, tile.getY() << 7) && visibleArea.contains((tile.getX() << 7) + 128 - 1, (tile.getY() << 7) + 128 - 1)) {
                                    floorTileVisible = true;
                                    break;
                                }
                                if (tile.getX() < minX) {
                                    minX = tile.getX();
                                }
                                if (tile.getX() > maxX) {
                                    maxX = tile.getX();
                                }
                                if (tile.getY() < minY) {
                                    minY = tile.getY();
                                }
                                if (tile.getY() <= maxY) continue;
                                maxY = tile.getY();
                            }
                            if (!floorTileVisible && minX != Integer.MAX_VALUE) {
                                CustomLayerController.this.app.view.moveTo(((maxX + minX) / 2 << 7) + 64, ((maxY + minY) / 2 << 7) + 64);
                            }
                            if (!(config = Configuration.getInstance()).isMessageDisplayedCountAtLeast(CustomLayerController.EDITING_FLOOR_DIMENSION_KEY, 3)) {
                                AwtUtils.doLaterOnEventThread(() -> JOptionPane.showMessageDialog(CustomLayerController.this.app, "Press Esc to finish editing the " + longName + ",\nor select the Surface dimension from the app.view menu or by pressing " + App.COMMAND_KEY_NAME + "+U", "Editing " + longName, 1));
                                config.setMessageDisplayed(CustomLayerController.EDITING_FLOOR_DIMENSION_KEY);
                            }
                            JLabel label = new JLabel("<html><font size='+1'>Press Esc to leave the " + longName + ".</font></html>");
                            label.setBorder(new CompoundBorder(new LineBorder(Color.BLACK), new EmptyBorder(5, 5, 5, 5)));
                            CustomLayerController.this.app.pushGlassPaneComponent(label);
                        });
                    } else {
                        menuItem.setEnabled(false);
                    }
                    popup.add(menuItem);
                }
                menuItem = new JMenuItem("Find");
                menuItem.addActionListener(e1 -> CustomLayerController.this.findLayer((Layer)layer));
                popup.add(menuItem);
                menuItem = new JMenuItem("Duplicate...");
                if (layer.isExportableToFile()) {
                    menuItem.addActionListener(e1 -> this.duplicate());
                } else {
                    menuItem.setEnabled(false);
                    menuItem.setToolTipText("This layer cannot be duplicated.");
                }
                popup.add(menuItem);
                menuItem = new JMenuItem(strings.getString("remove") + "...");
                menuItem.addActionListener(e1 -> this.remove());
                popup.add(menuItem);
                menuItem = new JMenuItem("Export to file...");
                if (layer.isExportableToFile()) {
                    menuItem.addActionListener(e1 -> CustomLayerController.this.exportLayer(layer));
                } else {
                    menuItem.setEnabled(false);
                    menuItem.setToolTipText("This layer cannot be exported to a file.");
                }
                popup.add(menuItem);
                JMenu paletteMenu = new JMenu("Move to palette");
                for (Palette palette : CustomLayerController.this.paletteManager.getPalettes()) {
                    menuItem = new JMenuItem(palette.getName());
                    menuItem.addActionListener(e1 -> CustomLayerController.this.moveLayerToPalette(layer, palette));
                    if (palette.contains((Layer)layer)) {
                        menuItem.setEnabled(false);
                    }
                    paletteMenu.add(menuItem);
                }
                menuItem = new JMenuItem("New palette...");
                menuItem.addActionListener(e1 -> CustomLayerController.this.createNewLayerPalette(layer));
                paletteMenu.add(menuItem);
                popup.add(paletteMenu);
                List actions = layer.getActions();
                if (actions != null) {
                    for (Action action : actions) {
                        action.putValue("org.pepsoft.worldpainter.dimension", dimension);
                        popup.add(new JMenuItem(action));
                    }
                }
                popup.show(button, e.getX(), e.getY());
            }

            private void duplicate() {
                CustomLayer duplicate = layer.clone();
                duplicate.setName("Copy of " + layer.getName());
                Object paint = layer.getPaint();
                if (paint instanceof Color) {
                    Color colour = (Color)paint;
                    float[] hsb = Color.RGBtoHSB(colour.getRed(), colour.getGreen(), colour.getBlue(), null);
                    hsb[0] = hsb[0] + 0.083333336f;
                    if (hsb[0] > 1.0f) {
                        hsb[0] = hsb[0] - 1.0f;
                    }
                    colour = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
                    duplicate.setPaint((Object)colour);
                }
                AbstractEditLayerDialog<CustomLayer> dialog = CustomLayerController.this.createEditLayerDialog(duplicate);
                dialog.setVisible(() -> CustomLayerController.this.registerCustomLayer((CustomLayer)dialog.getLayer(), true));
            }

            private void remove() {
                if (JOptionPane.showConfirmDialog(CustomLayerController.this.app, MessageFormat.format(strings.getString("are.you.sure.you.want.to.remove.the.0.layer"), layer.getName()), MessageFormat.format(strings.getString("confirm.0.removal"), layer.getName()), 0) == 0) {
                    CustomLayerController.this.deleteCustomLayer(layer);
                    CustomLayerController.this.app.validate();
                }
            }
        });
        return buttonComponents;
    }

    public void layerRemoved(CustomLayer layer) {
        this.app.layerRemoved((Layer)layer);
    }

    public List<Component> createPopupMenuButton() {
        JButton addLayerButton = new JButton(ADD_CUSTOM_LAYER_BUTTON_ICON);
        addLayerButton.setToolTipText(strings.getString("add.a.custom.layer"));
        addLayerButton.setMargin(new Insets(2, 2, 2, 2));
        addLayerButton.addActionListener(e -> {
            Container parent;
            if (this.app.getDimension() == null) {
                DesktopUtils.beep();
                return;
            }
            for (parent = addLayerButton.getParent(); parent != null && !(parent instanceof DockableFrame); parent = parent.getParent()) {
            }
            if (parent != null) {
                String nameKey = ((DockableFrame)parent).getKey();
                String paletteName = nameKey.substring(nameKey.indexOf(46) + 1);
                JPopupMenu customLayerMenu = this.createCustomLayerMenu(paletteName);
                customLayerMenu.show(addLayerButton, addLayerButton.getWidth(), 0);
            } else {
                logger.error("Could not find palette add layer button is on");
                DesktopUtils.beep();
            }
        });
        ArrayList<Component> addLayerButtonPanel = new ArrayList<Component>(3);
        addLayerButtonPanel.add(new JPanel());
        addLayerButtonPanel.add(new JPanel());
        addLayerButtonPanel.add(addLayerButton);
        return addLayerButtonPanel;
    }

    void registerCustomLayer(CustomLayer layer, boolean activate) {
        Palette palette = this.paletteManager.register(layer);
        if (palette != null) {
            this.app.dockingManager.addFrame(palette.getDockableFrame());
            this.app.dockingManager.dockFrame(palette.getDockableFrame().getKey(), 8, 3);
            if (activate) {
                this.app.dockingManager.activateFrame(palette.getDockableFrame().getKey());
            }
            palette.addPropertyChangeListener(this);
        } else {
            this.app.validate();
        }
        if (activate) {
            this.paletteManager.activate(layer);
        }
        Configuration config = Configuration.getInstance();
        if (activate && this.paletteManager.getPaletteContaining(layer).getLayers().size() >= 25 && !config.isMessageDisplayed(LAYER_PALETTE_TIP_KEY)) {
            MessageUtils.showInfo((Component)this.app, (String)"Tip: you can distribute Custom Layers over multiple\npalettes by right-clicking on the layer button and\nselecting Move to palette \u2192 New palette...", (String)"Layer Palette Tip");
            config.setMessageDisplayed(LAYER_PALETTE_TIP_KEY);
        }
    }

    void unregisterCustomLayer(CustomLayer layer) {
        Palette palette = this.paletteManager.unregister(layer);
        this.app.layerSoloCheckBoxes.remove(layer);
        if (palette.isEmpty()) {
            palette.removePropertyChangeListener(this);
            this.paletteManager.delete(palette);
            this.app.dockingManager.removeFrame(palette.getDockableFrame().getKey());
        }
    }

    JPopupMenu createCustomLayerMenu(String paletteName) {
        World2 world = this.app.getWorld();
        BetterJPopupMenu customLayerMenu = new BetterJPopupMenu();
        JMenuItem menuItem = new JMenuItem(strings.getString("add.a.custom.object.layer") + "...");
        menuItem.addActionListener(e -> {
            EditLayerDialog<Class<Bo2Layer>> dialog = new EditLayerDialog<Class<Bo2Layer>>((Window)this.app, world.getPlatform(), Bo2Layer.class);
            dialog.setVisible(() -> {
                Bo2Layer layer = (Bo2Layer)dialog.getLayer();
                if (paletteName != null) {
                    layer.setPalette(paletteName);
                }
                this.registerCustomLayer((CustomLayer)layer, true);
            });
        });
        customLayerMenu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("add.a.custom.ground.cover.layer") + "...");
        menuItem.addActionListener(e -> {
            EditLayerDialog<Class<GroundCoverLayer>> dialog = new EditLayerDialog<Class<GroundCoverLayer>>((Window)this.app, world.getPlatform(), GroundCoverLayer.class);
            dialog.setVisible(() -> {
                GroundCoverLayer layer = (GroundCoverLayer)dialog.getLayer();
                if (paletteName != null) {
                    layer.setPalette(paletteName);
                }
                this.registerCustomLayer((CustomLayer)layer, true);
            });
        });
        customLayerMenu.add(menuItem);
        Dimension dimension = this.app.getDimension();
        Dimension.Anchor anchor = dimension.getAnchor();
        menuItem = new JMenuItem(strings.getString("add.a.custom.underground.pockets.layer") + "...");
        menuItem.addActionListener(e -> {
            UndergroundPocketsDialog dialog = new UndergroundPocketsDialog((Window)this.app, world.getPlatform(), MixedMaterial.create((Platform)world.getPlatform(), (Material)Material.IRON_BLOCK), this.app.getColourScheme(), dimension.getMinHeight(), dimension.getMaxHeight(), world.isExtendedBlockIds());
            dialog.setVisible(() -> {
                UndergroundPocketsLayer layer = dialog.getLayer();
                if (paletteName != null) {
                    layer.setPalette(paletteName);
                }
                this.registerCustomLayer((CustomLayer)layer, true);
            });
        });
        if (anchor.role == Dimension.Role.CAVE_FLOOR || anchor.role == Dimension.Role.FLOATING_FLOOR) {
            menuItem.setEnabled(false);
        }
        customLayerMenu.add(menuItem);
        menuItem = new JMenuItem("Add a custom cave/tunnel layer...");
        menuItem.addActionListener(e -> {
            int waterLevel;
            int baseHeight;
            TunnelLayer layer = new TunnelLayer("Tunnels", TunnelLayer.LayerMode.CAVE, (Object)Color.BLACK, world.getPlatform());
            TileFactory tileFactory = dimension.getTileFactory();
            if (tileFactory instanceof HeightMapTileFactory) {
                baseHeight = (int)((HeightMapTileFactory)tileFactory).getBaseHeight();
                waterLevel = ((HeightMapTileFactory)tileFactory).getWaterHeight();
                layer.setFloodWithLava(((HeightMapTileFactory)tileFactory).isFloodWithLava());
            } else {
                baseHeight = 58;
                waterLevel = 62;
            }
            TunnelLayerDialog dialog = new TunnelLayerDialog(this.app, world.getPlatform(), layer, dimension, world.isExtendedBlockIds(), this.app.getColourScheme(), this.app.getCustomBiomeManager(), dimension.getMinHeight(), dimension.getMaxHeight(), baseHeight, waterLevel);
            dialog.setVisible(() -> {
                if (paletteName != null) {
                    layer.setPalette(paletteName);
                }
                this.registerCustomLayer((CustomLayer)layer, true);
            });
        });
        if (anchor.role == Dimension.Role.CAVE_FLOOR || anchor.role == Dimension.Role.FLOATING_FLOOR) {
            menuItem.setEnabled(false);
        }
        customLayerMenu.add(menuItem);
        menuItem = new JMenuItem("Add a custom plants layer...");
        menuItem.addActionListener(e -> {
            EditLayerDialog<Class<PlantLayer>> dialog = new EditLayerDialog<Class<PlantLayer>>((Window)this.app, world.getPlatform(), PlantLayer.class);
            dialog.setVisible(() -> {
                PlantLayer layer = (PlantLayer)dialog.getLayer();
                if (paletteName != null) {
                    layer.setPalette(paletteName);
                }
                this.registerCustomLayer((CustomLayer)layer, true);
            });
        });
        customLayerMenu.add(menuItem);
        menuItem = new JMenuItem("Add a combined layer...");
        menuItem.addActionListener(e -> {
            EditLayerDialog<Class<CombinedLayer>> dialog = new EditLayerDialog<Class<CombinedLayer>>((Window)this.app, world.getPlatform(), CombinedLayer.class);
            dialog.setVisible(() -> {
                CombinedLayer layer = (CombinedLayer)dialog.getLayer();
                if (paletteName != null) {
                    layer.setPalette(paletteName);
                }
                this.registerCustomLayer((CustomLayer)layer, true);
            });
        });
        customLayerMenu.add(menuItem);
        menuItem = new JMenuItem("Add a custom annotations layer...");
        menuItem.addActionListener(e -> {
            CustomAnnotationLayerDialog dialog = new CustomAnnotationLayerDialog((Window)this.app, new CustomAnnotationLayer("My Custom Annotation", "A custom annotations layer", (Object)Color.YELLOW));
            dialog.setVisible(() -> {
                CustomAnnotationLayer layer = dialog.getLayer();
                if (paletteName != null) {
                    layer.setPalette(paletteName);
                }
                this.registerCustomLayer((CustomLayer)layer, true);
            });
        });
        customLayerMenu.add(menuItem);
        menuItem = new JMenuItem("[ALPHA] Add a floating dimension...");
        menuItem.addActionListener(e -> {
            int waterLevel;
            int baseHeight;
            TunnelLayer layer = new TunnelLayer("Floating Dimension", TunnelLayer.LayerMode.FLOATING, (Object)Color.CYAN, world.getPlatform());
            layer.setFloorMode(TunnelLayer.Mode.FIXED_HEIGHT_ABOVE_FLOOR);
            layer.setFloorLevel(16);
            layer.setBottomEdgeShape(TunnelLayer.EdgeShape.ROUNDED);
            TileFactory tileFactory = dimension.getTileFactory();
            if (tileFactory instanceof HeightMapTileFactory) {
                baseHeight = (int)((HeightMapTileFactory)tileFactory).getBaseHeight();
                waterLevel = ((HeightMapTileFactory)tileFactory).getWaterHeight();
                layer.setFloodWithLava(((HeightMapTileFactory)tileFactory).isFloodWithLava());
            } else {
                baseHeight = 58;
                waterLevel = 62;
            }
            FloatingLayerDialog dialog = new FloatingLayerDialog(this.app, world.getPlatform(), layer, dimension, world.isExtendedBlockIds(), this.app.getColourScheme(), this.app.getCustomBiomeManager(), dimension.getMinHeight(), dimension.getMaxHeight(), baseHeight, waterLevel);
            dialog.setVisible(() -> {
                if (paletteName != null) {
                    layer.setPalette(paletteName);
                }
                this.registerCustomLayer((CustomLayer)layer, true);
            });
        });
        if (anchor.role == Dimension.Role.CAVE_FLOOR || anchor.role == Dimension.Role.FLOATING_FLOOR) {
            menuItem.setEnabled(false);
        }
        customLayerMenu.add(menuItem);
        ArrayList allPluginLayers = new ArrayList();
        for (CustomLayerProvider layerProvider : WPPluginManager.getInstance().getPlugins(CustomLayerProvider.class)) {
            allPluginLayers.addAll(layerProvider.getCustomLayers());
        }
        if (!allPluginLayers.isEmpty()) {
            customLayerMenu.addSeparator();
            for (Class customLayerClass : allPluginLayers) {
                menuItem = new JMenuItem("Add a " + customLayerClass.getSimpleName() + " layer...");
                menuItem.addActionListener(e -> {
                    EditLayerDialog<Class> dialog = new EditLayerDialog<Class>((Window)this.app, world.getPlatform(), customLayerClass);
                    dialog.setVisible(() -> {
                        CustomLayer layer = (CustomLayer)dialog.getLayer();
                        if (paletteName != null) {
                            layer.setPalette(paletteName);
                        }
                        this.registerCustomLayer(layer, true);
                    });
                });
                customLayerMenu.add(menuItem);
            }
            customLayerMenu.addSeparator();
        }
        menuItem = new JMenu("Copy layer from another dimension");
        menuItem.setToolTipText("This will make a duplicate of the layer, with its own identity and separate settings");
        Function<Layer, Boolean> filter = this.app.getLayerFilterForCurrentDimension();
        List<JMenuItem> copyMenuItems = this.getCopyLayerMenuItems(paletteName != null ? paletteName : "Custom Layers", filter);
        if (!copyMenuItems.isEmpty()) {
            for (JMenuItem copyMenuItem : copyMenuItems) {
                ((JMenu)menuItem).add(copyMenuItem);
            }
        } else {
            menuItem.setEnabled(false);
        }
        customLayerMenu.add(menuItem);
        menuItem = new JMenuItem("Import custom layer(s) from file...");
        menuItem.addActionListener(e -> this.app.importLayers(paletteName, filter));
        customLayerMenu.add(menuItem);
        menuItem = new JMenuItem("Import custom layer(s) from another world...");
        menuItem.addActionListener(e -> this.app.importCustomItemsFromWorld(CustomItemsTreeModel.ItemType.LAYER, filter));
        customLayerMenu.add(menuItem);
        return customLayerMenu;
    }

    void editCustomLayer(CustomLayer layer, Runnable callback) {
        Object previousPaint = layer.getPaint();
        float previousOpacity = layer.getOpacity();
        BufferedImage previousIcon = layer.getIcon();
        AbstractEditLayerDialog<CustomLayer> dialog = this.createEditLayerDialog(layer);
        dialog.setVisible(() -> {
            JComponent control;
            App.LayerControls layerControls = this.app.layerControls.get(layer);
            JComponent jComponent = control = layerControls != null ? layerControls.control : null;
            if (control != null) {
                if (control instanceof AbstractButton) {
                    ((AbstractButton)control).setText(layer.getName());
                }
                control.setToolTipText(layer.getName() + ": " + layer.getDescription() + "; right-click for options");
            }
            Object newPaint = layer.getPaint();
            float newOpacity = layer.getOpacity();
            BufferedImage newIcon = layer.getIcon();
            boolean viewRefreshed = false;
            if (!Objects.equals(newIcon, previousIcon) && control instanceof AbstractButton) {
                ((AbstractButton)control).setIcon(new ImageIcon(layer.getIcon()));
            }
            if (!Objects.equals(newPaint, previousPaint) || newOpacity != previousOpacity) {
                this.app.view.refreshTilesForLayer((Layer)layer, false);
                viewRefreshed = true;
            }
            this.app.getDimension().changed();
            if (layer instanceof CombinedLayer) {
                this.updateHiddenLayers();
            }
            if (layer instanceof TunnelLayer && !viewRefreshed) {
                this.app.view.refreshTilesForLayer((Layer)layer, false);
            }
            if (callback != null) {
                callback.run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteCustomLayer(CustomLayer layer) {
        Dimension dimension = this.app.getDimension();
        if (this.app.getActiveOperation() instanceof PaintOperation && this.app.paint instanceof LayerPaint && ((LayerPaint)this.app.paint).getLayer() == layer) {
            this.app.deselectPaint();
        }
        dimension.setEventsInhibited(true);
        try {
            dimension.clearLayerData((Layer)layer);
            if (layer instanceof TunnelLayer && ((TunnelLayer)layer).getFloorDimensionId() != null) {
                Dimension.Anchor anchor = dimension.getAnchor();
                this.app.getWorld().removeDimension(new Dimension.Anchor(anchor.dim, ((TunnelLayer)layer).getLayerMode() == TunnelLayer.LayerMode.CAVE ? Dimension.Role.CAVE_FLOOR : Dimension.Role.FLOATING_FLOOR, anchor.invert, ((TunnelLayer)layer).getFloorDimensionId().intValue()));
            }
            dimension.clearUndo();
        }
        finally {
            dimension.setEventsInhibited(false);
        }
        this.unregisterCustomLayer(layer);
        boolean visibleLayersChanged = false;
        if (this.app.getHiddenLayers().contains(layer)) {
            this.app.hiddenLayers.remove(layer);
            visibleLayersChanged = true;
        }
        if (layer.equals((Object)this.app.soloLayer)) {
            this.app.soloLayer = null;
            visibleLayersChanged = true;
        }
        if (layer instanceof LayerContainer) {
            boolean layersUnhidden = false;
            for (Layer subLayer : ((LayerContainer)layer).getLayers()) {
                if (!(subLayer instanceof CustomLayer) || !((CustomLayer)subLayer).isHide()) continue;
                ((CustomLayer)subLayer).setHide(false);
                layersUnhidden = true;
            }
            if (layersUnhidden) {
                this.updateHiddenLayers();
                visibleLayersChanged = false;
            }
        }
        if (visibleLayersChanged) {
            this.app.updateLayerVisibility();
        }
    }

    void deleteUnusedLayers() {
        Dimension dimension = this.app.getDimension();
        if (dimension == null) {
            DesktopUtils.beep();
            return;
        }
        List<CustomLayer> unusedLayers = this.getCustomLayers();
        Set layersInUse = dimension.getAllLayers(true);
        unusedLayers.removeAll(layersInUse);
        if (unusedLayers.isEmpty()) {
            MessageUtils.showInfo((Component)this.app, (String)"There are no unused layers in this dimension.", (String)"No Unused Layers");
        } else {
            DeleteLayersDialog dialog = new DeleteLayersDialog((Window)this.app, unusedLayers);
            dialog.setVisible(true);
            if (!dialog.isCancelled()) {
                MessageUtils.showInfo((Component)this.app, (String)"The selected layers have been deleted.", (String)"Layers Deleted");
            }
        }
    }

    List<CustomLayer> getCustomLayers() {
        ArrayList<CustomLayer> customLayers = new ArrayList<CustomLayer>(256);
        customLayers.addAll(this.paletteManager.getLayers());
        customLayers.addAll(this.app.layersWithNoButton);
        customLayers.sort(Comparator.comparing(Layer::getName));
        return customLayers;
    }

    Map<String, Collection<CustomLayer>> getCustomLayersByPalette() {
        Map<String, Collection<CustomLayer>> customLayers = this.paletteManager.getLayersByPalette();
        if (!this.app.layersWithNoButton.isEmpty()) {
            customLayers.put(null, this.app.layersWithNoButton);
        }
        return customLayers;
    }

    boolean importCustomLayer(CustomLayer layer) {
        boolean customTerrainButtonsAdded = false;
        layer.setExportIndex(null);
        this.registerCustomLayer(layer, true);
        if (layer instanceof CombinedLayer) {
            CombinedLayer combinedLayer = (CombinedLayer)layer;
            this.importLayersFromCombinedLayer(combinedLayer);
            if (!combinedLayer.restoreCustomTerrain()) {
                MessageUtils.showWarning((Component)this.app, (String)"The layer contained a Custom Terrain which could not be restored. The terrain has been reset.", (String)"Custom Terrain Not Restored");
            } else {
                Terrain terrain = combinedLayer.getTerrain();
                if (terrain != null && terrain.isCustom() && this.app.customMaterialButtons[terrain.getCustomTerrainIndex()] == null) {
                    customTerrainButtonsAdded = true;
                    this.app.addButtonForNewCustomTerrain(terrain.getCustomTerrainIndex(), Terrain.getCustomMaterial((int)terrain.getCustomTerrainIndex()), false);
                }
            }
        }
        return customTerrainButtonsAdded;
    }

    private void updateHiddenLayers() {
        this.paletteManager.getLayers().stream().filter(CustomLayer::isHide).forEach(layer -> {
            if (this.app.getActiveOperation() instanceof PaintOperation && this.app.paint instanceof LayerPaint && ((LayerPaint)this.app.paint).getLayer().equals(layer)) {
                this.app.deselectPaint();
            }
            this.unregisterCustomLayer((CustomLayer)layer);
            this.app.hiddenLayers.remove(layer);
            if (layer.equals((Object)this.app.soloLayer)) {
                this.app.soloLayer = null;
            }
            this.app.layersWithNoButton.add((CustomLayer)layer);
        });
        Iterator<CustomLayer> i = this.app.layersWithNoButton.iterator();
        while (i.hasNext()) {
            CustomLayer layer2 = i.next();
            if (layer2.isHide()) continue;
            i.remove();
            this.registerCustomLayer(layer2, false);
        }
        this.app.updateLayerVisibility();
    }

    private void importLayersFromCombinedLayer(CombinedLayer combinedLayer) {
        combinedLayer.getLayers().stream().filter(layer -> layer instanceof CustomLayer && !this.paletteManager.contains((Layer)layer) && !this.app.layersWithNoButton.contains(layer)).forEach(layer -> {
            CustomLayer customLayer = (CustomLayer)layer;
            customLayer.setExportIndex(null);
            if (customLayer.isHide()) {
                this.app.layersWithNoButton.add(customLayer);
            } else {
                this.registerCustomLayer(customLayer, false);
            }
            if (layer instanceof CombinedLayer) {
                this.importLayersFromCombinedLayer((CombinedLayer)customLayer);
            }
        });
    }

    private void findLayer(Layer layer) {
        WorldPainter view = this.app.view;
        Dimension dimension = this.app.getDimension();
        int tileX = view.getViewX() >> 7;
        int tileY = view.getViewY() >> 7;
        AtomicInteger closestTileX = new AtomicInteger();
        AtomicInteger closestTileY = new AtomicInteger();
        AtomicDouble closestDistance = new AtomicDouble(Double.MAX_VALUE);
        dimension.visitTiles().forFilter((Filter)DefaultFilter.buildForDimension((Dimension)dimension).onlyOn((Object)layer).build()).andDo(tile -> {
            if (!this.isLayerSet(tile, layer)) {
                return;
            }
            float distance = MathUtils.getDistance((int)(tile.getX() - tileX), (int)(tile.getY() - tileY));
            if (distance < closestDistance.floatValue()) {
                closestDistance.set((double)distance);
                closestTileX.set(tile.getX());
                closestTileY.set(tile.getY());
            }
        });
        if (closestDistance.get() == Double.MAX_VALUE) {
            DesktopUtils.beep();
            MessageUtils.showInfo((Component)((Object)view), (String)("Layer " + layer + " is not in use in the current dimension"), (String)"Layer Not Present");
        } else {
            view.moveTo((closestTileX.get() << 7) + 64, (closestTileY.get() << 7) + 64);
        }
    }

    private boolean isLayerSet(Tile tile, Layer layer) {
        switch (layer.dataSize) {
            case BIT: 
            case BIT_PER_CHUNK: {
                boolean defaultBitValue = layer.getDefaultValue() != 0;
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        if (tile.getBitLayerValue(layer, x, y) == defaultBitValue) continue;
                        return true;
                    }
                }
                return false;
            }
            case NIBBLE: 
            case BYTE: {
                int defaultValue = layer.getDefaultValue();
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        if (tile.getLayerValue(layer, x, y) == defaultValue) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid data size " + layer.dataSize);
    }

    private void editCustomLayer(CustomLayer layer) {
        this.editCustomLayer(layer, null);
    }

    private void exportLayer(CustomLayer layer) {
        File selectedFile;
        Configuration config = Configuration.getInstance();
        File layerDirectory = config.getLayerDirectory();
        if (layerDirectory == null || !layerDirectory.isDirectory()) {
            layerDirectory = DesktopUtils.getDocumentsFolder();
        }
        if ((selectedFile = FileUtils.selectFileForSave(this.app, "Export WorldPainter layer file", new File(layerDirectory, org.pepsoft.util.FileUtils.sanitiseName((String)layer.getName()) + ".layer"), new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".layer");
            }

            @Override
            public String getDescription() {
                return "WorldPainter Custom Layers (*.layer)";
            }

            @Override
            public String getExtensions() {
                return "*.layer";
            }
        })) != null) {
            if (!selectedFile.getName().toLowerCase().endsWith(".layer")) {
                selectedFile = new File(selectedFile.getPath() + ".layer");
            }
            if (selectedFile.isFile() && JOptionPane.showConfirmDialog(this.app, "The file " + selectedFile.getName() + " already exists.\nDo you want to overwrite it?", "Overwrite File", 0) == 1) {
                return;
            }
            try (ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(selectedFile))));){
                out.writeObject(layer);
            }
            catch (IOException e) {
                throw new RuntimeException("I/O error while trying to write " + selectedFile, e);
            }
            config.setLayerDirectory(selectedFile.getParentFile());
            MessageUtils.showInfo((Component)this.app, (String)("Layer " + layer.getName() + " exported successfully"), (String)"Success");
        }
    }

    private void moveLayerToPalette(CustomLayer layer, Palette destPalette) {
        Palette srcPalette = this.paletteManager.move(layer, destPalette);
        if (srcPalette.isEmpty()) {
            this.app.dockingManager.removeFrame(srcPalette.getDockableFrame().getKey());
            srcPalette.removePropertyChangeListener(this);
            this.paletteManager.delete(srcPalette);
        }
        this.app.validate();
    }

    private void createNewLayerPalette(CustomLayer layer) {
        String name = JOptionPane.showInputDialog(this.app, "Enter a unique name for the new palette:", "New Palette", 3);
        if (name != null) {
            if ((name = name.trim()).isEmpty()) {
                MessageUtils.beepAndShowError((Component)this.app, (String)"Palette name cannot be empty", (String)"Invalid Name");
                return;
            }
            if (this.paletteManager.getPalette(name) != null) {
                JOptionPane.showMessageDialog(this.app, "There is already a palette with that name!", "Duplicate Name", 0);
                return;
            }
            Palette destPalette = this.paletteManager.create(name);
            this.app.dockingManager.addFrame(destPalette.getDockableFrame());
            this.app.dockingManager.dockFrame(destPalette.getDockableFrame().getKey(), 8, 3);
            this.moveLayerToPalette(layer, destPalette);
            this.app.dockingManager.activateFrame(destPalette.getDockableFrame().getKey());
            destPalette.addPropertyChangeListener(this);
        }
    }

    @NotNull
    private <L extends CustomLayer> AbstractEditLayerDialog<L> createEditLayerDialog(L layer) {
        AbstractEditLayerDialog dialog;
        World2 world = this.app.getWorld();
        Dimension dimension = this.app.getDimension();
        if (layer instanceof UndergroundPocketsLayer) {
            dialog = new UndergroundPocketsDialog((Window)this.app, world.getPlatform(), (UndergroundPocketsLayer)layer, this.app.getColourScheme(), dimension.getMinHeight(), dimension.getMaxHeight(), world.isExtendedBlockIds());
        } else if (layer instanceof TunnelLayer) {
            int waterLevel;
            int baseHeight;
            TileFactory tileFactory = dimension.getTileFactory();
            if (tileFactory instanceof HeightMapTileFactory) {
                baseHeight = (int)((HeightMapTileFactory)tileFactory).getBaseHeight();
                waterLevel = ((HeightMapTileFactory)tileFactory).getWaterHeight();
            } else {
                baseHeight = 58;
                waterLevel = 62;
            }
            dialog = ((TunnelLayer)layer).getLayerMode() == TunnelLayer.LayerMode.CAVE ? new TunnelLayerDialog(this.app, world.getPlatform(), (TunnelLayer)layer, dimension, world.isExtendedBlockIds(), this.app.getColourScheme(), this.app.getCustomBiomeManager(), dimension.getMinHeight(), dimension.getMaxHeight(), baseHeight, waterLevel) : new FloatingLayerDialog(this.app, world.getPlatform(), (TunnelLayer)layer, dimension, world.isExtendedBlockIds(), this.app.getColourScheme(), this.app.getCustomBiomeManager(), dimension.getMinHeight(), dimension.getMaxHeight(), baseHeight, waterLevel);
        } else {
            dialog = layer instanceof CustomAnnotationLayer ? new CustomAnnotationLayerDialog((Window)this.app, (CustomAnnotationLayer)layer) : new EditLayerDialog<L>((Window)this.app, world.getPlatform(), layer);
        }
        return dialog;
    }

    private List<JMenuItem> getCopyLayerMenuItems(String targetPaletteName, Function<Layer, Boolean> filter) {
        if (targetPaletteName == null) {
            throw new NullPointerException("targetPaletteName");
        }
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        Dimension currentDimension = this.app.getDimension();
        for (Dimension dimension : this.app.getWorld().getDimensions()) {
            JMenu menuForDimension;
            if (dimension == currentDimension) continue;
            HashMap<String, JMenu> menusForDimension = new HashMap<String, JMenu>();
            for (CustomLayer layer : dimension.getCustomLayers()) {
                if (!layer.isExportableToFile() || filter != null && !filter.apply((Layer)layer).booleanValue()) continue;
                String palette = layer.getPalette();
                JMenuItem menuForPalette = menusForDimension.computeIfAbsent(palette, k -> new JMenu(palette));
                JMenuItem menuItem = new JMenuItem(layer.getName(), new ImageIcon(layer.getIcon()));
                menuItem.addActionListener(event -> this.copyLayerToPalette(layer, targetPaletteName));
                menuForPalette.add(menuItem);
            }
            if (menusForDimension.size() == 1) {
                menuForDimension = (JMenu)menusForDimension.values().iterator().next();
                menuForDimension.setText(dimension.getName());
            } else {
                menuForDimension = new JMenu(dimension.getName());
                for (JMenu menu : menusForDimension.values()) {
                    menuForDimension.add(menu);
                }
            }
            if (menuForDimension.getItemCount() <= 0) continue;
            menuItems.add(menuForDimension);
        }
        if (menuItems.size() == 1) {
            return Lists.transform(Arrays.asList(((JMenu)menuItems.get(0)).getMenuComponents()), e -> (JMenuItem)e);
        }
        return menuItems;
    }

    private void copyLayerToPalette(CustomLayer layer, String paletteName) {
        CustomLayer copy = layer.clone();
        copy.setPalette(paletteName);
        this.registerCustomLayer(copy, true);
    }
}

