/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.swing.TiledImageViewer;
import org.pepsoft.worldpainter.ColourEditor;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.ConfigureOverlayDialog;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Overlay;
import org.pepsoft.worldpainter.OverlaysTableModel;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.biomeschemes.BiomeSchemeManager;
import org.pepsoft.worldpainter.layers.renderers.VoidRenderer;
import org.pepsoft.worldpainter.util.ImageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigureViewDialog
extends WorldPainterDialog
implements WindowListener {
    private JButton buttonAddOverlay;
    private JButton buttonClose;
    private JButton buttonDeleteOverlay;
    private JButton buttonEditOverlay;
    private JButton buttonResetBackgroundColour;
    private JButton buttonSelectBackgroundImage;
    private JCheckBox checkBoxBackgroundImage;
    private JCheckBox checkBoxContours;
    private JCheckBox checkBoxGrid;
    private JCheckBox checkBoxImageOverlay;
    private JCheckBox checkBoxShowBiomes;
    private JCheckBox checkBoxShowBorders;
    private ColourEditor colourEditor1;
    private JComboBox<TiledImageViewer.BackgroundImageMode> comboBoxBackgroundImageMode;
    private JTextField fieldBackgroundImage;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel9;
    private JScrollPane jScrollPane2;
    private JSpinner spinnerContourSeparation;
    private JSpinner spinnerGridSize;
    private JSpinner spinnerRenderDistance;
    private JTable tableOverlays;
    private final Dimension dimension;
    private final WorldPainter view;
    private final boolean enableOverlay;
    private final OverlaysTableModel overlaysTableModel;
    private final Configuration config;
    private BufferedImage overlayImage;
    private boolean programmaticChange = true;
    private static final Logger logger = LoggerFactory.getLogger(ConfigureViewDialog.class);
    private static final long serialVersionUID = 1L;

    public ConfigureViewDialog(Frame parent, Dimension dimension, WorldPainter view) {
        this(parent, dimension, view, false);
    }

    public ConfigureViewDialog(Frame parent, Dimension dimension, WorldPainter view, boolean enableOverlay) {
        super((Window)parent);
        this.dimension = dimension;
        this.view = view;
        this.enableOverlay = enableOverlay;
        this.initComponents();
        this.checkBoxGrid.setSelected(view.isPaintGrid());
        this.spinnerGridSize.setValue(view.getGridSize());
        this.checkBoxImageOverlay.setSelected(dimension.isOverlaysEnabled());
        this.overlaysTableModel = new OverlaysTableModel(dimension);
        this.tableOverlays.setModel(this.overlaysTableModel);
        this.checkBoxContours.setSelected(view.isDrawContours());
        this.spinnerContourSeparation.setValue(view.getContourSeparation());
        this.checkBoxBackgroundImage.setSelected(view.getBackgroundImage() != null);
        this.config = Configuration.getInstance();
        this.spinnerRenderDistance.setValue(this.config.getViewDistance() / 16);
        if (this.config.getBackgroundImage() != null) {
            this.fieldBackgroundImage.setText(this.config.getBackgroundImage().getAbsolutePath());
        }
        this.comboBoxBackgroundImageMode.setModel(new DefaultComboBoxModel<TiledImageViewer.BackgroundImageMode>(TiledImageViewer.BackgroundImageMode.values()));
        this.comboBoxBackgroundImageMode.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof TiledImageViewer.BackgroundImageMode) {
                    switch ((TiledImageViewer.BackgroundImageMode)value) {
                        case CENTRE: {
                            this.setText("Centre");
                            break;
                        }
                        case CENTRE_REPEAT: {
                            this.setText("Centre (repeat)");
                            break;
                        }
                        case FIT: {
                            this.setText("Fit");
                            break;
                        }
                        case FIT_REPEAT: {
                            this.setText("Fit (repeat)");
                            break;
                        }
                        case REPEAT: {
                            this.setText("Repeat");
                            break;
                        }
                        case STRETCH: {
                            this.setText("Stretch");
                        }
                    }
                }
                return this;
            }
        });
        this.comboBoxBackgroundImageMode.setSelectedItem(this.config.getBackgroundImageMode());
        this.checkBoxShowBiomes.setSelected(this.config.isShowBiomes());
        this.checkBoxShowBorders.setSelected(this.config.isShowBorders());
        this.fieldBackgroundImage.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ConfigureViewDialog.this.updateBackgroundImageFile();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ConfigureViewDialog.this.updateBackgroundImageFile();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ConfigureViewDialog.this.updateBackgroundImageFile();
            }
        });
        this.colourEditor1.setColour(view.getBackground().getRGB());
        this.colourEditor1.addPropertyChangeListener("colour", event -> {
            int newColour = (Integer)event.getNewValue();
            if (newColour == VoidRenderer.getColour()) {
                this.config.setBackgroundColour(-1);
            } else {
                this.config.setBackgroundColour(newColour);
            }
            view.setBackground(new Color(newColour));
        });
        if (BiomeSchemeManager.getAvailableBiomeAlgorithms().isEmpty()) {
            this.checkBoxShowBiomes.setSelected(false);
            this.checkBoxShowBiomes.setEnabled(false);
        }
        this.tableOverlays.getSelectionModel().addListSelectionListener(e -> this.setControlStates());
        this.tableOverlays.getColumnModel().getColumn(0).setMaxWidth((int)(50.0f * GUIUtils.getUIScale()));
        this.setControlStates();
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
        if (enableOverlay) {
            this.addWindowListener(this);
        }
        this.programmaticChange = false;
    }

    @Override
    protected void cancel() {
        if (this.dimension.getOverlays().stream().noneMatch(Overlay::isEnabled)) {
            this.dimension.setOverlaysEnabled(false);
        }
        super.cancel();
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.enableOverlay) {
            this.enableOverlay();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private void setControlStates() {
        this.spinnerGridSize.setEnabled(this.checkBoxGrid.isSelected());
        boolean imageOverlayEnabled = this.checkBoxImageOverlay.isSelected();
        this.spinnerContourSeparation.setEnabled(this.checkBoxContours.isSelected());
        boolean backgroundImageEnabled = this.checkBoxBackgroundImage.isSelected();
        this.fieldBackgroundImage.setEnabled(backgroundImageEnabled);
        this.buttonSelectBackgroundImage.setEnabled(backgroundImageEnabled);
        this.comboBoxBackgroundImageMode.setEnabled(backgroundImageEnabled);
        this.tableOverlays.setEnabled(imageOverlayEnabled);
        this.buttonAddOverlay.setEnabled(imageOverlayEnabled);
        this.buttonDeleteOverlay.setEnabled(imageOverlayEnabled && this.tableOverlays.getSelectedRowCount() > 0);
        this.buttonEditOverlay.setEnabled(imageOverlayEnabled && this.tableOverlays.getSelectedRowCount() > 0);
    }

    private void updateBackgroundImageFile() {
        File file = new File(this.fieldBackgroundImage.getText());
        if (!this.config.isSafeMode()) {
            BufferedImage image = ImageUtils.loadImage(this, file);
            if (image != null) {
                this.config.setBackgroundImage(file);
                this.view.setBackgroundImage(image);
            }
        } else if (file.isFile() && file.canRead()) {
            logger.info("[SAFE MODE] Not loading background image");
            this.config.setBackgroundImage(file);
        }
    }

    private void selectBackgroundImage() {
        File selectedFile = ImageUtils.selectImageForOpen(this, "a background image file", new File(this.fieldBackgroundImage.getText()));
        if (selectedFile != null) {
            this.fieldBackgroundImage.setText(selectedFile.getAbsolutePath());
        }
    }

    private void enableOverlay() {
        if (!this.checkBoxImageOverlay.isSelected()) {
            this.checkBoxImageOverlay.setSelected(true);
            this.dimension.setOverlaysEnabled(true);
            this.setControlStates();
            if (this.dimension.getOverlays().isEmpty()) {
                this.addOverlay();
            }
        }
    }

    private void addOverlay() {
        File imageFile = ImageUtils.selectImageForOpen(this, "an overlay image file", this.config.getOverlaysDirectory());
        if (imageFile != null) {
            Overlay overlay = new Overlay(imageFile);
            int rowIndex = this.overlaysTableModel.addOverlay(overlay);
            ConfigureOverlayDialog dialog = new ConfigureOverlayDialog((Window)this, overlay, this.dimension);
            dialog.setVisible(true);
            if (!dialog.isCancelled()) {
                this.overlaysTableModel.overlayChanged(rowIndex);
                this.config.setOverlaysDirectory(imageFile.getParentFile());
            } else {
                this.overlaysTableModel.removeOverlay(rowIndex);
            }
        }
    }

    private void deleteOverlay() {
        this.overlaysTableModel.removeOverlay(this.tableOverlays.getSelectedRow());
    }

    private void editOverlay() {
        int selectedRow = this.tableOverlays.getSelectedRow();
        Overlay overlay = this.overlaysTableModel.getOverlay(selectedRow);
        ConfigureOverlayDialog dialog = new ConfigureOverlayDialog((Window)this, overlay, this.dimension);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            this.overlaysTableModel.overlayChanged(selectedRow);
        }
    }

    private void initComponents() {
        this.checkBoxGrid = new JCheckBox();
        this.spinnerGridSize = new JSpinner();
        this.jLabel1 = new JLabel();
        this.checkBoxImageOverlay = new JCheckBox();
        this.buttonClose = new JButton();
        this.jLabel9 = new JLabel();
        this.checkBoxContours = new JCheckBox();
        this.jLabel10 = new JLabel();
        this.spinnerContourSeparation = new JSpinner();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.colourEditor1 = new ColourEditor();
        this.checkBoxBackgroundImage = new JCheckBox();
        this.jLabel13 = new JLabel();
        this.fieldBackgroundImage = new JTextField();
        this.buttonSelectBackgroundImage = new JButton();
        this.jLabel14 = new JLabel();
        this.comboBoxBackgroundImageMode = new JComboBox();
        this.checkBoxShowBiomes = new JCheckBox();
        this.checkBoxShowBorders = new JCheckBox();
        this.buttonResetBackgroundColour = new JButton();
        this.buttonAddOverlay = new JButton();
        this.buttonDeleteOverlay = new JButton();
        this.buttonEditOverlay = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.tableOverlays = new JTable();
        this.jLabel2 = new JLabel();
        this.spinnerRenderDistance = new JSpinner();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Configure View");
        this.checkBoxGrid.setText("Grid");
        this.checkBoxGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureViewDialog.this.checkBoxGridActionPerformed(evt);
            }
        });
        this.spinnerGridSize.setModel(new SpinnerNumberModel(128, 2, 9999, 1));
        this.spinnerGridSize.setEnabled(false);
        this.spinnerGridSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ConfigureViewDialog.this.spinnerGridSizeStateChanged(evt);
            }
        });
        this.jLabel1.setText("Grid size:");
        this.checkBoxImageOverlay.setSelected(true);
        this.checkBoxImageOverlay.setText("Show image overlay(s):");
        this.checkBoxImageOverlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureViewDialog.this.checkBoxImageOverlayActionPerformed(evt);
            }
        });
        this.buttonClose.setText("Close");
        this.buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureViewDialog.this.buttonCloseActionPerformed(evt);
            }
        });
        this.jLabel9.setText("blocks");
        this.checkBoxContours.setSelected(true);
        this.checkBoxContours.setText("Contour lines");
        this.checkBoxContours.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureViewDialog.this.checkBoxContoursActionPerformed(evt);
            }
        });
        this.jLabel10.setText("Separation:");
        this.spinnerContourSeparation.setModel(new SpinnerNumberModel(10, 2, 999, 1));
        this.spinnerContourSeparation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ConfigureViewDialog.this.spinnerContourSeparationStateChanged(evt);
            }
        });
        this.jLabel11.setText("blocks");
        this.jLabel12.setText("Background colour:");
        this.checkBoxBackgroundImage.setText("Background image");
        this.checkBoxBackgroundImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureViewDialog.this.checkBoxBackgroundImageActionPerformed(evt);
            }
        });
        this.jLabel13.setText("Image:");
        this.fieldBackgroundImage.setEnabled(false);
        this.buttonSelectBackgroundImage.setText("...");
        this.buttonSelectBackgroundImage.setEnabled(false);
        this.buttonSelectBackgroundImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureViewDialog.this.buttonSelectBackgroundImageActionPerformed(evt);
            }
        });
        this.jLabel14.setText("Layout:");
        this.comboBoxBackgroundImageMode.setEnabled(false);
        this.comboBoxBackgroundImageMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureViewDialog.this.comboBoxBackgroundImageModeActionPerformed(evt);
            }
        });
        this.checkBoxShowBiomes.setText("Show Minecraft biomes (when available and applicable)");
        this.checkBoxShowBiomes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureViewDialog.this.checkBoxShowBiomesActionPerformed(evt);
            }
        });
        this.checkBoxShowBorders.setText("Show borders");
        this.checkBoxShowBorders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureViewDialog.this.checkBoxShowBordersActionPerformed(evt);
            }
        });
        this.buttonResetBackgroundColour.setText("Reset");
        this.buttonResetBackgroundColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureViewDialog.this.buttonResetBackgroundColourActionPerformed(evt);
            }
        });
        this.buttonAddOverlay.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/brick_add.png")));
        this.buttonAddOverlay.setToolTipText("Add an overlay");
        this.buttonAddOverlay.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAddOverlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureViewDialog.this.buttonAddOverlayActionPerformed(evt);
            }
        });
        this.buttonDeleteOverlay.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/brick_delete.png")));
        this.buttonDeleteOverlay.setToolTipText("Remove the selected overlay");
        this.buttonDeleteOverlay.setEnabled(false);
        this.buttonDeleteOverlay.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDeleteOverlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureViewDialog.this.buttonDeleteOverlayActionPerformed(evt);
            }
        });
        this.buttonEditOverlay.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/brick_edit.png")));
        this.buttonEditOverlay.setToolTipText("Edit the selected overlay");
        this.buttonEditOverlay.setEnabled(false);
        this.buttonEditOverlay.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEditOverlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureViewDialog.this.buttonEditOverlayActionPerformed(evt);
            }
        });
        this.tableOverlays.setSelectionMode(0);
        this.tableOverlays.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ConfigureViewDialog.this.tableOverlaysMousePressed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.tableOverlays);
        this.jLabel2.setText("Render distance:");
        this.spinnerRenderDistance.setModel(new SpinnerNumberModel(12, 1, 32, 1));
        this.spinnerRenderDistance.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ConfigureViewDialog.this.spinnerRenderDistanceStateChanged(evt);
            }
        });
        this.jLabel3.setText("chunks");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colourEditor1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonResetBackgroundColour).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerRenderDistance, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonAddOverlay, GroupLayout.Alignment.TRAILING).addComponent(this.buttonDeleteOverlay, GroupLayout.Alignment.TRAILING).addComponent(this.buttonEditOverlay, GroupLayout.Alignment.TRAILING))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldBackgroundImage)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerGridSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerContourSeparation, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxBackgroundImageMode, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxGrid).addComponent(this.checkBoxContours).addComponent(this.checkBoxBackgroundImage).addComponent(this.checkBoxShowBorders).addComponent(this.checkBoxShowBiomes).addComponent(this.checkBoxImageOverlay)).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelectBackgroundImage))))).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.buttonClose).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxGrid).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.spinnerGridSize, -2, -1, -2).addComponent(this.jLabel9)).addGap(18, 18, 18).addComponent(this.checkBoxContours).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.spinnerContourSeparation, -2, -1, -2).addComponent(this.jLabel11)).addGap(18, 18, 18).addComponent(this.checkBoxImageOverlay).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buttonAddOverlay).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDeleteOverlay).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEditOverlay)).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.checkBoxShowBorders).addGap(18, 18, 18).addComponent(this.checkBoxShowBiomes).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.colourEditor1, -2, -1, -2).addComponent(this.buttonResetBackgroundColour)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxBackgroundImage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.fieldBackgroundImage, -2, -1, -2).addComponent(this.buttonSelectBackgroundImage)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.comboBoxBackgroundImageMode, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.spinnerRenderDistance, -2, -1, -2).addComponent(this.jLabel3)).addGap(18, 18, 18).addComponent(this.buttonClose).addContainerGap()));
        this.pack();
    }

    private void checkBoxGridActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.programmaticChange = true;
            try {
                this.setControlStates();
                boolean gridEnabled = this.checkBoxGrid.isSelected();
                this.view.setPaintGrid(gridEnabled);
                this.dimension.setGridEnabled(gridEnabled);
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void checkBoxImageOverlayActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.programmaticChange = true;
            try {
                this.setControlStates();
                boolean overlaysEnabled = this.checkBoxImageOverlay.isSelected();
                this.dimension.setOverlaysEnabled(overlaysEnabled);
                if (this.dimension.getOverlays().isEmpty()) {
                    this.addOverlay();
                }
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void spinnerGridSizeStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.programmaticChange = true;
            try {
                int gridSize = ((Number)this.spinnerGridSize.getValue()).intValue();
                this.view.setGridSize(gridSize);
                this.dimension.setGridSize(gridSize);
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void buttonCloseActionPerformed(ActionEvent evt) {
        if (this.dimension.getOverlays().stream().noneMatch(Overlay::isEnabled)) {
            this.dimension.setOverlaysEnabled(false);
        }
        this.ok();
    }

    private void checkBoxContoursActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.programmaticChange = true;
            try {
                this.setControlStates();
                boolean contoursEnabled = this.checkBoxContours.isSelected();
                this.view.setDrawContours(contoursEnabled);
                this.dimension.setContoursEnabled(contoursEnabled);
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void spinnerContourSeparationStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.programmaticChange = true;
            try {
                int contourSeparation = ((Number)this.spinnerContourSeparation.getValue()).intValue();
                this.view.setContourSeparation(contourSeparation);
                this.dimension.setContourSeparation(contourSeparation);
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void checkBoxBackgroundImageActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.programmaticChange = true;
            try {
                if (this.checkBoxBackgroundImage.isSelected()) {
                    if (this.fieldBackgroundImage.getText().trim().isEmpty()) {
                        this.selectBackgroundImage();
                    } else {
                        this.updateBackgroundImageFile();
                    }
                } else {
                    this.config.setBackgroundImage(null);
                    this.view.setBackgroundImage(null);
                }
                this.setControlStates();
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void buttonSelectBackgroundImageActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.programmaticChange = true;
            try {
                this.selectBackgroundImage();
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void checkBoxShowBordersActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.programmaticChange = true;
            try {
                boolean showBorders = this.checkBoxShowBorders.isSelected();
                this.config.setShowBorders(showBorders);
                this.view.setDrawBorders(showBorders);
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void checkBoxShowBiomesActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.programmaticChange = true;
            try {
                boolean showBiomes = this.checkBoxShowBiomes.isSelected();
                this.config.setShowBiomes(showBiomes);
                this.view.setDrawBiomes(showBiomes);
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void comboBoxBackgroundImageModeActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.programmaticChange = true;
            try {
                TiledImageViewer.BackgroundImageMode mode = (TiledImageViewer.BackgroundImageMode)this.comboBoxBackgroundImageMode.getSelectedItem();
                this.config.setBackgroundImageMode(mode);
                this.view.setBackgroundImageMode(mode);
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void buttonResetBackgroundColourActionPerformed(ActionEvent evt) {
        this.colourEditor1.setColour(VoidRenderer.getColour());
        this.view.setBackground(new Color(VoidRenderer.getColour()));
        this.config.setBackgroundColour(-1);
    }

    private void buttonAddOverlayActionPerformed(ActionEvent evt) {
        this.addOverlay();
    }

    private void buttonDeleteOverlayActionPerformed(ActionEvent evt) {
        this.deleteOverlay();
    }

    private void buttonEditOverlayActionPerformed(ActionEvent evt) {
        this.editOverlay();
    }

    private void tableOverlaysMousePressed(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && this.tableOverlays.isEnabled()) {
            this.editOverlay();
        }
    }

    private void spinnerRenderDistanceStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.programmaticChange = true;
            try {
                int renderDistance = ((Number)this.spinnerRenderDistance.getValue()).intValue();
                this.view.setViewDistance(renderDistance * 16);
                this.config.setViewDistance(renderDistance * 16);
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }
}

