/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Overlay;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.util.ImageUtils;

public class ConfigureOverlayDialog
extends WorldPainterDialog {
    private JButton buttonCancel;
    private JButton buttonFitToDimension;
    private JButton buttonOK;
    private JCheckBox checkBoxImageOverlay;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel labelFile;
    private JSpinner spinnerScale;
    private JSpinner spinnerTransparency;
    private JSpinner spinnerXOffset;
    private JSpinner spinnerYOffset;
    private final Overlay overlay;
    private final Dimension dimension;
    private final boolean originalEnabled;
    private final float originalScale;
    private final float originalTransparency;
    private final int originalOffsetX;
    private final int originalOffsetY;
    private boolean programmaticChange = true;

    public ConfigureOverlayDialog(Window parent, Overlay overlay, Dimension dimension) {
        super(parent);
        this.overlay = overlay;
        this.dimension = dimension;
        this.originalEnabled = overlay.isEnabled();
        this.originalScale = overlay.getScale();
        this.originalTransparency = overlay.getTransparency();
        this.originalOffsetX = overlay.getOffsetX();
        this.originalOffsetY = overlay.getOffsetY();
        this.initComponents();
        this.labelFile.setText(overlay.getFile().getAbsolutePath());
        this.checkBoxImageOverlay.setSelected(overlay.isEnabled());
        this.spinnerScale.setValue(Float.valueOf(overlay.getScale() * 100.0f));
        this.spinnerTransparency.setValue(Math.round(overlay.getTransparency() * 100.0f));
        this.spinnerXOffset.setValue(overlay.getOffsetX());
        this.spinnerYOffset.setValue(overlay.getOffsetY());
        this.setControlStates();
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
        this.programmaticChange = false;
    }

    @Override
    protected void cancel() {
        this.overlay.setScale(this.originalScale);
        this.overlay.setTransparency(this.originalTransparency);
        this.overlay.setOffsetX(this.originalOffsetX);
        this.overlay.setOffsetY(this.originalOffsetY);
        this.overlay.setEnabled(this.originalEnabled);
        super.cancel();
    }

    private void setControlStates() {
        boolean imageOverlayEnabled = this.checkBoxImageOverlay.isSelected();
        this.spinnerScale.setEnabled(imageOverlayEnabled);
        this.spinnerTransparency.setEnabled(imageOverlayEnabled);
        this.spinnerXOffset.setEnabled(imageOverlayEnabled);
        this.spinnerYOffset.setEnabled(imageOverlayEnabled);
        this.buttonFitToDimension.setEnabled(imageOverlayEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fitOverlayToDimension() {
        float imgRatio;
        BufferedImage overlayImage = ImageUtils.loadImage(this, this.overlay.getFile());
        if (overlayImage == null) {
            return;
        }
        float dimRatio = (float)this.dimension.getWidth() / (float)this.dimension.getHeight();
        float desiredScale = dimRatio > (imgRatio = (float)overlayImage.getWidth() / (float)overlayImage.getHeight()) ? (float)(this.dimension.getHeight() << 7) / (float)overlayImage.getHeight() : (float)(this.dimension.getWidth() << 7) / (float)overlayImage.getWidth();
        int scaledWidth = Math.round((float)overlayImage.getWidth() * desiredScale);
        int scaledHeight = Math.round((float)overlayImage.getHeight() * desiredScale);
        int xOffset = (this.dimension.getLowestX() << 7) + ((this.dimension.getWidth() << 7) - scaledWidth) / 2;
        int yOffset = (this.dimension.getLowestY() << 7) + ((this.dimension.getHeight() << 7) - scaledHeight) / 2;
        this.programmaticChange = true;
        try {
            this.overlay.setOffsetX(xOffset);
            this.overlay.setOffsetY(yOffset);
            this.overlay.setScale(desiredScale);
            this.spinnerScale.setValue(Float.valueOf(desiredScale * 100.0f));
            this.spinnerXOffset.setValue(xOffset);
            this.spinnerYOffset.setValue(yOffset);
        }
        finally {
            this.programmaticChange = false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.spinnerScale = new JSpinner();
        this.jLabel4 = new JLabel();
        this.buttonFitToDimension = new JButton();
        this.jLabel5 = new JLabel();
        this.spinnerTransparency = new JSpinner();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.spinnerXOffset = new JSpinner();
        this.jLabel8 = new JLabel();
        this.spinnerYOffset = new JSpinner();
        this.buttonCancel = new JButton();
        this.buttonOK = new JButton();
        this.checkBoxImageOverlay = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.labelFile = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Configure Overlay");
        this.jLabel2.setText("File:");
        this.jLabel3.setText("Scale:");
        this.spinnerScale.setModel(new SpinnerNumberModel(Float.valueOf(100.0f), Float.valueOf(0.01f), Float.valueOf(9999.99f), Float.valueOf(0.1f)));
        this.spinnerScale.setEditor(new JSpinner.NumberEditor(this.spinnerScale, "0.00"));
        this.spinnerScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ConfigureOverlayDialog.this.spinnerScaleStateChanged(evt);
            }
        });
        this.jLabel4.setText("%");
        this.buttonFitToDimension.setText("Fit to dimension");
        this.buttonFitToDimension.setToolTipText("Sets the scale and offset such that the image exactly covers the current dimension (as far as possible).");
        this.buttonFitToDimension.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureOverlayDialog.this.buttonFitToDimensionActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Transparency:");
        this.spinnerTransparency.setModel(new SpinnerNumberModel(50, 0, 99, 1));
        this.spinnerTransparency.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ConfigureOverlayDialog.this.spinnerTransparencyStateChanged(evt);
            }
        });
        this.jLabel6.setText("%");
        this.jLabel7.setText("X offset:");
        this.spinnerXOffset.setModel(new SpinnerNumberModel(0, -999999, 999999, 1));
        this.spinnerXOffset.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ConfigureOverlayDialog.this.spinnerXOffsetStateChanged(evt);
            }
        });
        this.jLabel8.setText(", Y offset:");
        this.spinnerYOffset.setModel(new SpinnerNumberModel(0, -999999, 999999, 1));
        this.spinnerYOffset.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ConfigureOverlayDialog.this.spinnerYOffsetStateChanged(evt);
            }
        });
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureOverlayDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureOverlayDialog.this.buttonOKActionPerformed(evt);
            }
        });
        this.checkBoxImageOverlay.setText(" ");
        this.checkBoxImageOverlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureOverlayDialog.this.checkBoxImageOverlayActionPerformed(evt);
            }
        });
        this.jLabel1.setLabelFor(this.checkBoxImageOverlay);
        this.jLabel1.setText("Enabled:");
        this.labelFile.setText("jLabel9");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerScale, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonFitToDimension)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerTransparency, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel6)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerXOffset, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerYOffset, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxImageOverlay)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelFile))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.labelFile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxImageOverlay).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.spinnerScale, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.buttonFitToDimension)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.spinnerTransparency, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.spinnerXOffset, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.spinnerYOffset, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK)).addContainerGap()));
        this.pack();
    }

    private void spinnerScaleStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.overlay.setScale(((Float)this.spinnerScale.getValue()).floatValue() / 100.0f);
        }
    }

    private void buttonFitToDimensionActionPerformed(ActionEvent evt) {
        this.fitOverlayToDimension();
    }

    private void spinnerTransparencyStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.overlay.setTransparency((float)((Number)this.spinnerTransparency.getValue()).intValue() / 100.0f);
        }
    }

    private void spinnerXOffsetStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.overlay.setOffsetX(((Number)this.spinnerXOffset.getValue()).intValue());
        }
    }

    private void spinnerYOffsetStateChanged(ChangeEvent evt) {
        if (!this.programmaticChange) {
            this.overlay.setOffsetY(((Number)this.spinnerYOffset.getValue()).intValue());
        }
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void checkBoxImageOverlayActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            this.overlay.setEnabled(this.checkBoxImageOverlay.isSelected());
        }
    }
}

