/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class ColourEditor
extends JPanel
implements MouseListener {
    private int colour = Color.ORANGE.getRGB();
    private JButton buttonSelectColour;
    private JLabel labelColour;
    private static final long serialVersionUID = 1L;

    public ColourEditor() {
        this.initComponents();
        this.setLabelColour();
    }

    public int getColour() {
        return this.colour;
    }

    public void setColour(int colour) {
        this.colour = colour;
        this.setLabelColour();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.labelColour.setOpaque(enabled);
        this.buttonSelectColour.setEnabled(enabled);
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.labelColour.getBaseline(width, height);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isEnabled()) {
            this.pickColour();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void setLabelColour() {
        this.labelColour.setBackground(new Color(this.colour));
    }

    private void pickColour() {
        int newColour;
        Color pick = JColorChooser.showDialog(this, "Select Colour", new Color(this.colour));
        if (pick != null && (newColour = pick.getRGB()) != this.colour) {
            int oldColour = this.colour;
            this.colour = pick.getRGB();
            this.setLabelColour();
            this.firePropertyChange("colour", oldColour, newColour);
        }
    }

    private void initComponents() {
        this.labelColour = new JLabel();
        this.buttonSelectColour = new JButton();
        this.labelColour.setBackground(new Color(255, 128, 0));
        this.labelColour.setLabelFor(this.buttonSelectColour);
        this.labelColour.setText("                 ");
        this.labelColour.setToolTipText("Click to select a colour");
        this.labelColour.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.labelColour.setOpaque(true);
        this.buttonSelectColour.setText("...");
        this.buttonSelectColour.setToolTipText("Click to select a colour");
        this.buttonSelectColour.addActionListener(this::buttonSelectColourActionPerformed);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelColour).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelectColour)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelColour).addComponent(this.buttonSelectColour)));
    }

    private void buttonSelectColourActionPerformed(ActionEvent evt) {
        this.pickColour();
    }
}

