/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pepsoft.minecraft.SuperflatGenerator;
import org.pepsoft.minecraft.SuperflatPreset;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.Version;
import org.pepsoft.util.swing.ProgressDialog;
import org.pepsoft.util.swing.ProgressTask;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightTransform;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.util.WorldUtils;

public class ChangeHeightDialog
extends WorldPainterDialog {
    private JButton buttonCancel;
    private JButton buttonOK;
    private JCheckBox checkBoxAdjustLayers;
    private JCheckBox checkBoxScale;
    private JCheckBox checkBoxTranslate;
    private JComboBox<Integer> comboBoxNewMaxHeight;
    private JComboBox<Integer> comboBoxNewMinHeight;
    private JComboBox<Platform> comboBoxPlatform;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel label;
    private JLabel labelCurrentMaxHeight;
    private JLabel labelCurrentMinHeight;
    private JLabel labelCutOffWarning;
    private JLabel labelNewExtents;
    private JLabel labelOldExtents;
    private JLabel labelPlatformWarning;
    private JLabel labelWarning;
    private JSpinner spinnerScaleAmount;
    private JSpinner spinnerTranslateAmount;
    private final World2 world;
    private final int lowestHeight;
    private final int highestHeight;
    private final List<Platform> supportedPlatforms = new ArrayList<Platform>();
    private boolean initialising = true;
    private static final long serialVersionUID = 1L;

    public ChangeHeightDialog(Window parent, World2 world) {
        super(parent);
        this.world = world;
        Set dimensions = world.getDimensions().stream().filter(dimension -> (dimension.getAnchor().role == Dimension.Role.DETAIL || dimension.getAnchor().role == Dimension.Role.MASTER) && !dimension.getAnchor().invert).collect(Collectors.toSet());
        this.lowestHeight = dimensions.stream().mapToInt(Dimension::getLowestIntHeight).min().getAsInt();
        this.highestHeight = dimensions.stream().mapToInt(Dimension::getHighestIntHeight).max().getAsInt();
        this.initComponents();
        this.labelOldExtents.setText(this.lowestHeight + " - " + this.highestHeight);
        this.supportedPlatforms.addAll(PlatformManager.getInstance().getAllPlatforms());
        ArrayList<Platform> allPlatforms = new ArrayList<Platform>(this.supportedPlatforms);
        Platform platform = world.getPlatform();
        if (!allPlatforms.contains(platform)) {
            allPlatforms.add(0, platform);
        }
        this.comboBoxPlatform.setModel(new DefaultComboBoxModel<Platform>(allPlatforms.toArray(new Platform[allPlatforms.size()])));
        this.comboBoxPlatform.setSelectedItem(platform);
        this.setPlatform(platform);
        int minHeight = world.getMinHeight();
        int maxHeight = world.getMaxHeight();
        this.labelCurrentMinHeight.setText(Integer.toString(minHeight));
        this.comboBoxNewMinHeight.setSelectedItem(minHeight);
        this.labelCurrentMaxHeight.setText(Integer.toString(maxHeight));
        this.comboBoxNewMaxHeight.setSelectedItem(maxHeight);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.initialising = false;
        this.updateLabels();
        this.setControlStates();
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void setPlatform(Platform platform) {
        this.comboBoxNewMinHeight.setModel(new DefaultComboBoxModel<Integer>((Integer[])Arrays.stream(platform.minHeights).boxed().toArray(Integer[]::new)));
        this.comboBoxNewMinHeight.setEnabled(platform.minHeights.length > 1);
        int desiredMinHeight = platform.minZ < this.world.getMinHeight() ? platform.minZ : this.world.getMinHeight();
        int matchingMinHeight = Integer.MIN_VALUE;
        for (int minHeight : platform.minHeights) {
            if (minHeight > desiredMinHeight) continue;
            matchingMinHeight = minHeight;
            break;
        }
        if (matchingMinHeight == Integer.MIN_VALUE) {
            matchingMinHeight = platform.minMinHeight;
        }
        this.comboBoxNewMinHeight.setSelectedItem(matchingMinHeight);
        this.comboBoxNewMaxHeight.setModel(new DefaultComboBoxModel<Integer>((Integer[])Arrays.stream(platform.maxHeights).boxed().toArray(Integer[]::new)));
        this.comboBoxNewMaxHeight.setEnabled(platform.maxHeights.length > 1);
        int desiredMaxHeight = platform.standardMaxHeight > this.world.getMaxHeight() ? platform.standardMaxHeight : this.world.getMaxHeight();
        int matchingMaxHeight = Integer.MIN_VALUE;
        for (int maxHeight : platform.maxHeights) {
            if (maxHeight < desiredMaxHeight) continue;
            matchingMaxHeight = maxHeight;
            break;
        }
        if (matchingMaxHeight == Integer.MIN_VALUE) {
            matchingMaxHeight = platform.maxMaxHeight;
        }
        this.comboBoxNewMaxHeight.setSelectedItem(matchingMaxHeight);
        this.updateLabels();
        this.pack();
        this.setControlStates();
    }

    private void updateLabels() {
        HeightTransform transform = this.getTransform();
        int newLowestHeight = transform.transformHeight(this.lowestHeight);
        int newHighestHeight = transform.transformHeight(this.highestHeight);
        int newMinHeight = (Integer)this.comboBoxNewMinHeight.getSelectedItem();
        int newMaxHeight = (Integer)this.comboBoxNewMaxHeight.getSelectedItem();
        boolean activateWarning = false;
        StringBuilder label = new StringBuilder("<html>");
        if (newLowestHeight < newMinHeight) {
            label.append("<b><color=red>" + newLowestHeight + "</color></b>");
            activateWarning = true;
        } else {
            label.append(newLowestHeight);
        }
        label.append(" - ");
        if (newHighestHeight > newMaxHeight) {
            label.append("<b><color=red>" + newHighestHeight + "</color></b>");
            activateWarning = true;
        } else {
            label.append(newHighestHeight);
        }
        label.append("</html>");
        this.labelNewExtents.setText(label.toString());
        this.labelCutOffWarning.setVisible(activateWarning);
        this.labelPlatformWarning.setVisible(!this.supportedPlatforms.contains(this.comboBoxPlatform.getSelectedItem()));
    }

    private void setControlStates() {
        Platform oldPlatform = this.world.getPlatform();
        Platform newPlatform = (Platform)this.comboBoxPlatform.getSelectedItem();
        int oldMinHeight = this.world.getMinHeight();
        int newMinHeight = (Integer)this.comboBoxNewMinHeight.getSelectedItem();
        int oldMaxHeight = this.world.getMaxHeight();
        int newMaxHeight = (Integer)this.comboBoxNewMaxHeight.getSelectedItem();
        boolean translate = this.checkBoxTranslate.isSelected();
        boolean scale = this.checkBoxScale.isSelected();
        this.buttonOK.setEnabled(oldPlatform != newPlatform || oldMinHeight != newMinHeight || oldMaxHeight != newMaxHeight || translate && (Integer)this.spinnerTranslateAmount.getValue() != 0 || scale && (Integer)this.spinnerScaleAmount.getValue() != 100);
        this.spinnerTranslateAmount.setEnabled(translate);
        this.spinnerScaleAmount.setEnabled(scale);
        if (newPlatform == DefaultPlugin.JAVA_MCREGION && newMaxHeight != 128) {
            this.labelWarning.setText("Only with mods!");
            this.labelWarning.setVisible(true);
        } else if ((newMinHeight < oldMinHeight || newMaxHeight > oldMaxHeight) && ((Version)newPlatform.getAttribute(DefaultPlugin.ATTRIBUTE_MC_VERSION)).isAtLeast(Constants.V_1_17) && newMaxHeight - newMinHeight > 384) {
            this.labelWarning.setText("May impact performance");
            this.labelWarning.setVisible(true);
        } else {
            this.labelWarning.setVisible(false);
        }
        this.checkBoxAdjustLayers.setEnabled(newMinHeight != oldMinHeight || newMaxHeight != oldMaxHeight || translate || scale);
        this.pack();
    }

    private void doResize() {
        Platform oldPlatform = this.world.getPlatform();
        Platform newPlatform = (Platform)this.comboBoxPlatform.getSelectedItem();
        int oldMaxHeight = this.world.getMaxHeight();
        int oldMinHeight = this.world.getMinHeight();
        final int newMaxHeight = (Integer)this.comboBoxNewMaxHeight.getSelectedItem();
        final int newMinHeight = (Integer)this.comboBoxNewMinHeight.getSelectedItem();
        if ((newPlatform != oldPlatform || newMinHeight != oldMinHeight || newMaxHeight != oldMaxHeight) && this.world.getImportedFrom() != null && JOptionPane.showConfirmDialog(this, "<html>This world was imported from an existing map!<br>Are you <i>sure</i> you want to retarget it?<br>You will not be able to merge it back to the existing map any more!</html>", "Import from Existing Map", 0, 2) != 0) {
            return;
        }
        this.changePlatform(newPlatform, this.checkBoxAdjustLayers.isSelected());
        ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<Void>(){

            public String getName() {
                return "Changing world height";
            }

            public Void execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                WorldUtils.resizeWorld((World2)ChangeHeightDialog.this.world, (HeightTransform)ChangeHeightDialog.this.getTransform(), (int)newMinHeight, (int)newMaxHeight, (boolean)ChangeHeightDialog.this.checkBoxAdjustLayers.isSelected(), (ProgressReceiver)progressReceiver);
                return null;
            }
        }, (ProgressDialog.Option[])new ProgressDialog.Option[]{ProgressDialog.NOT_CANCELABLE});
        if (newMinHeight != oldMinHeight) {
            this.world.addHistoryEntry(24, new Serializable[]{Integer.valueOf(newMinHeight)});
        }
        if (newMaxHeight != oldMaxHeight) {
            this.world.addHistoryEntry(20, new Serializable[]{Integer.valueOf(newMaxHeight)});
        }
        if (this.checkBoxTranslate.isSelected()) {
            for (Dimension dimension : this.world.getDimensions()) {
                this.world.addHistoryEntry(18, new Serializable[]{dimension.getName(), (Integer)this.spinnerTranslateAmount.getValue()});
            }
        }
    }

    private void changePlatform(Platform newPlatform, boolean transformLayers) {
        Platform oldPlatform = this.world.getPlatform();
        if (newPlatform != oldPlatform) {
            this.world.setPlatform(newPlatform);
            if (transformLayers) {
                for (Dimension dim : this.world.getDimensions()) {
                    SuperflatPreset settings;
                    if (!(dim.getGenerator() instanceof SuperflatGenerator) || (settings = ((SuperflatGenerator)dim.getGenerator()).getSettings()) == null) continue;
                    if ((oldPlatform == DefaultPlugin.JAVA_MCREGION || oldPlatform == DefaultPlugin.JAVA_ANVIL) && newPlatform != DefaultPlugin.JAVA_MCREGION && newPlatform != DefaultPlugin.JAVA_ANVIL) {
                        for (SuperflatPreset.Layer layer : settings.getLayers()) {
                            switch (layer.getMaterialName()) {
                                case "minecraft:grass": {
                                    layer.setMaterialName("minecraft:grass_block");
                                    break;
                                }
                                case "minecraft:snow_layer": {
                                    layer.setMaterialName("minecraft:snow");
                                }
                            }
                        }
                        continue;
                    }
                    if (oldPlatform == DefaultPlugin.JAVA_MCREGION || oldPlatform == DefaultPlugin.JAVA_ANVIL || newPlatform != DefaultPlugin.JAVA_MCREGION && newPlatform != DefaultPlugin.JAVA_ANVIL) continue;
                    for (SuperflatPreset.Layer layer : settings.getLayers()) {
                        switch (layer.getMaterialName()) {
                            case "minecraft:grass_block": {
                                layer.setMaterialName("minecraft:grass");
                                break;
                            }
                            case "minecraft:snow": {
                                layer.setMaterialName("minecraft:snow_layer");
                            }
                        }
                    }
                }
            }
            this.world.addHistoryEntry(25, new Serializable[]{oldPlatform.displayName, newPlatform.displayName});
        }
    }

    private HeightTransform getTransform() {
        boolean scale = this.checkBoxScale.isSelected();
        int scaleAmount = (Integer)this.spinnerScaleAmount.getValue();
        boolean translate = this.checkBoxTranslate.isSelected();
        int translateAmount = (Integer)this.spinnerTranslateAmount.getValue();
        return HeightTransform.get((int)(scale ? scaleAmount : 100), (int)(translate ? translateAmount : 0));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.labelCurrentMaxHeight = new JLabel();
        this.comboBoxNewMaxHeight = new JComboBox();
        this.buttonCancel = new JButton();
        this.buttonOK = new JButton();
        this.jLabel5 = new JLabel();
        this.spinnerTranslateAmount = new JSpinner();
        this.label = new JLabel();
        this.spinnerScaleAmount = new JSpinner();
        this.jLabel7 = new JLabel();
        this.checkBoxScale = new JCheckBox();
        this.checkBoxTranslate = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.jLabel8 = new JLabel();
        this.labelWarning = new JLabel();
        this.jLabel3 = new JLabel();
        this.comboBoxPlatform = new JComboBox();
        this.labelCurrentMinHeight = new JLabel();
        this.jLabel9 = new JLabel();
        this.comboBoxNewMinHeight = new JComboBox();
        this.jLabel10 = new JLabel();
        this.checkBoxAdjustLayers = new JCheckBox();
        this.labelCutOffWarning = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel4 = new JLabel();
        this.labelOldExtents = new JLabel();
        this.jLabel12 = new JLabel();
        this.labelNewExtents = new JLabel();
        this.labelPlatformWarning = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Change Map Format");
        this.jLabel1.setText("Current build limits:");
        this.jLabel2.setText("New build limits:");
        this.labelCurrentMaxHeight.setText("jLabel3");
        this.comboBoxNewMaxHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeHeightDialog.this.comboBoxNewMaxHeightActionPerformed(evt);
            }
        });
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeHeightDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOK.setText("OK");
        this.buttonOK.setEnabled(false);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeHeightDialog.this.buttonOKActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Terrain and water levels:");
        this.spinnerTranslateAmount.setModel(new SpinnerNumberModel(0, -127, 127, 1));
        this.spinnerTranslateAmount.setEnabled(false);
        this.spinnerTranslateAmount.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ChangeHeightDialog.this.spinnerTranslateAmountStateChanged(evt);
            }
        });
        this.label.setText("blocks");
        this.spinnerScaleAmount.setModel(new SpinnerNumberModel(100, 1, 9999, 1));
        this.spinnerScaleAmount.setEnabled(false);
        this.spinnerScaleAmount.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ChangeHeightDialog.this.spinnerScaleAmountStateChanged(evt);
            }
        });
        this.jLabel7.setText("%");
        this.checkBoxScale.setText("Scale");
        this.checkBoxScale.setToolTipText("<html>Scale the levels by the specified percentage;<br>\nlevels that are (still) too low or high will be cut off.</html>");
        this.checkBoxScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ChangeHeightDialog.this.checkBoxScaleStateChanged(evt);
            }
        });
        this.checkBoxScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeHeightDialog.this.checkBoxScaleActionPerformed(evt);
            }
        });
        this.checkBoxTranslate.setText("Shift");
        this.checkBoxTranslate.setToolTipText("<html>Shift the levels up or down by the specified number of blocks;<br>\nnegative means down; levels which are (still) too low or high will be cut off.</html>");
        this.checkBoxTranslate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ChangeHeightDialog.this.checkBoxTranslateStateChanged(evt);
            }
        });
        this.checkBoxTranslate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeHeightDialog.this.checkBoxTranslateActionPerformed(evt);
            }
        });
        this.jLabel6.setText("<html><b>Note:</b> this operation cannot be undone!</html>");
        this.jLabel8.setText("(If both are enabled scale");
        this.labelWarning.setFont(this.labelWarning.getFont().deriveFont(this.labelWarning.getFont().getStyle() | 1));
        this.labelWarning.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/error.png")));
        this.labelWarning.setText("May impact performance");
        this.jLabel3.setText("Map format:");
        this.comboBoxPlatform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeHeightDialog.this.comboBoxPlatformActionPerformed(evt);
            }
        });
        this.labelCurrentMinHeight.setText("jLabel4");
        this.jLabel9.setText("Lower");
        this.comboBoxNewMinHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeHeightDialog.this.comboBoxNewMinHeightActionPerformed(evt);
            }
        });
        this.jLabel10.setText("Upper");
        this.checkBoxAdjustLayers.setSelected(true);
        this.checkBoxAdjustLayers.setText("Also apply to theme and layer settings");
        this.labelCutOffWarning.setFont(this.labelCutOffWarning.getFont().deriveFont(this.labelCutOffWarning.getFont().getStyle() | 1));
        this.labelCutOffWarning.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/error.png")));
        this.labelCutOffWarning.setText("Top and/or bottom cut off!");
        this.jLabel11.setText("will be applied first, then shift.)");
        this.jLabel4.setText("Current height range in use:");
        this.labelOldExtents.setText("-999 - -999");
        this.jLabel12.setText("New height range in use:");
        this.labelNewExtents.setText("<html><b>-999 - 999</b></html>");
        this.labelPlatformWarning.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/error.png")));
        this.labelPlatformWarning.setText("<html><b>Unknown format; export not possible</b></html>");
        this.labelPlatformWarning.setToolTipText("<html>This map format is unknown and cannot be Exported. Most likely it<br>\nis supported by a plugin that is not installed or cannot be loaded.</html>");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.labelCutOffWarning).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxAdjustLayers).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.labelCurrentMinHeight).addComponent(this.comboBoxNewMinHeight, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.comboBoxNewMaxHeight, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelWarning)).addComponent(this.labelCurrentMaxHeight).addComponent(this.jLabel10))).addComponent(this.jLabel5).addComponent(this.jLabel6, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxPlatform, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxTranslate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.spinnerScaleAmount, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel7)).addGroup(layout.createSequentialGroup().addComponent(this.spinnerTranslateAmount, -2, -1, -2).addGap(0, 0, 0).addComponent(this.label))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addComponent(this.jLabel8))).addComponent(this.checkBoxScale).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelNewExtents, -2, -1, -2).addComponent(this.labelOldExtents))).addComponent(this.labelPlatformWarning, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboBoxPlatform, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelPlatformWarning, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.labelCurrentMaxHeight).addComponent(this.labelCurrentMinHeight)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboBoxNewMaxHeight, -2, -1, -2).addComponent(this.labelWarning).addComponent(this.comboBoxNewMinHeight, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxScale).addComponent(this.spinnerScaleAmount, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxTranslate).addComponent(this.spinnerTranslateAmount, -2, -1, -2).addComponent(this.label).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.labelOldExtents)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.labelNewExtents, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.checkBoxAdjustLayers).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK).addComponent(this.labelCutOffWarning)).addContainerGap()));
        this.pack();
    }

    private void comboBoxNewMaxHeightActionPerformed(ActionEvent evt) {
        if (this.initialising) {
            return;
        }
        this.updateLabels();
        this.setControlStates();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void checkBoxScaleStateChanged(ChangeEvent evt) {
        if (this.initialising) {
            return;
        }
        this.setControlStates();
    }

    private void checkBoxTranslateStateChanged(ChangeEvent evt) {
        if (this.initialising) {
            return;
        }
        this.setControlStates();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.doResize();
        this.ok();
    }

    private void spinnerScaleAmountStateChanged(ChangeEvent evt) {
        if (this.initialising) {
            return;
        }
        this.updateLabels();
        this.setControlStates();
    }

    private void spinnerTranslateAmountStateChanged(ChangeEvent evt) {
        if (this.initialising) {
            return;
        }
        this.updateLabels();
        this.setControlStates();
    }

    private void comboBoxPlatformActionPerformed(ActionEvent evt) {
        if (this.initialising) {
            return;
        }
        this.setPlatform((Platform)this.comboBoxPlatform.getSelectedItem());
    }

    private void comboBoxNewMinHeightActionPerformed(ActionEvent evt) {
        if (this.initialising) {
            return;
        }
        this.updateLabels();
        this.setControlStates();
    }

    private void checkBoxScaleActionPerformed(ActionEvent evt) {
        if (this.initialising) {
            return;
        }
        this.updateLabels();
    }

    private void checkBoxTranslateActionPerformed(ActionEvent evt) {
        if (this.initialising) {
            return;
        }
        this.updateLabels();
    }
}

