/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.biomeschemes.BiomeHelper;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;

public class BiomeListCellRenderer
extends DefaultListCellRenderer {
    private final BiomeHelper biomeHelper;
    private final String nullLabel;
    private final boolean showIds;
    private static final long serialVersionUID = 1L;

    public BiomeListCellRenderer(ColourScheme colourScheme, CustomBiomeManager customBiomeManager, Platform platform) {
        this(colourScheme, customBiomeManager, " ", platform);
    }

    public BiomeListCellRenderer(ColourScheme colourScheme, CustomBiomeManager customBiomeManager, String nullLabel, Platform platform) {
        this.nullLabel = nullLabel;
        this.showIds = !platform.capabilities.contains(Platform.Capability.NAMED_BIOMES);
        this.biomeHelper = new BiomeHelper(colourScheme, customBiomeManager, platform);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value == null) {
            this.setText(this.nullLabel);
        } else if (value instanceof Integer) {
            int biome = (Integer)value;
            if (biome == -1) {
                this.setText(this.nullLabel);
            } else {
                this.setText((String)(this.showIds ? value + " " + this.biomeHelper.getBiomeNameWithoutId(biome) : this.biomeHelper.getBiomeNameWithoutId(biome)));
                this.setIcon(this.biomeHelper.getBiomeIcon(biome));
            }
        }
        return this;
    }
}

