/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft.mapexplorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jnbt.ByteArrayTag;
import org.jnbt.IntArrayTag;
import org.jnbt.LongArrayTag;
import org.jnbt.Tag;
import org.pepsoft.minecraft.mapexplorer.DataNode;
import org.pepsoft.minecraft.mapexplorer.FileSystemNode;
import org.pepsoft.minecraft.mapexplorer.MapTreeCellRenderer;
import org.pepsoft.minecraft.mapexplorer.MapTreeModel;
import org.pepsoft.minecraft.mapexplorer.NBTFileNode;
import org.pepsoft.minecraft.mapexplorer.TagNode;
import org.pepsoft.util.plugins.PluginManager;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Main;
import org.pepsoft.worldpainter.MouseAdapter;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.WPContext;
import org.pepsoft.worldpainter.mapexplorer.Node;
import org.pepsoft.worldpainter.plugins.WPPluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapExplorer {
    private static JLabel detailsArea;
    private static JSpinner wordSizeSpinner;
    private static JSpinner lineLengthSpinner;
    private static Object data;
    private static final Set<String> SUPPORTED_IMAGE_TYPES;
    private static final Set<String> TEXT_FILES;
    private static final Logger logger;

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        try {
            Class.forName("org.pepsoft.worldpainter.DefaultPlugin");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        File configDir = Configuration.getConfigDir();
        Configuration config = Configuration.load();
        if (config == null) {
            if (!logger.isDebugEnabled()) {
                logger.info("Creating new configuration");
            }
            config = new Configuration();
        }
        Configuration.setInstance((Configuration)config);
        logger.info("Installation ID: " + config.getUuid());
        X509Certificate trustedCert = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            trustedCert = (X509Certificate)certificateFactory.generateCertificate(Main.class.getResourceAsStream("/wproot.pem"));
        }
        catch (CertificateException e) {
            logger.error("Certificate exception while loading trusted root certificate", (Throwable)e);
        }
        if (trustedCert != null) {
            PluginManager.loadPlugins((File)new File(configDir, "plugins"), (PublicKey)trustedCert.getPublicKey(), (String)"org.pepsoft.worldpainter.plugins", (org.pepsoft.util.Version)Version.VERSION_OBJ, (boolean)false);
        } else {
            logger.error("Trusted root certificate not available; not loading plugins");
        }
        WPPluginManager.initialise((UUID)config.getUuid(), (WPContext)WPContext.INSTANCE);
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("Minecraft Map Explorer");
            frame.setDefaultCloseOperation(2);
            JSplitPane splitPane = new JSplitPane(1);
            splitPane.setLeftComponent(MapExplorer.createTreePanel());
            splitPane.setRightComponent(MapExplorer.createDetailsPanel());
            frame.getContentPane().add((Component)splitPane, "Center");
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setSize(screenSize.width * 8 / 10, screenSize.height * 8 / 10);
            splitPane.setDividerLocation(screenSize.width / 5);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        });
    }

    private static Component createDetailsPanel() {
        JPanel detailsPanel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        wordSizeSpinner = new JSpinner(new SpinnerNumberModel(4, 4, 999, 1));
        wordSizeSpinner.addChangeListener(e -> MapExplorer.updateBinaryData());
        JLabel label = new JLabel("Word size:");
        label.setLabelFor(wordSizeSpinner);
        toolBar.add(label);
        toolBar.add(wordSizeSpinner);
        lineLengthSpinner = new JSpinner(new SpinnerNumberModel(16, 1, 9999, 1));
        lineLengthSpinner.addChangeListener(e -> MapExplorer.updateBinaryData());
        label = new JLabel("Line length:");
        label.setLabelFor(lineLengthSpinner);
        toolBar.add(label);
        toolBar.add(lineLengthSpinner);
        toolBar.add(Box.createHorizontalStrut(Integer.MAX_VALUE));
        detailsPanel.add((Component)toolBar, "North");
        detailsArea = new JLabel();
        detailsArea.setVerticalAlignment(1);
        detailsPanel.add((Component)new JScrollPane(detailsArea), "Center");
        detailsPanel.setMinimumSize(new Dimension(0, 0));
        return detailsPanel;
    }

    @NotNull
    private static Component createTreePanel() {
        final MapTreeModel treeModel = new MapTreeModel();
        final JTree tree = new JTree(treeModel);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setCellRenderer(new MapTreeCellRenderer());
        JScrollPane scrollPane = new JScrollPane(tree);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                Object node = event.getPath().getLastPathComponent();
                if (!treeModel.isLeaf(node) && treeModel.getChildCount(node) == 1) {
                    tree.expandPath(event.getPath().pathByAddingChild(treeModel.getChild(node, 0)));
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath path;
                if (e.isPopupTrigger() && (path = tree.getPathForLocation(e.getX(), e.getY())) != null) {
                    this.showPopupMenu(e, path);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mousePressed(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                if (e.getClickCount() == 2 && (path = tree.getPathForLocation(e.getX(), e.getY())) != null) {
                    ((Node)path.getLastPathComponent()).doubleClicked();
                }
            }

            private void showPopupMenu(MouseEvent e, TreePath path) {
                Node node = (Node)path.getLastPathComponent();
                tree.setSelectionPath(path);
                node.showPopupMenu(e.getComponent(), e.getX(), e.getY(), action -> {
                    switch (action) {
                        case REFRESH: {
                            treeModel.refresh(path);
                        }
                    }
                });
            }
        });
        tree.getSelectionModel().addTreeSelectionListener(e -> {
            TreePath path = e.getPath();
            if (path != null) {
                MapExplorer.updateDetails((Node)path.getLastPathComponent());
            }
        });
        scrollPane.setMinimumSize(new Dimension(0, 0));
        return scrollPane;
    }

    private static void updateDetails(Node node) {
        try {
            if (node instanceof TagNode) {
                Tag tag = ((TagNode)node).getTag();
                if (tag instanceof ByteArrayTag) {
                    data = ((ByteArrayTag)tag).getValue();
                    MapExplorer.updateBinaryData();
                } else if (tag instanceof IntArrayTag) {
                    data = ((IntArrayTag)tag).getValue();
                    MapExplorer.updateBinaryData();
                } else if (tag instanceof LongArrayTag) {
                    data = ((LongArrayTag)tag).getValue();
                    MapExplorer.updateBinaryData();
                } else {
                    data = null;
                    detailsArea.setIcon(null);
                    detailsArea.setText("<html><pre>" + tag + "</pre></html>");
                }
            } else if (node instanceof DataNode) {
                data = ((DataNode)node).getData();
                MapExplorer.updateBinaryData();
            } else if (node instanceof FileSystemNode) {
                if (node instanceof NBTFileNode) {
                    MapExplorer.clearDetails();
                    return;
                }
                File file = ((FileSystemNode)node).file;
                if (!file.isFile() || !file.canRead()) {
                    MapExplorer.clearDetails();
                    return;
                }
                String name = file.getName().toLowerCase().trim();
                int p = name.lastIndexOf(46);
                String extension = p != -1 ? name.substring(p + 1) : null;
                if (SUPPORTED_IMAGE_TYPES.contains(extension)) {
                    byte[] contents = Files.readAllBytes(file.toPath());
                    BufferedImage image = ImageIO.read(new ByteArrayInputStream(contents));
                    data = null;
                    detailsArea.setIcon(new ImageIcon(image));
                    detailsArea.setText(null);
                } else if (TEXT_FILES.contains(extension)) {
                    byte[] contents = Files.readAllBytes(file.toPath());
                    data = null;
                    detailsArea.setIcon(null);
                    detailsArea.setText("<html><pre>" + new String(contents, StandardCharsets.UTF_8) + "</pre></html>");
                } else {
                    data = null;
                    detailsArea.setIcon(null);
                    detailsArea.setText(null);
                }
            } else {
                MapExplorer.clearDetails();
            }
        }
        catch (IOException | RuntimeException e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            data = null;
            detailsArea.setIcon(null);
            detailsArea.setText("<html><pre>" + sw + "</pre></html>");
        }
    }

    private static void clearDetails() {
        data = null;
        detailsArea.setIcon(null);
        detailsArea.setText(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void updateBinaryData() {
        int lengthInWords;
        BitSet bitSet;
        if (data == null) {
            return;
        }
        int wordSize = (Integer)wordSizeSpinner.getValue();
        int lineLength = (Integer)lineLengthSpinner.getValue();
        int wordsPerLong = 64 / wordSize;
        boolean straddleLongs = false;
        StringBuilder text = new StringBuilder("<html><pre>");
        if (data instanceof byte[]) {
            bitSet = BitSet.valueOf((byte[])data);
            lengthInWords = straddleLongs ? ((byte[])data).length * 8 / wordSize : ((byte[])data).length / 8 * wordsPerLong;
        } else if (data instanceof long[]) {
            bitSet = BitSet.valueOf((long[])data);
            lengthInWords = straddleLongs ? ((long[])data).length * 64 / wordSize : ((long[])data).length * wordsPerLong;
        } else {
            if (!(data instanceof int[])) throw new IllegalArgumentException("Don't know how to process data of type " + data.getClass());
            int[] dataAsInts = (int[])data;
            if (dataAsInts.length % 2 != 0) throw new IllegalArgumentException("Don't know how to process data of type int[] and odd length");
            long[] dataAsLongs = new long[dataAsInts.length / 2];
            for (int i = 0; i < dataAsLongs.length; ++i) {
                dataAsLongs[i] = (long)dataAsInts[i * 2] & 0xFFFFFFFFL | (long)dataAsInts[i * 2 + 1] << 32;
            }
            bitSet = BitSet.valueOf(dataAsLongs);
            lengthInWords = straddleLongs ? dataAsLongs.length * 64 / wordSize : dataAsLongs.length * wordsPerLong;
        }
        int wordLength = (int)Math.ceil((double)wordSize / 4.0);
        String wordFormat = "%" + wordLength + "x";
        int lineCount = (int)Math.ceil((double)lengthInWords / (double)lineLength);
        int lineNumberLength = (int)Math.ceil(Math.log(lineCount + 1) / Math.log(10.0));
        String lineNumberFormat = "%" + lineNumberLength + "d";
        int wordsOnLine = 0;
        int lineNumber = 1;
        for (int w = 0; w < lengthInWords; ++w) {
            if (wordsOnLine == lineLength) {
                text.append('\n');
                wordsOnLine = 0;
                ++lineNumber;
            }
            if (wordsOnLine == 0) {
                text.append(String.format(lineNumberFormat, lineNumber));
                text.append(':');
            }
            text.append(' ');
            ++wordsOnLine;
            int wordOffset = straddleLongs ? w * wordSize : w / wordsPerLong * 64 + w % wordsPerLong * wordSize;
            int word = 0;
            for (int b = 0; b < wordSize; ++b) {
                word |= bitSet.get(wordOffset + b) ? 1 << b : 0;
            }
            text.append(String.format(wordFormat, word));
        }
        text.append("</pre></html>");
        detailsArea.setIcon(null);
        detailsArea.setText(text.toString());
    }

    static {
        SUPPORTED_IMAGE_TYPES = new HashSet<String>(Arrays.asList(ImageIO.getReaderFileSuffixes()));
        TEXT_FILES = new HashSet<String>(Arrays.asList("json", "txt", "xml", "log"));
        logger = LoggerFactory.getLogger(MapExplorer.class);
    }
}

