/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import java.awt.AlphaComposite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.ChunkStore;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.minecraft.MC115AnvilChunk;
import org.pepsoft.minecraft.MC118AnvilChunk;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.MinecraftCoords;
import org.pepsoft.util.swing.TileListener;
import org.pepsoft.util.swing.TileProvider;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinecraftMapTileProvider
implements TileProvider {
    private final ChunkStore chunkStore;
    private final int maxHeight;
    private final ColourScheme colourScheme;
    private final List<TileListener> listeners = new ArrayList<TileListener>();
    private final Rectangle extent;
    private final Set<Point> presentTiles = new HashSet<Point>();
    private final Map<String, String> statusSymbols = new HashMap<String, String>();
    private final Set<Material> reportedMaterials = new HashSet<Material>();
    private static final int DEFAULT_VOID_COLOUR = 65535;
    private static final ThreadLocal<BufferedImage> renderBufferRef = ThreadLocal.withInitial(() -> new BufferedImage(128, 128, 2));
    private static final Logger logger = LoggerFactory.getLogger(MinecraftMapTileProvider.class);

    public MinecraftMapTileProvider(File mapDir) throws IOException {
        JavaLevel level = JavaLevel.load((File)new File(mapDir, "level.dat"));
        this.maxHeight = level.getMaxHeight();
        PlatformManager platformManager = PlatformManager.getInstance();
        Platform platform = platformManager.identifyPlatform(mapDir);
        this.chunkStore = platformManager.getChunkStore(platform, mapDir, 0);
        Set chunkCoords = this.chunkStore.getChunkCoords();
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (MinecraftCoords coords : chunkCoords) {
            int tileX = coords.x >> 3;
            int tileY = coords.z >> 3;
            this.presentTiles.add(new Point(tileX, tileY));
            if (tileX < minX) {
                minX = tileX;
            }
            if (tileX > maxX) {
                maxX = tileX;
            }
            if (tileY < minY) {
                minY = tileY;
            }
            if (tileY <= maxY) continue;
            maxY = tileY;
        }
        this.extent = new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
        this.colourScheme = ColourScheme.DEFAULT;
    }

    public int getTileSize() {
        return 128;
    }

    public boolean isTilePresent(int x, int y) {
        return this.presentTiles.contains(new Point(x, y));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paintTile(Image tileImage, int x, int y, int dx, int dy) {
        BufferedImage image = renderBufferRef.get();
        int chunkX1 = x * 8;
        int chunkY1 = y * 8;
        int chunkX2 = chunkX1 + 8 - 1;
        int chunkY2 = chunkY1 + 8 - 1;
        Font font = Font.decode("Dialog-9");
        for (int chunkX = chunkX1; chunkX <= chunkX2; ++chunkX) {
            for (int chunkY = chunkY1; chunkY <= chunkY2; ++chunkY) {
                Chunk chunk = this.chunkStore.getChunk(chunkX, chunkY);
                if (chunk != null) {
                    String symbol;
                    String status = null;
                    if (chunk instanceof MC115AnvilChunk) {
                        status = ((MC115AnvilChunk)chunk).status;
                    } else if (chunk instanceof MC118AnvilChunk) {
                        status = ((MC118AnvilChunk)chunk).status;
                    }
                    for (int blockX = 0; blockX < 16; ++blockX) {
                        for (int blockY = 0; blockY < 16; ++blockY) {
                            image.setRGB(chunkX - chunkX1 << 4 | blockX, chunkY - chunkY1 << 4 | blockY, 0xFF000000 | this.getColour(chunk, blockX, blockY));
                        }
                    }
                    if (status == null) continue;
                    Map<String, String> blockY = this.statusSymbols;
                    synchronized (blockY) {
                        symbol = this.statusSymbols.get(status);
                        if (symbol == null) {
                            if (status.length() <= 4) {
                                symbol = status;
                            } else {
                                String[] parts = status.split("_+");
                                int partLength = parts.length == 1 ? 4 : (parts.length == 2 ? 2 : 1);
                                symbol = Arrays.stream(parts).map(part -> part.substring(0, 1).toUpperCase() + part.substring(1, partLength)).collect(Collectors.joining());
                            }
                            this.statusSymbols.put(status, symbol);
                            logger.info("Status symbols: {}", this.statusSymbols);
                        }
                    }
                    Graphics2D g2 = image.createGraphics();
                    try {
                        g2.setFont(font);
                        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
                        if (symbol.length() > 2) {
                            g2.drawString(symbol.substring(0, 2), (chunkX - chunkX1 << 4) + 1, (chunkY - chunkY1 << 4) + 7);
                            g2.drawString(symbol.substring(2), (chunkX - chunkX1 << 4) + 1, (chunkY - chunkY1 << 4) + 15);
                            continue;
                        }
                        g2.drawString(symbol, (chunkX - chunkX1 << 4) + 1, (chunkY - chunkY1 << 4) + 7);
                        continue;
                    }
                    finally {
                        g2.dispose();
                    }
                }
                for (int blockX = 0; blockX < 16; ++blockX) {
                    for (int blockY = 0; blockY < 16; ++blockY) {
                        image.setRGB(chunkX - chunkX1 << 4 | blockX, chunkY - chunkY1 << 4 | blockY, 0);
                    }
                }
            }
        }
        Graphics2D g2 = (Graphics2D)tileImage.getGraphics();
        try {
            g2.setComposite(AlphaComposite.Src);
            g2.drawImage((Image)image, dx, dy, null);
        }
        finally {
            g2.dispose();
        }
        return true;
    }

    public int getTilePriority(int x, int y) {
        return 0;
    }

    public Rectangle getExtent() {
        return this.extent;
    }

    public void addTileListener(TileListener tileListener) {
        this.listeners.add(tileListener);
    }

    public void removeTileListener(TileListener tileListener) {
        this.listeners.remove(tileListener);
    }

    public boolean isZoomSupported() {
        return false;
    }

    public int getZoom() {
        return 0;
    }

    public void setZoom(int zoom) {
        if (zoom != 0) {
            throw new UnsupportedOperationException();
        }
    }

    private int getColour(Chunk chunk, int x, int y) {
        int minHeight = chunk.getMinHeight();
        for (int z = this.maxHeight - 1; z >= minHeight; --z) {
            Material material = chunk.getMaterial(x, z, y);
            if (material.empty) continue;
            int colour = this.colourScheme.getColour(material);
            if (colour == 0xFF00FF && !this.reportedMaterials.contains(material)) {
                logger.warn("Don't know colour of material {}", (Object)material);
                this.reportedMaterials.add(material);
            }
            return colour;
        }
        return 65535;
    }
}

