/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.awt.Rectangle;

public final class Box
implements Cloneable {
    private int x1;
    private int y1;
    private int z1;
    private int x2;
    private int y2;
    private int z2;

    public Box() {
    }

    public Box(int x1, int x2, int y1, int y2, int z1, int z2) {
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
        this.normalise();
    }

    public int getX1() {
        return this.x1;
    }

    public void setX1(int x1) {
        this.x1 = x1;
    }

    public int getX2() {
        return this.x2;
    }

    public void setX2(int x2) {
        this.x2 = x2;
    }

    public int getY1() {
        return this.y1;
    }

    public void setY1(int y1) {
        this.y1 = y1;
    }

    public int getY2() {
        return this.y2;
    }

    public void setY2(int y2) {
        this.y2 = y2;
    }

    public int getZ1() {
        return this.z1;
    }

    public void setZ1(int z1) {
        this.z1 = z1;
    }

    public int getZ2() {
        return this.z2;
    }

    public void setZ2(int z2) {
        this.z2 = z2;
    }

    public int getWidth() {
        return Math.abs(this.x2 - this.x1);
    }

    public int getLength() {
        return Math.abs(this.y2 - this.y1);
    }

    public int getHeight() {
        return Math.abs(this.z2 - this.z1);
    }

    public int getVolume() {
        return this.getWidth() * this.getLength() * this.getHeight();
    }

    public int getSurface() {
        int width = this.getWidth();
        int length = this.getLength();
        int height = this.getHeight();
        return width * height * 2 + length * height * 2 + width * length * 2;
    }

    public void translate(int dx, int dy, int dz) {
        this.x1 += dx;
        this.x2 += dx;
        this.y1 += dy;
        this.y2 += dy;
        this.z1 += dz;
        this.x2 += dz;
    }

    public void encompass(Box box) {
        this.normalise();
        box.normalise();
        if (box.x1 < this.x1) {
            this.x1 = box.x1;
        }
        if (box.x2 > this.x2) {
            this.x2 = box.x2;
        }
        if (box.y1 < this.y1) {
            this.y1 = box.y1;
        }
        if (box.y2 > this.y2) {
            this.y2 = box.y2;
        }
        if (box.z1 < this.z1) {
            this.z1 = box.z1;
        }
        if (box.z2 > this.z2) {
            this.z2 = box.z2;
        }
    }

    public void intersect(Box box) {
        this.normalise();
        box.normalise();
        if (box.x1 >= this.x2 || box.x2 <= this.x1 || box.y1 >= this.y2 || box.y2 <= this.y1 || box.z1 >= this.z2 || box.z2 <= this.z1) {
            this.x2 = this.x1;
            this.y2 = this.y1;
            this.z2 = this.z1;
        } else {
            if (box.x1 > this.x1) {
                this.x1 = box.x1;
            }
            if (box.x2 > this.x2) {
                this.x2 = box.x2;
            }
            if (box.y1 > this.y1) {
                this.y1 = box.y1;
            }
            if (box.y2 > this.y2) {
                this.y2 = box.y2;
            }
            if (box.z1 > this.z1) {
                this.z1 = box.z1;
            }
            if (box.z2 > this.z2) {
                this.z2 = box.z2;
            }
        }
    }

    public boolean isEmpty() {
        return this.x1 == this.x2 && this.y1 == this.y2 && this.z1 == this.z2;
    }

    public boolean contains(int x, int y, int z) {
        return x >= this.x1 && x < this.x2 && y >= this.y1 && y < this.y2 && z >= this.z1 && z < this.z2;
    }

    public boolean containsXY(int x, int y) {
        return x >= this.x1 && x < this.x2 && y >= this.y1 && y < this.y2;
    }

    public Rectangle getFootPrint() {
        this.normalise();
        return new Rectangle(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
    }

    public void expand(int delta) {
        this.normalise();
        this.x1 -= delta;
        this.x2 += delta;
        this.y1 -= delta;
        this.y2 += delta;
        this.z1 -= delta;
        this.z2 += delta;
    }

    public String toString() {
        return "[" + this.x1 + "," + this.y1 + "," + this.z1 + " -> " + this.x2 + "," + this.y2 + "," + this.z2 + "]";
    }

    public Box clone() {
        try {
            return (Box)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private void normalise() {
        int tmp;
        if (this.x1 > this.x2) {
            tmp = this.x1;
            this.x1 = this.x2;
            this.x2 = tmp;
        }
        if (this.y1 > this.y2) {
            tmp = this.y1;
            this.y1 = this.y2;
            this.y2 = tmp;
        }
        if (this.z1 > this.z2) {
            tmp = this.z1;
            this.z1 = this.z2;
            this.z2 = tmp;
        }
    }
}

