/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import org.pepsoft.util.Version;

public final class SystemUtils {
    public static final Version JAVA_VERSION = Version.parse(System.getProperty("java.specification.version"));
    public static final Version JAVA_11 = new Version(11);
    public static final Version JAVA_10 = new Version(10);
    public static final Version JAVA_9 = new Version(9);
    public static final Version JAVA_8 = new Version(1, 8);
    private static final OS OPERATING_SYSTEM;

    private SystemUtils() {
    }

    public static OS getOS() {
        return OPERATING_SYSTEM;
    }

    public static boolean isWindows() {
        return OPERATING_SYSTEM == OS.WINDOWS;
    }

    public static boolean isMac() {
        return OPERATING_SYSTEM == OS.MAC;
    }

    public static boolean isLinux() {
        return OPERATING_SYSTEM == OS.LINUX;
    }

    public static Version getJavaVersion() {
        return JAVA_VERSION;
    }

    static {
        String os_name = System.getProperty("os.name").toLowerCase();
        OPERATING_SYSTEM = os_name.contains("windows") ? OS.WINDOWS : (os_name.contains("os x") ? OS.MAC : (os_name.contains("linux") ? OS.LINUX : OS.OTHER));
    }

    public static enum OS {
        WINDOWS,
        MAC,
        LINUX,
        OTHER;

    }
}

