/*
 * Decompiled with CFR 0.152.
 */
package org.jnbt;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jnbt.ByteArrayTag;
import org.jnbt.ByteTag;
import org.jnbt.CompoundTag;
import org.jnbt.DoubleTag;
import org.jnbt.FloatTag;
import org.jnbt.IntArrayTag;
import org.jnbt.IntTag;
import org.jnbt.ListTag;
import org.jnbt.LongArrayTag;
import org.jnbt.LongTag;
import org.jnbt.ShortTag;
import org.jnbt.StringTag;
import org.jnbt.Tag;
import org.pepsoft.util.StreamUtils;
import org.pepsoft.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLTransformer {
    public static Tag fromXML(Reader in) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(in));
            return XMLTransformer.fromElement(document.getDocumentElement());
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    public static void toXML(Tag tag, Writer out) throws IOException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = builder.newDocument();
            document.appendChild(XMLTransformer.toElement(document, tag));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(out));
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new IOException(e);
        }
    }

    private static Tag fromElement(Element element) throws IOException {
        switch (element.getTagName()) {
            case "bytes": {
                return new ByteArrayTag(element.getAttribute("name"), XMLTransformer.decodeBytes(element.getTextContent()));
            }
            case "byte": {
                return new ByteTag(element.getAttribute("name"), Byte.valueOf(element.getTextContent()));
            }
            case "compound": {
                HashMap<String, Tag> map = new HashMap<String, Tag>();
                XMLUtils.forEachElement((NodeList)element.getChildNodes(), child -> {
                    Tag childTag = XMLTransformer.fromElement(child);
                    map.put(childTag.getName(), childTag);
                });
                return new CompoundTag(element.getAttribute("name"), map);
            }
            case "double": {
                return new DoubleTag(element.getAttribute("name"), Double.valueOf(element.getTextContent()));
            }
            case "float": {
                return new FloatTag(element.getAttribute("name"), Float.valueOf(element.getTextContent()).floatValue());
            }
            case "ints": {
                return new IntArrayTag(element.getAttribute("name"), XMLTransformer.decodeInts(element.getTextContent()));
            }
            case "int": {
                return new IntTag(element.getAttribute("name"), Integer.valueOf(element.getTextContent()));
            }
            case "list": {
                ArrayList list = new ArrayList(element.getChildNodes().getLength());
                XMLUtils.forEachElement((NodeList)element.getChildNodes(), child -> list.add(XMLTransformer.fromElement(child)));
                return new ListTag(element.getAttribute("name"), ((Tag)list.get(0)).getClass(), list);
            }
            case "longs": {
                return new LongArrayTag(element.getAttribute("name"), XMLTransformer.decodeLongs(element.getTextContent()));
            }
            case "long": {
                return new LongTag(element.getAttribute("name"), Long.valueOf(element.getTextContent()));
            }
            case "short": {
                return new ShortTag(element.getAttribute("name"), Short.valueOf(element.getTextContent()));
            }
            case "string": {
                return new StringTag(element.getAttribute("name"), element.getTextContent());
            }
        }
        throw new IllegalArgumentException("Don't know how to convert element " + element + " to NBT tag");
    }

    private static Element toElement(Document document, Tag tag) throws IOException {
        Element element;
        if (tag instanceof ByteArrayTag) {
            element = XMLTransformer.textElement(document, "bytes", XMLTransformer.encodeBytes(((ByteArrayTag)tag).getValue()));
        } else if (tag instanceof ByteTag) {
            element = XMLTransformer.textElement(document, "byte", Byte.toString(((ByteTag)tag).getValue()));
        } else if (tag instanceof CompoundTag) {
            element = document.createElement("compound");
            for (Tag childTag : ((CompoundTag)tag).getValue().values()) {
                element.appendChild(XMLTransformer.toElement(document, childTag));
            }
        } else if (tag instanceof DoubleTag) {
            element = XMLTransformer.textElement(document, "double", Double.toString(((DoubleTag)tag).getValue()));
        } else if (tag instanceof FloatTag) {
            element = XMLTransformer.textElement(document, "float", Float.toString(((FloatTag)tag).getValue()));
        } else if (tag instanceof IntArrayTag) {
            element = XMLTransformer.textElement(document, "ints", XMLTransformer.encodeInts(((IntArrayTag)tag).getValue()));
        } else if (tag instanceof IntTag) {
            element = XMLTransformer.textElement(document, "int", Integer.toString(((IntTag)tag).getValue()));
        } else if (tag instanceof ListTag) {
            element = document.createElement("list");
            for (Tag childTag : ((ListTag)tag).getValue()) {
                element.appendChild(XMLTransformer.toElement(document, childTag));
            }
        } else if (tag instanceof LongArrayTag) {
            element = XMLTransformer.textElement(document, "longs", XMLTransformer.encodeLongs(((LongArrayTag)tag).getValue()));
        } else if (tag instanceof LongTag) {
            element = XMLTransformer.textElement(document, "long", Long.toString(((LongTag)tag).getValue()));
        } else if (tag instanceof ShortTag) {
            element = XMLTransformer.textElement(document, "short", Short.toString(((ShortTag)tag).getValue()));
        } else if (tag instanceof StringTag) {
            element = XMLTransformer.textElement(document, "string", ((StringTag)tag).getValue());
        } else {
            throw new IllegalArgumentException("Don't know how to convert tag " + tag + " to XML element");
        }
        if (!Strings.isNullOrEmpty((String)tag.getName())) {
            element.setAttribute("name", tag.getName());
        }
        return element;
    }

    private static Element textElement(Document document, String name, String text) {
        Element element = document.createElement(name);
        element.setTextContent(text);
        return element;
    }

    private static String encodeBytes(byte[] bytes) throws IOException {
        ByteArrayOutputStream outputStore = new ByteArrayOutputStream();
        try (GZIPOutputStream compressor = new GZIPOutputStream(outputStore);){
            compressor.write(bytes);
        }
        byte[] compressedBytes = outputStore.toByteArray();
        if (compressedBytes.length < bytes.length) {
            return "g" + Base64.getEncoder().encodeToString(compressedBytes);
        }
        return "u" + Base64.getEncoder().encodeToString(bytes);
    }

    private static String encodeInts(int[] ints) throws IOException {
        ByteArrayOutputStream outputStore = new ByteArrayOutputStream();
        try (GZIPOutputStream compressor = new GZIPOutputStream(outputStore);){
            for (int i : ints) {
                compressor.write(i & 0xFF);
                compressor.write((i & 0xFF00) >> 8);
                compressor.write((i & 0xFF0000) >> 16);
                compressor.write((i & 0xFF000000) >>> 24);
            }
        }
        byte[] compressedBytes = outputStore.toByteArray();
        return "g" + Base64.getEncoder().encodeToString(compressedBytes);
    }

    private static String encodeLongs(long[] longs) throws IOException {
        ByteArrayOutputStream outputStore = new ByteArrayOutputStream();
        try (GZIPOutputStream compressor = new GZIPOutputStream(outputStore);){
            for (long l : longs) {
                compressor.write((int)(l & 0xFFL));
                compressor.write((int)((l & 0xFF00L) >> 8));
                compressor.write((int)((l & 0xFF0000L) >> 16));
                compressor.write((int)((l & 0xFF000000L) >> 24));
                compressor.write((int)((l & 0xFF00000000L) >> 32));
                compressor.write((int)((l & 0xFF0000000000L) >> 40));
                compressor.write((int)((l & 0xFF000000000000L) >> 48));
                compressor.write((int)((l & 0xFF00000000000000L) >> 56));
            }
        }
        byte[] compressedBytes = outputStore.toByteArray();
        return "g" + Base64.getEncoder().encodeToString(compressedBytes);
    }

    private static byte[] decodeBytes(String str) throws IOException {
        if (str.startsWith("g")) {
            byte[] compressedBytes = Base64.getDecoder().decode(str.substring(1));
            ByteArrayOutputStream outputStore = new ByteArrayOutputStream();
            GZIPInputStream decompressor = new GZIPInputStream(new ByteArrayInputStream(compressedBytes));
            StreamUtils.copy((InputStream)decompressor, (OutputStream)outputStore);
            return outputStore.toByteArray();
        }
        if (str.startsWith("u")) {
            return Base64.getDecoder().decode(str.substring(1));
        }
        throw new IllegalArgumentException("Compression method flag missing");
    }

    private static int[] decodeInts(String str) throws IOException {
        if (str.startsWith("g")) {
            byte[] bytes = XMLTransformer.decodeBytes(str);
            if (bytes.length % 4 != 0) {
                throw new IllegalArgumentException("Byte count not a multiple of four (size of int)");
            }
            int[] ints = new int[bytes.length / 4];
            for (int i = 0; i < ints.length; ++i) {
                ints[i] = bytes[i << 2] & 0xFF | (bytes[i << 2 | 1] & 0xFF) << 8 | (bytes[i << 2 | 2] & 0xFF) << 16 | (bytes[i << 2 | 3] & 0xFF) << 24;
            }
            return ints;
        }
        throw new IllegalArgumentException("Compression method flag missing");
    }

    private static long[] decodeLongs(String str) throws IOException {
        if (str.startsWith("g")) {
            byte[] bytes = XMLTransformer.decodeBytes(str);
            if (bytes.length % 8 != 0) {
                throw new IllegalArgumentException("Byte count not a multiple of eight (size of long)");
            }
            long[] longs = new long[bytes.length / 8];
            for (int i = 0; i < longs.length; ++i) {
                longs[i] = (long)bytes[i << 3] & 0xFFL | ((long)bytes[i << 3 | 1] & 0xFFL) << 8 | ((long)bytes[i << 3 | 2] & 0xFFL) << 16 | ((long)bytes[i << 3 | 3] & 0xFFL) << 24 | ((long)bytes[i << 3 | 4] & 0xFFL) << 32 | ((long)bytes[i << 3 | 5] & 0xFFL) << 40 | ((long)bytes[i << 3 | 6] & 0xFFL) << 48 | ((long)bytes[i << 3 | 7] & 0xFFL) << 56;
            }
            return longs;
        }
        throw new IllegalArgumentException("Compression method flag missing");
    }
}

