/*
 * Decompiled with CFR 0.152.
 */
package org.jnbt;

import com.google.common.io.LittleEndianDataOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.jnbt.ByteArrayTag;
import org.jnbt.ByteTag;
import org.jnbt.CompoundTag;
import org.jnbt.DoubleTag;
import org.jnbt.EndTag;
import org.jnbt.FloatTag;
import org.jnbt.IntArrayTag;
import org.jnbt.IntTag;
import org.jnbt.ListTag;
import org.jnbt.LongArrayTag;
import org.jnbt.LongTag;
import org.jnbt.NBTUtils;
import org.jnbt.ShortTag;
import org.jnbt.StringTag;
import org.jnbt.Tag;

public final class NBTOutputStream
implements Closeable {
    private final DataOutput os;

    public NBTOutputStream(OutputStream os) {
        this.os = os instanceof DataOutput ? (DataOutput)((Object)os) : new DataOutputStream(os);
    }

    public NBTOutputStream(OutputStream os, boolean littleEndian) {
        this.os = littleEndian ? new LittleEndianDataOutputStream(os) : new DataOutputStream(os);
    }

    public void writeTag(Tag tag) throws IOException {
        try {
            int type = NBTUtils.getTypeCode(tag.getClass());
            String name = tag.getName();
            byte[] nameBytes = name.getBytes("UTF-8");
            this.os.writeByte(type);
            this.os.writeShort(nameBytes.length);
            this.os.write(nameBytes);
            this.writeTagPayload(tag);
        }
        catch (IOException | RuntimeException e) {
            throw new IOException(e.getClass().getSimpleName() + " while writing tag " + tag, e);
        }
    }

    private void writeTagPayload(Tag tag) throws IOException {
        int type = NBTUtils.getTypeCode(tag.getClass());
        switch (type) {
            case 0: {
                this.writeEndTagPayload((EndTag)tag);
                break;
            }
            case 1: {
                this.writeByteTagPayload((ByteTag)tag);
                break;
            }
            case 2: {
                this.writeShortTagPayload((ShortTag)tag);
                break;
            }
            case 3: {
                this.writeIntTagPayload((IntTag)tag);
                break;
            }
            case 4: {
                this.writeLongTagPayload((LongTag)tag);
                break;
            }
            case 5: {
                this.writeFloatTagPayload((FloatTag)tag);
                break;
            }
            case 6: {
                this.writeDoubleTagPayload((DoubleTag)tag);
                break;
            }
            case 7: {
                this.writeByteArrayTagPayload((ByteArrayTag)tag);
                break;
            }
            case 8: {
                this.writeStringTagPayload((StringTag)tag);
                break;
            }
            case 9: {
                this.writeListTagPayload((ListTag)tag);
                break;
            }
            case 10: {
                this.writeCompoundTagPayload((CompoundTag)tag);
                break;
            }
            case 11: {
                this.writeIntArrayTagPayload((IntArrayTag)tag);
                break;
            }
            case 12: {
                this.writeLongArrayTagPayload((LongArrayTag)tag);
                break;
            }
            default: {
                throw new IOException("Invalid tag type: " + type + ".");
            }
        }
    }

    private void writeByteTagPayload(ByteTag tag) throws IOException {
        this.os.writeByte(tag.getValue());
    }

    private void writeByteArrayTagPayload(ByteArrayTag tag) throws IOException {
        byte[] bytes = tag.getValue();
        this.os.writeInt(bytes.length);
        this.os.write(bytes);
    }

    private void writeCompoundTagPayload(CompoundTag tag) throws IOException {
        for (Tag childTag : tag.getValue().values()) {
            this.writeTag(childTag);
        }
        this.os.writeByte(0);
    }

    private void writeListTagPayload(ListTag tag) throws IOException {
        Class<Tag> clazz = tag.getType();
        List tags = tag.getValue();
        int size = tags.size();
        this.os.writeByte(NBTUtils.getTypeCode(clazz));
        this.os.writeInt(size);
        for (Tag tag1 : tags) {
            this.writeTagPayload(tag1);
        }
    }

    private void writeStringTagPayload(StringTag tag) throws IOException {
        byte[] bytes = tag.getValue().getBytes("UTF-8");
        this.os.writeShort(bytes.length);
        this.os.write(bytes);
    }

    private void writeDoubleTagPayload(DoubleTag tag) throws IOException {
        this.os.writeDouble(tag.getValue());
    }

    private void writeFloatTagPayload(FloatTag tag) throws IOException {
        this.os.writeFloat(tag.getValue());
    }

    private void writeLongTagPayload(LongTag tag) throws IOException {
        this.os.writeLong(tag.getValue());
    }

    private void writeIntTagPayload(IntTag tag) throws IOException {
        this.os.writeInt(tag.getValue());
    }

    private void writeShortTagPayload(ShortTag tag) throws IOException {
        this.os.writeShort(tag.getValue());
    }

    private void writeIntArrayTagPayload(IntArrayTag tag) throws IOException {
        int[] values = tag.getValue();
        this.os.writeInt(values.length);
        for (int value : values) {
            this.os.writeInt(value);
        }
    }

    private void writeLongArrayTagPayload(LongArrayTag tag) throws IOException {
        long[] values = tag.getValue();
        this.os.writeInt(values.length);
        for (long value : values) {
            this.os.writeLong(value);
        }
    }

    private void writeEndTagPayload(EndTag tag) {
    }

    @Override
    public void close() throws IOException {
        ((OutputStream)((Object)this.os)).close();
    }
}

