/*
 * Decompiled with CFR 0.152.
 */
package org.jnbt;

import org.jnbt.Tag;

public final class ByteArrayTag
extends Tag {
    private byte[] value;
    private static final long serialVersionUID = 1L;

    public ByteArrayTag(String name, byte[] value) {
        super(name);
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder hex = new StringBuilder();
        if (this.value.length <= 32) {
            for (byte b : this.value) {
                String hexDigits = Integer.toHexString(b & 0xFF).toUpperCase();
                if (hexDigits.length() == 1) {
                    hex.append("0");
                }
                hex.append(hexDigits).append(" ");
            }
        } else {
            for (int i = 0; i < 32; ++i) {
                if (i != 30) {
                    String hexDigits = Integer.toHexString(this.value[i <= 30 ? i : this.value.length - 1] & 0xFF).toUpperCase();
                    if (hexDigits.length() == 1) {
                        hex.append("0");
                    }
                    hex.append(hexDigits).append(" ");
                    continue;
                }
                hex.append("(");
                hex.append(this.value.length - 31);
                hex.append(" more) ");
            }
        }
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        return "TAG_Byte_Array" + append + ": " + (hex.length() > 0 ? hex.substring(0, hex.length() - 1) : "empty");
    }

    @Override
    public ByteArrayTag clone() {
        ByteArrayTag clone = (ByteArrayTag)super.clone();
        clone.value = (byte[])this.value.clone();
        return clone;
    }
}

