/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.common;

import java.util.AbstractSequentialList;
import java.util.ListIterator;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableLinkedList<T>
extends AbstractSequentialList<T> {
    private static final ImmutableLinkedList<Object> NIL = new ImmutableLinkedList<Object>(){
        private final ListIterator<Object> iterator = new IllIterator<Object>(this);

        @Override
        public Object head() {
            throw new UnsupportedOperationException("head of empty list");
        }

        @Override
        public ImmutableLinkedList<Object> tail() {
            throw new UnsupportedOperationException("tail of empty list");
        }

        @Override
        public Object last() {
            throw new UnsupportedOperationException("last of empty list");
        }

        @Override
        public ListIterator<Object> listIterator(int index) {
            return this.iterator;
        }
    };
    private final T head;
    private final ImmutableLinkedList<T> tail;

    public static <T> ImmutableLinkedList<T> nil() {
        return NIL;
    }

    private ImmutableLinkedList() {
        this.head = null;
        this.tail = null;
    }

    public ImmutableLinkedList(T head, ImmutableLinkedList<T> tail) {
        Preconditions.checkArgNotNull(tail, "tail");
        this.head = head;
        this.tail = tail;
    }

    public T head() {
        return this.head;
    }

    public ImmutableLinkedList<T> tail() {
        return this.tail;
    }

    public T last() {
        ImmutableLinkedList<T> cursor = this;
        while (!cursor.tail.isEmpty()) {
            cursor = cursor.tail();
        }
        return cursor.head();
    }

    public ImmutableLinkedList<T> prepend(T object) {
        return new ImmutableLinkedList<T>(object, this);
    }

    public ImmutableLinkedList<T> reverse() {
        if (this.tail == NIL) {
            return this;
        }
        ImmutableLinkedList<T> reversed = ImmutableLinkedList.nil();
        ImmutableLinkedList<T> next = this;
        while (next != NIL) {
            reversed = reversed.prepend(next.head);
            next = next.tail;
        }
        return reversed;
    }

    public static <T> boolean equal(ImmutableLinkedList<T> a, ImmutableLinkedList<T> b) {
        Preconditions.checkArgNotNull(a, "a");
        Preconditions.checkArgNotNull(b, "b");
        return Utils.equal(a.head, b.head) && ImmutableLinkedList.equal(a.tail, b.tail);
    }

    public static int hashCode(ImmutableLinkedList<?> list) {
        Preconditions.checkArgNotNull(list, "list");
        return list.isEmpty() ? 0 : 31 * list.head.hashCode() + ImmutableLinkedList.hashCode(list.tail);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        IllIterator iterator = new IllIterator(this);
        while (index-- > 0) {
            if (!iterator.hasNext()) {
                throw new IndexOutOfBoundsException();
            }
            iterator.next();
        }
        return iterator;
    }

    @Override
    public boolean isEmpty() {
        return this == NIL;
    }

    @Override
    public int size() {
        ImmutableLinkedList<T> cursor = this;
        int size = 0;
        while (!cursor.isEmpty()) {
            ++size;
            cursor = cursor.tail();
        }
        return size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IllIterator<T>
    implements ListIterator<T> {
        private final ImmutableLinkedList<T> start;
        private ImmutableLinkedList<T> current;
        private int nextIndex = 0;

        private IllIterator(ImmutableLinkedList<T> start) {
            this.start = start;
            this.current = start;
        }

        @Override
        public boolean hasNext() {
            return this.current != NIL;
        }

        @Override
        public T next() {
            ImmutableLinkedList<T> next = this.current;
            this.current = ((ImmutableLinkedList)this.current).tail;
            ++this.nextIndex;
            return (T)((ImmutableLinkedList)next).head;
        }

        @Override
        public boolean hasPrevious() {
            return this.current != this.start;
        }

        @Override
        public T previous() {
            ImmutableLinkedList previous = this.start;
            while (previous.tail != this.current) {
                previous = previous.tail;
            }
            --this.nextIndex;
            return (T)previous.head;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T t) {
            throw new UnsupportedOperationException();
        }
    }
}

