/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.direct;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.credentials.CredentialUtil;
import org.pac4j.http.credentials.DigestCredentials;
import org.pac4j.http.credentials.extractor.DigestAuthExtractor;

public class DirectDigestAuthClient
extends DirectClient<DigestCredentials, CommonProfile> {
    private String realm = "pac4jRealm";

    public DirectDigestAuthClient() {
    }

    public DirectDigestAuthClient(Authenticator digestAuthenticator) {
        this.defaultAuthenticator(digestAuthenticator);
    }

    public DirectDigestAuthClient(Authenticator digestAuthenticator, ProfileCreator profileCreator) {
        this.defaultAuthenticator(digestAuthenticator);
        this.defaultProfileCreator(profileCreator);
    }

    protected void clientInit(WebContext context) {
        this.defaultCredentialsExtractor(new DigestAuthExtractor(this.getName()));
    }

    protected DigestCredentials retrieveCredentials(WebContext context) throws HttpAction {
        DigestCredentials credentials = (DigestCredentials)super.retrieveCredentials(context);
        if (credentials == null) {
            String nonce = this.calculateNonce();
            HttpAction.unauthorizedDigest((String)"Digest required", (WebContext)context, (String)this.realm, (String)"auth", (String)nonce);
        }
        return credentials;
    }

    private String calculateNonce() {
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy:MM:dd:HH:mm:ss.SSS");
        String fmtTime = formatter.format(time);
        return CredentialUtil.encryptMD5(fmtTime + CommonHelper.randomString((int)10));
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "realm", this.realm, "extractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }
}

