/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.hints;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.xml.hints.EvidenceMatcher;
import org.owasp.dependencycheck.xml.suppression.PropertyType;

@NotThreadSafe
public class HintRule {
    private final List<PropertyType> filenames = new ArrayList<PropertyType>();
    private final List<EvidenceMatcher> givenVendor = new ArrayList<EvidenceMatcher>();
    private final List<EvidenceMatcher> givenProduct = new ArrayList<EvidenceMatcher>();
    private final List<EvidenceMatcher> givenVersion = new ArrayList<EvidenceMatcher>();
    private final List<Evidence> addVendor = new ArrayList<Evidence>();
    private final List<Evidence> addProduct = new ArrayList<Evidence>();
    private final List<Evidence> addVersion = new ArrayList<Evidence>();
    private final List<EvidenceMatcher> removeVendor = new ArrayList<EvidenceMatcher>();
    private final List<EvidenceMatcher> removeProduct = new ArrayList<EvidenceMatcher>();
    private final List<EvidenceMatcher> removeVersion = new ArrayList<EvidenceMatcher>();

    public void addFilename(PropertyType filename) {
        this.filenames.add(filename);
    }

    public List<PropertyType> getFilenames() {
        return this.filenames;
    }

    public void addGivenProduct(String source, String name, String value, boolean regex, Confidence confidence) {
        this.givenProduct.add(new EvidenceMatcher(source, name, value, regex, confidence));
    }

    public List<EvidenceMatcher> getGivenProduct() {
        return this.givenProduct;
    }

    public void addGivenVendor(String source, String name, String value, boolean regex, Confidence confidence) {
        this.givenVendor.add(new EvidenceMatcher(source, name, value, regex, confidence));
    }

    public List<EvidenceMatcher> getGivenVendor() {
        return this.givenVendor;
    }

    public void addAddProduct(String source, String name, String value, Confidence confidence) {
        this.addProduct.add(new Evidence(source, name, value, confidence));
    }

    public List<Evidence> getAddProduct() {
        return this.addProduct;
    }

    public void addAddVersion(String source, String name, String value, Confidence confidence) {
        this.addVersion.add(new Evidence(source, name, value, confidence));
    }

    public List<Evidence> getAddVersion() {
        return this.addVersion;
    }

    public void addAddVendor(String source, String name, String value, Confidence confidence) {
        this.addVendor.add(new Evidence(source, name, value, confidence));
    }

    public List<Evidence> getAddVendor() {
        return this.addVendor;
    }

    public void addRemoveVendor(String source, String name, String value, boolean regex, Confidence confidence) {
        this.removeVendor.add(new EvidenceMatcher(source, name, value, regex, confidence));
    }

    public List<EvidenceMatcher> getRemoveVendor() {
        return this.removeVendor;
    }

    public void addRemoveProduct(String source, String name, String value, boolean regex, Confidence confidence) {
        this.removeProduct.add(new EvidenceMatcher(source, name, value, regex, confidence));
    }

    public List<EvidenceMatcher> getRemoveProduct() {
        return this.removeProduct;
    }

    public void addRemoveVersion(String source, String name, String value, boolean regex, Confidence confidence) {
        this.removeVersion.add(new EvidenceMatcher(source, name, value, regex, confidence));
    }

    public List<EvidenceMatcher> getRemoveVersion() {
        return this.removeVersion;
    }

    public void addGivenVersion(String source, String name, String value, boolean regex, Confidence confidence) {
        this.givenVersion.add(new EvidenceMatcher(source, name, value, regex, confidence));
    }

    public List<EvidenceMatcher> getGivenVersion() {
        return this.givenVersion;
    }
}

