/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.data.update.nvd.DownloadTask;
import org.owasp.dependencycheck.data.update.nvd.NvdCve12Handler;
import org.owasp.dependencycheck.data.update.nvd.NvdCve20Handler;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@ThreadSafe
public class ProcessTask
implements Callable<ProcessTask> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessTask.class);
    private UpdateException exception = null;
    private final CveDB cveDB;
    private final DownloadTask filePair;
    private final DatabaseProperties properties;
    private final Settings settings;

    public UpdateException getException() {
        return this.exception;
    }

    public void setException(UpdateException exception) {
        this.exception = exception;
    }

    public ProcessTask(CveDB cveDB, DownloadTask filePair, Settings settings) {
        this.cveDB = cveDB;
        this.filePair = filePair;
        this.properties = cveDB.getDatabaseProperties();
        this.settings = settings;
    }

    @Override
    public ProcessTask call() throws Exception {
        try {
            this.processFiles();
        }
        catch (UpdateException ex) {
            this.exception = ex;
        }
        finally {
            this.settings.cleanup(false);
        }
        return this;
    }

    protected void importXML(File file, File oldVersion) throws ParserConfigurationException, SAXException, IOException, SQLException, DatabaseException, ClassNotFoundException {
        SAXParser saxParser = XmlUtils.buildSecureSaxParser();
        NvdCve12Handler cve12Handler = new NvdCve12Handler();
        saxParser.parse(oldVersion, (DefaultHandler)cve12Handler);
        Map<String, List<VulnerableSoftware>> prevVersionVulnMap = cve12Handler.getVulnerabilities();
        NvdCve20Handler cve20Handler = new NvdCve20Handler();
        cve20Handler.setCveDB(this.cveDB);
        cve20Handler.setPrevVersionVulnMap(prevVersionVulnMap);
        saxParser.parse(file, (DefaultHandler)cve20Handler);
    }

    private void processFiles() throws UpdateException {
        LOGGER.info("Processing Started for NVD CVE - {}", (Object)this.filePair.getNvdCveInfo().getId());
        long startProcessing = System.currentTimeMillis();
        try {
            this.importXML(this.filePair.getFirst(), this.filePair.getSecond());
            this.cveDB.commit();
            this.properties.save(this.filePair.getNvdCveInfo());
        }
        catch (IOException | ClassNotFoundException | SQLException | ParserConfigurationException | DatabaseException | SAXException ex) {
            throw new UpdateException(ex);
        }
        finally {
            this.filePair.cleanup();
        }
        LOGGER.info("Processing Complete for NVD CVE - {}  ({} ms)", (Object)this.filePair.getNvdCveInfo().getId(), (Object)(System.currentTimeMillis() - startProcessing));
    }
}

