/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nodeaudit;

import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

@ThreadSafe
public final class SanitizePackage {
    private SanitizePackage() {
    }

    public static JsonObject sanitize(JsonObject packageJson) {
        JsonObjectBuilder payloadBuilder = Json.createObjectBuilder();
        payloadBuilder.add("name", packageJson.getString("name"));
        payloadBuilder.add("version", packageJson.getString("version"));
        JsonValue jsonValue = (JsonValue)packageJson.get((Object)"requires");
        if (jsonValue.getValueType() != JsonValue.ValueType.OBJECT) {
            JsonObjectBuilder requiresBuilder = Json.createObjectBuilder();
            JsonObject dependencies = packageJson.getJsonObject("dependencies");
            for (String moduleName : dependencies.keySet()) {
                JsonObject module = dependencies.getJsonObject(moduleName);
                String version = module.getString("version");
                requiresBuilder.add(moduleName, version);
            }
            payloadBuilder.add("requires", (JsonValue)requiresBuilder.build());
        }
        payloadBuilder.add("dependencies", (JsonValue)packageJson.getJsonObject("dependencies"));
        payloadBuilder.add("install", (JsonValue)Json.createArrayBuilder().build());
        payloadBuilder.add("remove", (JsonValue)Json.createArrayBuilder().build());
        payloadBuilder.add("metadata", Json.createObjectBuilder().add("npm_version", "6.1.0").add("node_version", "v10.5.0").add("platform", "linux"));
        return payloadBuilder.build();
    }
}

