/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.JarAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.UrlStringUtils;

@Experimental
@ThreadSafe
public class PythonPackageAnalyzer
extends AbstractFileTypeAnalyzer {
    public static final String DEPENDENCY_ECOSYSTEM = "Python.Pkg";
    private static final int REGEX_OPTIONS = 34;
    private static final String EXTENSIONS = "py";
    private static final Pattern MODULE_DOCSTRING = Pattern.compile("^(['\\\"]{3})(.*?)\\1", 34);
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\b(__)?version(__)? *= *(['\"]+)(\\d+\\.\\d+.*?)\\3", 34);
    private static final Pattern TITLE_PATTERN = PythonPackageAnalyzer.compileAssignPattern("title");
    private static final Pattern SUMMARY_PATTERN = PythonPackageAnalyzer.compileAssignPattern("summary");
    private static final Pattern URI_PATTERN = PythonPackageAnalyzer.compileAssignPattern("ur[il]");
    private static final Pattern HOMEPAGE_PATTERN = PythonPackageAnalyzer.compileAssignPattern("home_?page");
    private static final Pattern AUTHOR_PATTERN = PythonPackageAnalyzer.compileAssignPattern("author");
    private static final FileFilter INIT_PY_FILTER = new NameFileFilter("__init__.py");
    private static final FileFilter PY_FILTER = new SuffixFileFilter(".py");
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions("py").build();

    @Override
    public String getName() {
        return "Python Package Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.INFORMATION_COLLECTION;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.python.package.enabled";
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    private static Pattern compileAssignPattern(String name) {
        return Pattern.compile(String.format("\\b(__)?%s(__)?\\b *= *(['\"]+)(.*?)\\3", name), 34);
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
        File file = dependency.getActualFile();
        File parent = file.getParentFile();
        String parentName = parent.getName();
        if (INIT_PY_FILTER.accept(file)) {
            dependency.addEvidence(EvidenceType.PRODUCT, file.getName(), "PackageName", parentName, Confidence.HIGHEST);
            dependency.setName(parentName);
            File[] fileList = parent.listFiles(PY_FILTER);
            if (fileList != null) {
                for (File sourceFile : fileList) {
                    this.analyzeFileContents(dependency, sourceFile);
                }
            }
        } else {
            engine.removeDependency(dependency);
        }
    }

    private boolean analyzeFileContents(Dependency dependency, File file) throws AnalysisException {
        String contents;
        try {
            contents = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset()).trim();
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        boolean found = false;
        if (!contents.isEmpty()) {
            String source = file.getName();
            found = this.gatherEvidence(dependency, EvidenceType.VERSION, VERSION_PATTERN, contents, source, "SourceVersion", Confidence.MEDIUM);
            found |= this.addSummaryInfo(dependency, SUMMARY_PATTERN, 4, contents, source, "summary");
            if (INIT_PY_FILTER.accept(file)) {
                found |= this.addSummaryInfo(dependency, MODULE_DOCSTRING, 2, contents, source, "docstring");
            }
            found |= this.gatherEvidence(dependency, EvidenceType.PRODUCT, TITLE_PATTERN, contents, source, "SourceTitle", Confidence.LOW);
            found |= this.gatherEvidence(dependency, EvidenceType.VENDOR, AUTHOR_PATTERN, contents, source, "SourceAuthor", Confidence.MEDIUM);
            found |= this.gatherHomePageEvidence(dependency, EvidenceType.VENDOR, URI_PATTERN, source, "URL", contents);
            found |= this.gatherHomePageEvidence(dependency, EvidenceType.VENDOR, HOMEPAGE_PATTERN, source, "HomePage", contents);
        }
        return found;
    }

    private boolean addSummaryInfo(Dependency dependency, Pattern pattern, int group, String contents, String source, String key) {
        Matcher matcher = pattern.matcher(contents);
        boolean found = matcher.find();
        if (found) {
            JarAnalyzer.addDescription(dependency, matcher.group(group), source, key);
        }
        return found;
    }

    private boolean gatherHomePageEvidence(Dependency dependency, EvidenceType type, Pattern pattern, String source, String name, String contents) {
        String url;
        Matcher matcher = pattern.matcher(contents);
        boolean found = false;
        if (matcher.find() && UrlStringUtils.isUrl(url = matcher.group(4))) {
            found = true;
            dependency.addEvidence(type, source, name, url, Confidence.MEDIUM);
        }
        return found;
    }

    private boolean gatherEvidence(Dependency dependency, EvidenceType type, Pattern pattern, String contents, String source, String name, Confidence confidence) {
        Matcher matcher = pattern.matcher(contents);
        boolean found = matcher.find();
        if (found) {
            dependency.addEvidence(type, source, name, matcher.group(4), confidence);
            if (type == EvidenceType.VERSION) {
                dependency.setVersion(matcher.group(4));
                String dispName = String.format("%s:%s", dependency.getName(), dependency.getVersion());
                dependency.setDisplayFileName(dispName);
            }
        }
        return found;
    }
}

