/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.xml.hints.EvidenceMatcher;
import org.owasp.dependencycheck.xml.hints.HintParseException;
import org.owasp.dependencycheck.xml.hints.HintParser;
import org.owasp.dependencycheck.xml.hints.HintRule;
import org.owasp.dependencycheck.xml.hints.VendorDuplicatingHintRule;
import org.owasp.dependencycheck.xml.suppression.PropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@ThreadSafe
public class HintAnalyzer
extends AbstractAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HintAnalyzer.class);
    private static final String HINT_RULE_FILE_NAME = "dependencycheck-base-hint.xml";
    private HintRule[] hints = null;
    private VendorDuplicatingHintRule[] vendorHints;
    private static final String ANALYZER_NAME = "Hint Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.PRE_IDENTIFIER_ANALYSIS;

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.hint.enabled";
    }

    @Override
    public void prepareAnalyzer(Engine engine) throws InitializationException {
        try {
            this.loadHintRules();
        }
        catch (HintParseException ex) {
            LOGGER.debug("Unable to parse hint file", (Throwable)ex);
            throw new InitializationException("Unable to parse the hint file", ex);
        }
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        for (HintRule hintRule : this.hints) {
            boolean matchFound = false;
            for (EvidenceMatcher evidenceMatcher : hintRule.getGivenVendor()) {
                if (!this.hasMatchingEvidence(dependency.getEvidence(EvidenceType.VENDOR), evidenceMatcher)) continue;
                matchFound = true;
                break;
            }
            if (!matchFound) {
                for (EvidenceMatcher evidenceMatcher : hintRule.getGivenProduct()) {
                    if (!this.hasMatchingEvidence(dependency.getEvidence(EvidenceType.PRODUCT), evidenceMatcher)) continue;
                    matchFound = true;
                    break;
                }
            }
            if (!matchFound) {
                for (EvidenceMatcher evidenceMatcher : hintRule.getGivenVersion()) {
                    if (!this.hasMatchingEvidence(dependency.getEvidence(EvidenceType.VERSION), evidenceMatcher)) continue;
                    matchFound = true;
                    break;
                }
            }
            if (!matchFound) {
                for (PropertyType propertyType : hintRule.getFilenames()) {
                    if (!propertyType.matches(dependency.getFileName())) continue;
                    matchFound = true;
                    break;
                }
            }
            if (!matchFound) continue;
            for (Evidence evidence : hintRule.getAddVendor()) {
                dependency.addEvidence(EvidenceType.VENDOR, evidence);
            }
            for (Evidence evidence : hintRule.getAddProduct()) {
                dependency.addEvidence(EvidenceType.PRODUCT, evidence);
            }
            for (Evidence evidence : hintRule.getAddVersion()) {
                dependency.addEvidence(EvidenceType.VERSION, evidence);
            }
            for (EvidenceMatcher evidenceMatcher : hintRule.getRemoveVendor()) {
                this.removeMatchingEvidences(dependency, EvidenceType.VENDOR, evidenceMatcher);
            }
            for (EvidenceMatcher evidenceMatcher : hintRule.getRemoveProduct()) {
                this.removeMatchingEvidences(dependency, EvidenceType.PRODUCT, evidenceMatcher);
            }
            for (EvidenceMatcher evidenceMatcher : hintRule.getRemoveVersion()) {
                this.removeMatchingEvidences(dependency, EvidenceType.VERSION, evidenceMatcher);
            }
        }
        Iterator itr = dependency.getEvidence(EvidenceType.VENDOR).iterator();
        ArrayList<Evidence> newEntries = new ArrayList<Evidence>();
        while (itr.hasNext()) {
            Evidence e = (Evidence)itr.next();
            for (VendorDuplicatingHintRule vendorDuplicatingHintRule : this.vendorHints) {
                if (!vendorDuplicatingHintRule.getValue().equalsIgnoreCase(e.getValue())) continue;
                newEntries.add(new Evidence(e.getSource() + " (hint)", e.getName(), vendorDuplicatingHintRule.getDuplicate(), e.getConfidence()));
            }
        }
        for (Evidence evidence : newEntries) {
            dependency.addEvidence(EvidenceType.VENDOR, evidence);
        }
    }

    private boolean hasMatchingEvidence(Set<Evidence> evidences, EvidenceMatcher criterion) {
        for (Evidence evidence : evidences) {
            if (!criterion.matches(evidence)) continue;
            return true;
        }
        return false;
    }

    private void removeMatchingEvidences(Dependency dependency, EvidenceType type, EvidenceMatcher e) {
        for (Evidence evidence : dependency.getEvidence(type)) {
            if (!e.matches(evidence)) continue;
            dependency.removeEvidence(type, evidence);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadHintRules() throws HintParseException {
        List<VendorDuplicatingHintRule> localVendorHints;
        List<HintRule> localHints;
        block35: {
            HintParser parser = new HintParser();
            File file = null;
            try {
                parser.parseHints(org.owasp.dependencycheck.utils.FileUtils.getResourceAsStream((String)HINT_RULE_FILE_NAME));
            }
            catch (SAXException ex) {
                throw new HintParseException("Error parsing hinits: " + ex.getMessage(), ex);
            }
            localHints = parser.getHintRules();
            localVendorHints = parser.getVendorDuplicatingHintRules();
            String filePath = this.getSettings().getString("hints.file");
            if (filePath != null) {
                boolean deleteTempFile = false;
                try {
                    block34: {
                        Pattern uriRx = Pattern.compile("^(https?|file)\\:.*", 2);
                        if (uriRx.matcher(filePath).matches()) {
                            deleteTempFile = true;
                            file = this.getSettings().getTempFile("hint", "xml");
                            URL url = new URL(filePath);
                            Downloader downloader = new Downloader(this.getSettings());
                            try {
                                downloader.fetchFile(url, file, false);
                            }
                            catch (DownloadFailedException ex) {
                                downloader.fetchFile(url, file, true);
                            }
                        } else {
                            file = new File(filePath);
                            if (!file.exists()) {
                                try (InputStream fromClasspath = org.owasp.dependencycheck.utils.FileUtils.getResourceAsStream((String)filePath);){
                                    if (fromClasspath == null) break block34;
                                    deleteTempFile = true;
                                    file = this.getSettings().getTempFile("hint", "xml");
                                    try {
                                        FileUtils.copyInputStreamToFile((InputStream)fromClasspath, (File)file);
                                    }
                                    catch (IOException ex) {
                                        throw new HintParseException("Unable to locate hints file in classpath", ex);
                                    }
                                }
                            }
                        }
                    }
                    if (file != null) {
                        try {
                            parser.parseHints(file);
                            if (parser.getHintRules() != null && !parser.getHintRules().isEmpty()) {
                                localHints.addAll(parser.getHintRules());
                            }
                            if (parser.getVendorDuplicatingHintRules() != null && !parser.getVendorDuplicatingHintRules().isEmpty()) {
                                localVendorHints.addAll(parser.getVendorDuplicatingHintRules());
                            }
                        }
                        catch (HintParseException ex) {
                            LOGGER.warn("Unable to parse hint rule xml file '{}'", (Object)file.getPath());
                            LOGGER.warn(ex.getMessage());
                            LOGGER.debug("", (Throwable)ex);
                            throw ex;
                        }
                    }
                    if (!deleteTempFile || file == null) break block35;
                }
                catch (DownloadFailedException ex) {
                    try {
                        throw new HintParseException("Unable to fetch the configured hint file", ex);
                        catch (MalformedURLException ex2) {
                            throw new HintParseException("Configured hint file has an invalid URL", ex2);
                        }
                        catch (IOException ex3) {
                            throw new HintParseException("Unable to create temp file for hints", ex3);
                        }
                    }
                    catch (Throwable throwable) {
                        if (deleteTempFile && file != null) {
                            org.owasp.dependencycheck.utils.FileUtils.delete(file);
                        }
                        throw throwable;
                    }
                }
                org.owasp.dependencycheck.utils.FileUtils.delete((File)file);
            }
        }
        this.hints = localHints.toArray(new HintRule[localHints.size()]);
        this.vendorHints = localVendorHints.toArray(new VendorDuplicatingHintRule[localVendorHints.size()]);
        LOGGER.debug("{} hint rules were loaded.", (Object)this.hints.length);
        LOGGER.debug("{} duplicating hint rules were loaded.", (Object)this.vendorHints.length);
    }
}

