/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.composer;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.stream.JsonParsingException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.dependencycheck.data.composer.ComposerDependency;
import org.owasp.dependencycheck.data.composer.ComposerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ComposerLockParser {
    private final JsonReader jsonReader;
    private final List<ComposerDependency> composerDependencies;
    private final boolean skipDev;
    private static final Logger LOGGER = LoggerFactory.getLogger(ComposerLockParser.class);

    public ComposerLockParser(InputStream inputStream, boolean skipDev) {
        LOGGER.debug("Creating a ComposerLockParser");
        this.jsonReader = Json.createReader((InputStream)inputStream);
        this.composerDependencies = new ArrayList<ComposerDependency>();
        this.skipDev = skipDev;
    }

    public void process() {
        LOGGER.debug("Beginning Composer lock processing");
        try {
            JsonObject composer = this.jsonReader.readObject();
            if (composer.containsKey((Object)"packages")) {
                LOGGER.debug("Found packages");
                JsonArray packages = composer.getJsonArray("packages");
                for (JsonObject pkg : packages.getValuesAs(JsonObject.class)) {
                    this.processPackageEntry(pkg);
                }
            }
            if (composer.containsKey((Object)"packages-dev") && !this.skipDev) {
                LOGGER.debug("Found packages-dev");
                JsonArray devPackages = composer.getJsonArray("packages-dev");
                for (JsonObject pkg : devPackages.getValuesAs(JsonObject.class)) {
                    this.processPackageEntry(pkg);
                }
            }
        }
        catch (JsonParsingException jsonpe) {
            throw new ComposerException("Error parsing stream", jsonpe);
        }
        catch (JsonException jsone) {
            throw new ComposerException("Error reading stream", jsone);
        }
        catch (IllegalStateException ise) {
            throw new ComposerException("Illegal state in composer stream", ise);
        }
        catch (ClassCastException cce) {
            throw new ComposerException("Not exactly composer lock", cce);
        }
    }

    protected void processPackageEntry(JsonObject pkg) {
        if (pkg.containsKey((Object)"name")) {
            String groupName = pkg.getString("name");
            if (groupName.indexOf(47) >= 0 && groupName.indexOf(47) <= groupName.length() - 1) {
                if (pkg.containsKey((Object)"version")) {
                    String group = groupName.substring(0, groupName.indexOf(47));
                    String project = groupName.substring(groupName.indexOf(47) + 1);
                    String version = pkg.getString("version");
                    if (version.startsWith("v")) {
                        version = version.substring(1);
                    }
                    LOGGER.debug("Got package {}/{}/{}", new Object[]{group, project, version});
                    this.composerDependencies.add(new ComposerDependency(group, project, version));
                } else {
                    LOGGER.debug("Group/package {} does not have a version", (Object)groupName);
                }
            } else {
                LOGGER.debug("Got a dependency with no name");
            }
        }
    }

    public List<ComposerDependency> getDependencies() {
        return this.composerDependencies;
    }
}

