/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class TermsSetQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    @Nullable
    private final String minimumShouldMatchField;
    @Nullable
    private final Script minimumShouldMatchScript;
    private final List<String> terms;
    public static final JsonpDeserializer<TermsSetQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermsSetQuery::setupTermsSetQueryDeserializer);

    private TermsSetQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.minimumShouldMatchField = builder.minimumShouldMatchField;
        this.minimumShouldMatchScript = builder.minimumShouldMatchScript;
        this.terms = ApiTypeHelper.unmodifiableRequired(builder.terms, (Object)this, "terms");
    }

    public static TermsSetQuery of(Function<Builder, ObjectBuilder<TermsSetQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.TermsSet;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final String minimumShouldMatchField() {
        return this.minimumShouldMatchField;
    }

    @Nullable
    public final Script minimumShouldMatchScript() {
        return this.minimumShouldMatchScript;
    }

    public final List<String> terms() {
        return this.terms;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.minimumShouldMatchField != null) {
            generator.writeKey("minimum_should_match_field");
            generator.write(this.minimumShouldMatchField);
        }
        if (this.minimumShouldMatchScript != null) {
            generator.writeKey("minimum_should_match_script");
            this.minimumShouldMatchScript.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.terms)) {
            generator.writeKey("terms");
            generator.writeStartArray();
            for (String item0 : this.terms) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    public Builder toBuilder() {
        return new Builder().field(this.field).minimumShouldMatchField(this.minimumShouldMatchField).minimumShouldMatchScript(this.minimumShouldMatchScript).terms(this.terms);
    }

    protected static void setupTermsSetQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::minimumShouldMatchField, JsonpDeserializer.stringDeserializer(), "minimum_should_match_field");
        op.add(Builder::minimumShouldMatchScript, Script._DESERIALIZER, "minimum_should_match_script");
        op.add(Builder::terms, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "terms");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TermsSetQuery> {
        private String field;
        @Nullable
        private String minimumShouldMatchField;
        @Nullable
        private Script minimumShouldMatchScript;
        private List<String> terms;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder minimumShouldMatchField(@Nullable String value) {
            this.minimumShouldMatchField = value;
            return this;
        }

        public final Builder minimumShouldMatchScript(@Nullable Script value) {
            this.minimumShouldMatchScript = value;
            return this;
        }

        public final Builder minimumShouldMatchScript(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.minimumShouldMatchScript(fn.apply(new Script.Builder()).build());
        }

        public final Builder terms(List<String> list) {
            this.terms = Builder._listAddAll(this.terms, list);
            return this;
        }

        public final Builder terms(String value, String ... values) {
            this.terms = Builder._listAdd(this.terms, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TermsSetQuery build() {
            this._checkSingleUse();
            return new TermsSetQuery(this);
        }
    }
}

