/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.HashMap;
import java.util.Map;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class ReplaceAliasWithAnchorValueVisitor<P>
extends YamlVisitor<P> {
    Map<String, Yaml> anchorValues = new HashMap<String, Yaml>();

    @Override
    public Yaml visitMapping(Yaml.Mapping mapping, P p) {
        if (mapping.getAnchor() != null) {
            this.anchorValues.put(mapping.getAnchor().getKey(), mapping.withAnchor(null));
        }
        return super.visitMapping(mapping, p);
    }

    @Override
    public Yaml visitScalar(Yaml.Scalar scalar, P p) {
        if (scalar.getAnchor() != null) {
            this.anchorValues.put(scalar.getAnchor().getKey(), scalar.withAnchor(null));
        }
        return super.visitScalar(scalar, p);
    }

    @Override
    public Yaml visitAlias(Yaml.Alias alias, P p) {
        Yaml.Alias al = (Yaml.Alias)super.visitAlias(alias, p);
        Yaml anchorVal = this.anchorValues.get(al.getAnchor().getKey());
        if (anchorVal != null) {
            return anchorVal;
        }
        return al;
    }
}

