/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.pkg.container;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import org.ofdrw.pkg.container.PageDir;
import org.ofdrw.pkg.container.VirtualContainer;

public class PagesDir
extends VirtualContainer {
    private int maxPageIndex = 0;

    public PagesDir(Path fullDir) throws IllegalArgumentException {
        super(fullDir);
        this.initContainer();
    }

    private void initContainer() {
        File fullDirFile = new File(this.getSysAbsPath());
        File[] files = fullDirFile.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.getName().startsWith("Page_")) continue;
                String numb = f.getName().replace("Page_", "");
                try {
                    int num = Integer.parseInt(numb);
                    if (this.maxPageIndex > num) continue;
                    this.maxPageIndex = num + 1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public PageDir newPageDir() {
        String name = "Page_" + this.maxPageIndex;
        ++this.maxPageIndex;
        return this.obtainContainer(name, PageDir::new);
    }

    public PageDir getByIndex(int index) throws FileNotFoundException {
        String containerName = "Page_" + index;
        return this.getContainer(containerName, PageDir::new);
    }

    public PageDir getPageDir(String containerName) throws FileNotFoundException {
        return this.getContainer(containerName, PageDir::new);
    }
}

