/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout;

import java.util.LinkedList;
import java.util.List;
import org.ofdrw.layout.PageLayout;
import org.ofdrw.layout.VirtualPage;
import org.ofdrw.layout.element.Div;
import org.ofdrw.layout.engine.Segment;
import org.ofdrw.layout.engine.SegmentationEngine;
import org.ofdrw.layout.engine.StreamingLayoutAnalyzer;

public class StreamCollect {
    private Integer pageNum = null;
    private final LinkedList<Div> content = new LinkedList();

    public StreamCollect() {
    }

    public StreamCollect(Integer pageNum) {
        this();
        this.pageNum = pageNum;
    }

    public LinkedList<Div> getContent() {
        return this.content;
    }

    public StreamCollect add(Div element) {
        if (element != null) {
            this.content.add(element);
        }
        return this;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public StreamCollect setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
        return this;
    }

    public List<VirtualPage> analyze(PageLayout pageLayout) {
        SegmentationEngine sgmEngine = new SegmentationEngine(pageLayout);
        StreamingLayoutAnalyzer analyzer = new StreamingLayoutAnalyzer(pageLayout);
        List<Segment> sgmQueue = sgmEngine.process(this.content);
        List<VirtualPage> virtualPageList = analyzer.analyze(sgmQueue);
        if (this.pageNum != null) {
            int start = this.pageNum;
            for (VirtualPage vPage : virtualPageList) {
                vPage.setPageNum(start);
                ++start;
            }
        }
        return virtualPageList;
    }
}

