/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.engine;

import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.dom4j.DocumentException;
import org.ofdrw.core.basicStructure.pageObj.Content;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicStructure.pageObj.Template;
import org.ofdrw.core.basicStructure.pageObj.layer.CT_Layer;
import org.ofdrw.core.basicStructure.pageObj.layer.Type;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageTree.Pages;
import org.ofdrw.layout.PageLayout;
import org.ofdrw.layout.VirtualPage;
import org.ofdrw.layout.edit.AdditionVPage;
import org.ofdrw.layout.element.Div;
import org.ofdrw.layout.element.Img;
import org.ofdrw.layout.element.PageAreaFiller;
import org.ofdrw.layout.element.Paragraph;
import org.ofdrw.layout.element.canvas.Canvas;
import org.ofdrw.layout.engine.ResManager;
import org.ofdrw.layout.engine.render.CanvasRender;
import org.ofdrw.layout.engine.render.DivRender;
import org.ofdrw.layout.engine.render.ImgRender;
import org.ofdrw.layout.engine.render.ParagraphRender;
import org.ofdrw.pkg.container.DocDir;
import org.ofdrw.pkg.container.PageDir;
import org.ofdrw.pkg.container.PagesDir;

public class VPageParseEngine {
    private DocDir docDir;
    private AtomicInteger maxUnitID;
    private Pages pages;
    private PagesDir pagesDir;
    private PageLayout pageLayout;
    private ResManager resManager;

    public VPageParseEngine(PageLayout pageLayout, DocDir docDir, ResManager prm, AtomicInteger maxUnitID) {
        this.docDir = docDir;
        this.maxUnitID = maxUnitID;
        this.pageLayout = pageLayout;
        this.resManager = prm;
        try {
            this.pages = docDir.getDocument().getPages();
            if (this.pages == null) {
                this.pages = new Pages();
                docDir.getDocument().setPages(this.pages);
            }
            this.pagesDir = docDir.obtainPages();
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u5230Document.xml \u5bf9\u8c61", e);
        }
    }

    public void process(List<VirtualPage> vPageList) {
        if (vPageList == null || vPageList.isEmpty()) {
            return;
        }
        LinkedList<VirtualPage> seq = new LinkedList<VirtualPage>(vPageList);
        while (!seq.isEmpty()) {
            VirtualPage virtualPage = seq.pop();
            if (virtualPage == null) continue;
            if (virtualPage instanceof AdditionVPage) {
                this.pageEdit((AdditionVPage)virtualPage);
                continue;
            }
            PageDir pageDir = null;
            pageDir = virtualPage.getPageNum() == null ? this.newPage() : this.addNewPage(virtualPage.getPageNum() - 1);
            this.convertPageContent(virtualPage, pageDir);
        }
    }

    private void convertPageContent(VirtualPage vPage, PageDir pageDir) {
        List<Template> templates;
        Page page = new Page();
        PageLayout vPageStyle = vPage.getStyle();
        if (!this.pageLayout.equals(vPageStyle)) {
            page.setArea(vPageStyle.getPageArea());
        }
        if ((templates = vPage.getTemplates()) != null && !templates.isEmpty()) {
            for (Template tpl : templates) {
                page.addTemplate(tpl);
            }
        }
        pageDir.setContent(page);
        if (vPage.getContent().isEmpty()) {
            return;
        }
        Content content = new Content();
        List<List<Div>> layerArr = vPage.getLayerContent();
        for (List<Div> layerContent : layerArr) {
            if (layerContent.isEmpty()) continue;
            Type type = layerContent.get(0).getLayer();
            CT_Layer ctlayer = new CT_Layer();
            ctlayer.setType(type);
            ctlayer.setObjID((long)this.maxUnitID.incrementAndGet());
            content.addLayer(ctlayer);
            this.convert2Layer(ctlayer, layerContent);
        }
        page.setContent(content);
    }

    private void pageEdit(AdditionVPage virtualPage) {
        List<List<Div>> layerArr = virtualPage.getLayerContent();
        for (List<Div> layerContent : layerArr) {
            if (layerContent.isEmpty()) continue;
            Type type = layerContent.get(0).getLayer();
            CT_Layer ctlayer = virtualPage.newLayer(this.maxUnitID);
            ctlayer.setType(type);
            ctlayer.setObjID((long)this.maxUnitID.incrementAndGet());
            this.convert2Layer(ctlayer, layerContent);
        }
    }

    private void convert2Layer(CT_Layer to, List<Div> content) {
        for (Div elem : content) {
            if (elem instanceof PageAreaFiller || elem.isPlaceholder()) continue;
            DivRender.render((CT_PageBlock)to, elem, this.maxUnitID);
            if (elem instanceof Img) {
                ImgRender.render((CT_PageBlock)to, this.resManager, (Img)elem, this.maxUnitID);
                continue;
            }
            if (elem instanceof Paragraph) {
                ParagraphRender.render((CT_PageBlock)to, this.resManager, (Paragraph)elem, this.maxUnitID);
                continue;
            }
            if (!(elem instanceof Canvas)) continue;
            CanvasRender.render((CT_PageBlock)to, this.resManager, (Canvas)elem, this.maxUnitID);
        }
    }

    private PageDir newPage() {
        PageDir pageDir = this.pagesDir.newPageDir();
        String pageLoc = String.format("Pages/Page_%d/Content.xml", pageDir.getIndex());
        org.ofdrw.core.basicStructure.pageTree.Page page = new org.ofdrw.core.basicStructure.pageTree.Page((long)this.maxUnitID.incrementAndGet(), pageLoc);
        this.pages.addPage(page);
        return pageDir;
    }

    private PageDir addNewPage(int index) {
        PageDir pageDir = this.pagesDir.newPageDir();
        String pageLoc = String.format("Pages/Page_%d/Content.xml", pageDir.getIndex());
        org.ofdrw.core.basicStructure.pageTree.Page page = new org.ofdrw.core.basicStructure.pageTree.Page((long)this.maxUnitID.incrementAndGet(), pageLoc);
        int size = this.pages.getSize();
        if (index <= 0) {
            index = 0;
        } else if (index >= size) {
            index = size;
        }
        this.pages.elements().add(index, page);
        return pageDir;
    }
}

